/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ContextMenuContent;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ChoiceBoxBehavior;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.skin.ChoiceBoxSkin$1;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Window;

public class ChoiceBoxSkin<T>
extends SkinBase<ChoiceBox<T>> {
    private ObservableList<T> choiceBoxItems;
    private ContextMenu popup;
    private StackPane openButton;
    private final ToggleGroup toggleGroup = new ToggleGroup();
    private SelectionModel<T> selectionModel;
    private Label label;
    private final BehaviorBase<ChoiceBox<T>> behavior;
    private final ListChangeListener<T> choiceBoxItemsListener = new ChoiceBoxSkin$1(this);
    private final WeakListChangeListener<T> weakChoiceBoxItemsListener = new WeakListChangeListener<T>(this.choiceBoxItemsListener);
    private final InvalidationListener itemsObserver;
    private InvalidationListener selectionChangeListener = observable -> this.updateSelection();

    public ChoiceBoxSkin(ChoiceBox<T> choiceBox) {
        super(choiceBox);
        this.behavior = new ChoiceBoxBehavior<T>(choiceBox);
        this.initialize();
        this.itemsObserver = observable -> this.updateChoiceBoxItems();
        choiceBox.itemsProperty().addListener(this.itemsObserver);
        choiceBox.requestLayout();
        this.registerChangeListener(choiceBox.selectionModelProperty(), observableValue -> this.updateSelectionModel());
        this.registerChangeListener(choiceBox.showingProperty(), singleSelectionModel -> {
            if (((ChoiceBox)this.getSkinnable()).isShowing()) {
                singleSelectionModel = ((ChoiceBox)this.getSkinnable()).getSelectionModel();
                if (singleSelectionModel == null) {
                    return;
                }
                long l2 = singleSelectionModel.getSelectedIndex();
                ((ChoiceBox)this.getSkinnable()).autosize();
                double d2 = 0.0;
                if (this.popup.getSkin() != null && (singleSelectionModel = (ContextMenuContent)this.popup.getSkin().getNode()) != null && l2 != -1L) {
                    d2 = -((ContextMenuContent)((Object)singleSelectionModel)).getMenuYOffset((int)l2);
                }
                this.popup.show((Node)((Object)this.getSkinnable()), Side.BOTTOM, 2.0, d2);
                return;
            }
            ((Window)this.popup).hide();
        });
        this.registerChangeListener(choiceBox.itemsProperty(), observableValue -> {
            this.updateChoiceBoxItems();
            this.updatePopupItems();
            this.updateSelectionModel();
            this.updateSelection();
        });
        this.registerChangeListener(choiceBox.converterProperty(), observableValue -> {
            this.updateChoiceBoxItems();
            this.updatePopupItems();
            this.updateLabelText();
        });
        this.registerChangeListener(choiceBox.valueProperty(), observableValue -> this.updateLabelText());
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        ((ChoiceBox)this.getSkinnable()).itemsProperty().removeListener(this.itemsObserver);
        if (this.choiceBoxItems != null) {
            this.choiceBoxItems.removeListener(this.weakChoiceBoxItemsListener);
            this.choiceBoxItems = null;
        }
        if (this.selectionModel != null) {
            this.selectionModel.selectedIndexProperty().removeListener(this.selectionChangeListener);
            this.selectionModel = null;
        }
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = ((Node)this.openButton).prefWidth(-1.0);
        this.label.resizeRelocate(d2, d3, d4, d5);
        ((Node)this.openButton).resize(d6, ((Node)this.openButton).prefHeight(-1.0));
        ChoiceBoxSkin choiceBoxSkin = this;
        choiceBoxSkin.positionInArea(choiceBoxSkin.openButton, d2 + d4 - d6, d3, d6, d5, 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = ((Node)this.label).minWidth(-1.0) + ((Node)this.openButton).minWidth(-1.0);
        double d8 = this.popup.minWidth(-1.0);
        return d6 + Math.max(d7, d8) + d4;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = ((Node)this.label).minHeight(-1.0);
        double d8 = ((Node)this.openButton).minHeight(-1.0);
        return d3 + Math.max(d7, d8) + d5;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = ((Node)this.label).prefWidth(-1.0) + ((Node)this.openButton).prefWidth(-1.0);
        double d9 = this.popup.prefWidth(-1.0);
        if (d7 <= 0.0 && this.popup.getItems().size() > 0) {
            d9 = new Text(((MenuItem)this.popup.getItems().get(0)).getText()).prefWidth(-1.0);
        }
        if (this.popup.getItems().size() == 0) {
            return 50.0;
        }
        return d6 + Math.max(d8, d9) + d4;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = ((Node)this.label).prefHeight(-1.0);
        double d8 = ((Node)this.openButton).prefHeight(-1.0);
        return d3 + Math.max(d7, d8) + d5;
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)((ChoiceBox)this.getSkinnable())).prefHeight(d2);
    }

    @Override
    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)((ChoiceBox)this.getSkinnable())).prefWidth(d2);
    }

    private void initialize() {
        this.updateChoiceBoxItems();
        this.label = new Label();
        this.label.setMnemonicParsing(false);
        this.openButton = new StackPane();
        this.openButton.getStyleClass().setAll((String[])new String[]{"open-button"});
        StackPane stackPane = new StackPane();
        stackPane.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.openButton.getChildren().clear();
        this.openButton.getChildren().addAll((Node[])new Node[]{stackPane});
        this.popup = new ContextMenu();
        this.popup.showingProperty().addListener((observableValue, bl2, bl3) -> {
            if (!bl3.booleanValue()) {
                ((ChoiceBox)this.getSkinnable()).hide();
            }
        });
        this.popup.setId("choice-box-popup-menu");
        this.getChildren().setAll((Node[])new Node[]{this.label, this.openButton});
        this.updatePopupItems();
        this.updateSelectionModel();
        this.updateSelection();
        this.updateLabelText();
    }

    private void updateLabelText() {
        Object t2 = ((ChoiceBox)this.getSkinnable()).getValue();
        this.label.setText(this.getDisplayText(t2));
    }

    private String getDisplayText(T t2) {
        if (((ChoiceBox)this.getSkinnable()).getConverter() != null) {
            return ((ChoiceBox)this.getSkinnable()).getConverter().toString(t2);
        }
        if (t2 == null) {
            return "";
        }
        return t2.toString();
    }

    private void updateChoiceBoxItems() {
        if (this.choiceBoxItems != null) {
            this.choiceBoxItems.removeListener(this.weakChoiceBoxItemsListener);
        }
        this.choiceBoxItems = ((ChoiceBox)this.getSkinnable()).getItems();
        if (this.choiceBoxItems != null) {
            this.choiceBoxItems.addListener(this.weakChoiceBoxItemsListener);
        }
    }

    String getChoiceBoxSelectedText() {
        return this.label.getText();
    }

    ContextMenu getChoiceBoxPopup() {
        return this.popup;
    }

    private void addPopupItem(T object, int n2) {
        if (object instanceof Separator) {
            object = new SeparatorMenuItem();
        } else if (object instanceof SeparatorMenuItem) {
            object = (SeparatorMenuItem)object;
        } else {
            RadioMenuItem radioMenuItem = new RadioMenuItem(this.getDisplayText(object));
            radioMenuItem.setId("choice-box-menu-item");
            radioMenuItem.setToggleGroup(this.toggleGroup);
            radioMenuItem.setOnAction(actionEvent -> {
                if (this.selectionModel == null) {
                    return;
                }
                int n2 = ((ChoiceBox)this.getSkinnable()).getItems().indexOf(object);
                this.selectionModel.select(n2);
                radioMenuItem.setSelected(true);
            });
            object = radioMenuItem;
        }
        ((MenuItem)object).setMnemonicParsing(false);
        this.popup.getItems().add(n2, (MenuItem)object);
    }

    private void updatePopupItems() {
        this.toggleGroup.getToggles().clear();
        this.popup.getItems().clear();
        this.toggleGroup.selectToggle(null);
        for (int i2 = 0; i2 < this.choiceBoxItems.size(); ++i2) {
            Object e2 = this.choiceBoxItems.get(i2);
            this.addPopupItem(e2, i2);
        }
    }

    private void updateSelectionModel() {
        if (this.selectionModel != null) {
            this.selectionModel.selectedIndexProperty().removeListener(this.selectionChangeListener);
        }
        this.selectionModel = ((ChoiceBox)this.getSkinnable()).getSelectionModel();
        if (this.selectionModel != null) {
            this.selectionModel.selectedIndexProperty().addListener(this.selectionChangeListener);
        }
    }

    private void updateSelection() {
        if (this.selectionModel == null || this.selectionModel.isEmpty()) {
            this.toggleGroup.selectToggle(null);
            return;
        }
        int n2 = this.selectionModel.getSelectedIndex();
        if (n2 == -1 || n2 > this.popup.getItems().size()) {
            return;
        }
        if (n2 < this.popup.getItems().size()) {
            MenuItem menuItem = (MenuItem)this.popup.getItems().get(n2);
            if (menuItem instanceof RadioMenuItem) {
                ((RadioMenuItem)menuItem).setSelected(true);
                return;
            }
            this.toggleGroup.selectToggle(null);
        }
    }
}

