/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.event.ActionEvent;
import javafx.geometry.Side;
import javafx.scene.control.Tooltip;
import javafx.scene.control.skin.ColorPalette;
import javafx.scene.control.skin.ColorPalette$ColorType;
import javafx.scene.control.skin.ColorPickerSkin;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javafx.stage.Window;

class ColorPalette$ColorSquare
extends StackPane {
    Rectangle rectangle;
    int index;
    boolean isEmpty;
    ColorPalette$ColorType colorType = ColorPalette$ColorType.NORMAL;
    final /* synthetic */ ColorPalette this$0;

    public ColorPalette$ColorSquare(ColorPalette colorPalette) {
        this(colorPalette, null, -1, ColorPalette$ColorType.NORMAL);
    }

    public ColorPalette$ColorSquare(ColorPalette colorPalette, Color color, int n2) {
        this(colorPalette, color, n2, ColorPalette$ColorType.NORMAL);
    }

    public ColorPalette$ColorSquare(ColorPalette object, Color color, int n2, ColorPalette$ColorType colorPalette$ColorType) {
        this.this$0 = object;
        this.getStyleClass().add("color-square");
        if (color != null) {
            this.setFocusTraversable(true);
            this.focusedProperty().addListener((observableValue, bl2, bl3) -> this.this$0.setFocusedSquare(bl3 != false ? this : null));
            this.addEventHandler(MouseEvent.MOUSE_ENTERED, (? super T mouseEvent) -> this.this$0.setFocusedSquare(this));
            this.addEventHandler(MouseEvent.MOUSE_EXITED, (? super T mouseEvent) -> this.this$0.setFocusedSquare(null));
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, (? super T mouseEvent) -> {
                if (!this.this$0.dragDetected && mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 1) {
                    if (!this.isEmpty) {
                        Color color = (Color)this.rectangle.getFill();
                        this.this$0.colorPicker.setValue(color);
                        this.this$0.colorPicker.fireEvent(new ActionEvent());
                        this.this$0.updateSelection(color);
                        mouseEvent.consume();
                    }
                    this.this$0.colorPicker.hide();
                    return;
                }
                if ((mouseEvent.getButton() == MouseButton.SECONDARY || mouseEvent.getButton() == MouseButton.MIDDLE) && this.colorType == ColorPalette$ColorType.CUSTOM && this.this$0.contextMenu != null) {
                    if (!this.this$0.contextMenu.isShowing()) {
                        this.this$0.contextMenu.show(this, Side.RIGHT, 0.0, 0.0);
                        Utils.addMnemonics(this.this$0.contextMenu, this.getScene(), NodeHelper.isShowMnemonics(this.this$0.colorPicker));
                        return;
                    }
                    ((Window)this.this$0.contextMenu).hide();
                    Utils.removeMnemonics(this.this$0.contextMenu, this.getScene());
                }
            });
        }
        this.index = n2;
        this.colorType = colorPalette$ColorType;
        this.rectangle = new Rectangle(15.0, 15.0);
        if (color == null) {
            this.rectangle.setFill(Color.WHITE);
            this.isEmpty = true;
        } else {
            this.rectangle.setFill(color);
        }
        this.rectangle.setStrokeType(StrokeType.INSIDE);
        object = ColorPickerSkin.tooltipString(color);
        Tooltip.install(this, new Tooltip((String)(object == null ? "" : object)));
        this.rectangle.getStyleClass().add("color-rect");
        this.getChildren().add(this.rectangle);
    }

    public void selectColor(KeyEvent keyEvent) {
        if (this.rectangle.getFill() != null) {
            if (this.rectangle.getFill() instanceof Color) {
                this.this$0.colorPicker.setValue((Color)this.rectangle.getFill());
                this.this$0.colorPicker.fireEvent(new ActionEvent());
            }
            keyEvent.consume();
        }
        this.this$0.colorPicker.hide();
    }
}

