/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ColorPickerBehavior;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableStringProperty;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.ColorPalette;
import javafx.scene.control.skin.ColorPickerSkin$1;
import javafx.scene.control.skin.ColorPickerSkin$2;
import javafx.scene.control.skin.ColorPickerSkin$3;
import javafx.scene.control.skin.ColorPickerSkin$4;
import javafx.scene.control.skin.ColorPickerSkin$5;
import javafx.scene.control.skin.ColorPickerSkin$6;
import javafx.scene.control.skin.ColorPickerSkin$PickerColorBox;
import javafx.scene.control.skin.ColorPickerSkin$StyleableProperties;
import javafx.scene.control.skin.ComboBoxBaseSkin;
import javafx.scene.control.skin.ComboBoxMode;
import javafx.scene.control.skin.ComboBoxPopupControl;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.StringConverter;

public class ColorPickerSkin
extends ComboBoxPopupControl<Color> {
    private Label displayNode;
    private StackPane pickerColorBox;
    private Rectangle colorRect;
    private ColorPalette popupContent;
    private final ColorPickerBehavior behavior;
    BooleanProperty colorLabelVisible = new ColorPickerSkin$1(this, true);
    private final StyleableStringProperty imageUrl = new ColorPickerSkin$2(this);
    private final StyleableDoubleProperty colorRectWidth = new ColorPickerSkin$3(this, 12.0);
    private final StyleableDoubleProperty colorRectHeight = new ColorPickerSkin$4(this, 12.0);
    private final StyleableDoubleProperty colorRectX = new ColorPickerSkin$5(this, 0.0);
    private final StyleableDoubleProperty colorRectY = new ColorPickerSkin$6(this, 0.0);
    private static final Map<Color, String> COLOR_NAME_MAP = Map.ofEntries(Map.entry(Color.TRANSPARENT, Properties.getColorPickerString("colorName.transparent")), Map.entry(Color.BLACK, Properties.getColorPickerString("colorName.black")), Map.entry(Color.BLUE, Properties.getColorPickerString("colorName.blue")), Map.entry(Color.CYAN, Properties.getColorPickerString("colorName.cyan")), Map.entry(Color.DARKBLUE, Properties.getColorPickerString("colorName.darkblue")), Map.entry(Color.DARKCYAN, Properties.getColorPickerString("colorName.darkcyan")), Map.entry(Color.DARKGRAY, Properties.getColorPickerString("colorName.darkgray")), Map.entry(Color.DARKGREEN, Properties.getColorPickerString("colorName.darkgreen")), Map.entry(Color.DARKMAGENTA, Properties.getColorPickerString("colorName.darkmagenta")), Map.entry(Color.DARKRED, Properties.getColorPickerString("colorName.darkred")), Map.entry(Color.GRAY, Properties.getColorPickerString("colorName.gray")), Map.entry(Color.GREEN, Properties.getColorPickerString("colorName.green")), Map.entry(Color.LIGHTBLUE, Properties.getColorPickerString("colorName.lightblue")), Map.entry(Color.LIGHTCYAN, Properties.getColorPickerString("colorName.lightcyan")), Map.entry(Color.LIGHTGRAY, Properties.getColorPickerString("colorName.lightgray")), Map.entry(Color.LIGHTGREEN, Properties.getColorPickerString("colorName.lightgreen")), Map.entry(Color.LIGHTYELLOW, Properties.getColorPickerString("colorName.lightyellow")), Map.entry(Color.LIME, Properties.getColorPickerString("colorName.lime")), Map.entry(Color.MAGENTA, Properties.getColorPickerString("colorName.magenta")), Map.entry(Color.MAROON, Properties.getColorPickerString("colorName.maroon")), Map.entry(Color.MEDIUMBLUE, Properties.getColorPickerString("colorName.mediumblue")), Map.entry(Color.NAVY, Properties.getColorPickerString("colorName.navy")), Map.entry(Color.OLIVE, Properties.getColorPickerString("colorName.olive")), Map.entry(Color.ORANGE, Properties.getColorPickerString("colorName.orange")), Map.entry(Color.PINK, Properties.getColorPickerString("colorName.pink")), Map.entry(Color.PURPLE, Properties.getColorPickerString("colorName.purple")), Map.entry(Color.RED, Properties.getColorPickerString("colorName.red")), Map.entry(Color.TEAL, Properties.getColorPickerString("colorName.teal")), Map.entry(Color.WHITE, Properties.getColorPickerString("colorName.white")), Map.entry(Color.YELLOW, Properties.getColorPickerString("colorName.yellow")));
    private static final Map<Color, String> CSS_NAME_MAP = Map.ofEntries(Map.entry(Color.ALICEBLUE, "aliceblue"), Map.entry(Color.ANTIQUEWHITE, "antiquewhite"), Map.entry(Color.AQUAMARINE, "aquamarine"), Map.entry(Color.AZURE, "azure"), Map.entry(Color.BEIGE, "beige"), Map.entry(Color.BISQUE, "bisque"), Map.entry(Color.BLACK, "black"), Map.entry(Color.BLANCHEDALMOND, "blanchedalmond"), Map.entry(Color.BLUE, "blue"), Map.entry(Color.BLUEVIOLET, "blueviolet"), Map.entry(Color.BROWN, "brown"), Map.entry(Color.BURLYWOOD, "burlywood"), Map.entry(Color.CADETBLUE, "cadetblue"), Map.entry(Color.CHARTREUSE, "chartreuse"), Map.entry(Color.CHOCOLATE, "chocolate"), Map.entry(Color.CORAL, "coral"), Map.entry(Color.CORNFLOWERBLUE, "cornflowerblue"), Map.entry(Color.CORNSILK, "cornsilk"), Map.entry(Color.CRIMSON, "crimson"), Map.entry(Color.CYAN, "cyan"), Map.entry(Color.DARKBLUE, "darkblue"), Map.entry(Color.DARKCYAN, "darkcyan"), Map.entry(Color.DARKGOLDENROD, "darkgoldenrod"), Map.entry(Color.DARKGRAY, "darkgray"), Map.entry(Color.DARKGREEN, "darkgreen"), Map.entry(Color.DARKKHAKI, "darkkhaki"), Map.entry(Color.DARKMAGENTA, "darkmagenta"), Map.entry(Color.DARKOLIVEGREEN, "darkolivegreen"), Map.entry(Color.DARKORANGE, "darkorange"), Map.entry(Color.DARKORCHID, "darkorchid"), Map.entry(Color.DARKRED, "darkred"), Map.entry(Color.DARKSALMON, "darksalmon"), Map.entry(Color.DARKSEAGREEN, "darkseagreen"), Map.entry(Color.DARKSLATEBLUE, "darkslateblue"), Map.entry(Color.DARKSLATEGRAY, "darkslategray"), Map.entry(Color.DARKTURQUOISE, "darkturquoise"), Map.entry(Color.DARKVIOLET, "darkviolet"), Map.entry(Color.DEEPPINK, "deeppink"), Map.entry(Color.DEEPSKYBLUE, "deepskyblue"), Map.entry(Color.DIMGRAY, "dimgray"), Map.entry(Color.DODGERBLUE, "dodgerblue"), Map.entry(Color.FIREBRICK, "firebrick"), Map.entry(Color.FLORALWHITE, "floralwhite"), Map.entry(Color.FORESTGREEN, "forestgreen"), Map.entry(Color.GAINSBORO, "gainsboro"), Map.entry(Color.GHOSTWHITE, "ghostwhite"), Map.entry(Color.GOLD, "gold"), Map.entry(Color.GOLDENROD, "goldenrod"), Map.entry(Color.GRAY, "gray"), Map.entry(Color.GREEN, "green"), Map.entry(Color.GREENYELLOW, "greenyellow"), Map.entry(Color.HONEYDEW, "honeydew"), Map.entry(Color.HOTPINK, "hotpink"), Map.entry(Color.INDIANRED, "indianred"), Map.entry(Color.INDIGO, "indigo"), Map.entry(Color.IVORY, "ivory"), Map.entry(Color.KHAKI, "khaki"), Map.entry(Color.LAVENDER, "lavender"), Map.entry(Color.LAVENDERBLUSH, "lavenderblush"), Map.entry(Color.LAWNGREEN, "lawngreen"), Map.entry(Color.LEMONCHIFFON, "lemonchiffon"), Map.entry(Color.LIGHTBLUE, "lightblue"), Map.entry(Color.LIGHTCORAL, "lightcoral"), Map.entry(Color.LIGHTCYAN, "lightcyan"), Map.entry(Color.LIGHTGOLDENRODYELLOW, "lightgoldenrodyellow"), Map.entry(Color.LIGHTGRAY, "lightgray"), Map.entry(Color.LIGHTGREEN, "lightgreen"), Map.entry(Color.LIGHTPINK, "lightpink"), Map.entry(Color.LIGHTSALMON, "lightsalmon"), Map.entry(Color.LIGHTSEAGREEN, "lightseagreen"), Map.entry(Color.LIGHTSKYBLUE, "lightskyblue"), Map.entry(Color.LIGHTSLATEGRAY, "lightslategray"), Map.entry(Color.LIGHTSTEELBLUE, "lightsteelblue"), Map.entry(Color.LIGHTYELLOW, "lightyellow"), Map.entry(Color.LIME, "lime"), Map.entry(Color.LIMEGREEN, "limegreen"), Map.entry(Color.LINEN, "linen"), Map.entry(Color.MAGENTA, "magenta"), Map.entry(Color.MAROON, "maroon"), Map.entry(Color.MEDIUMAQUAMARINE, "mediumaquamarine"), Map.entry(Color.MEDIUMBLUE, "mediumblue"), Map.entry(Color.MEDIUMORCHID, "mediumorchid"), Map.entry(Color.MEDIUMPURPLE, "mediumpurple"), Map.entry(Color.MEDIUMSEAGREEN, "mediumseagreen"), Map.entry(Color.MEDIUMSLATEBLUE, "mediumslateblue"), Map.entry(Color.MEDIUMSPRINGGREEN, "mediumspringgreen"), Map.entry(Color.MEDIUMTURQUOISE, "mediumturquoise"), Map.entry(Color.MEDIUMVIOLETRED, "mediumvioletred"), Map.entry(Color.MIDNIGHTBLUE, "midnightblue"), Map.entry(Color.MINTCREAM, "mintcream"), Map.entry(Color.MISTYROSE, "mistyrose"), Map.entry(Color.MOCCASIN, "moccasin"), Map.entry(Color.NAVAJOWHITE, "navajowhite"), Map.entry(Color.NAVY, "navy"), Map.entry(Color.OLDLACE, "oldlace"), Map.entry(Color.OLIVE, "olive"), Map.entry(Color.OLIVEDRAB, "olivedrab"), Map.entry(Color.ORANGE, "orange"), Map.entry(Color.ORANGERED, "orangered"), Map.entry(Color.ORCHID, "orchid"), Map.entry(Color.PALEGOLDENROD, "palegoldenrod"), Map.entry(Color.PALEGREEN, "palegreen"), Map.entry(Color.PALETURQUOISE, "paleturquoise"), Map.entry(Color.PALEVIOLETRED, "palevioletred"), Map.entry(Color.PAPAYAWHIP, "papayawhip"), Map.entry(Color.PEACHPUFF, "peachpuff"), Map.entry(Color.PERU, "peru"), Map.entry(Color.PINK, "pink"), Map.entry(Color.PLUM, "plum"), Map.entry(Color.POWDERBLUE, "powderblue"), Map.entry(Color.PURPLE, "purple"), Map.entry(Color.RED, "red"), Map.entry(Color.ROSYBROWN, "rosybrown"), Map.entry(Color.ROYALBLUE, "royalblue"), Map.entry(Color.SADDLEBROWN, "saddlebrown"), Map.entry(Color.SALMON, "salmon"), Map.entry(Color.SANDYBROWN, "sandybrown"), Map.entry(Color.SEAGREEN, "seagreen"), Map.entry(Color.SEASHELL, "seashell"), Map.entry(Color.SIENNA, "sienna"), Map.entry(Color.SILVER, "silver"), Map.entry(Color.SKYBLUE, "skyblue"), Map.entry(Color.SLATEBLUE, "slateblue"), Map.entry(Color.SLATEGRAY, "slategray"), Map.entry(Color.SNOW, "snow"), Map.entry(Color.SPRINGGREEN, "springgreen"), Map.entry(Color.STEELBLUE, "steelblue"), Map.entry(Color.TAN, "tan"), Map.entry(Color.TEAL, "teal"), Map.entry(Color.THISTLE, "thistle"), Map.entry(Color.TOMATO, "tomato"), Map.entry(Color.TRANSPARENT, "transparent"), Map.entry(Color.TURQUOISE, "turquoise"), Map.entry(Color.VIOLET, "violet"), Map.entry(Color.WHEAT, "wheat"), Map.entry(Color.WHITE, "white"), Map.entry(Color.WHITESMOKE, "whitesmoke"), Map.entry(Color.YELLOW, "yellow"), Map.entry(Color.YELLOWGREEN, "yellowgreen"));

    public ColorPickerSkin(ColorPicker colorPicker) {
        super(colorPicker);
        this.behavior = new ColorPickerBehavior(colorPicker);
        this.updateComboBoxMode();
        ListenerHelper.get(this).addChangeListener(colorPicker.valueProperty(), color -> this.updateColor());
        this.displayNode = new Label();
        this.displayNode.getStyleClass().add("color-picker-label");
        this.displayNode.setManaged(false);
        this.pickerColorBox = new ColorPickerSkin$PickerColorBox(this);
        this.pickerColorBox.getStyleClass().add("picker-color");
        this.colorRect = new Rectangle(12.0, 12.0);
        this.colorRect.getStyleClass().add("picker-color-rect");
        this.updateColor();
        this.pickerColorBox.getChildren().add(this.colorRect);
        this.displayNode.setGraphic(this.pickerColorBox);
        if (colorPicker.isShowing()) {
            ((ComboBoxBaseSkin)this).show();
        }
    }

    private final StringProperty imageUrlProperty() {
        return this.imageUrl;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            ((BehaviorBase)this.behavior).dispose();
        }
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        if (!this.colorLabelVisible.get()) {
            return super.computePrefWidth(d2, d3, d4, d5, d6);
        }
        String string = this.displayNode.getText();
        double d7 = 0.0;
        for (String string2 : COLOR_NAME_MAP.values()) {
            this.displayNode.setText(string2);
            d7 = Math.max(d7, super.computePrefWidth(d2, d3, d4, d5, d6));
        }
        this.displayNode.setText(Utils.formatHexString(Color.BLACK));
        d7 = Math.max(d7, super.computePrefWidth(d2, d3, d4, d5, d6));
        this.displayNode.setText(string);
        return d7;
    }

    @Override
    protected Node getPopupContent() {
        if (this.popupContent == null) {
            this.popupContent = new ColorPalette((ColorPicker)this.getSkinnable());
            this.popupContent.setPopupControl(this.getPopup());
        }
        return this.popupContent;
    }

    @Override
    public void show() {
        super.show();
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        this.popupContent.updateSelection((Color)colorPicker.getValue());
    }

    @Override
    public Node getDisplayNode() {
        return this.displayNode;
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        this.updateComboBoxMode();
        super.layoutChildren(d2, d3, d4, d5);
    }

    @Override
    void focusLost() {
    }

    @Override
    ComboBoxBaseBehavior getBehavior() {
        return this.behavior;
    }

    private void updateComboBoxMode() {
        ObservableList<String> observableList = ((ComboBoxBase)this.getSkinnable()).getStyleClass();
        if (observableList.contains("button")) {
            this.setMode(ComboBoxMode.BUTTON);
            return;
        }
        if (observableList.contains("split-button")) {
            this.setMode(ComboBoxMode.SPLITBUTTON);
        }
    }

    static String colorDisplayName(Color color) {
        if (color != null) {
            String string = COLOR_NAME_MAP.get(color);
            if (string == null) {
                string = Utils.formatHexString(color);
            }
            return string;
        }
        return null;
    }

    static String tooltipString(Color object) {
        if (object != null) {
            Object object2 = "";
            String string = COLOR_NAME_MAP.get(object);
            if (string != null) {
                object2 = (String)object2 + string + " ";
            }
            object2 = (String)object2 + Utils.formatHexString((Color)object);
            if ((object = CSS_NAME_MAP.get(object)) != null) {
                object2 = (String)object2 + " (css: " + (String)object + ")";
            }
            return object2;
        }
        return null;
    }

    private void updateColor() {
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        this.colorRect.setFill((Paint)colorPicker.getValue());
        if (this.colorLabelVisible.get()) {
            this.displayNode.setText(ColorPickerSkin.colorDisplayName((Color)colorPicker.getValue()));
            return;
        }
        this.displayNode.setText("");
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return ColorPickerSkin$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ColorPickerSkin.getClassCssMetaData();
    }

    @Override
    protected StringConverter<Color> getConverter() {
        return null;
    }

    @Override
    protected TextField getEditor() {
        return null;
    }
}

