/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.IDisconnectable;
import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.behavior.ComboBoxListViewBehavior;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.ComboBoxBaseSkin;
import javafx.scene.control.skin.ComboBoxListViewSkin$1;
import javafx.scene.control.skin.ComboBoxListViewSkin$2;
import javafx.scene.control.skin.ComboBoxListViewSkin$3;
import javafx.scene.control.skin.ComboBoxListViewSkin$4;
import javafx.scene.control.skin.ComboBoxPopupControl;
import javafx.scene.control.skin.VirtualContainerBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ComboBoxListViewSkin<T>
extends ComboBoxPopupControl<T> {
    private static final String COMBO_BOX_ROWS_TO_MEASURE_WIDTH_KEY = "comboBoxRowsToMeasureWidth";
    private final ComboBox<T> comboBox;
    private ObservableList<T> comboBoxItems;
    private ListCell<T> buttonCell;
    private Callback<ListView<T>, ListCell<T>> cellFactory;
    private final ListView<T> listView;
    private ObservableList<T> listViewItems;
    private boolean listSelectionLock = false;
    private boolean listViewSelectionDirty = false;
    private final ComboBoxListViewBehavior behavior;
    private IDisconnectable selectedItemWatcher;
    private boolean itemCountDirty;
    private final ListChangeListener<T> listViewItemsListener = new ComboBoxListViewSkin$1(this);
    private final WeakListChangeListener<T> weakListViewItemsListener = new WeakListChangeListener<T>(this.listViewItemsListener);
    private final BooleanProperty hideOnClick = new SimpleBooleanProperty(this, "hideOnClick", true);
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass("selected");
    private static final PseudoClass PSEUDO_CLASS_EMPTY = PseudoClass.getPseudoClass("empty");
    private static final PseudoClass PSEUDO_CLASS_FILLED = PseudoClass.getPseudoClass("filled");

    public ComboBoxListViewSkin(ComboBox<T> comboBox) {
        super(comboBox);
        this.behavior = new ComboBoxListViewBehavior<T>(comboBox);
        this.comboBox = comboBox;
        this.updateComboBoxItems();
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addInvalidationListener(comboBox.itemsProperty(), observable -> {
            this.updateComboBoxItems();
            this.updateListViewItems();
        });
        this.listView = this.createListView();
        this.listView.setManaged(false);
        this.getChildren().add(this.listView);
        this.updateListViewItems();
        this.updateCellFactory();
        this.updateButtonCell();
        this.updateValue();
        listenerHelper.addChangeListener(comboBox.itemsProperty(), observableList -> {
            this.updateComboBoxItems();
            this.updateListViewItems();
        });
        listenerHelper.addChangeListener(comboBox.promptTextProperty(), string -> this.updateDisplayNode());
        listenerHelper.addChangeListener(comboBox.cellFactoryProperty(), callback -> this.updateCellFactory());
        listenerHelper.addChangeListener(comboBox.visibleRowCountProperty(), number -> {
            if (this.listView == null) {
                return;
            }
            this.listView.requestLayout();
        });
        listenerHelper.addChangeListener(comboBox.converterProperty(), stringConverter -> this.updateListViewItems());
        listenerHelper.addChangeListener(comboBox.buttonCellProperty(), listCell -> {
            this.updateButtonCell();
            this.updateDisplayArea();
        });
        listenerHelper.addChangeListener(comboBox.valueProperty(), object -> {
            this.updateValue();
            comboBox.fireEvent(new ActionEvent());
        });
        listenerHelper.addChangeListener(comboBox.editableProperty(), bl2 -> this.updateEditable());
        if (this.comboBox.isShowing()) {
            ((ComboBoxBaseSkin)this).show();
        }
        listenerHelper.addInvalidationListener(this.comboBox.sceneProperty(), observable -> {
            if (((ObservableValue)observable).getValue() == null) {
                this.comboBox.hide();
            }
        });
    }

    public final BooleanProperty hideOnClickProperty() {
        return this.hideOnClick;
    }

    public final boolean isHideOnClick() {
        return this.hideOnClick.get();
    }

    public final void setHideOnClick(boolean bl2) {
        this.hideOnClick.set(bl2);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            ((BehaviorBase)this.behavior).dispose();
        }
    }

    @Override
    protected TextField getEditor() {
        if (((ComboBoxBase)this.getSkinnable()).isEditable()) {
            return ((ComboBox)this.getSkinnable()).getEditor();
        }
        return null;
    }

    @Override
    protected StringConverter<T> getConverter() {
        return ((ComboBox)this.getSkinnable()).getConverter();
    }

    @Override
    public Node getDisplayNode() {
        Control control = this.comboBox.isEditable() ? this.getEditableInputNode() : this.buttonCell;
        this.updateDisplayNode();
        return control;
    }

    @Override
    public Node getPopupContent() {
        return this.listView;
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        this.reconfigurePopup();
        return 50.0;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = super.computePrefWidth(d2, d3, d4, d5, d6);
        double d8 = ((Node)this.listView).prefWidth(d2);
        double d9 = Math.max(d7, d8);
        this.reconfigurePopup();
        return d9;
    }

    @Override
    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        this.reconfigurePopup();
        return super.computeMaxWidth(d2, d3, d4, d5, d6);
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        this.reconfigurePopup();
        return super.computeMinHeight(d2, d3, d4, d5, d6);
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        this.reconfigurePopup();
        return super.computePrefHeight(d2, d3, d4, d5, d6);
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        this.reconfigurePopup();
        return super.computeMaxHeight(d2, d3, d4, d5, d6);
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        if (this.listViewSelectionDirty) {
            try {
                this.listSelectionLock = true;
                SingleSelectionModel<T> singleSelectionModel = this.comboBox.getSelectionModel();
                if (singleSelectionModel != null) {
                    singleSelectionModel = singleSelectionModel.getSelectedItem();
                    this.listView.getSelectionModel().clearSelection();
                    this.listView.getSelectionModel().select(singleSelectionModel);
                }
            }
            finally {
                this.listSelectionLock = false;
                this.listViewSelectionDirty = false;
            }
        }
        super.layoutChildren(d2, d3, d4, d5);
    }

    @Override
    void updateDisplayNode() {
        if (this.getEditor() != null) {
            super.updateDisplayNode();
            return;
        }
        Object t2 = this.comboBox.getValue();
        int n2 = this.getIndexOfComboBoxValueInItemsList();
        if (n2 >= 0) {
            this.buttonCell.setItem(null);
            this.buttonCell.updateIndex(n2);
            return;
        }
        this.buttonCell.updateIndex(-1);
        ComboBoxListViewSkin comboBoxListViewSkin = this;
        boolean bl2 = comboBoxListViewSkin.updateDisplayText(comboBoxListViewSkin.buttonCell, t2, false);
        this.buttonCell.pseudoClassStateChanged(PSEUDO_CLASS_EMPTY, bl2);
        this.buttonCell.pseudoClassStateChanged(PSEUDO_CLASS_FILLED, !bl2);
        this.buttonCell.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, true);
    }

    @Override
    ComboBoxBaseBehavior getBehavior() {
        return this.behavior;
    }

    private void updateComboBoxItems() {
        this.comboBoxItems = this.comboBox.getItems();
        this.comboBoxItems = this.comboBoxItems == null ? FXCollections.emptyObservableList() : this.comboBoxItems;
    }

    private void updateListViewItems() {
        if (this.listViewItems != null) {
            this.listViewItems.removeListener(this.weakListViewItemsListener);
        }
        this.listViewItems = this.comboBoxItems;
        this.listView.setItems(this.listViewItems);
        if (this.listViewItems != null) {
            this.listViewItems.addListener(this.weakListViewItemsListener);
        }
        this.itemCountDirty = true;
        ((ComboBoxBase)this.getSkinnable()).requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateValue() {
        SingleSelectionModel<T> singleSelectionModel = this.comboBox.getSelectionModel();
        if (singleSelectionModel == null) {
            return;
        }
        Object t2 = this.comboBox.getValue();
        MultipleSelectionModel multipleSelectionModel = this.listView.getSelectionModel();
        int n2 = this.getIndexOfComboBoxValueInItemsList();
        if (t2 == null && n2 == -1) {
            multipleSelectionModel.clearSelection();
            return;
        }
        if (n2 == -1) {
            this.listSelectionLock = true;
            multipleSelectionModel.clearSelection();
            this.listSelectionLock = false;
            return;
        }
        int n3 = singleSelectionModel.getSelectedIndex();
        if (n3 >= 0 && n3 < this.comboBoxItems.size()) {
            Object e2 = this.comboBoxItems.get(n3);
            if (e2 != null && e2.equals(t2) || e2 == null && t2 == null) {
                multipleSelectionModel.select(n3);
                return;
            }
            multipleSelectionModel.select(t2);
            return;
        }
        n2 = this.comboBoxItems.indexOf(t2);
        if (n2 == -1) {
            this.updateDisplayNode();
            return;
        }
        multipleSelectionModel.select(n2);
    }

    private boolean updateDisplayText(ListCell<T> listCell, T object, boolean bl2) {
        if (bl2) {
            if (listCell == null) {
                return true;
            }
            listCell.setGraphic(null);
            listCell.setText(null);
            return true;
        }
        if (object instanceof Node) {
            Node node = listCell.getGraphic();
            Node node2 = (Node)object;
            if (node == null || !node.equals(node2)) {
                listCell.setText(null);
                listCell.setGraphic(node2);
            }
            return node2 == null;
        }
        StringConverter<T> stringConverter = this.comboBox.getConverter();
        String string = this.comboBox.getPromptText();
        object = object == null && string != null ? string : (stringConverter == null ? (object == null ? null : object.toString()) : stringConverter.toString(object));
        listCell.setText((String)object);
        listCell.setGraphic(null);
        return object == null || ((String)object).isEmpty();
    }

    private int getIndexOfComboBoxValueInItemsList() {
        Object t2 = this.comboBox.getValue();
        int n2 = this.comboBoxItems.indexOf(t2);
        return n2;
    }

    private void updateButtonCell() {
        this.buttonCell = this.comboBox.getButtonCell() != null ? this.comboBox.getButtonCell() : this.getDefaultCellFactory().call(this.listView);
        this.buttonCell.setMouseTransparent(true);
        this.buttonCell.updateListView(this.listView);
        this.buttonCell.setAccessibleRole(AccessibleRole.NODE);
    }

    private void updateCellFactory() {
        Callback<ListView<T>, ListCell<T>> callback = this.comboBox.getCellFactory();
        this.cellFactory = callback != null ? callback : this.getDefaultCellFactory();
        this.listView.setCellFactory(this.cellFactory);
    }

    private Callback<ListView<T>, ListCell<T>> getDefaultCellFactory() {
        return new ComboBoxListViewSkin$2(this);
    }

    private ListView<T> createListView() {
        ComboBoxListViewSkin$3 comboBoxListViewSkin$3 = new ComboBoxListViewSkin$3(this);
        comboBoxListViewSkin$3.setId("list-view");
        comboBoxListViewSkin$3.placeholderProperty().bind(this.comboBox.placeholderProperty());
        comboBoxListViewSkin$3.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        comboBoxListViewSkin$3.setFocusTraversable(false);
        comboBoxListViewSkin$3.getSelectionModel().selectedIndexProperty().addListener(singleSelectionModel -> {
            if (this.listSelectionLock) {
                return;
            }
            singleSelectionModel = this.comboBox.getSelectionModel();
            if (singleSelectionModel == null) {
                return;
            }
            int n2 = this.listView.getSelectionModel().getSelectedIndex();
            ((SelectionModel)((Object)singleSelectionModel)).select(n2);
            this.updateDisplayNode();
            this.comboBox.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT);
        });
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addChangeListener(this.comboBox.selectionModelProperty(), true, (observableValue, singleSelectionModel, singleSelectionModel2) -> {
            if (this.selectedItemWatcher != null) {
                this.selectedItemWatcher.disconnect();
            }
            if (singleSelectionModel2 != null) {
                this.selectedItemWatcher = listenerHelper.addInvalidationListener(singleSelectionModel2.selectedItemProperty(), observable -> {
                    this.listViewSelectionDirty = true;
                });
            }
        });
        comboBoxListViewSkin$3.addEventFilter(MouseEvent.MOUSE_RELEASED, observableList -> {
            if ((observableList = ((Event)((Object)observableList)).getTarget()) instanceof Parent && ((observableList = ((Parent)((Object)observableList)).getStyleClass()).contains("thumb") || observableList.contains("track") || observableList.contains("decrement-arrow") || observableList.contains("increment-arrow"))) {
                return;
            }
            if (this.isHideOnClick()) {
                this.comboBox.hide();
            }
        });
        comboBoxListViewSkin$3.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER || keyEvent.getCode() == KeyCode.SPACE || keyEvent.getCode() == KeyCode.ESCAPE) {
                this.comboBox.hide();
            }
        });
        return comboBoxListViewSkin$3;
    }

    private double getListViewPrefHeight() {
        double d2;
        if (this.listView.getSkin() instanceof VirtualContainerBase) {
            int n2 = this.comboBox.getVisibleRowCount();
            VirtualContainerBase virtualContainerBase = (VirtualContainerBase)this.listView.getSkin();
            d2 = virtualContainerBase.getVirtualFlowPreferredHeight(n2);
        } else {
            double d3 = this.comboBoxItems.size() * 25;
            d2 = Math.min(d3, 200.0);
        }
        return d2;
    }

    ListView<T> getListView() {
        return this.listView;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (ComboBoxListViewSkin$4.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                if (this.comboBox.isShowing()) {
                    return ((Node)this.listView).queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
                }
                return null;
            }
            case 2: {
                object = this.comboBox.getAccessibleText();
                if (object != null && !((String)object).isEmpty()) {
                    return object;
                }
                object = this.comboBox.isEditable() ? this.getEditor().getText() : this.buttonCell.getText();
                if (object == null || ((String)object).isEmpty()) {
                    object = this.comboBox.getPromptText();
                }
                return object;
            }
            case 3: {
                if (this.getEditor() != null) {
                    return this.getEditor().getSelection().getStart();
                }
                return null;
            }
            case 4: {
                if (this.getEditor() != null) {
                    return this.getEditor().getSelection().getEnd();
                }
                return null;
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }
}

