/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ContextMenuContent;
import com.sun.javafx.scene.control.EmbeddedTextContextMenuContent;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusBehavior;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusPopupBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Collection;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ContextMenuSkin$1;
import javafx.scene.control.skin.ContextMenuSkin$2;
import javafx.scene.control.skin.ContextMenuSkin$3;
import javafx.scene.control.skin.ContextMenuSkin$4;
import javafx.scene.control.skin.ContextMenuSkin$5;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.stage.WindowEvent;

public class ContextMenuSkin
implements Skin<ContextMenu> {
    private ContextMenu popupMenu;
    private final Region root;
    private TwoLevelFocusPopupBehavior tlFocus;
    private double prefHeight;
    private double shiftY;
    private double prefWidth;
    private double shiftX;
    private final EventHandler<KeyEvent> keyListener = new ContextMenuSkin$1(this);

    public ContextMenuSkin(ContextMenu contextMenu) {
        this.popupMenu = contextMenu;
        this.popupMenu.addEventHandler(Menu.ON_SHOWING, new ContextMenuSkin$2(this));
        this.popupMenu.addEventHandler(Menu.ON_SHOWN, new ContextMenuSkin$3(this));
        this.popupMenu.addEventHandler(Menu.ON_HIDDEN, new ContextMenuSkin$4(this));
        this.popupMenu.addEventFilter(WindowEvent.WINDOW_HIDING, new ContextMenuSkin$5(this));
        this.root = Properties.IS_TOUCH_SUPPORTED && this.popupMenu.getStyleClass().contains("text-input-context-menu") ? new EmbeddedTextContextMenuContent(this.popupMenu) : new ContextMenuContent(this.popupMenu);
        this.root.idProperty().bind(this.popupMenu.idProperty());
        this.root.styleProperty().bind(this.popupMenu.styleProperty());
        this.root.getStyleClass().addAll((Collection<String>)this.popupMenu.getStyleClass());
        if (Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusPopupBehavior(this.popupMenu);
        }
    }

    @Override
    public ContextMenu getSkinnable() {
        return this.popupMenu;
    }

    @Override
    public Node getNode() {
        return this.root;
    }

    @Override
    public void dispose() {
        this.root.idProperty().unbind();
        this.root.styleProperty().unbind();
        Region region = this.root;
        if (region instanceof ContextMenuContent) {
            region = (ContextMenuContent)region;
            ((ContextMenuContent)region).disposeListeners();
        }
        if (this.tlFocus != null) {
            ((TwoLevelFocusBehavior)this.tlFocus).dispose();
        }
    }

    private void performPopupShifts() {
        ContextMenu contextMenu = this.getSkinnable();
        Object object = contextMenu.getOwnerNode();
        if (object == null) {
            return;
        }
        Node node = object;
        object = node.localToScreen(node.getLayoutBounds());
        if (object == null) {
            return;
        }
        double d2 = ((Node)this.root).prefHeight(-1.0);
        this.shiftY = this.prefHeight - d2;
        if (this.shiftY > 0.0 && contextMenu.getY() + d2 < ((Bounds)object).getMinY()) {
            ContextMenu contextMenu2 = contextMenu;
            contextMenu2.setY(contextMenu2.getY() + this.shiftY);
        }
        double d3 = ((Node)this.root).prefWidth(-1.0);
        this.shiftX = this.prefWidth - d3;
        if (this.shiftX > 0.0 && contextMenu.getX() + d3 < ((Bounds)object).getMinX()) {
            ContextMenu contextMenu3 = contextMenu;
            contextMenu3.setX(contextMenu3.getX() + this.shiftX);
        }
    }
}

