/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ListViewBehavior;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.security.AccessController;
import java.util.ArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.collections.WeakMapChangeListener;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.skin.ListViewSkin$1;
import javafx.scene.control.skin.ListViewSkin$2;
import javafx.scene.control.skin.ListViewSkin$3;
import javafx.scene.control.skin.VirtualContainerBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public class ListViewSkin<T>
extends VirtualContainerBase<ListView<T>, ListCell<T>> {
    private static final boolean IS_PANNABLE = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.scene.control.skin.ListViewSkin.pannable"));
    private static final String EMPTY_LIST_TEXT = ControlResources.getString("ListView.noContent");
    private final VirtualFlow<ListCell<T>> flow;
    private StackPane placeholderRegion;
    private Node placeholderNode;
    private ObservableList<T> listViewItems;
    private boolean needCellsRebuilt = true;
    private boolean needCellsReconfigured = false;
    private int itemCount = -1;
    private ListViewBehavior<T> behavior;
    private MapChangeListener<Object, Object> propertiesMapListener = mapChangeListener$Change -> {
        if (!mapChangeListener$Change.wasAdded()) {
            return;
        }
        if ("recreateKey".equals(mapChangeListener$Change.getKey())) {
            this.needCellsRebuilt = true;
            ((ListView)this.getSkinnable()).requestLayout();
            ((ListView)this.getSkinnable()).getProperties().remove("recreateKey");
        }
    };
    private WeakMapChangeListener<Object, Object> weakPropertiesMapListener = new WeakMapChangeListener<Object, Object>(this.propertiesMapListener);
    private final ListChangeListener<T> listViewItemsListener = new ListViewSkin$1(this);
    private final WeakListChangeListener<T> weakListViewItemsListener = new WeakListChangeListener<T>(this.listViewItemsListener);
    private final InvalidationListener itemsChangeListener = observable -> this.updateListViewItems();
    private WeakInvalidationListener weakItemsChangeListener = new WeakInvalidationListener(this.itemsChangeListener);

    public ListViewSkin(ListView<T> listView) {
        super(listView);
        this.behavior = new ListViewBehavior<T>(listView);
        this.behavior.setOnFocusPreviousRow(() -> this.onFocusPreviousCell());
        this.behavior.setOnFocusNextRow(() -> this.onFocusNextCell());
        this.behavior.setOnMoveToFirstCell(() -> this.onMoveToFirstCell());
        this.behavior.setOnMoveToLastCell(() -> this.onMoveToLastCell());
        this.behavior.setOnSelectPreviousRow(() -> this.onSelectPreviousCell());
        this.behavior.setOnSelectNextRow(() -> this.onSelectNextCell());
        this.behavior.setOnScrollPageDown(this::onScrollPageDown);
        this.behavior.setOnScrollPageUp(this::onScrollPageUp);
        this.updateListViewItems();
        this.flow = this.getVirtualFlow();
        this.flow.setId("virtual-flow");
        this.flow.setPannable(IS_PANNABLE);
        this.flow.setVertical(listView.getOrientation() == Orientation.VERTICAL);
        this.flow.setCellFactory(virtualFlow -> this.createCell());
        this.flow.setFixedCellSize(listView.getFixedCellSize());
        this.getChildren().add(this.flow);
        Object object = mouseEvent -> {
            if (listView.isFocusTraversable()) {
                listView.requestFocus();
            }
        };
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, object);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, object);
        this.updateItemCount();
        listView.itemsProperty().addListener(this.weakItemsChangeListener);
        object = listView.getProperties();
        object.remove("recreateKey");
        object.addListener(this.weakPropertiesMapListener);
        this.registerChangeListener(listView.itemsProperty(), observableValue -> this.updateListViewItems());
        this.registerChangeListener(listView.orientationProperty(), observableValue -> this.flow.setVertical(listView.getOrientation() == Orientation.VERTICAL));
        this.registerChangeListener(listView.cellFactoryProperty(), observableValue -> this.flow.recreateCells());
        this.registerChangeListener(listView.parentProperty(), observableValue -> {
            if (listView.getParent() != null && listView.isVisible()) {
                listView.requestLayout();
            }
        });
        this.registerChangeListener(listView.placeholderProperty(), observableValue -> this.updatePlaceholderRegionVisibility());
        this.registerChangeListener(listView.fixedCellSizeProperty(), observableValue -> this.flow.setFixedCellSize(listView.getFixedCellSize()));
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        ((ListView)this.getSkinnable()).getProperties().removeListener(this.weakPropertiesMapListener);
        ((ListView)this.getSkinnable()).itemsProperty().removeListener(this.weakItemsChangeListener);
        if (this.listViewItems != null) {
            this.listViewItems.removeListener(this.weakListViewItemsListener);
            this.listViewItems = null;
        }
        this.getChildren().remove(this.flow);
        super.dispose();
        if (this.behavior != null) {
            ((BehaviorBase)this.behavior).dispose();
        }
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        super.layoutChildren(d2, d3, d4, d5);
        if (this.needCellsRebuilt) {
            this.flow.rebuildCells();
        } else if (this.needCellsReconfigured) {
            this.flow.reconfigureCells();
        }
        this.needCellsRebuilt = false;
        this.needCellsReconfigured = false;
        if (this.getItemCount() == 0) {
            if (this.placeholderRegion != null) {
                this.placeholderRegion.setVisible(d4 > 0.0 && d5 > 0.0);
                this.placeholderRegion.resizeRelocate(d2, d3, d4, d5);
                return;
            }
        } else {
            this.flow.resizeRelocate(d2, d3, d4, d5);
        }
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        this.checkState();
        if (this.getItemCount() == 0) {
            if (this.placeholderRegion == null) {
                this.updatePlaceholderRegionVisibility();
            }
            if (this.placeholderRegion != null) {
                return ((Node)this.placeholderRegion).prefWidth(d2) + d6 + d4;
            }
        }
        return this.computePrefHeight(-1.0, d3, d4, d5, d6) * 0.618033987;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return 400.0;
    }

    @Override
    protected int getItemCount() {
        return this.itemCount;
    }

    @Override
    protected void updateItemCount() {
        int n2;
        if (this.flow == null) {
            return;
        }
        int n3 = this.itemCount;
        this.itemCount = n2 = this.listViewItems == null ? 0 : this.listViewItems.size();
        this.flow.setCellCount(n2);
        this.updatePlaceholderRegionVisibility();
        if (n2 == n3) {
            this.needCellsReconfigured = true;
            return;
        }
        if (n3 == 0) {
            this.requestRebuildCells();
        }
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute object, Object ... object2) {
        switch (ListViewSkin$3.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                object = ((ListView)this.getSkinnable()).getFocusModel();
                if (object == null) {
                    if (this.placeholderRegion != null && this.placeholderRegion.isVisible()) {
                        return this.placeholderRegion.getChildren().get(0);
                    }
                    return null;
                }
                int n2 = ((FocusModel)object).getFocusedIndex();
                if (n2 == -1) {
                    if (this.placeholderRegion != null && this.placeholderRegion.isVisible()) {
                        return this.placeholderRegion.getChildren().get(0);
                    }
                    if (this.getItemCount() > 0) {
                        n2 = 0;
                    } else {
                        return null;
                    }
                }
                return this.flow.getPrivateCell(n2);
            }
            case 2: {
                return this.getItemCount();
            }
            case 3: {
                object = (Integer)object2[0];
                if (object == null) {
                    return null;
                }
                if (0 <= (Integer)object && (Integer)object < this.getItemCount()) {
                    return this.flow.getPrivateCell((Integer)object);
                }
                return null;
            }
            case 4: {
                object = ((ListView)this.getSkinnable()).getSelectionModel();
                if (object == null) {
                    return FXCollections.observableArrayList();
                }
                object = ((MultipleSelectionModel)object).getSelectedIndices();
                object2 = new ArrayList(object.size());
                object = object.iterator();
                while (object.hasNext()) {
                    int n3 = (Integer)object.next();
                    ListCell<T> listCell = this.flow.getPrivateCell(n3);
                    if (listCell == null) continue;
                    object2.add(listCell);
                }
                return FXCollections.observableArrayList(object2);
            }
            case 5: {
                return this.flow.getVbar();
            }
            case 6: {
                return this.flow.getHbar();
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), (Object[])object2);
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction object, Object ... object2) {
        switch (ListViewSkin$3.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                object = (Node)object2[0];
                if (!(object instanceof ListCell)) break;
                object2 = (ListCell)object;
                this.flow.scrollTo(((IndexedCell)object2).getIndex());
                return;
            }
            case 2: {
                object = (ObservableList)object2[0];
                if (object == null) break;
                object2 = ((ListView)this.getSkinnable()).getSelectionModel();
                if (object2 != null) {
                    ((SelectionModel)object2).clearSelection();
                    object = object.iterator();
                    while (object.hasNext()) {
                        Node node = (Node)object.next();
                        if (!(node instanceof ListCell)) continue;
                        node = (ListCell)node;
                        ((SelectionModel)object2).select(((IndexedCell)node).getIndex());
                    }
                }
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), (Object[])object2);
            }
        }
    }

    private ListCell<T> createCell() {
        ListCell<T> listCell = ((ListView)this.getSkinnable()).getCellFactory() != null ? ((ListView)this.getSkinnable()).getCellFactory().call((ListView)this.getSkinnable()) : ListViewSkin.createDefaultCellImpl();
        listCell.updateListView((ListView)this.getSkinnable());
        return listCell;
    }

    private void updateListViewItems() {
        if (this.listViewItems != null) {
            this.listViewItems.removeListener(this.weakListViewItemsListener);
        }
        this.listViewItems = ((ListView)this.getSkinnable()).getItems();
        if (this.listViewItems != null) {
            this.listViewItems.addListener(this.weakListViewItemsListener);
        }
        this.markItemCountDirty();
        ((ListView)this.getSkinnable()).requestLayout();
    }

    private final void updatePlaceholderRegionVisibility() {
        boolean bl2 = this.getItemCount() == 0;
        if (bl2) {
            this.placeholderNode = ((ListView)this.getSkinnable()).getPlaceholder();
            if (this.placeholderNode == null && EMPTY_LIST_TEXT != null && !EMPTY_LIST_TEXT.isEmpty()) {
                this.placeholderNode = new Label();
                ((Label)this.placeholderNode).setText(EMPTY_LIST_TEXT);
            }
            if (this.placeholderNode != null) {
                if (this.placeholderRegion == null) {
                    this.placeholderRegion = new StackPane();
                    this.placeholderRegion.getStyleClass().setAll((String[])new String[]{"placeholder"});
                    this.getChildren().add(this.placeholderRegion);
                }
                this.placeholderRegion.getChildren().setAll((Node[])new Node[]{this.placeholderNode});
            }
        }
        this.flow.setVisible(!bl2);
        if (this.placeholderRegion != null) {
            this.placeholderRegion.setVisible(bl2);
        }
    }

    private static <T> ListCell<T> createDefaultCellImpl() {
        return new ListViewSkin$2();
    }

    private void onFocusPreviousCell() {
        FocusModel focusModel = ((ListView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.scrollTo(focusModel.getFocusedIndex());
    }

    private void onFocusNextCell() {
        FocusModel focusModel = ((ListView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.scrollTo(focusModel.getFocusedIndex());
    }

    private void onSelectPreviousCell() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getSkinnable()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n2 = multipleSelectionModel.getSelectedIndex();
        this.flow.scrollTo(n2);
        ListCell<T> listCell = this.flow.getFirstVisibleCell();
        if (listCell == null || n2 < listCell.getIndex()) {
            this.flow.setPosition((double)n2 / (double)this.getItemCount());
        }
    }

    private void onSelectNextCell() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getSkinnable()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n2 = multipleSelectionModel.getSelectedIndex();
        this.flow.scrollTo(n2);
        ListCell<T> listCell = this.flow.getLastVisibleCell();
        if (listCell == null || listCell.getIndex() < n2) {
            this.flow.setPosition((double)n2 / (double)this.getItemCount());
        }
    }

    private void onMoveToFirstCell() {
        this.flow.scrollTo(0);
        this.flow.setPosition(0.0);
    }

    private void onMoveToLastCell() {
        int n2 = this.getItemCount() - 1;
        this.flow.scrollTo(n2);
        this.flow.setPosition(1.0);
    }

    private int onScrollPageDown(boolean bl2) {
        boolean bl3;
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getSkinnable()).getSelectionModel();
        FocusModel focusModel = ((ListView)this.getSkinnable()).getFocusModel();
        if (multipleSelectionModel == null || focusModel == null) {
            return -1;
        }
        ListCell<T> listCell = this.flow.getLastVisibleCellWithinViewport();
        if (listCell == null) {
            return -1;
        }
        int n2 = listCell.getIndex();
        if (bl2) {
            bl3 = listCell.isFocused() || focusModel.isFocused(n2);
        } else {
            boolean bl4 = bl3 = listCell.isSelected() || multipleSelectionModel.isSelected(n2);
        }
        if (bl3 && (bl2 = bl2 && focusModel.getFocusedIndex() == n2 || !bl2 && multipleSelectionModel.getSelectedIndex() == n2)) {
            this.flow.scrollToTop(listCell);
            ListCell<T> listCell2 = this.flow.getLastVisibleCellWithinViewport();
            listCell = listCell2 == null ? listCell : listCell2;
        }
        int n3 = listCell.getIndex();
        this.flow.scrollTo(listCell);
        return n3;
    }

    private int onScrollPageUp(boolean bl2) {
        boolean bl3;
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getSkinnable()).getSelectionModel();
        FocusModel focusModel = ((ListView)this.getSkinnable()).getFocusModel();
        if (multipleSelectionModel == null || focusModel == null) {
            return -1;
        }
        ListCell<T> listCell = this.flow.getFirstVisibleCellWithinViewport();
        if (listCell == null) {
            return -1;
        }
        int n2 = listCell.getIndex();
        if (bl2) {
            bl3 = listCell.isFocused() || focusModel.isFocused(n2);
        } else {
            boolean bl4 = bl3 = listCell.isSelected() || multipleSelectionModel.isSelected(n2);
        }
        if (bl3 && (bl2 = bl2 && focusModel.getFocusedIndex() == n2 || !bl2 && multipleSelectionModel.getSelectedIndex() == n2)) {
            this.flow.scrollToBottom(listCell);
            ListCell<T> listCell2 = this.flow.getFirstVisibleCellWithinViewport();
            listCell = listCell2 == null ? listCell : listCell2;
        }
        int n3 = listCell.getIndex();
        this.flow.scrollTo(listCell);
        return n3;
    }
}

