/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.TreeShowingProperty;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javafx.animation.Animation;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SkinBase;
import javafx.scene.control.skin.ProgressIndicatorSkin$1;
import javafx.scene.control.skin.ProgressIndicatorSkin$2;
import javafx.scene.control.skin.ProgressIndicatorSkin$3;
import javafx.scene.control.skin.ProgressIndicatorSkin$4;
import javafx.scene.control.skin.ProgressIndicatorSkin$5;
import javafx.scene.control.skin.ProgressIndicatorSkin$6;
import javafx.scene.control.skin.ProgressIndicatorSkin$DeterminateIndicator;
import javafx.scene.control.skin.ProgressIndicatorSkin$IndeterminateSpinner;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class ProgressIndicatorSkin
extends SkinBase<ProgressIndicator> {
    private final String DONE = ControlResources.getString("ProgressIndicator.doneString");
    final Duration CLIPPED_DELAY = new Duration(300.0);
    final Duration UNCLIPPED_DELAY = new Duration(0.0);
    private ProgressIndicatorSkin$IndeterminateSpinner spinner;
    private ProgressIndicatorSkin$DeterminateIndicator determinateIndicator;
    private ProgressIndicator control;
    private TreeShowingProperty treeShowingProperty;
    Animation indeterminateTransition;
    private ObjectProperty<Paint> progressColor = new ProgressIndicatorSkin$1(this, null);
    private IntegerProperty indeterminateSegmentCount = new ProgressIndicatorSkin$2(this, 8);
    private final BooleanProperty spinEnabled = new ProgressIndicatorSkin$3(this, false);
    private static final CssMetaData<ProgressIndicator, Paint> PROGRESS_COLOR = new ProgressIndicatorSkin$4("-fx-progress-color", PaintConverter.getInstance(), null);
    private static final CssMetaData<ProgressIndicator, Number> INDETERMINATE_SEGMENT_COUNT = new ProgressIndicatorSkin$5("-fx-indeterminate-segment-count", SizeConverter.getInstance(), 8);
    private static final CssMetaData<ProgressIndicator, Boolean> SPIN_ENABLED = new ProgressIndicatorSkin$6("-fx-spin-enabled", BooleanConverter.getInstance(), Boolean.FALSE);
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public ProgressIndicatorSkin(ProgressIndicator progressIndicator) {
        super(progressIndicator);
        this.control = progressIndicator;
        this.treeShowingProperty = new TreeShowingProperty(progressIndicator);
        this.registerChangeListener(progressIndicator.indeterminateProperty(), observableValue -> this.initialize());
        this.registerChangeListener(progressIndicator.progressProperty(), observableValue -> this.updateProgress());
        this.registerChangeListener(progressIndicator.sceneProperty(), observableValue -> this.updateAnimation());
        ProgressIndicatorSkin progressIndicatorSkin = this;
        progressIndicatorSkin.registerChangeListener(progressIndicatorSkin.treeShowingProperty, observableValue -> this.updateAnimation());
        this.initialize();
        this.updateAnimation();
    }

    Paint getProgressColor() {
        return (Paint)this.progressColor.get();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.treeShowingProperty.dispose();
        if (this.indeterminateTransition != null) {
            this.indeterminateTransition.stop();
            this.indeterminateTransition = null;
        }
        if (this.spinner != null) {
            this.spinner = null;
        }
        this.control = null;
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        if (this.spinner != null && this.control.isIndeterminate()) {
            this.spinner.layoutChildren();
            this.spinner.resizeRelocate(0.0, 0.0, d4, d5);
            return;
        }
        if (this.determinateIndicator != null) {
            this.determinateIndicator.layoutChildren();
            this.determinateIndicator.resizeRelocate(0.0, 0.0, d4, d5);
        }
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        if (this.spinner != null && this.control.isIndeterminate()) {
            d7 = ((Node)this.spinner).minWidth(-1.0);
        } else if (this.determinateIndicator != null) {
            d7 = ((Node)this.determinateIndicator).minWidth(-1.0);
        }
        return d7;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        if (this.spinner != null && this.control.isIndeterminate()) {
            d7 = ((Node)this.spinner).minHeight(-1.0);
        } else if (this.determinateIndicator != null) {
            d7 = ((Node)this.determinateIndicator).minHeight(-1.0);
        }
        return d7;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        if (this.spinner != null && this.control.isIndeterminate()) {
            d7 = ((Node)this.spinner).prefWidth(d2);
        } else if (this.determinateIndicator != null) {
            d7 = ((Node)this.determinateIndicator).prefWidth(d2);
        }
        return d7;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        if (this.spinner != null && this.control.isIndeterminate()) {
            d7 = ((Node)this.spinner).prefHeight(d2);
        } else if (this.determinateIndicator != null) {
            d7 = ((Node)this.determinateIndicator).prefHeight(d2);
        }
        return d7;
    }

    @Override
    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return this.computePrefWidth(d2, d3, d4, d5, d6);
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.computePrefHeight(d2, d3, d4, d5, d6);
    }

    void initialize() {
        boolean bl2 = this.control.isIndeterminate();
        if (bl2) {
            if (this.determinateIndicator != null) {
                this.determinateIndicator.unregisterListener();
            }
            this.determinateIndicator = null;
            ProgressIndicatorSkin progressIndicatorSkin = this;
            this.spinner = new ProgressIndicatorSkin$IndeterminateSpinner(progressIndicatorSkin, progressIndicatorSkin.spinEnabled.get(), (Paint)this.progressColor.get());
            this.getChildren().setAll((Node[])new Node[]{this.spinner});
            if (NodeHelper.isTreeShowing(this.control) && this.indeterminateTransition != null) {
                this.indeterminateTransition.play();
                return;
            }
        } else {
            if (this.spinner != null) {
                if (this.indeterminateTransition != null) {
                    this.indeterminateTransition.stop();
                }
                this.spinner = null;
            }
            ProgressIndicatorSkin progressIndicatorSkin = this;
            ProgressIndicatorSkin progressIndicatorSkin2 = this;
            this.determinateIndicator = new ProgressIndicatorSkin$DeterminateIndicator(progressIndicatorSkin, progressIndicatorSkin.control, progressIndicatorSkin2, (Paint)progressIndicatorSkin2.progressColor.get());
            this.getChildren().setAll((Node[])new Node[]{this.determinateIndicator});
        }
    }

    void updateProgress() {
        if (this.determinateIndicator != null) {
            this.determinateIndicator.updateProgress(this.control.getProgress());
        }
    }

    void createIndeterminateTimeline() {
        if (this.spinner != null) {
            this.spinner.rebuildTimeline();
        }
    }

    void pauseTimeline(boolean bl2) {
        if (((ProgressIndicator)this.getSkinnable()).isIndeterminate()) {
            if (this.indeterminateTransition == null) {
                this.createIndeterminateTimeline();
            }
            if (bl2) {
                this.indeterminateTransition.pause();
                return;
            }
            this.indeterminateTransition.play();
        }
    }

    void updateAnimation() {
        boolean bl2;
        ProgressIndicator progressIndicator = (ProgressIndicator)this.getSkinnable();
        boolean bl3 = bl2 = NodeHelper.isTreeShowing(progressIndicator) && progressIndicator.getScene() != null;
        if (this.indeterminateTransition != null) {
            this.pauseTimeline(!bl2);
            return;
        }
        if (bl2) {
            this.createIndeterminateTimeline();
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ProgressIndicatorSkin.getClassCssMetaData();
    }

    static /* synthetic */ void access$000(ProgressIndicatorSkin progressIndicatorSkin, ObservableValue observableValue, Consumer consumer) {
        progressIndicatorSkin.registerChangeListener(observableValue, consumer);
    }

    static /* synthetic */ Consumer access$100(ProgressIndicatorSkin progressIndicatorSkin, ObservableValue observableValue) {
        return progressIndicatorSkin.unregisterChangeListeners(observableValue);
    }

    static {
        ArrayList arrayList = new ArrayList(SkinBase.getClassCssMetaData());
        arrayList.add(PROGRESS_COLOR);
        arrayList.add(INDETERMINATE_SEGMENT_COUNT);
        arrayList.add(SPIN_ENABLED);
        STYLEABLES = Collections.unmodifiableList(arrayList);
    }
}

