/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ToggleButtonBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.skin.LabeledSkinBase;
import javafx.scene.layout.StackPane;

public class RadioButtonSkin
extends LabeledSkinBase<RadioButton> {
    private StackPane radio;
    private final BehaviorBase<RadioButton> behavior;

    public RadioButtonSkin(RadioButton radioButton) {
        super(radioButton);
        this.behavior = new ToggleButtonBehavior<RadioButton>(radioButton);
        this.radio = RadioButtonSkin.createRadio();
        this.updateChildren();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        if (this.radio != null) {
            this.getChildren().add(this.radio);
        }
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        RadioButtonSkin radioButtonSkin = this;
        return super.computeMinWidth(d2, d3, d4, d5, d6) + radioButtonSkin.snapSizeX(((Node)radioButtonSkin.radio).minWidth(-1.0));
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        RadioButtonSkin radioButtonSkin = this;
        return Math.max(radioButtonSkin.snapSizeY(super.computeMinHeight(d2 - ((Node)this.radio).minWidth(-1.0), d3, d4, d5, d6)), d3 + ((Node)this.radio).minHeight(-1.0) + d5);
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        RadioButtonSkin radioButtonSkin = this;
        return super.computePrefWidth(d2, d3, d4, d5, d6) + radioButtonSkin.snapSizeX(((Node)radioButtonSkin.radio).prefWidth(-1.0));
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        RadioButtonSkin radioButtonSkin = this;
        return Math.max(radioButtonSkin.snapSizeY(super.computePrefHeight(d2 - ((Node)this.radio).prefWidth(-1.0), d3, d4, d5, d6)), d3 + ((Node)this.radio).prefHeight(-1.0) + d5);
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        RadioButton radioButton = (RadioButton)this.getSkinnable();
        double d6 = ((Node)this.radio).prefWidth(-1.0);
        double d7 = ((Node)this.radio).prefHeight(-1.0);
        double d8 = Math.max(((Node)radioButton).prefWidth(-1.0), ((Node)radioButton).minWidth(-1.0));
        double d9 = Math.min(d8 - d6, d4 - this.snapSizeX(d6));
        double d10 = Math.min(((Node)radioButton).prefHeight(d9), d5);
        double d11 = Math.max(d7, d10);
        double d12 = Utils.computeXOffset(d4, d9 + d6, radioButton.getAlignment().getHpos()) + d2;
        double d13 = Utils.computeYOffset(d5, d11, radioButton.getAlignment().getVpos()) + d3;
        this.layoutLabelInArea(d12 + d6, d13, d9, d11, radioButton.getAlignment());
        ((Node)this.radio).resize(this.snapSizeX(d6), this.snapSizeY(d7));
        RadioButtonSkin radioButtonSkin = this;
        radioButtonSkin.positionInArea(radioButtonSkin.radio, d12, d13, d6, d11, 0.0, radioButton.getAlignment().getHpos(), radioButton.getAlignment().getVpos());
    }

    private static StackPane createRadio() {
        StackPane stackPane = new StackPane();
        stackPane.getStyleClass().setAll((String[])new String[]{"radio"});
        stackPane.setSnapToPixel(false);
        StackPane stackPane2 = new StackPane();
        stackPane2.getStyleClass().setAll((String[])new String[]{"dot"});
        stackPane.getChildren().clear();
        stackPane.getChildren().addAll((Node[])new Node[]{stackPane2});
        return stackPane;
    }
}

