/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.behavior.ScrollBarBehavior;
import com.sun.javafx.util.Utils;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SkinBase;
import javafx.scene.control.skin.ScrollBarSkin$1;
import javafx.scene.control.skin.ScrollBarSkin$2;
import javafx.scene.control.skin.ScrollBarSkin$3;
import javafx.scene.control.skin.ScrollBarSkin$EndButton;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;

public class ScrollBarSkin
extends SkinBase<ScrollBar> {
    private final ScrollBarBehavior behavior;
    private StackPane thumb;
    private StackPane trackBackground;
    private StackPane track;
    private ScrollBarSkin$EndButton incButton;
    private ScrollBarSkin$EndButton decButton;
    private double trackLength;
    private double thumbLength;
    private double preDragThumbPos;
    private Point2D dragStart;
    private double trackPos;

    public ScrollBarSkin(ScrollBar scrollBar) {
        super(scrollBar);
        this.behavior = new ScrollBarBehavior(scrollBar);
        this.initialize();
        ((ScrollBar)this.getSkinnable()).requestLayout();
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addChangeListener(() -> {
            this.positionThumb();
            ((ScrollBar)this.getSkinnable()).requestLayout();
        }, scrollBar.minProperty(), scrollBar.maxProperty(), scrollBar.visibleAmountProperty());
        listenerHelper.addChangeListener(scrollBar.valueProperty(), number -> this.positionThumb());
        listenerHelper.addChangeListener(scrollBar.orientationProperty(), orientation -> ((ScrollBar)this.getSkinnable()).requestLayout());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        ScrollBar scrollBar;
        ScrollBar scrollBar2 = (ScrollBar)this.getSkinnable();
        double d6 = scrollBar.getMax() > scrollBar2.getMin() ? scrollBar2.getVisibleAmount() / (scrollBar2.getMax() - scrollBar2.getMin()) : 1.0;
        if (scrollBar2.getOrientation() == Orientation.VERTICAL) {
            if (!Properties.IS_TOUCH_SUPPORTED) {
                ScrollBarSkin scrollBarSkin = this;
                double d7 = scrollBarSkin.snapSizeY(((Node)scrollBarSkin.decButton).prefHeight(-1.0));
                ScrollBarSkin scrollBarSkin2 = this;
                double d8 = scrollBarSkin2.snapSizeY(((Node)scrollBarSkin2.incButton).prefHeight(-1.0));
                ((Node)this.decButton).resize(d4, d7);
                ((Node)this.incButton).resize(d4, d8);
                this.trackLength = this.snapSizeY(d5 - (d7 + d8));
                this.thumbLength = this.snapSizeY(Utils.clamp(this.minThumbLength(), this.trackLength * d6, this.trackLength));
                this.trackBackground.resizeRelocate(this.snapPositionX(d2), this.snapPositionY(d3), d4, this.trackLength + d7 + d8);
                this.decButton.relocate(this.snapPositionX(d2), this.snapPositionY(d3));
                this.incButton.relocate(this.snapPositionX(d2), this.snapPositionY(d3 + d5 - d8));
                this.track.resizeRelocate(this.snapPositionX(d2), this.snapPositionY(d3 + d7), d4, this.trackLength);
                ((Node)this.thumb).resize(this.snapSizeX(d2 >= 0.0 ? d4 : d4 + d2), this.thumbLength);
                this.positionThumb();
            } else {
                this.trackLength = this.snapSizeY(d5);
                this.thumbLength = this.snapSizeY(Utils.clamp(this.minThumbLength(), this.trackLength * d6, this.trackLength));
                this.track.resizeRelocate(this.snapPositionX(d2), this.snapPositionY(d3), d4, this.trackLength);
                ((Node)this.thumb).resize(this.snapSizeX(d2 >= 0.0 ? d4 : d4 + d2), this.thumbLength);
                this.positionThumb();
            }
        } else {
            if (!Properties.IS_TOUCH_SUPPORTED) {
                ScrollBarSkin scrollBarSkin = this;
                double d9 = scrollBarSkin.snapSizeX(((Node)scrollBarSkin.decButton).prefWidth(-1.0));
                ScrollBarSkin scrollBarSkin3 = this;
                double d10 = scrollBarSkin3.snapSizeX(((Node)scrollBarSkin3.incButton).prefWidth(-1.0));
                ((Node)this.decButton).resize(d9, d5);
                ((Node)this.incButton).resize(d10, d5);
                this.trackLength = this.snapSizeX(d4 - (d9 + d10));
                this.thumbLength = this.snapSizeX(Utils.clamp(this.minThumbLength(), this.trackLength * d6, this.trackLength));
                this.trackBackground.resizeRelocate(this.snapPositionX(d2), this.snapPositionY(d3), this.trackLength + d9 + d10, d5);
                this.decButton.relocate(this.snapPositionX(d2), this.snapPositionY(d3));
                this.incButton.relocate(this.snapPositionX(d2 + d4 - d10), this.snapPositionY(d3));
                this.track.resizeRelocate(this.snapPositionX(d2 + d9), this.snapPositionY(d3), this.trackLength, d5);
                ((Node)this.thumb).resize(this.thumbLength, this.snapSizeY(d3 >= 0.0 ? d5 : d5 + d3));
                this.positionThumb();
            } else {
                this.trackLength = this.snapSizeX(d4);
                this.thumbLength = this.snapSizeX(Utils.clamp(this.minThumbLength(), this.trackLength * d6, this.trackLength));
                this.track.resizeRelocate(this.snapPositionX(d2), this.snapPositionY(d3), this.trackLength, d5);
                ((Node)this.thumb).resize(this.thumbLength, this.snapSizeY(d3 >= 0.0 ? d5 : d5 + d3));
                this.positionThumb();
            }
            ((Node)scrollBar2).resize(this.snapSizeX(scrollBar2.getWidth()), this.snapSizeY(scrollBar2.getHeight()));
        }
        if (scrollBar2.getOrientation() == Orientation.VERTICAL && d5 >= this.computeMinHeight(-1.0, (int)d3, this.snappedRightInset(), this.snappedBottomInset(), (int)d2) - (d3 + this.snappedBottomInset()) || scrollBar2.getOrientation() == Orientation.HORIZONTAL && d4 >= this.computeMinWidth(-1.0, (int)d3, this.snappedRightInset(), this.snappedBottomInset(), (int)d2) - (d2 + this.snappedRightInset())) {
            this.trackBackground.setVisible(true);
            this.track.setVisible(true);
            this.thumb.setVisible(true);
            if (!Properties.IS_TOUCH_SUPPORTED) {
                this.incButton.setVisible(true);
                this.decButton.setVisible(true);
                return;
            }
        } else {
            this.trackBackground.setVisible(false);
            this.track.setVisible(false);
            this.thumb.setVisible(false);
            if (!Properties.IS_TOUCH_SUPPORTED) {
                if (d5 >= this.decButton.computeMinWidth(-1.0)) {
                    this.decButton.setVisible(true);
                } else {
                    this.decButton.setVisible(false);
                }
                if (d5 >= this.incButton.computeMinWidth(-1.0)) {
                    this.incButton.setVisible(true);
                    return;
                }
                this.incButton.setVisible(false);
            }
        }
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return this.getBreadth();
        }
        if (!Properties.IS_TOUCH_SUPPORTED) {
            return ((Node)this.decButton).minWidth(-1.0) + ((Node)this.incButton).minWidth(-1.0) + this.minTrackLength() + d6 + d4;
        }
        return this.minTrackLength() + d6 + d4;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            if (!Properties.IS_TOUCH_SUPPORTED) {
                return ((Node)this.decButton).minHeight(-1.0) + ((Node)this.incButton).minHeight(-1.0) + this.minTrackLength() + d3 + d5;
            }
            return this.minTrackLength() + d3 + d5;
        }
        return this.getBreadth();
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        if (scrollBar.getOrientation() == Orientation.VERTICAL) {
            return this.getBreadth();
        }
        return d6 + 100.0 + d4;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        if (scrollBar.getOrientation() == Orientation.VERTICAL) {
            return d3 + 100.0 + d5;
        }
        return this.getBreadth();
    }

    @Override
    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        if (scrollBar.getOrientation() == Orientation.VERTICAL) {
            return ((Node)scrollBar).prefWidth(-1.0);
        }
        return Double.MAX_VALUE;
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        if (scrollBar.getOrientation() == Orientation.VERTICAL) {
            return Double.MAX_VALUE;
        }
        return ((Node)scrollBar).prefHeight(-1.0);
    }

    private void initialize() {
        this.track = new StackPane();
        this.track.getStyleClass().setAll((String[])new String[]{"track"});
        this.trackBackground = new StackPane();
        this.trackBackground.getStyleClass().setAll((String[])new String[]{"track-background"});
        this.thumb = new ScrollBarSkin$1(this);
        this.thumb.getStyleClass().setAll((String[])new String[]{"thumb"});
        this.thumb.setAccessibleRole(AccessibleRole.THUMB);
        if (!Properties.IS_TOUCH_SUPPORTED) {
            this.incButton = new ScrollBarSkin$2(this, "increment-button", "increment-arrow");
            this.incButton.setAccessibleRole(AccessibleRole.INCREMENT_BUTTON);
            this.incButton.setOnMousePressed(mouseEvent -> {
                if (!this.thumb.isVisible() || this.trackLength > this.thumbLength) {
                    this.behavior.incButtonPressed();
                }
                mouseEvent.consume();
            });
            this.incButton.setOnMouseReleased(mouseEvent -> {
                if (!this.thumb.isVisible() || this.trackLength > this.thumbLength) {
                    this.behavior.incButtonReleased();
                }
                mouseEvent.consume();
            });
            this.decButton = new ScrollBarSkin$3(this, "decrement-button", "decrement-arrow");
            this.decButton.setAccessibleRole(AccessibleRole.DECREMENT_BUTTON);
            this.decButton.setOnMousePressed(mouseEvent -> {
                if (!this.thumb.isVisible() || this.trackLength > this.thumbLength) {
                    this.behavior.decButtonPressed();
                }
                mouseEvent.consume();
            });
            this.decButton.setOnMouseReleased(mouseEvent -> {
                if (!this.thumb.isVisible() || this.trackLength > this.thumbLength) {
                    this.behavior.decButtonReleased();
                }
                mouseEvent.consume();
            });
        }
        this.track.setOnMousePressed(mouseEvent -> {
            if (!this.thumb.isPressed() && mouseEvent.getButton() == MouseButton.PRIMARY) {
                if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                    if (this.trackLength != 0.0) {
                        this.behavior.trackPress(mouseEvent.getY() / this.trackLength);
                        mouseEvent.consume();
                        return;
                    }
                } else if (this.trackLength != 0.0) {
                    this.behavior.trackPress(mouseEvent.getX() / this.trackLength);
                    mouseEvent.consume();
                }
            }
        });
        this.track.setOnMouseReleased(mouseEvent -> {
            this.behavior.trackRelease();
            mouseEvent.consume();
        });
        this.thumb.setOnMousePressed(mouseEvent -> {
            if (mouseEvent.isSynthesized()) {
                mouseEvent.consume();
                return;
            }
            if (((ScrollBar)this.getSkinnable()).getMax() > ((ScrollBar)this.getSkinnable()).getMin()) {
                this.dragStart = this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
                double d2 = Utils.clamp(((ScrollBar)this.getSkinnable()).getMin(), ((ScrollBar)this.getSkinnable()).getValue(), ((ScrollBar)this.getSkinnable()).getMax());
                this.preDragThumbPos = (d2 - ((ScrollBar)this.getSkinnable()).getMin()) / (((ScrollBar)this.getSkinnable()).getMax() - ((ScrollBar)this.getSkinnable()).getMin());
                mouseEvent.consume();
            }
        });
        this.thumb.setOnMouseDragged(mouseEvent -> {
            if (mouseEvent.isSynthesized()) {
                mouseEvent.consume();
                return;
            }
            if (((ScrollBar)this.getSkinnable()).getMax() > ((ScrollBar)this.getSkinnable()).getMin()) {
                if (this.trackLength > this.thumbLength) {
                    Point2D point2D = this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
                    if (this.dragStart == null) {
                        this.dragStart = this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
                    }
                    double d2 = ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? point2D.getY() - this.dragStart.getY() : point2D.getX() - this.dragStart.getX();
                    this.behavior.thumbDragged(this.preDragThumbPos + d2 / (this.trackLength - this.thumbLength));
                }
                mouseEvent.consume();
            }
        });
        this.thumb.setOnScrollStarted(scrollEvent -> {
            if (scrollEvent.isDirect() && ((ScrollBar)this.getSkinnable()).getMax() > ((ScrollBar)this.getSkinnable()).getMin()) {
                this.dragStart = this.thumb.localToParent(scrollEvent.getX(), scrollEvent.getY());
                double d2 = Utils.clamp(((ScrollBar)this.getSkinnable()).getMin(), ((ScrollBar)this.getSkinnable()).getValue(), ((ScrollBar)this.getSkinnable()).getMax());
                this.preDragThumbPos = (d2 - ((ScrollBar)this.getSkinnable()).getMin()) / (((ScrollBar)this.getSkinnable()).getMax() - ((ScrollBar)this.getSkinnable()).getMin());
                scrollEvent.consume();
            }
        });
        this.thumb.setOnScroll(scrollEvent -> {
            if (scrollEvent.isDirect() && ((ScrollBar)this.getSkinnable()).getMax() > ((ScrollBar)this.getSkinnable()).getMin()) {
                if (this.trackLength > this.thumbLength) {
                    Point2D point2D = this.thumb.localToParent(scrollEvent.getX(), scrollEvent.getY());
                    if (this.dragStart == null) {
                        this.dragStart = this.thumb.localToParent(scrollEvent.getX(), scrollEvent.getY());
                    }
                    double d2 = ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? point2D.getY() - this.dragStart.getY() : point2D.getX() - this.dragStart.getX();
                    this.behavior.thumbDragged(this.preDragThumbPos + d2 / (this.trackLength - this.thumbLength));
                }
                scrollEvent.consume();
                return;
            }
        });
        ListenerHelper.get(this).addEventHandler(this.getSkinnable(), ScrollEvent.SCROLL, scrollEvent -> {
            if (this.trackLength > this.thumbLength) {
                double d2;
                double d3 = scrollEvent.getDeltaX();
                double d4 = scrollEvent.getDeltaY();
                d3 = Math.abs(d3) < Math.abs(d4) ? d4 : d3;
                ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
                double d5 = d2 = ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? d4 : d3;
                if (scrollEvent.isDirect()) {
                    if (this.trackLength > this.thumbLength) {
                        this.behavior.thumbDragged((((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? scrollEvent.getY() : scrollEvent.getX()) / this.trackLength);
                        scrollEvent.consume();
                        return;
                    }
                } else {
                    if (d2 > 0.0 && scrollBar.getValue() > scrollBar.getMin()) {
                        scrollBar.decrement();
                        scrollEvent.consume();
                        return;
                    }
                    if (d2 < 0.0 && scrollBar.getValue() < scrollBar.getMax()) {
                        scrollBar.increment();
                        scrollEvent.consume();
                    }
                }
            }
        });
        this.getChildren().clear();
        if (!Properties.IS_TOUCH_SUPPORTED) {
            this.getChildren().addAll((Node[])new Node[]{this.trackBackground, this.incButton, this.decButton, this.track, this.thumb});
            return;
        }
        this.getChildren().addAll((Node[])new Node[]{this.track, this.thumb});
    }

    double getBreadth() {
        if (!Properties.IS_TOUCH_SUPPORTED) {
            if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                return Math.max(((Node)this.decButton).prefWidth(-1.0), ((Node)this.incButton).prefWidth(-1.0)) + this.snappedLeftInset() + this.snappedRightInset();
            }
            return Math.max(((Node)this.decButton).prefHeight(-1.0), ((Node)this.incButton).prefHeight(-1.0)) + this.snappedTopInset() + this.snappedBottomInset();
        }
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return Math.max(8.0, 8.0) + this.snappedLeftInset() + this.snappedRightInset();
        }
        return Math.max(8.0, 8.0) + this.snappedTopInset() + this.snappedBottomInset();
    }

    double minThumbLength() {
        return 1.5 * this.getBreadth();
    }

    double minTrackLength() {
        return 2.0 * this.getBreadth();
    }

    void positionThumb() {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        double d2 = Utils.clamp(scrollBar.getMin(), scrollBar.getValue(), scrollBar.getMax());
        double d3 = this.trackPos = scrollBar.getMax() - scrollBar.getMin() > 0.0 ? (this.trackLength - this.thumbLength) * (d2 - scrollBar.getMin()) / (scrollBar.getMax() - scrollBar.getMin()) : 0.0;
        if (!Properties.IS_TOUCH_SUPPORTED) {
            this.trackPos = scrollBar.getOrientation() == Orientation.VERTICAL ? (this.trackPos += ((Node)this.decButton).prefHeight(-1.0)) : (this.trackPos += ((Node)this.decButton).prefWidth(-1.0));
        }
        this.thumb.setTranslateX(this.snapPositionX(scrollBar.getOrientation() == Orientation.VERTICAL ? this.snappedLeftInset() : this.trackPos + this.snappedLeftInset()));
        this.thumb.setTranslateY(this.snapPositionY(scrollBar.getOrientation() == Orientation.VERTICAL ? this.trackPos + this.snappedTopInset() : this.snappedTopInset()));
    }

    private Node getThumb() {
        return this.thumb;
    }

    private Node getTrack() {
        return this.track;
    }

    private Node getIncrementButton() {
        return this.incButton;
    }

    private Node getDecrementButton() {
        return this.decButton;
    }
}

