/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ScrollPaneBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalEngine;
import javafx.animation.Animation;
import javafx.animation.Animation$Status;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ScrollPane$ScrollBarPolicy;
import javafx.scene.control.SkinBase;
import javafx.scene.control.skin.ScrollPaneSkin$1;
import javafx.scene.control.skin.ScrollPaneSkin$2;
import javafx.scene.control.skin.ScrollPaneSkin$3;
import javafx.scene.control.skin.ScrollPaneSkin$4;
import javafx.scene.control.skin.ScrollPaneSkin$5;
import javafx.scene.control.skin.ScrollPaneSkin$6;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class ScrollPaneSkin
extends SkinBase<ScrollPane> {
    private static final double DEFAULT_PREF_SIZE = 100.0;
    private static final double DEFAULT_MIN_SIZE = 36.0;
    private static final double DEFAULT_SB_BREADTH = 12.0;
    private static final double DEFAULT_EMBEDDED_SB_BREADTH = 8.0;
    private static final double PAN_THRESHOLD = 0.5;
    private Node scrollNode;
    private final BehaviorBase<ScrollPane> behavior;
    private double nodeWidth;
    private double nodeHeight;
    private boolean nodeSizeInvalid = true;
    private double posX;
    private double posY;
    private boolean hsbvis;
    private boolean vsbvis;
    private double hsbHeight;
    private double vsbWidth;
    private StackPane viewRect;
    private StackPane viewContent;
    private double contentWidth;
    private double contentHeight;
    private StackPane corner;
    ScrollBar hsb;
    ScrollBar vsb;
    double pressX;
    double pressY;
    double ohvalue;
    double ovvalue;
    private Cursor saveCursor = null;
    private boolean dragDetected = false;
    private boolean touchDetected = false;
    private boolean mouseDown = false;
    Rectangle clipRect;
    Timeline sbTouchTimeline;
    KeyFrame sbTouchKF1;
    KeyFrame sbTouchKF2;
    Timeline contentsToViewTimeline;
    KeyFrame contentsToViewKF1;
    KeyFrame contentsToViewKF2;
    KeyFrame contentsToViewKF3;
    private boolean tempVisibility;
    private final InvalidationListener nodeListener = new ScrollPaneSkin$1(this);
    private final WeakInvalidationListener weakNodeListener = new WeakInvalidationListener(this.nodeListener);
    private final ChangeListener<Bounds> boundsChangeListener = new ScrollPaneSkin$2(this);
    private final WeakChangeListener<Bounds> weakBoundsChangeListener = new WeakChangeListener<Bounds>(this.boundsChangeListener);
    private DoubleProperty contentPosX;
    private DoubleProperty contentPosY;

    public ScrollPaneSkin(ScrollPane scrollPane) {
        super(scrollPane);
        this.behavior = new ScrollPaneBehavior(scrollPane);
        this.initialize();
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addChangeListener(scrollPane.contentProperty(), node -> {
            if (this.scrollNode != ((ScrollPane)this.getSkinnable()).getContent()) {
                if (this.scrollNode != null) {
                    this.scrollNode.layoutBoundsProperty().removeListener(this.weakNodeListener);
                    this.scrollNode.layoutBoundsProperty().removeListener(this.weakBoundsChangeListener);
                    this.viewContent.getChildren().remove(this.scrollNode);
                }
                this.scrollNode = ((ScrollPane)this.getSkinnable()).getContent();
                if (this.scrollNode != null) {
                    this.nodeWidth = this.snapSizeX(this.scrollNode.getLayoutBounds().getWidth());
                    this.nodeHeight = this.snapSizeY(this.scrollNode.getLayoutBounds().getHeight());
                    this.viewContent.getChildren().setAll((Node[])new Node[]{this.scrollNode});
                    this.scrollNode.layoutBoundsProperty().addListener(this.weakNodeListener);
                    this.scrollNode.layoutBoundsProperty().addListener(this.weakBoundsChangeListener);
                }
            }
            ((ScrollPane)this.getSkinnable()).requestLayout();
        });
        listenerHelper.addChangeListener(() -> {
            ((ScrollPane)this.getSkinnable()).requestLayout();
            ((Parent)this.viewRect).requestLayout();
        }, scrollPane.fitToWidthProperty(), scrollPane.fitToHeightProperty());
        listenerHelper.addChangeListener(scrollPane.hvalueProperty(), number -> this.hsb.setValue(((ScrollPane)this.getSkinnable()).getHvalue()));
        listenerHelper.addChangeListener(scrollPane.hmaxProperty(), number -> this.hsb.setMax(((ScrollPane)this.getSkinnable()).getHmax()));
        listenerHelper.addChangeListener(scrollPane.hminProperty(), number -> this.hsb.setMin(((ScrollPane)this.getSkinnable()).getHmin()));
        listenerHelper.addChangeListener(scrollPane.vvalueProperty(), number -> this.vsb.setValue(((ScrollPane)this.getSkinnable()).getVvalue()));
        listenerHelper.addChangeListener(scrollPane.vmaxProperty(), number -> this.vsb.setMax(((ScrollPane)this.getSkinnable()).getVmax()));
        listenerHelper.addChangeListener(scrollPane.vminProperty(), number -> this.vsb.setMin(((ScrollPane)this.getSkinnable()).getVmin()));
        listenerHelper.addChangeListener(() -> ((ScrollPane)this.getSkinnable()).requestLayout(), scrollPane.hbarPolicyProperty(), scrollPane.vbarPolicyProperty(), scrollPane.prefViewportWidthProperty(), scrollPane.prefViewportHeightProperty(), scrollPane.minViewportWidthProperty(), scrollPane.minViewportHeightProperty());
    }

    private final void setContentPosX(double d2) {
        this.contentPosXProperty().set(d2);
    }

    private final double getContentPosX() {
        if (this.contentPosX == null) {
            return 0.0;
        }
        return this.contentPosX.get();
    }

    private final DoubleProperty contentPosXProperty() {
        if (this.contentPosX == null) {
            this.contentPosX = new ScrollPaneSkin$3(this);
        }
        return this.contentPosX;
    }

    private final void setContentPosY(double d2) {
        this.contentPosYProperty().set(d2);
    }

    private final double getContentPosY() {
        if (this.contentPosY == null) {
            return 0.0;
        }
        return this.contentPosY.get();
    }

    private final DoubleProperty contentPosYProperty() {
        if (this.contentPosY == null) {
            this.contentPosY = new ScrollPaneSkin$4(this);
        }
        return this.contentPosY;
    }

    @Override
    public void dispose() {
        if (this.behavior != null) {
            this.behavior.dispose();
        }
        super.dispose();
    }

    public final ScrollBar getHorizontalScrollBar() {
        return this.hsb;
    }

    public final ScrollBar getVerticalScrollBar() {
        return this.vsb;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        double d7 = this.computeVsbSizeHint(scrollPane);
        double d8 = d7 + this.snappedLeftInset() + this.snappedRightInset();
        if (scrollPane.getPrefViewportWidth() > 0.0) {
            return scrollPane.getPrefViewportWidth() + d8;
        }
        if (scrollPane.getContent() != null) {
            return scrollPane.getContent().prefWidth(d2) + d8;
        }
        return Math.max(d8, 100.0);
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        double d7 = this.computeHsbSizeHint(scrollPane);
        double d8 = d7 + this.snappedTopInset() + this.snappedBottomInset();
        if (scrollPane.getPrefViewportHeight() > 0.0) {
            return scrollPane.getPrefViewportHeight() + d8;
        }
        if (scrollPane.getContent() != null) {
            return scrollPane.getContent().prefHeight(d2) + d8;
        }
        return Math.max(d8, 100.0);
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        double d8 = this.computeVsbSizeHint(scrollPane);
        double d9 = d8 + this.snappedLeftInset() + this.snappedRightInset();
        if (scrollPane.getMinViewportWidth() > 0.0) {
            return scrollPane.getMinViewportWidth() + d9;
        }
        double d10 = ((Node)this.corner).minWidth(-1.0);
        if (d7 > 0.0) {
            return d10 * 3.0;
        }
        return 36.0;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        double d8 = this.computeHsbSizeHint(scrollPane);
        double d9 = d8 + this.snappedTopInset() + this.snappedBottomInset();
        if (scrollPane.getMinViewportHeight() > 0.0) {
            return scrollPane.getMinViewportHeight() + d9;
        }
        double d10 = ((Node)this.corner).minHeight(-1.0);
        if (d7 > 0.0) {
            return d10 * 3.0;
        }
        return 36.0;
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        Insets insets = scrollPane.getPadding();
        double d6 = this.snapSizeX(insets.getRight());
        double d7 = this.snapSizeX(insets.getLeft());
        double d8 = this.snapSizeY(insets.getTop());
        double d9 = this.snapSizeY(insets.getBottom());
        this.vsb.setMin(scrollPane.getVmin());
        this.vsb.setMax(scrollPane.getVmax());
        this.hsb.setMin(scrollPane.getHmin());
        this.hsb.setMax(scrollPane.getHmax());
        this.contentWidth = d4;
        this.contentHeight = d5;
        double d10 = 0.0;
        double d11 = 0.0;
        ScrollPaneSkin scrollPaneSkin = this;
        scrollPaneSkin.computeScrollNodeSize(scrollPaneSkin.contentWidth, this.contentHeight);
        this.computeScrollBarSize();
        for (int i2 = 0; i2 < 2; ++i2) {
            this.vsbvis = this.determineVerticalSBVisible();
            this.hsbvis = this.determineHorizontalSBVisible();
            if (this.vsbvis && !Properties.IS_TOUCH_SUPPORTED) {
                this.contentWidth = d4 - this.vsbWidth;
            }
            d10 = d4 + d7 + d6 - (this.vsbvis ? this.vsbWidth : 0.0);
            if (this.hsbvis && !Properties.IS_TOUCH_SUPPORTED) {
                this.contentHeight = d5 - this.hsbHeight;
            }
            d11 = d5 + d8 + d9 - (this.hsbvis ? this.hsbHeight : 0.0);
        }
        if (this.scrollNode != null && this.scrollNode.isResizable()) {
            if (this.vsbvis && this.hsbvis) {
                ScrollPaneSkin scrollPaneSkin2 = this;
                scrollPaneSkin2.computeScrollNodeSize(scrollPaneSkin2.contentWidth, this.contentHeight);
            } else if (this.hsbvis && !this.vsbvis) {
                ScrollPaneSkin scrollPaneSkin3 = this;
                scrollPaneSkin3.computeScrollNodeSize(scrollPaneSkin3.contentWidth, this.contentHeight);
                this.vsbvis = this.determineVerticalSBVisible();
                if (this.vsbvis) {
                    this.contentWidth -= this.vsbWidth;
                    d10 -= this.vsbWidth;
                    ScrollPaneSkin scrollPaneSkin4 = this;
                    scrollPaneSkin4.computeScrollNodeSize(scrollPaneSkin4.contentWidth, this.contentHeight);
                }
            } else if (this.vsbvis && !this.hsbvis) {
                ScrollPaneSkin scrollPaneSkin5 = this;
                scrollPaneSkin5.computeScrollNodeSize(scrollPaneSkin5.contentWidth, this.contentHeight);
                this.hsbvis = this.determineHorizontalSBVisible();
                if (this.hsbvis) {
                    this.contentHeight -= this.hsbHeight;
                    d11 -= this.hsbHeight;
                    ScrollPaneSkin scrollPaneSkin6 = this;
                    scrollPaneSkin6.computeScrollNodeSize(scrollPaneSkin6.contentWidth, this.contentHeight);
                }
            }
        }
        double d12 = this.snappedLeftInset() - d7;
        double d13 = this.snappedTopInset() - d8;
        this.vsb.setVisible(this.vsbvis);
        if (this.vsbvis) {
            this.vsb.resizeRelocate(this.snappedLeftInset() + d4 - this.vsbWidth + (d6 < 1.0 ? 0.0 : d6 - 1.0), d13, this.vsbWidth, d11);
        }
        this.updateVerticalSB();
        this.hsb.setVisible(this.hsbvis);
        if (this.hsbvis) {
            this.hsb.resizeRelocate(d12, this.snappedTopInset() + d5 - this.hsbHeight + (d9 < 1.0 ? 0.0 : d9 - 1.0), d10, this.hsbHeight);
        }
        this.updateHorizontalSB();
        ScrollPaneSkin scrollPaneSkin7 = this;
        ScrollPaneSkin scrollPaneSkin8 = this;
        this.viewRect.resizeRelocate(this.snappedLeftInset(), this.snappedTopInset(), scrollPaneSkin7.snapSizeX(scrollPaneSkin7.contentWidth), scrollPaneSkin8.snapSizeY(scrollPaneSkin8.contentHeight));
        this.resetClip();
        if (this.vsbvis && this.hsbvis) {
            this.corner.setVisible(true);
            double d14 = this.vsbWidth;
            double d15 = this.hsbHeight;
            ScrollPaneSkin scrollPaneSkin9 = this;
            ScrollPaneSkin scrollPaneSkin10 = this;
            this.corner.resizeRelocate(scrollPaneSkin9.snapPositionX(scrollPaneSkin9.vsb.getLayoutX()), scrollPaneSkin10.snapPositionY(scrollPaneSkin10.hsb.getLayoutY()), this.snapSizeX(d14), this.snapSizeY(d15));
        } else {
            this.corner.setVisible(false);
        }
        ScrollPaneSkin scrollPaneSkin11 = this;
        ScrollPaneSkin scrollPaneSkin12 = this;
        ScrollPaneSkin scrollPaneSkin13 = this;
        ScrollPaneSkin scrollPaneSkin14 = this;
        scrollPane.setViewportBounds(new BoundingBox(scrollPaneSkin11.snapPositionX(scrollPaneSkin11.viewContent.getLayoutX()), scrollPaneSkin12.snapPositionY(scrollPaneSkin12.viewContent.getLayoutY()), scrollPaneSkin13.snapSizeX(scrollPaneSkin13.contentWidth), scrollPaneSkin14.snapSizeY(scrollPaneSkin14.contentHeight)));
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case VERTICAL_SCROLLBAR: {
                return this.vsb;
            }
            case HORIZONTAL_SCROLLBAR: {
                return this.hsb;
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    private void initialize() {
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        this.scrollNode = scrollPane.getContent();
        Object object = new ParentTraversalEngine((Parent)((Object)this.getSkinnable()));
        ((TraversalEngine)object).addTraverseListener((node, bounds) -> this.scrollBoundsIntoView(bounds));
        ParentHelper.setTraversalEngine((Parent)((Object)this.getSkinnable()), (ParentTraversalEngine)object);
        if (this.scrollNode != null) {
            this.scrollNode.layoutBoundsProperty().addListener(this.weakNodeListener);
            this.scrollNode.layoutBoundsProperty().addListener(this.weakBoundsChangeListener);
        }
        this.viewRect = new ScrollPaneSkin$5(this);
        this.viewRect.setManaged(false);
        this.viewRect.setCache(true);
        this.viewRect.getStyleClass().add("viewport");
        this.clipRect = new Rectangle();
        this.viewRect.setClip(this.clipRect);
        this.hsb = new ScrollBar();
        this.vsb = new ScrollBar();
        this.vsb.setOrientation(Orientation.VERTICAL);
        object = mouseEvent -> {
            if (((ScrollPane)this.getSkinnable()).isFocusTraversable()) {
                ((ScrollPane)this.getSkinnable()).requestFocus();
            }
        };
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addEventFilter(this.hsb, MouseEvent.MOUSE_PRESSED, object);
        listenerHelper.addEventFilter(this.vsb, MouseEvent.MOUSE_PRESSED, object);
        this.corner = new StackPane();
        this.corner.getStyleClass().setAll((String[])new String[]{"corner"});
        this.viewContent = new ScrollPaneSkin$6(this);
        this.viewRect.getChildren().add(this.viewContent);
        if (this.scrollNode != null) {
            this.viewContent.getChildren().add(this.scrollNode);
            this.viewRect.nodeOrientationProperty().bind(this.scrollNode.nodeOrientationProperty());
        }
        this.getChildren().clear();
        this.getChildren().addAll((Node[])new Node[]{this.viewRect, this.vsb, this.hsb, this.corner});
        listenerHelper.addInvalidationListener(this.vsb.valueProperty(), observable -> {
            this.posY = !Properties.IS_TOUCH_SUPPORTED ? com.sun.javafx.util.Utils.clamp(((ScrollPane)this.getSkinnable()).getVmin(), this.vsb.getValue(), ((ScrollPane)this.getSkinnable()).getVmax()) : this.vsb.getValue();
            this.updatePosY();
        });
        listenerHelper.addInvalidationListener(this.hsb.valueProperty(), observable -> {
            this.posX = !Properties.IS_TOUCH_SUPPORTED ? com.sun.javafx.util.Utils.clamp(((ScrollPane)this.getSkinnable()).getHmin(), this.hsb.getValue(), ((ScrollPane)this.getSkinnable()).getHmax()) : this.hsb.getValue();
            this.updatePosX();
        });
        this.viewRect.setOnMousePressed(mouseEvent -> {
            this.mouseDown = true;
            if (Properties.IS_TOUCH_SUPPORTED) {
                this.startSBReleasedAnimation();
            }
            this.pressX = mouseEvent.getX();
            this.pressY = mouseEvent.getY();
            this.ohvalue = this.hsb.getValue();
            this.ovvalue = this.vsb.getValue();
        });
        this.viewRect.setOnDragDetected(mouseEvent -> {
            if (Properties.IS_TOUCH_SUPPORTED) {
                this.startSBReleasedAnimation();
            }
            if (((ScrollPane)this.getSkinnable()).isPannable()) {
                this.dragDetected = true;
                if (this.saveCursor == null) {
                    this.saveCursor = ((ScrollPane)this.getSkinnable()).getCursor();
                    if (this.saveCursor == null) {
                        this.saveCursor = Cursor.DEFAULT;
                    }
                    ((ScrollPane)this.getSkinnable()).setCursor(Cursor.MOVE);
                    ((ScrollPane)this.getSkinnable()).requestLayout();
                }
            }
        });
        this.viewRect.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            this.mouseDown = false;
            if (this.dragDetected) {
                if (this.saveCursor != null) {
                    ((ScrollPane)this.getSkinnable()).setCursor(this.saveCursor);
                    this.saveCursor = null;
                    ((ScrollPane)this.getSkinnable()).requestLayout();
                }
                this.dragDetected = false;
            }
            if ((this.posY > ((ScrollPane)this.getSkinnable()).getVmax() || this.posY < ((ScrollPane)this.getSkinnable()).getVmin() || this.posX > ((ScrollPane)this.getSkinnable()).getHmax() || this.posX < ((ScrollPane)this.getSkinnable()).getHmin()) && !this.touchDetected) {
                this.startContentsToViewport();
            }
        });
        this.viewRect.setOnMouseDragged(mouseEvent -> {
            if (Properties.IS_TOUCH_SUPPORTED) {
                this.startSBReleasedAnimation();
            }
            if (((ScrollPane)this.getSkinnable()).isPannable() || Properties.IS_TOUCH_SUPPORTED) {
                double d2;
                double d3 = this.pressX - mouseEvent.getX();
                double d4 = this.pressY - mouseEvent.getY();
                if (this.hsb.getVisibleAmount() > 0.0 && this.hsb.getVisibleAmount() < this.hsb.getMax() && Math.abs(d3) > 0.5) {
                    if (this.isReverseNodeOrientation()) {
                        d3 = -d3;
                    }
                    d2 = this.ohvalue + d3 / (this.nodeWidth - this.viewRect.getWidth()) * (this.hsb.getMax() - this.hsb.getMin());
                    if (!Properties.IS_TOUCH_SUPPORTED) {
                        if (d2 > this.hsb.getMax()) {
                            d2 = this.hsb.getMax();
                        } else if (d2 < this.hsb.getMin()) {
                            d2 = this.hsb.getMin();
                        }
                        this.hsb.setValue(d2);
                    } else {
                        this.hsb.setValue(d2);
                    }
                }
                if (this.vsb.getVisibleAmount() > 0.0 && this.vsb.getVisibleAmount() < this.vsb.getMax() && Math.abs(d4) > 0.5) {
                    d2 = this.ovvalue + d4 / (this.nodeHeight - this.viewRect.getHeight()) * (this.vsb.getMax() - this.vsb.getMin());
                    if (!Properties.IS_TOUCH_SUPPORTED) {
                        if (d2 > this.vsb.getMax()) {
                            d2 = this.vsb.getMax();
                        } else if (d2 < this.vsb.getMin()) {
                            d2 = this.vsb.getMin();
                        }
                        this.vsb.setValue(d2);
                    } else {
                        this.vsb.setValue(d2);
                    }
                }
            }
            mouseEvent.consume();
        });
        object = (event, eventDispatchChain) -> event;
        EventDispatcher eventDispatcher = this.hsb.getEventDispatcher();
        this.hsb.setEventDispatcher((arg_0, arg_1) -> ScrollPaneSkin.lambda$initialize$18((EventDispatcher)object, eventDispatcher, arg_0, arg_1));
        eventDispatcher = this.vsb.getEventDispatcher();
        this.vsb.setEventDispatcher((arg_0, arg_1) -> ScrollPaneSkin.lambda$initialize$19((EventDispatcher)object, eventDispatcher, arg_0, arg_1));
        this.viewRect.addEventHandler(ScrollEvent.SCROLL, scrollEvent -> {
            block12: {
                block14: {
                    double d2;
                    block13: {
                        double d3;
                        double d4;
                        double d5;
                        double d6;
                        block9: {
                            block11: {
                                block10: {
                                    double d7;
                                    if (Properties.IS_TOUCH_SUPPORTED) {
                                        this.startSBReleasedAnimation();
                                    }
                                    if (!(this.vsb.getVisibleAmount() < this.vsb.getMax())) break block9;
                                    d6 = ((ScrollPane)this.getSkinnable()).getVmax() - ((ScrollPane)this.getSkinnable()).getVmin();
                                    d5 = this.nodeHeight - this.contentHeight;
                                    d4 = d7 > 0.0 ? d6 / d5 : 0.0;
                                    d2 = this.vsb.getValue() + -scrollEvent.getDeltaY() * d4;
                                    if (Properties.IS_TOUCH_SUPPORTED) break block10;
                                    if (!(scrollEvent.getDeltaY() > 0.0 && this.vsb.getValue() > this.vsb.getMin()) && (!(scrollEvent.getDeltaY() < 0.0) || !(this.vsb.getValue() < this.vsb.getMax()))) break block9;
                                    this.vsb.setValue(d2);
                                    break block11;
                                }
                                if (scrollEvent.isInertia() && (!scrollEvent.isInertia() || this.contentsToViewTimeline != null && this.contentsToViewTimeline.getStatus() != Animation$Status.STOPPED)) break block9;
                                this.vsb.setValue(d2);
                                if ((d2 > this.vsb.getMax() || d2 < this.vsb.getMin()) && !this.mouseDown && !this.touchDetected) {
                                    this.startContentsToViewport();
                                }
                            }
                            scrollEvent.consume();
                        }
                        if (!(this.hsb.getVisibleAmount() < this.hsb.getMax())) break block12;
                        d6 = ((ScrollPane)this.getSkinnable()).getHmax() - ((ScrollPane)this.getSkinnable()).getHmin();
                        d5 = this.nodeWidth - this.contentWidth;
                        d4 = d3 > 0.0 ? d6 / d5 : 0.0;
                        d2 = this.hsb.getValue() + -scrollEvent.getDeltaX() * d4;
                        if (Properties.IS_TOUCH_SUPPORTED) break block13;
                        if (!(scrollEvent.getDeltaX() > 0.0 && this.hsb.getValue() > this.hsb.getMin()) && (!(scrollEvent.getDeltaX() < 0.0) || !(this.hsb.getValue() < this.hsb.getMax()))) break block12;
                        this.hsb.setValue(d2);
                        break block14;
                    }
                    if (scrollEvent.isInertia() && (!scrollEvent.isInertia() || this.contentsToViewTimeline != null && this.contentsToViewTimeline.getStatus() != Animation$Status.STOPPED)) break block12;
                    this.hsb.setValue(d2);
                    if ((d2 > this.hsb.getMax() || d2 < this.hsb.getMin()) && !this.mouseDown && !this.touchDetected) {
                        this.startContentsToViewport();
                    }
                }
                scrollEvent.consume();
            }
        });
        listenerHelper.addEventHandler(this.getSkinnable(), TouchEvent.TOUCH_PRESSED, touchEvent -> {
            this.touchDetected = true;
            this.startSBReleasedAnimation();
            touchEvent.consume();
        });
        listenerHelper.addEventHandler(this.getSkinnable(), TouchEvent.TOUCH_RELEASED, touchEvent -> {
            this.touchDetected = false;
            touchEvent.consume();
        });
        this.consumeMouseEvents(false);
        this.hsb.setValue(scrollPane.getHvalue());
        this.vsb.setValue(scrollPane.getVvalue());
    }

    void scrollBoundsIntoView(Bounds bounds) {
        double d2;
        double d3;
        double d4 = 0.0;
        double d5 = 0.0;
        if (bounds.getMaxX() > this.contentWidth) {
            d4 = bounds.getMinX() - this.snappedLeftInset();
        }
        if (bounds.getMinX() < this.snappedLeftInset()) {
            d4 = bounds.getMaxX() - this.contentWidth - this.snappedLeftInset();
        }
        if (bounds.getMaxY() > this.snappedTopInset() + this.contentHeight) {
            d5 = bounds.getMinY() - this.snappedTopInset();
        }
        if (bounds.getMinY() < this.snappedTopInset()) {
            d5 = bounds.getMaxY() - this.contentHeight - this.snappedTopInset();
        }
        if (d4 != 0.0) {
            double d6;
            d3 = this.nodeWidth - this.contentWidth;
            d2 = d6 > 0.0 ? d4 * (this.hsb.getMax() - this.hsb.getMin()) / d3 : 0.0;
            d2 = d2 + -1.0 * Math.signum(d2) * this.hsb.getUnitIncrement() / 5.0;
            this.hsb.setValue(this.hsb.getValue() + d2);
            ((ScrollPane)this.getSkinnable()).requestLayout();
        }
        if (d5 != 0.0) {
            double d7;
            d3 = this.nodeHeight - this.contentHeight;
            d2 = d7 > 0.0 ? d5 * (this.vsb.getMax() - this.vsb.getMin()) / d3 : 0.0;
            d2 = d2 + -1.0 * Math.signum(d2) * this.vsb.getUnitIncrement() / 5.0;
            this.vsb.setValue(this.vsb.getValue() + d2);
            ((ScrollPane)this.getSkinnable()).requestLayout();
        }
    }

    private double computeHsbSizeHint(ScrollPane scrollPane) {
        if (scrollPane.getHbarPolicy() == ScrollPane$ScrollBarPolicy.ALWAYS || scrollPane.getHbarPolicy() == ScrollPane$ScrollBarPolicy.AS_NEEDED && (scrollPane.getPrefViewportHeight() > 0.0 || scrollPane.getMinViewportHeight() > 0.0)) {
            return ((Node)this.hsb).prefHeight(-1.0);
        }
        return 0.0;
    }

    private double computeVsbSizeHint(ScrollPane scrollPane) {
        if (scrollPane.getVbarPolicy() == ScrollPane$ScrollBarPolicy.ALWAYS || scrollPane.getVbarPolicy() == ScrollPane$ScrollBarPolicy.AS_NEEDED && (scrollPane.getPrefViewportWidth() > 0.0 || scrollPane.getMinViewportWidth() > 0.0)) {
            return ((Node)this.vsb).prefWidth(-1.0);
        }
        return 0.0;
    }

    private void computeScrollNodeSize(double d2, double d3) {
        if (this.scrollNode != null) {
            if (this.scrollNode.isResizable()) {
                ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
                Orientation orientation = this.scrollNode.getContentBias();
                if (orientation == null) {
                    this.nodeWidth = this.snapSizeX(Utils.boundedSize(scrollPane.isFitToWidth() ? d2 : this.scrollNode.prefWidth(-1.0), this.scrollNode.minWidth(-1.0), this.scrollNode.maxWidth(-1.0)));
                    this.nodeHeight = this.snapSizeY(Utils.boundedSize(scrollPane.isFitToHeight() ? d3 : this.scrollNode.prefHeight(-1.0), this.scrollNode.minHeight(-1.0), this.scrollNode.maxHeight(-1.0)));
                } else if (orientation == Orientation.HORIZONTAL) {
                    this.nodeWidth = this.snapSizeX(Utils.boundedSize(scrollPane.isFitToWidth() ? d2 : this.scrollNode.prefWidth(-1.0), this.scrollNode.minWidth(-1.0), this.scrollNode.maxWidth(-1.0)));
                    this.nodeHeight = this.snapSizeY(Utils.boundedSize(scrollPane.isFitToHeight() ? d3 : this.scrollNode.prefHeight(this.nodeWidth), this.scrollNode.minHeight(this.nodeWidth), this.scrollNode.maxHeight(this.nodeWidth)));
                } else {
                    this.nodeHeight = this.snapSizeY(Utils.boundedSize(scrollPane.isFitToHeight() ? d3 : this.scrollNode.prefHeight(-1.0), this.scrollNode.minHeight(-1.0), this.scrollNode.maxHeight(-1.0)));
                    this.nodeWidth = this.snapSizeX(Utils.boundedSize(scrollPane.isFitToWidth() ? d2 : this.scrollNode.prefWidth(this.nodeHeight), this.scrollNode.minWidth(this.nodeHeight), this.scrollNode.maxWidth(this.nodeHeight)));
                }
            } else {
                this.nodeWidth = this.snapSizeX(this.scrollNode.getLayoutBounds().getWidth());
                this.nodeHeight = this.snapSizeY(this.scrollNode.getLayoutBounds().getHeight());
            }
            this.nodeSizeInvalid = false;
        }
    }

    private boolean isReverseNodeOrientation() {
        return this.scrollNode != null && ((ScrollPane)this.getSkinnable()).getEffectiveNodeOrientation() != this.scrollNode.getEffectiveNodeOrientation();
    }

    private boolean determineHorizontalSBVisible() {
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        if (Properties.IS_TOUCH_SUPPORTED) {
            return this.tempVisibility && this.nodeWidth > this.contentWidth;
        }
        ScrollPane$ScrollBarPolicy scrollPane$ScrollBarPolicy = scrollPane.getHbarPolicy();
        if (ScrollPane$ScrollBarPolicy.NEVER != scrollPane$ScrollBarPolicy) {
            if (ScrollPane$ScrollBarPolicy.ALWAYS == scrollPane$ScrollBarPolicy) {
                return true;
            }
            if (scrollPane.isFitToWidth() && this.scrollNode != null && this.scrollNode.isResizable()) {
                return this.nodeWidth > this.contentWidth && this.scrollNode.minWidth(-1.0) > this.contentWidth;
            }
            if (this.nodeWidth > this.contentWidth) {
                return true;
            }
        }
        return false;
    }

    private boolean determineVerticalSBVisible() {
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        if (Properties.IS_TOUCH_SUPPORTED) {
            return this.tempVisibility && this.nodeHeight > this.contentHeight;
        }
        ScrollPane$ScrollBarPolicy scrollPane$ScrollBarPolicy = scrollPane.getVbarPolicy();
        if (ScrollPane$ScrollBarPolicy.NEVER != scrollPane$ScrollBarPolicy) {
            if (ScrollPane$ScrollBarPolicy.ALWAYS == scrollPane$ScrollBarPolicy) {
                return true;
            }
            if (scrollPane.isFitToHeight() && this.scrollNode != null && this.scrollNode.isResizable()) {
                return this.nodeHeight > this.contentHeight && this.scrollNode.minHeight(-1.0) > this.contentHeight;
            }
            if (this.nodeHeight > this.contentHeight) {
                return true;
            }
        }
        return false;
    }

    private void computeScrollBarSize() {
        this.vsbWidth = this.snapSizeX(((Node)this.vsb).prefWidth(-1.0));
        if (this.vsbWidth == 0.0) {
            this.vsbWidth = Properties.IS_TOUCH_SUPPORTED ? 8.0 : 12.0;
        }
        this.hsbHeight = this.snapSizeY(((Node)this.hsb).prefHeight(-1.0));
        if (this.hsbHeight == 0.0) {
            if (Properties.IS_TOUCH_SUPPORTED) {
                this.hsbHeight = 8.0;
                return;
            }
            this.hsbHeight = 12.0;
        }
    }

    private void updateHorizontalSB() {
        double d2;
        double d3 = this.nodeWidth * (this.hsb.getMax() - this.hsb.getMin());
        if (d2 > 0.0) {
            this.hsb.setVisibleAmount(this.contentWidth / d3);
            this.hsb.setBlockIncrement(0.9 * this.hsb.getVisibleAmount());
            this.hsb.setUnitIncrement(0.1 * this.hsb.getVisibleAmount());
        } else {
            this.hsb.setVisibleAmount(0.0);
            this.hsb.setBlockIncrement(0.0);
            this.hsb.setUnitIncrement(0.0);
        }
        if (this.hsb.isVisible()) {
            this.updatePosX();
            return;
        }
        if (this.nodeWidth > this.contentWidth) {
            this.updatePosX();
            return;
        }
        this.viewContent.setLayoutX(0.0);
    }

    private void updateVerticalSB() {
        double d2;
        double d3 = this.nodeHeight * (this.vsb.getMax() - this.vsb.getMin());
        if (d2 > 0.0) {
            this.vsb.setVisibleAmount(this.contentHeight / d3);
            this.vsb.setBlockIncrement(0.9 * this.vsb.getVisibleAmount());
            this.vsb.setUnitIncrement(0.1 * this.vsb.getVisibleAmount());
        } else {
            this.vsb.setVisibleAmount(0.0);
            this.vsb.setBlockIncrement(0.0);
            this.vsb.setUnitIncrement(0.0);
        }
        if (this.vsb.isVisible()) {
            this.updatePosY();
            return;
        }
        if (this.nodeHeight > this.contentHeight) {
            this.updatePosY();
            return;
        }
        this.viewContent.setLayoutY(0.0);
    }

    private double updatePosX() {
        double d2;
        double d3;
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        double d4 = this.isReverseNodeOrientation() ? this.hsb.getMax() - (this.posX - this.hsb.getMin()) : this.posX;
        double d5 = this.hsb.getMax() - this.hsb.getMin();
        double d6 = d3 = d2 > 0.0 ? -d4 / d5 * (this.nodeWidth - this.contentWidth) : 0.0;
        if (!Properties.IS_TOUCH_SUPPORTED) {
            d3 = Math.min(d3, 0.0);
        }
        this.viewContent.setLayoutX(this.snapPositionX(d3));
        if (!scrollPane.hvalueProperty().isBound()) {
            ScrollPane scrollPane2 = scrollPane;
            scrollPane2.setHvalue(com.sun.javafx.util.Utils.clamp(scrollPane2.getHmin(), this.posX, scrollPane.getHmax()));
        }
        return this.posX;
    }

    private double updatePosY() {
        double d2;
        double d3;
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        double d4 = this.vsb.getMax() - this.vsb.getMin();
        double d5 = d3 = d2 > 0.0 ? -this.posY / d4 * (this.nodeHeight - this.contentHeight) : 0.0;
        if (!Properties.IS_TOUCH_SUPPORTED) {
            d3 = Math.min(d3, 0.0);
        }
        this.viewContent.setLayoutY(this.snapPositionY(d3));
        if (!scrollPane.vvalueProperty().isBound()) {
            ScrollPane scrollPane2 = scrollPane;
            scrollPane2.setVvalue(com.sun.javafx.util.Utils.clamp(scrollPane2.getVmin(), this.posY, scrollPane.getVmax()));
        }
        return this.posY;
    }

    private void resetClip() {
        ScrollPaneSkin scrollPaneSkin = this;
        this.clipRect.setWidth(scrollPaneSkin.snapSizeX(scrollPaneSkin.contentWidth));
        ScrollPaneSkin scrollPaneSkin2 = this;
        this.clipRect.setHeight(scrollPaneSkin2.snapSizeY(scrollPaneSkin2.contentHeight));
    }

    private void startSBReleasedAnimation() {
        if (this.sbTouchTimeline == null) {
            this.sbTouchTimeline = new Timeline();
            this.sbTouchKF1 = new KeyFrame(Duration.millis(0.0), actionEvent -> {
                this.tempVisibility = true;
                if ((this.touchDetected || this.mouseDown) && NodeHelper.isTreeShowing((Node)((Object)this.getSkinnable()))) {
                    this.sbTouchTimeline.playFromStart();
                }
            }, new KeyValue[0]);
            this.sbTouchKF2 = new KeyFrame(Duration.millis(1000.0), actionEvent -> {
                this.tempVisibility = false;
                ((ScrollPane)this.getSkinnable()).requestLayout();
            }, new KeyValue[0]);
            this.sbTouchTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{this.sbTouchKF1, this.sbTouchKF2});
        }
        this.sbTouchTimeline.playFromStart();
    }

    private void startContentsToViewport() {
        double d2 = this.posX;
        double d3 = this.posY;
        ScrollPaneSkin scrollPaneSkin = this;
        scrollPaneSkin.setContentPosX(scrollPaneSkin.posX);
        ScrollPaneSkin scrollPaneSkin2 = this;
        scrollPaneSkin2.setContentPosY(scrollPaneSkin2.posY);
        if (this.posY > ((ScrollPane)this.getSkinnable()).getVmax()) {
            d3 = ((ScrollPane)this.getSkinnable()).getVmax();
        } else if (this.posY < ((ScrollPane)this.getSkinnable()).getVmin()) {
            d3 = ((ScrollPane)this.getSkinnable()).getVmin();
        }
        if (this.posX > ((ScrollPane)this.getSkinnable()).getHmax()) {
            d2 = ((ScrollPane)this.getSkinnable()).getHmax();
        } else if (this.posX < ((ScrollPane)this.getSkinnable()).getHmin()) {
            d2 = ((ScrollPane)this.getSkinnable()).getHmin();
        }
        if (!Properties.IS_TOUCH_SUPPORTED) {
            this.startSBReleasedAnimation();
        }
        if (this.contentsToViewTimeline != null) {
            ((Animation)this.contentsToViewTimeline).stop();
        }
        this.contentsToViewTimeline = new Timeline();
        this.contentsToViewKF1 = new KeyFrame(Duration.millis(50.0), new KeyValue[0]);
        this.contentsToViewKF2 = new KeyFrame(Duration.millis(150.0), actionEvent -> ((ScrollPane)this.getSkinnable()).requestLayout(), new KeyValue(this.contentPosX, d2), new KeyValue(this.contentPosY, d3));
        this.contentsToViewKF3 = new KeyFrame(Duration.millis(1500.0), new KeyValue[0]);
        this.contentsToViewTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{this.contentsToViewKF1, this.contentsToViewKF2, this.contentsToViewKF3});
        this.contentsToViewTimeline.playFromStart();
    }

    private static /* synthetic */ Event lambda$initialize$19(EventDispatcher eventDispatcher, EventDispatcher eventDispatcher2, Event event, EventDispatchChain eventDispatchChain) {
        if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
            eventDispatchChain = eventDispatchChain.prepend(eventDispatcher);
            eventDispatchChain = eventDispatchChain.prepend(eventDispatcher2);
            return eventDispatchChain.dispatchEvent(event);
        }
        return eventDispatcher2.dispatchEvent(event, eventDispatchChain);
    }

    private static /* synthetic */ Event lambda$initialize$18(EventDispatcher eventDispatcher, EventDispatcher eventDispatcher2, Event event, EventDispatchChain eventDispatchChain) {
        if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
            eventDispatchChain = eventDispatchChain.prepend(eventDispatcher);
            eventDispatchChain = eventDispatchChain.prepend(eventDispatcher2);
            return eventDispatchChain.dispatchEvent(event);
        }
        return eventDispatcher2.dispatchEvent(event, eventDispatchChain);
    }

    static /* synthetic */ double access$000(ScrollPaneSkin scrollPaneSkin) {
        return scrollPaneSkin.snappedTopInset();
    }

    static /* synthetic */ double access$100(ScrollPaneSkin scrollPaneSkin, double d2) {
        return scrollPaneSkin.snapPositionY(d2);
    }

    static /* synthetic */ double access$200(ScrollPaneSkin scrollPaneSkin) {
        return scrollPaneSkin.snappedTopInset();
    }

    static /* synthetic */ double access$300(ScrollPaneSkin scrollPaneSkin, double d2) {
        return scrollPaneSkin.snapPositionY(d2);
    }

    static /* synthetic */ double access$400(ScrollPaneSkin scrollPaneSkin) {
        return scrollPaneSkin.snappedLeftInset();
    }

    static /* synthetic */ double access$500(ScrollPaneSkin scrollPaneSkin, double d2) {
        return scrollPaneSkin.snapPositionX(d2);
    }

    static /* synthetic */ double access$600(ScrollPaneSkin scrollPaneSkin) {
        return scrollPaneSkin.snappedLeftInset();
    }

    static /* synthetic */ double access$700(ScrollPaneSkin scrollPaneSkin, double d2) {
        return scrollPaneSkin.snapPositionX(d2);
    }
}

