/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.LambdaMultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.Collection;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.Side;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TabPane$TabClosingPolicy;
import javafx.scene.control.Tooltip;
import javafx.scene.control.skin.TabPaneSkin;
import javafx.scene.control.skin.TabPaneSkin$TabAnimationState;
import javafx.scene.control.skin.TabPaneSkin$TabHeaderSkin$1;
import javafx.scene.control.skin.TabPaneSkin$TabHeaderSkin$2;
import javafx.scene.control.skin.TabPaneSkin$TabHeaderSkin$3;
import javafx.scene.control.skin.TabPaneSkin$TabHeaderSkin$4;
import javafx.scene.control.skin.TabPaneSkin$TabHeaderSkin$5;
import javafx.scene.control.skin.TabPaneSkin$TabHeaderSkin$6;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.stage.PopupWindow;

class TabPaneSkin$TabHeaderSkin
extends StackPane {
    private final Tab tab;
    private Label label;
    private StackPane closeBtn;
    private StackPane inner;
    private Tooltip oldTooltip;
    private Tooltip tooltip;
    private Rectangle clip;
    private boolean isClosing = false;
    private LambdaMultiplePropertyChangeListenerHandler listener = new LambdaMultiplePropertyChangeListenerHandler();
    private final ListChangeListener<String> styleClassListener = new TabPaneSkin$TabHeaderSkin$1(this);
    private final WeakListChangeListener<String> weakStyleClassListener = new WeakListChangeListener<String>(this.styleClassListener);
    private final DoubleProperty animationTransition;
    private TabPaneSkin$TabAnimationState animationState;
    private Timeline currentAnimation;
    final /* synthetic */ TabPaneSkin this$0;

    public Tab getTab() {
        return this.tab;
    }

    public TabPaneSkin$TabHeaderSkin(TabPaneSkin object2, Tab tab) {
        this.this$0 = object2;
        TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin = this;
        this.animationTransition = new TabPaneSkin$TabHeaderSkin$6(tabPaneSkin$TabHeaderSkin, tabPaneSkin$TabHeaderSkin, "animationTransition", 1.0);
        this.animationState = TabPaneSkin$TabAnimationState.NONE;
        this.getStyleClass().setAll((Collection<String>)tab.getStyleClass());
        this.setId(tab.getId());
        this.setStyle(tab.getStyle());
        this.setAccessibleRole(AccessibleRole.TAB_ITEM);
        this.setViewOrder(1.0);
        this.tab = tab;
        this.clip = new Rectangle();
        TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin2 = this;
        tabPaneSkin$TabHeaderSkin2.setClip(tabPaneSkin$TabHeaderSkin2.clip);
        this.label = new Label(tab.getText(), tab.getGraphic());
        this.label.getStyleClass().setAll((String[])new String[]{"tab-label"});
        this.closeBtn = new TabPaneSkin$TabHeaderSkin$2(this, (TabPaneSkin)object2);
        this.closeBtn.setAccessibleRole(AccessibleRole.BUTTON);
        this.closeBtn.setAccessibleText(ControlResources.getString("Accessibility.title.TabPane.CloseButton"));
        this.closeBtn.getStyleClass().setAll((String[])new String[]{"tab-close-button"});
        this.closeBtn.setOnMousePressed(new TabPaneSkin$TabHeaderSkin$3(this, object2));
        this.updateGraphicRotation();
        Region region = new Region();
        region.setMouseTransparent(true);
        region.getStyleClass().add("focus-indicator");
        this.inner = new TabPaneSkin$TabHeaderSkin$4(this, (TabPaneSkin)object2, region);
        this.inner.getStyleClass().add("tab-container");
        this.inner.setRotate(((TabPane)object2.getSkinnable()).getSide().equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
        this.inner.getChildren().addAll((Node[])new Node[]{this.label, this.closeBtn, region});
        this.getChildren().addAll((Node[])new Node[]{this.inner});
        this.tooltip = tab.getTooltip();
        if (this.tooltip != null) {
            TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin3 = this;
            Tooltip.install(tabPaneSkin$TabHeaderSkin3, tabPaneSkin$TabHeaderSkin3.tooltip);
            this.oldTooltip = this.tooltip;
        }
        this.listener.registerChangeListener(tab.closableProperty(), observableValue -> {
            ((Parent)this.inner).requestLayout();
            ((Parent)this).requestLayout();
        });
        this.listener.registerChangeListener(tab.selectedProperty(), observableValue -> {
            this.pseudoClassStateChanged(TabPaneSkin.SELECTED_PSEUDOCLASS_STATE, tab.isSelected());
            ((Parent)this.inner).requestLayout();
            ((Parent)this).requestLayout();
        });
        this.listener.registerChangeListener(tab.textProperty(), observableValue -> this.label.setText(this.getTab().getText()));
        this.listener.registerChangeListener(tab.graphicProperty(), observableValue -> this.label.setGraphic(this.getTab().getGraphic()));
        this.listener.registerChangeListener(tab.tooltipProperty(), observableValue -> {
            if (this.oldTooltip != null) {
                TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin = this;
                Tooltip.uninstall(tabPaneSkin$TabHeaderSkin, tabPaneSkin$TabHeaderSkin.oldTooltip);
            }
            this.tooltip = tab.getTooltip();
            if (this.tooltip != null) {
                TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin = this;
                Tooltip.install(tabPaneSkin$TabHeaderSkin, tabPaneSkin$TabHeaderSkin.tooltip);
                this.oldTooltip = this.tooltip;
            }
        });
        this.listener.registerChangeListener(tab.disabledProperty(), observableValue -> this.updateTabDisabledState());
        this.listener.registerChangeListener(tab.getTabPane().disabledProperty(), observableValue -> this.updateTabDisabledState());
        this.listener.registerChangeListener(tab.styleProperty(), observableValue -> this.setStyle(tab.getStyle()));
        tab.getStyleClass().addListener(this.weakStyleClassListener);
        this.listener.registerChangeListener(((TabPane)object2.getSkinnable()).tabClosingPolicyProperty(), observableValue -> {
            ((Parent)this.inner).requestLayout();
            ((Parent)this).requestLayout();
        });
        this.listener.registerChangeListener(((TabPane)object2.getSkinnable()).sideProperty(), object -> {
            object = ((TabPane)this.this$0.getSkinnable()).getSide();
            this.pseudoClassStateChanged(TabPaneSkin.TOP_PSEUDOCLASS_STATE, object == Side.TOP);
            this.pseudoClassStateChanged(TabPaneSkin.RIGHT_PSEUDOCLASS_STATE, object == Side.RIGHT);
            this.pseudoClassStateChanged(TabPaneSkin.BOTTOM_PSEUDOCLASS_STATE, object == Side.BOTTOM);
            this.pseudoClassStateChanged(TabPaneSkin.LEFT_PSEUDOCLASS_STATE, object == Side.LEFT);
            this.inner.setRotate(object == Side.BOTTOM ? 180.0 : 0.0);
            if (((TabPane)this.this$0.getSkinnable()).isRotateGraphic()) {
                this.updateGraphicRotation();
            }
        });
        this.listener.registerChangeListener(((TabPane)object2.getSkinnable()).rotateGraphicProperty(), observableValue -> this.updateGraphicRotation());
        this.listener.registerChangeListener(((TabPane)object2.getSkinnable()).tabMinWidthProperty(), observableValue -> {
            ((Parent)this).requestLayout();
            ((TabPane)this.this$0.getSkinnable()).requestLayout();
        });
        this.listener.registerChangeListener(((TabPane)object2.getSkinnable()).tabMaxWidthProperty(), observableValue -> {
            ((Parent)this).requestLayout();
            ((TabPane)this.this$0.getSkinnable()).requestLayout();
        });
        this.listener.registerChangeListener(((TabPane)object2.getSkinnable()).tabMinHeightProperty(), observableValue -> {
            ((Parent)this).requestLayout();
            ((TabPane)this.this$0.getSkinnable()).requestLayout();
        });
        this.listener.registerChangeListener(((TabPane)object2.getSkinnable()).tabMaxHeightProperty(), observableValue -> {
            ((Parent)this).requestLayout();
            ((TabPane)this.this$0.getSkinnable()).requestLayout();
        });
        this.getProperties().put(Tab.class, tab);
        this.getProperties().put(ContextMenu.class, tab.getContextMenu());
        TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin4 = this;
        tabPaneSkin$TabHeaderSkin4.setOnContextMenuRequested(contextMenuEvent -> {
            if (this.getTab().getContextMenu() != null) {
                ((PopupWindow)this.getTab().getContextMenu()).show(this.inner, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                contextMenuEvent.consume();
            }
        });
        this.setOnMousePressed(new TabPaneSkin$TabHeaderSkin$5(this, object2));
        this.pseudoClassStateChanged(TabPaneSkin.SELECTED_PSEUDOCLASS_STATE, tab.isSelected());
        this.pseudoClassStateChanged(TabPaneSkin.DISABLED_PSEUDOCLASS_STATE, tab.isDisabled());
        object2 = ((TabPane)object2.getSkinnable()).getSide();
        this.pseudoClassStateChanged(TabPaneSkin.TOP_PSEUDOCLASS_STATE, object2 == Side.TOP);
        this.pseudoClassStateChanged(TabPaneSkin.RIGHT_PSEUDOCLASS_STATE, object2 == Side.RIGHT);
        this.pseudoClassStateChanged(TabPaneSkin.BOTTOM_PSEUDOCLASS_STATE, object2 == Side.BOTTOM);
        this.pseudoClassStateChanged(TabPaneSkin.LEFT_PSEUDOCLASS_STATE, object2 == Side.LEFT);
    }

    private void updateTabDisabledState() {
        this.pseudoClassStateChanged(TabPaneSkin.DISABLED_PSEUDOCLASS_STATE, this.tab.isDisabled());
        ((Parent)this.inner).requestLayout();
        ((Parent)this).requestLayout();
    }

    private void updateGraphicRotation() {
        if (this.label.getGraphic() != null) {
            this.label.getGraphic().setRotate(((TabPane)this.this$0.getSkinnable()).isRotateGraphic() ? 0.0 : (double)(((TabPane)this.this$0.getSkinnable()).getSide().equals((Object)Side.RIGHT) ? -90.0f : (((TabPane)this.this$0.getSkinnable()).getSide().equals((Object)Side.LEFT) ? 90.0f : 0.0f)));
        }
    }

    private boolean showCloseButton() {
        return this.tab.isClosable() && (((TabPane)this.this$0.getSkinnable()).getTabClosingPolicy().equals((Object)TabPane$TabClosingPolicy.ALL_TABS) || ((TabPane)this.this$0.getSkinnable()).getTabClosingPolicy().equals((Object)TabPane$TabClosingPolicy.SELECTED_TAB) && this.tab.isSelected());
    }

    private void dispose() {
        this.tab.getStyleClass().removeListener(this.weakStyleClassListener);
        this.listener.dispose();
        this.setOnContextMenuRequested(null);
        this.setOnMousePressed(null);
    }

    @Override
    protected double computePrefWidth(double d2) {
        TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin = this;
        double d3 = tabPaneSkin$TabHeaderSkin.snapSizeX(((TabPane)tabPaneSkin$TabHeaderSkin.this$0.getSkinnable()).getTabMinWidth());
        TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin2 = this;
        double d4 = tabPaneSkin$TabHeaderSkin2.snapSizeX(((TabPane)tabPaneSkin$TabHeaderSkin2.this$0.getSkinnable()).getTabMaxWidth());
        double d5 = this.snappedRightInset();
        double d6 = this.snappedLeftInset();
        TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin3 = this;
        double d7 = tabPaneSkin$TabHeaderSkin3.snapSizeX(((Node)tabPaneSkin$TabHeaderSkin3.label).prefWidth(-1.0));
        if (this.showCloseButton()) {
            TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin4 = this;
            d7 += tabPaneSkin$TabHeaderSkin4.snapSizeX(((Node)tabPaneSkin$TabHeaderSkin4.closeBtn).prefWidth(-1.0));
        }
        if (d7 > d4) {
            d7 = d4;
        } else if (d7 < d3) {
            d7 = d3;
        }
        return d7 += d5 + d6;
    }

    @Override
    protected double computePrefHeight(double d2) {
        double d3;
        TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin = this;
        double d4 = tabPaneSkin$TabHeaderSkin.snapSizeY(((TabPane)tabPaneSkin$TabHeaderSkin.this$0.getSkinnable()).getTabMinHeight());
        TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin2 = this;
        double d5 = tabPaneSkin$TabHeaderSkin2.snapSizeY(((TabPane)tabPaneSkin$TabHeaderSkin2.this$0.getSkinnable()).getTabMaxHeight());
        double d6 = this.snappedTopInset();
        double d7 = this.snappedBottomInset();
        TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin3 = this;
        double d8 = tabPaneSkin$TabHeaderSkin3.snapSizeY(((Node)tabPaneSkin$TabHeaderSkin3.label).prefHeight(d2));
        if (d3 > d5) {
            d8 = d5;
        } else if (d8 < d4) {
            d8 = d4;
        }
        return d8 += d6 + d7;
    }

    @Override
    protected void layoutChildren() {
        TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin = this;
        double d2 = (tabPaneSkin$TabHeaderSkin.snapSizeX(tabPaneSkin$TabHeaderSkin.getWidth()) - this.snappedRightInset() - this.snappedLeftInset()) * this.animationTransition.getValue();
        TabPaneSkin$TabHeaderSkin tabPaneSkin$TabHeaderSkin2 = this;
        ((Node)this.inner).resize(d2, tabPaneSkin$TabHeaderSkin2.snapSizeY(tabPaneSkin$TabHeaderSkin2.getHeight()) - this.snappedTopInset() - this.snappedBottomInset());
        this.inner.relocate(this.snappedLeftInset(), this.snappedTopInset());
    }

    @Override
    protected void setWidth(double d2) {
        super.setWidth(d2);
        this.clip.setWidth(d2);
    }

    @Override
    protected void setHeight(double d2) {
        super.setHeight(d2);
        this.clip.setHeight(d2);
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case TEXT: {
                return this.getTab().getText();
            }
            case SELECTED: {
                return this.this$0.selectedTab == this.getTab();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
        switch (accessibleAction) {
            case REQUEST_FOCUS: {
                ((SelectionModel)((TabPane)this.this$0.getSkinnable()).getSelectionModel()).select(this.getTab());
                return;
            }
        }
        super.executeAccessibleAction(accessibleAction, objectArray);
    }
}

