/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TableRowBehavior;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventTarget;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TableView$TableViewFocusModel;
import javafx.scene.control.skin.TableRowSkin$1;
import javafx.scene.control.skin.TableRowSkinBase;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.layout.Region;

public class TableRowSkin<T>
extends TableRowSkinBase<T, TableRow<T>, TableCell<T, ?>> {
    private final BehaviorBase<TableRow<T>> behavior;

    public TableRowSkin(TableRow<T> tableRow) {
        super(tableRow);
        this.behavior = new TableRowBehavior<T>(tableRow);
        this.registerChangeListener(tableRow.tableViewProperty(), observableValue -> {
            int n2 = this.cells.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = (Node)this.cells.get(i2);
                if (!(node instanceof TableCell)) continue;
                ((TableCell)node).updateTableView(((TableRow)this.getSkinnable()).getTableView());
            }
        });
        this.setupTreeTableViewListeners();
    }

    private void setupTreeTableViewListeners() {
        TableView tableView = ((TableRow)this.getSkinnable()).getTableView();
        if (tableView == null) {
            TableRowSkin tableRowSkin = this;
            tableRowSkin.registerInvalidationListener(((TableRow)tableRowSkin.getSkinnable()).tableViewProperty(), observable -> {
                TableRowSkin tableRowSkin = this;
                tableRowSkin.unregisterInvalidationListeners(((TableRow)tableRowSkin.getSkinnable()).tableViewProperty());
                this.setupTreeTableViewListeners();
            });
            return;
        }
        Object object = tableView.fixedCellSizeProperty();
        if (object != null) {
            TableRowSkin tableRowSkin;
            this.registerChangeListener((ObservableValue<?>)object, arg_0 -> this.lambda$setupTreeTableViewListeners$2((DoubleProperty)object, arg_0));
            this.fixedCellSize = object.get();
            this.fixedCellSizeEnabled = tableRowSkin.fixedCellSize > 0.0;
            object = this.getVirtualFlow();
            if (object != null) {
                this.registerChangeListener(((Region)object).widthProperty(), observableValue -> tableView.requestLayout());
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute object, Object ... object2) {
        switch (TableRowSkin$1.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                if (this.getTableView().getSelectionModel() != null) {
                    object = new ArrayList();
                    int n2 = ((TableRow)this.getSkinnable()).getIndex();
                    Iterator iterator = this.getTableView().getSelectionModel().getSelectedCells().iterator();
                    if (iterator.hasNext()) {
                        if (((TablePositionBase)((Object)(iterator = (TablePosition)iterator.next()))).getRow() == n2) {
                            EventTarget eventTarget = ((TablePosition)((Object)iterator)).getTableColumn();
                            if (eventTarget == null) {
                                eventTarget = this.getTableView().getVisibleLeafColumn(0);
                            }
                            if ((eventTarget = (TableCell)this.cellsMap.get(eventTarget).get()) != null) {
                                object.add(eventTarget);
                            }
                        }
                        return FXCollections.observableArrayList(object);
                    }
                }
                return FXCollections.observableArrayList();
            }
            case 2: {
                int n3 = (Integer)object2[1];
                object2 = this.getTableView().getVisibleLeafColumn(n3);
                if (this.cellsMap.containsKey(object2)) {
                    return this.cellsMap.get(object2).get();
                }
                return null;
            }
            case 3: {
                object = this.getTableView().getFocusModel();
                object2 = ((TableView$TableViewFocusModel)object).getFocusedCell();
                TableColumn<T, ?> tableColumn = object2.getTableColumn();
                if (tableColumn == null) {
                    tableColumn = this.getTableView().getVisibleLeafColumn(0);
                }
                if (this.cellsMap.containsKey(tableColumn)) {
                    return this.cellsMap.get(tableColumn).get();
                }
                return null;
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), object2);
    }

    @Override
    protected TableCell<T, ?> createCell(TableColumnBase tableColumnBase) {
        tableColumnBase = (TableColumn)tableColumnBase;
        TableCell tableCell = ((TableColumn)tableColumnBase).getCellFactory().call(tableColumnBase);
        tableCell.updateTableColumn((TableColumn)tableColumnBase);
        tableCell.updateTableView(((TableColumn)tableColumnBase).getTableView());
        tableCell.updateTableRow((TableRow)this.getSkinnable());
        return tableCell;
    }

    @Override
    protected ObservableList<TableColumn<T, ?>> getVisibleLeafColumns() {
        if (this.getTableView() == null) {
            return FXCollections.emptyObservableList();
        }
        return this.getTableView().getVisibleLeafColumns();
    }

    @Override
    protected void updateCell(TableCell<T, ?> tableCell, TableRow<T> tableRow) {
        tableCell.updateTableRow(tableRow);
    }

    @Override
    protected TableColumn<T, ?> getTableColumn(TableCell<T, ?> tableCell) {
        return tableCell.getTableColumn();
    }

    private TableView<T> getTableView() {
        return ((TableRow)this.getSkinnable()).getTableView();
    }

    TableViewSkin<T> getTableViewSkin() {
        TableView tableView = ((TableRow)this.getSkinnable()).getTableView();
        if (tableView != null && tableView.getSkin() instanceof TableViewSkin) {
            return (TableViewSkin)tableView.getSkin();
        }
        return null;
    }

    private /* synthetic */ void lambda$setupTreeTableViewListeners$2(DoubleProperty doubleProperty, ObservableValue observableValue) {
        TableRowSkin tableRowSkin;
        this.fixedCellSize = doubleProperty.get();
        this.fixedCellSizeEnabled = tableRowSkin.fixedCellSize > 0.0;
    }
}

