/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.tk.Toolkit;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.StyleableObjectProperty;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.skin.CellSkinBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.util.Duration;

public abstract class TableRowSkinBase<T, C extends IndexedCell, R extends IndexedCell>
extends CellSkinBase<C> {
    private static boolean IS_STUB_TOOLKIT = Toolkit.getToolkit().toString().contains("StubToolkit");
    private static boolean DO_ANIMATIONS = !IS_STUB_TOOLKIT && !PlatformUtil.isEmbedded();
    private static final Duration FADE_DURATION = Duration.millis(200.0);
    static final Map<TableColumnBase<?, ?>, Double> maxDisclosureWidthMap = new WeakHashMap();
    private static final int DEFAULT_FULL_REFRESH_COUNTER = 100;
    WeakHashMap<TableColumnBase, Reference<R>> cellsMap;
    final List<R> cells = new ArrayList<R>();
    private int fullRefreshCounter = 100;
    boolean isDirty = false;
    boolean updateCells = false;
    double fixedCellSize;
    boolean fixedCellSizeEnabled;

    public TableRowSkinBase(C c2) {
        super(c2);
        ((IndexedCell)this.getSkinnable()).setPickOnBounds(false);
        this.recreateCells();
        this.updateCells(true);
        TableRowSkinBase tableRowSkinBase = this;
        tableRowSkinBase.registerListChangeListener(tableRowSkinBase.getVisibleLeafColumns(), listChangeListener$Change -> this.updateLeafColumns());
        this.registerInvalidationListener(((Cell)c2).itemProperty(), observable -> this.requestCellUpdate());
        this.registerChangeListener(((IndexedCell)c2).indexProperty(), observableValue -> {
            if (((IndexedCell)this.getSkinnable()).isEmpty()) {
                this.requestCellUpdate();
            }
        });
    }

    private void updateLeafColumns() {
        this.isDirty = true;
        ((IndexedCell)this.getSkinnable()).requestLayout();
    }

    protected abstract R createCell(TableColumnBase<T, ?> var1);

    protected abstract void updateCell(R var1, C var2);

    protected abstract TableColumnBase<T, ?> getTableColumn(R var1);

    protected abstract ObservableList<? extends TableColumnBase> getVisibleLeafColumns();

    protected ObjectProperty<Node> graphicProperty() {
        return null;
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        int n2;
        double d6;
        this.checkState();
        if (this.cellsMap.isEmpty()) {
            return;
        }
        ObservableList<TableColumnBase> observableList = this.getVisibleLeafColumns();
        if (observableList.isEmpty()) {
            super.layoutChildren(d2, d3, d4, d5);
            return;
        }
        IndexedCell indexedCell = (IndexedCell)this.getSkinnable();
        double d7 = 0.0;
        double d8 = 0.0;
        boolean bl2 = this.isIndentationRequired();
        boolean bl3 = this.isDisclosureNodeVisible();
        int n3 = 0;
        Node node = null;
        if (bl2) {
            TableColumnBase tableColumnBase = this.getTreeColumn();
            n3 = tableColumnBase == null ? 0 : observableList.indexOf(tableColumnBase);
            n3 = n3 < 0 ? 0 : n3;
            int n4 = this.getIndentationLevel(indexedCell);
            if (!this.isShowRoot()) {
                --n4;
            }
            d6 = this.getIndentationPerLevel();
            d7 = (double)n4 * d6;
            double d9 = maxDisclosureWidthMap.containsKey(tableColumnBase) ? maxDisclosureWidthMap.get(tableColumnBase) : 0.0;
            d8 = d9;
            node = this.getDisclosureNode();
            if (node != null) {
                node.setVisible(bl3);
                if (bl3) {
                    double d10;
                    d8 = node.prefWidth(d5);
                    if (d10 > d9) {
                        maxDisclosureWidthMap.put(tableColumnBase, d8);
                        observableList = this.getVirtualFlow();
                        ((IndexedCell)this.getSkinnable()).getIndex();
                        for (int i2 = 0; i2 < ((VirtualFlow)((Object)observableList)).cells.size(); ++i2) {
                            IndexedCell indexedCell2 = (IndexedCell)((VirtualFlow)((Object)observableList)).cells.get(i2);
                            if (indexedCell2 == null || indexedCell2.isEmpty()) continue;
                            indexedCell2.requestLayout();
                            indexedCell2.layout();
                        }
                    }
                }
            }
        }
        if ((n2 = indexedCell.getIndex()) < 0) {
            return;
        }
        int n5 = this.cells.size();
        for (int i3 = 0; i3 < n5; ++i3) {
            double d11;
            indexedCell = (IndexedCell)this.cells.get(i3);
            Object object = this.getTableColumn(indexedCell);
            boolean bl4 = true;
            if (this.fixedCellSizeEnabled) {
                bl4 = this.isColumnPartiallyOrFullyVisible((TableColumnBase)object);
                d3 = 0.0;
                d6 = this.fixedCellSize;
            } else {
                d6 = d5;
            }
            if (bl4) {
                if (this.fixedCellSizeEnabled && indexedCell.getParent() == null) {
                    this.getChildren().add(indexedCell);
                }
                d11 = ((Node)indexedCell).prefWidth(d6);
                boolean bl5 = d6 <= 24.0;
                object = ((StyleableObjectProperty)indexedCell.alignmentProperty()).getStyleOrigin();
                if (!bl5 && object == null) {
                    indexedCell.setAlignment(Pos.TOP_LEFT);
                }
                if (bl2 && i3 == n3) {
                    ObjectProperty<Node> objectProperty;
                    Node node2;
                    if (bl3) {
                        double d12 = node.prefHeight(d8);
                        if (d11 > 0.0 && d11 < d8 + d7) {
                            this.fadeOut(node);
                        } else {
                            this.fadeIn(node);
                            node.resize(d8, d12);
                            node.relocate(d2 + d7, bl5 ? d3 + (d5 / 2.0 - d12 / 2.0) : d3 + indexedCell.getPadding().getTop());
                            node.toFront();
                        }
                    }
                    if ((node2 = (objectProperty = this.graphicProperty()) == null ? null : (Node)objectProperty.get()) != null) {
                        double d13 = node2.prefWidth(-1.0) + 3.0;
                        double d14 = node2.prefHeight(d13);
                        if (d11 > 0.0 && d11 < d8 + d7 + d13) {
                            this.fadeOut(node2);
                        } else {
                            this.fadeIn(node2);
                            node2.relocate(d2 + d7 + d8, bl5 ? d5 / 2.0 - d14 / 2.0 : d3 + indexedCell.getPadding().getTop());
                            node2.toFront();
                        }
                    }
                }
                ((Node)indexedCell).resize(d11, d6);
                indexedCell.relocate(d2, d3);
                indexedCell.requestLayout();
            } else {
                d11 = ((Node)indexedCell).prefWidth(d6);
                if (this.fixedCellSizeEnabled) {
                    this.getChildren().remove(indexedCell);
                }
            }
            d2 += d11;
        }
    }

    int getIndentationLevel(C c2) {
        return 0;
    }

    double getIndentationPerLevel() {
        return 0.0;
    }

    boolean isIndentationRequired() {
        return false;
    }

    TableColumnBase getTreeColumn() {
        return null;
    }

    Node getDisclosureNode() {
        return null;
    }

    boolean isDisclosureNodeVisible() {
        return false;
    }

    boolean isShowRoot() {
        return true;
    }

    void updateCells(boolean bl2) {
        EventTarget eventTarget;
        if (bl2) {
            if (this.fullRefreshCounter == 0) {
                this.recreateCells();
            }
            --this.fullRefreshCounter;
        }
        boolean bl3 = this.cells.isEmpty();
        this.cells.clear();
        IndexedCell indexedCell = (IndexedCell)this.getSkinnable();
        int n2 = indexedCell.getIndex();
        ObservableList<TableColumnBase> observableList = this.getVisibleLeafColumns();
        int n3 = observableList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            TableColumnBase eventTarget2 = (TableColumnBase)observableList.get(i2);
            eventTarget = null;
            if (this.cellsMap.containsKey(eventTarget2) && (eventTarget = (IndexedCell)this.cellsMap.get(eventTarget2).get()) == null) {
                this.cellsMap.remove(eventTarget2);
            }
            if (eventTarget == null) {
                eventTarget = (EventTarget)this.createCellAndCache(eventTarget2);
            }
            this.updateCell(eventTarget, indexedCell);
            eventTarget.updateIndex(n2);
            this.cells.add(eventTarget);
        }
        if (this.fixedCellSizeEnabled) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node : this.getChildren()) {
                if (!(node instanceof IndexedCell)) continue;
                eventTarget = this.getTableColumn((IndexedCell)node);
                if (this.getVisibleLeafColumns().contains(eventTarget)) continue;
                arrayList.add(node);
            }
            this.getChildren().removeAll((Collection<?>)arrayList);
        }
        if (bl2 || bl3) {
            this.getChildren().setAll((Collection<Node>)this.cells);
        }
    }

    VirtualFlow<C> getVirtualFlow() {
        for (Object object = this.getSkinnable(); object != null; object = ((Node)object).getParent()) {
            if (!(object instanceof VirtualFlow)) continue;
            return (VirtualFlow)object;
        }
        return null;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = d6 + d4;
        for (IndexedCell indexedCell : this.cells) {
            d7 += ((Node)indexedCell).prefWidth(d2);
        }
        return d7;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        this.checkState();
        double d7 = this.getCellSize() + d3 + d5;
        if (this.getCellSize() < 24.0) {
            return d7;
        }
        double d8 = 0.0;
        int n2 = this.cells.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            d8 = Math.max(d8, ((Node)indexedCell).prefHeight(-1.0));
        }
        double d9 = Math.max(d7, ((Node)((IndexedCell)this.getSkinnable())).minHeight(-1.0));
        double d10 = Math.max(d8 += d3 + d5, d9);
        return d10;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        this.checkState();
        if (this.getCellSize() < 24.0) {
            return this.getCellSize() + d3 + d5;
        }
        double d7 = 0.0;
        int n2 = this.cells.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            d7 = Math.max(d7, ((Node)indexedCell).minHeight(-1.0));
        }
        return d7 += d3 + d5;
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        return super.computeMaxHeight(d2, d3, d4, d5, d6);
    }

    final void checkState() {
        if (this.isDirty) {
            this.updateCells(true);
            this.isDirty = false;
            this.updateCells = false;
            return;
        }
        if (this.updateCells) {
            this.updateCells(false);
            this.updateCells = false;
        }
    }

    boolean isDirty() {
        return this.isDirty;
    }

    void setDirty(boolean bl2) {
        this.isDirty = bl2;
    }

    private boolean isColumnPartiallyOrFullyVisible(TableColumnBase tableColumnBase) {
        Object object;
        if (tableColumnBase == null || !tableColumnBase.isVisible()) {
            return false;
        }
        VirtualFlow<C> virtualFlow = this.getVirtualFlow();
        double d2 = virtualFlow == null ? 0.0 : virtualFlow.getHbar().getValue();
        double d3 = 0.0;
        virtualFlow = this.getVisibleLeafColumns();
        int n2 = virtualFlow.size();
        for (int i2 = 0; i2 < n2 && !(object = (TableColumnBase)virtualFlow.get(i2)).equals(tableColumnBase); ++i2) {
            d3 += ((TableColumnBase)object).getWidth();
        }
        double d4 = d3 + tableColumnBase.getWidth();
        object = ((IndexedCell)this.getSkinnable()).getPadding();
        double d5 = ((IndexedCell)this.getSkinnable()).getWidth() - ((Insets)object).getLeft() + ((Insets)object).getRight();
        return (d3 >= d2 || d4 > d2) && (d3 < d5 + d2 || d4 <= d5 + d2);
    }

    private void requestCellUpdate() {
        this.updateCells = true;
        ((IndexedCell)this.getSkinnable()).requestLayout();
        int n2 = ((IndexedCell)this.getSkinnable()).getIndex();
        int n3 = this.cells.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            ((IndexedCell)this.cells.get(i2)).updateIndex(n2);
        }
    }

    private void recreateCells() {
        Object object;
        Iterator iterator;
        if (this.cellsMap != null) {
            iterator = this.cellsMap.values();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = (Reference)iterator.next();
                if ((object = (IndexedCell)((Reference)object).get()) == null) continue;
                ((IndexedCell)object).updateIndex(-1);
                ((Control)object).getSkin().dispose();
                ((Control)object).setSkin(null);
            }
            this.cellsMap.clear();
        }
        iterator = this.getVisibleLeafColumns();
        this.cellsMap = new WeakHashMap(iterator.size());
        this.fullRefreshCounter = 100;
        this.getChildren().clear();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = (TableColumnBase)iterator.next();
            if (this.cellsMap.containsKey(object)) continue;
            this.createCellAndCache((TableColumnBase<T, ?>)object);
        }
    }

    private R createCellAndCache(TableColumnBase<T, ?> tableColumnBase) {
        R r2 = this.createCell(tableColumnBase);
        this.cellsMap.put(tableColumnBase, new WeakReference<R>(r2));
        return r2;
    }

    private void fadeOut(Node object) {
        if (((Node)object).getOpacity() < 1.0) {
            return;
        }
        if (!DO_ANIMATIONS) {
            ((Node)object).setOpacity(0.0);
            return;
        }
        object = new FadeTransition(FADE_DURATION, (Node)object);
        ((FadeTransition)object).setToValue(0.0);
        ((Animation)object).play();
    }

    private void fadeIn(Node object) {
        if (((Node)object).getOpacity() > 0.0) {
            return;
        }
        if (!DO_ANIMATIONS) {
            ((Node)object).setOpacity(1.0);
            return;
        }
        object = new FadeTransition(FADE_DURATION, (Node)object);
        ((FadeTransition)object).setToValue(1.0);
        ((Animation)object).play();
    }
}

