/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TableViewBehavior;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.scene.control.TableView$TableViewSelectionModel;
import javafx.scene.control.skin.TableViewSkin$1;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.input.MouseEvent;

public class TableViewSkin<T>
extends TableViewSkinBase<T, T, TableView<T>, TableRow<T>, TableColumn<T, ?>> {
    private final TableViewBehavior<T> behavior;

    public TableViewSkin(TableView<T> tableView) {
        super(tableView);
        this.behavior = new TableViewBehavior<T>(tableView);
        this.flow.setFixedCellSize(tableView.getFixedCellSize());
        this.flow.setCellFactory(virtualFlow -> this.createCell());
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        EventHandler<MouseEvent> eventHandler = mouseEvent -> {
            if (tableView.isFocusTraversable()) {
                tableView.requestFocus();
            }
        };
        listenerHelper.addEventFilter(this.flow.getVbar(), MouseEvent.MOUSE_PRESSED, eventHandler);
        listenerHelper.addEventFilter(this.flow.getHbar(), MouseEvent.MOUSE_PRESSED, eventHandler);
        this.behavior.setOnFocusPreviousRow(() -> this.onFocusAboveCell());
        this.behavior.setOnFocusNextRow(() -> this.onFocusBelowCell());
        this.behavior.setOnMoveToFirstCell(() -> this.onMoveToFirstCell());
        this.behavior.setOnMoveToLastCell(() -> this.onMoveToLastCell());
        this.behavior.setOnScrollPageDown(bl2 -> this.onScrollPageDown((boolean)bl2));
        this.behavior.setOnScrollPageUp(bl2 -> this.onScrollPageUp((boolean)bl2));
        this.behavior.setOnSelectPreviousRow(() -> this.onSelectAboveCell());
        this.behavior.setOnSelectNextRow(() -> this.onSelectBelowCell());
        this.behavior.setOnSelectLeftCell(() -> this.onSelectLeftCell());
        this.behavior.setOnSelectRightCell(() -> this.onSelectRightCell());
        this.behavior.setOnFocusLeftCell(() -> this.onFocusLeftCell());
        this.behavior.setOnFocusRightCell(() -> this.onFocusRightCell());
        listenerHelper.addChangeListener(tableView.fixedCellSizeProperty(), number -> this.flow.setFixedCellSize(((TableView)this.getSkinnable()).getFixedCellSize()));
        this.updateItemCount();
    }

    @Override
    public void dispose() {
        if (this.behavior != null) {
            ((BehaviorBase)this.behavior).dispose();
        }
        super.dispose();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... object2) {
        switch (TableViewSkin$1.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                object = new ArrayList();
                object2 = ((TableView)this.getSkinnable()).getSelectionModel();
                if (object2 != null) {
                    for (TablePosition tablePosition : ((TableView$TableViewSelectionModel)object2).getSelectedCells()) {
                        TableRow object3 = (TableRow)this.flow.getPrivateCell(tablePosition.getRow());
                        if (object3 == null) continue;
                        object.add(object3);
                    }
                }
                return FXCollections.observableArrayList(object);
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), (Object[])object2);
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction object, Object ... object2) {
        switch (TableViewSkin$1.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                object = (Node)object2[0];
                if (!(object instanceof TableCell)) break;
                object2 = (TableCell)object;
                this.flow.scrollTo(((IndexedCell)object2).getIndex());
                return;
            }
            case 2: {
                object = (ObservableList)object2[0];
                if (object == null) break;
                object2 = ((TableView)this.getSkinnable()).getSelectionModel();
                if (object2 != null) {
                    ((SelectionModel)object2).clearSelection();
                    object = object.iterator();
                    while (object.hasNext()) {
                        Node node = (Node)object.next();
                        if (!(node instanceof TableCell)) continue;
                        node = (TableCell)node;
                        ((TableSelectionModel)object2).select(((IndexedCell)node).getIndex(), ((TableCell)node).getTableColumn());
                    }
                }
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), (Object[])object2);
            }
        }
    }

    private TableRow<T> createCell() {
        TableView tableView = (TableView)this.getSkinnable();
        TableRow<Object> tableRow = tableView.getRowFactory() != null ? tableView.getRowFactory().call(tableView) : new TableRow();
        tableRow.updateTableView(tableView);
        return tableRow;
    }

    @Override
    protected int getItemCount() {
        TableView tableView = (TableView)this.getSkinnable();
        if (tableView.getItems() == null) {
            return 0;
        }
        return tableView.getItems().size();
    }

    @Override
    void horizontalScroll() {
        super.horizontalScroll();
        if (((TableView)this.getSkinnable()).getFixedCellSize() > 0.0) {
            this.flow.requestCellLayout();
        }
    }
}

