/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TextAreaBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Collection;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.geometry.VerticalDirection;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.skin.TextAreaSkin$1;
import javafx.scene.control.skin.TextAreaSkin$2;
import javafx.scene.control.skin.TextAreaSkin$3;
import javafx.scene.control.skin.TextAreaSkin$ContentView;
import javafx.scene.control.skin.TextInputControlSkin;
import javafx.scene.control.skin.TextInputControlSkin$Direction;
import javafx.scene.control.skin.TextInputControlSkin$TextUnit;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;
import javafx.scene.text.HitInfo;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class TextAreaSkin
extends TextInputControlSkin<TextArea> {
    private static final Path tmpCaretPath = new Path();
    private final TextArea textArea;
    private static final boolean USE_MULTIPLE_NODES = false;
    private final TextAreaBehavior behavior;
    private double computedMinWidth = Double.NEGATIVE_INFINITY;
    private double computedMinHeight = Double.NEGATIVE_INFINITY;
    private double computedPrefWidth = Double.NEGATIVE_INFINITY;
    private double computedPrefHeight = Double.NEGATIVE_INFINITY;
    private double widthForComputedPrefHeight = Double.NEGATIVE_INFINITY;
    private double characterWidth;
    private double lineHeight;
    private TextAreaSkin$ContentView contentView = new TextAreaSkin$ContentView(this);
    private Group paragraphNodes = new Group();
    private Text promptNode;
    private ObservableBooleanValue usePromptText;
    private ObservableIntegerValue caretPosition;
    private Group selectionHighlightGroup = new Group();
    private ScrollPane scrollPane;
    private Bounds oldViewportBounds;
    private VerticalDirection scrollDirection = null;
    private Path characterBoundingPath = new Path();
    private Timeline scrollSelectionTimeline = new Timeline();
    private EventHandler<ActionEvent> scrollSelectionHandler = actionEvent -> {
        switch (this.scrollDirection) {
            // Empty switch
        }
    };
    private double pressX;
    private double pressY;
    private boolean handlePressed;
    private EventHandler<ScrollEvent> scrollEventFilter;
    double targetCaretX = -1.0;

    public TextAreaSkin(TextArea object2) {
        super(object2);
        this.behavior = new TextAreaBehavior((TextArea)object2);
        this.behavior.setTextAreaSkin(this);
        this.textArea = object2;
        this.caretPosition = new TextAreaSkin$1(this, (TextArea)object2);
        this.caretPosition.addListener((arg_0, arg_1, arg_2) -> this.lambda$new$1((TextArea)object2, arg_0, arg_1, arg_2));
        this.forwardBiasProperty().addListener(arg_0 -> this.lambda$new$2((TextArea)object2, arg_0));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setFitToWidth(((TextArea)object2).isWrapText());
        this.scrollPane.setContent(this.contentView);
        this.getChildren().add(this.scrollPane);
        this.scrollEventFilter = scrollEvent -> {
            if (scrollEvent.isDirect() && this.handlePressed) {
                scrollEvent.consume();
            }
        };
        ((TextArea)this.getSkinnable()).addEventFilter(ScrollEvent.ANY, this.scrollEventFilter);
        this.selectionHighlightGroup.setManaged(false);
        this.selectionHighlightGroup.setVisible(false);
        this.contentView.getChildren().add(this.selectionHighlightGroup);
        this.paragraphNodes.setManaged(false);
        this.contentView.getChildren().add(this.paragraphNodes);
        this.caretPath.setManaged(false);
        this.caretPath.setStrokeWidth(1.0);
        this.caretPath.fillProperty().bind(this.textFillProperty());
        this.caretPath.strokeProperty().bind(this.textFillProperty());
        this.caretPath.opacityProperty().bind(new TextAreaSkin$2(this));
        this.contentView.getChildren().add(this.caretPath);
        if (SHOW_HANDLES) {
            this.contentView.getChildren().addAll((Node[])new Node[]{this.caretHandle, this.selectionHandle1, this.selectionHandle2});
        }
        this.scrollPane.hvalueProperty().addListener((observableValue, number, number2) -> ((TextArea)this.getSkinnable()).setScrollLeft(number2.doubleValue() * this.getScrollLeftMax()));
        this.scrollPane.vvalueProperty().addListener((observableValue, number, number2) -> ((TextArea)this.getSkinnable()).setScrollTop(number2.doubleValue() * this.getScrollTopMax()));
        this.scrollSelectionTimeline.setCycleCount(-1);
        ObservableList<KeyFrame> observableList = this.scrollSelectionTimeline.getKeyFrames();
        observableList.clear();
        observableList.add(new KeyFrame(Duration.millis(350.0), this.scrollSelectionHandler, new KeyValue[0]));
        for (int i2 = 0; i2 <= 0; ++i2) {
            String string = ((TextInputControl)object2).textProperty().getValueSafe();
            this.addParagraphNode(0, string.toString());
        }
        this.registerChangeListener(((TextInputControl)object2).selectionProperty(), arg_0 -> this.lambda$new$6((TextArea)object2, arg_0));
        this.registerChangeListener(((TextArea)object2).wrapTextProperty(), arg_0 -> this.lambda$new$7((TextArea)object2, arg_0));
        this.registerChangeListener(((TextArea)object2).prefColumnCountProperty(), observableValue -> {
            this.invalidateMetrics();
            this.updatePrefViewportWidth();
        });
        this.registerChangeListener(((TextArea)object2).prefRowCountProperty(), observableValue -> {
            this.invalidateMetrics();
            this.updatePrefViewportHeight();
        });
        this.updateFontMetrics();
        this.fontMetrics.addListener(observable -> this.updateFontMetrics());
        this.contentView.paddingProperty().addListener(observable -> {
            this.updatePrefViewportWidth();
            this.updatePrefViewportHeight();
        });
        this.scrollPane.viewportBoundsProperty().addListener(object -> {
            if (this.scrollPane.getViewportBounds() != null) {
                object = this.scrollPane.getViewportBounds();
                if (this.oldViewportBounds == null || this.oldViewportBounds.getWidth() != ((Bounds)((Object)object)).getWidth() || this.oldViewportBounds.getHeight() != ((Bounds)((Object)object)).getHeight()) {
                    this.invalidateMetrics();
                    this.oldViewportBounds = object;
                    this.contentView.requestLayout();
                }
            }
        });
        this.registerChangeListener(((TextArea)object2).scrollTopProperty(), arg_0 -> this.lambda$new$13((TextArea)object2, arg_0));
        this.registerChangeListener(((TextArea)object2).scrollLeftProperty(), arg_0 -> this.lambda$new$14((TextArea)object2, arg_0));
        this.registerInvalidationListener(((TextInputControl)object2).textProperty(), arg_0 -> this.lambda$new$16((TextArea)object2, arg_0));
        this.usePromptText = new TextAreaSkin$3(this, (TextArea)object2);
        if (this.usePromptText.get()) {
            this.createPromptNode();
        }
        TextAreaSkin textAreaSkin = this;
        textAreaSkin.registerInvalidationListener(textAreaSkin.usePromptText, arg_0 -> this.lambda$new$17((TextArea)object2, arg_0));
        this.updateHighlightFill();
        this.updatePrefViewportWidth();
        this.updatePrefViewportHeight();
        if (((Node)object2).isFocused()) {
            this.setCaretAnimating(true);
        }
        if (SHOW_HANDLES) {
            this.selectionHandle1.setRotate(180.0);
            EventHandler<MouseEvent> eventHandler = mouseEvent -> {
                this.pressX = mouseEvent.getX();
                this.pressY = mouseEvent.getY();
                this.handlePressed = true;
                mouseEvent.consume();
            };
            object2 = mouseEvent -> {
                this.handlePressed = false;
            };
            this.caretHandle.setOnMousePressed(eventHandler);
            this.selectionHandle1.setOnMousePressed(eventHandler);
            this.selectionHandle2.setOnMousePressed(eventHandler);
            this.caretHandle.setOnMouseReleased((EventHandler<? super MouseEvent>)object2);
            this.selectionHandle1.setOnMouseReleased((EventHandler<? super MouseEvent>)object2);
            this.selectionHandle2.setOnMouseReleased((EventHandler<? super MouseEvent>)object2);
            this.caretHandle.setOnMouseDragged(mouseEvent -> {
                Object object = this.getTextNode();
                Point2D point2D = ((Node)object).localToScene(0.0, 0.0);
                point2D = new Point2D(mouseEvent.getSceneX() - point2D.getX() - this.pressX + this.caretHandle.getWidth() / 2.0, mouseEvent.getSceneY() - point2D.getY() - this.pressY - 6.0);
                object = ((Text)object).hitTest(this.translateCaretPosition(point2D));
                this.positionCaret((HitInfo)object, false);
                mouseEvent.consume();
            });
            this.selectionHandle1.setOnMouseDragged(mouseEvent -> {
                int n2;
                TextArea textArea = (TextArea)this.getSkinnable();
                Object object = this.getTextNode();
                Point2D point2D = ((Node)object).localToScene(0.0, 0.0);
                point2D = new Point2D(mouseEvent.getSceneX() - point2D.getX() - this.pressX + this.selectionHandle1.getWidth() / 2.0, mouseEvent.getSceneY() - point2D.getY() - this.pressY + this.selectionHandle1.getHeight() + 5.0);
                object = ((Text)object).hitTest(this.translateCaretPosition(point2D));
                if (textArea.getAnchor() < textArea.getCaretPosition()) {
                    TextArea textArea2 = textArea;
                    textArea2.selectRange(textArea2.getCaretPosition(), textArea.getAnchor());
                }
                if ((n2 = ((HitInfo)object).getCharIndex()) > 0 && n2 >= textArea.getAnchor()) {
                    textArea.getAnchor();
                }
                this.positionCaret((HitInfo)object, true);
                mouseEvent.consume();
            });
            this.selectionHandle2.setOnMouseDragged(mouseEvent -> {
                int n2;
                TextArea textArea = (TextArea)this.getSkinnable();
                Object object = this.getTextNode();
                Point2D point2D = ((Node)object).localToScene(0.0, 0.0);
                point2D = new Point2D(mouseEvent.getSceneX() - point2D.getX() - this.pressX + this.selectionHandle2.getWidth() / 2.0, mouseEvent.getSceneY() - point2D.getY() - this.pressY - 6.0);
                object = ((Text)object).hitTest(this.translateCaretPosition(point2D));
                if (textArea.getAnchor() > textArea.getCaretPosition()) {
                    TextArea textArea2 = textArea;
                    textArea2.selectRange(textArea2.getCaretPosition(), textArea.getAnchor());
                }
                if ((n2 = ((HitInfo)object).getCharIndex()) > 0) {
                    if (n2 <= textArea.getAnchor() + 1) {
                        Math.min(textArea.getAnchor() + 2, textArea.getLength());
                    }
                    this.positionCaret((HitInfo)object, true);
                }
                mouseEvent.consume();
            });
        }
    }

    @Override
    protected void invalidateMetrics() {
        this.computedMinWidth = Double.NEGATIVE_INFINITY;
        this.computedMinHeight = Double.NEGATIVE_INFINITY;
        this.computedPrefWidth = Double.NEGATIVE_INFINITY;
        this.computedPrefHeight = Double.NEGATIVE_INFINITY;
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        this.scrollPane.resizeRelocate(d2, d3, d4, d5);
    }

    @Override
    protected void updateHighlightFill() {
        for (Node node : this.selectionHighlightGroup.getChildren()) {
            node = (Path)node;
            ((Shape)node).setFill((Paint)this.highlightFillProperty().get());
        }
    }

    public HitInfo getIndex(double d2, double d3) {
        Text text = this.getTextNode();
        Object object = new Point2D(d2 - text.getLayoutX(), d3 - this.getTextTranslateY());
        object = text.hitTest(this.translateCaretPosition((Point2D)object));
        return object;
    }

    @Override
    public void moveCaret(TextInputControlSkin$TextUnit textInputControlSkin$TextUnit, TextInputControlSkin$Direction textInputControlSkin$Direction, boolean bl2) {
        switch (textInputControlSkin$TextUnit) {
            case CHARACTER: {
                switch (textInputControlSkin$Direction) {
                    case LEFT: 
                    case RIGHT: {
                        this.nextCharacterVisually(textInputControlSkin$Direction == TextInputControlSkin$Direction.RIGHT);
                        return;
                    }
                }
                throw new IllegalArgumentException(String.valueOf((Object)textInputControlSkin$Direction));
            }
            case LINE: {
                switch (textInputControlSkin$Direction) {
                    case UP: {
                        this.previousLine(bl2);
                        return;
                    }
                    case DOWN: {
                        this.nextLine(bl2);
                        return;
                    }
                    case BEGINNING: {
                        boolean bl3 = bl2;
                        this.lineStart(bl3, bl3 && PlatformUtil.isMac());
                        return;
                    }
                    case END: {
                        boolean bl4 = bl2;
                        this.lineEnd(bl4, bl4 && PlatformUtil.isMac());
                        return;
                    }
                }
                throw new IllegalArgumentException(String.valueOf((Object)textInputControlSkin$Direction));
            }
            case PAGE: {
                switch (textInputControlSkin$Direction) {
                    case UP: {
                        this.previousPage(bl2);
                        return;
                    }
                    case DOWN: {
                        this.nextPage(bl2);
                        return;
                    }
                }
                throw new IllegalArgumentException(String.valueOf((Object)textInputControlSkin$Direction));
            }
            case PARAGRAPH: {
                switch (textInputControlSkin$Direction) {
                    case UP: {
                        this.paragraphStart(true, bl2);
                        return;
                    }
                    case DOWN: {
                        this.paragraphEnd(true, bl2);
                        return;
                    }
                    case BEGINNING: {
                        this.paragraphStart(false, bl2);
                        return;
                    }
                    case END: {
                        this.paragraphEnd(false, bl2);
                        return;
                    }
                }
                throw new IllegalArgumentException(String.valueOf((Object)textInputControlSkin$Direction));
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)textInputControlSkin$TextUnit));
    }

    private void nextCharacterVisually(boolean bl2) {
        if (this.isRTL()) {
            bl2 = !bl2;
        }
        Shape shape = this.getTextNode();
        Bounds bounds = this.caretPath.getLayoutBounds();
        if (this.caretPath.getElements().size() == 4) {
            bounds = new Path((PathElement)this.caretPath.getElements().get(0), (PathElement)this.caretPath.getElements().get(1)).getLayoutBounds();
        }
        double d2 = bl2 ? bounds.getMaxX() : bounds.getMinX();
        double d3 = (bounds.getMinY() + bounds.getMaxY()) / 2.0;
        HitInfo hitInfo = ((Text)shape).hitTest(new Point2D(d2, d3));
        boolean bl3 = hitInfo.isLeading();
        shape = new Path(((Text)shape).rangeShape(hitInfo.getCharIndex(), hitInfo.getCharIndex() + 1));
        if (bl2 && shape.getLayoutBounds().getMaxX() > bounds.getMaxX() || !bl2 && shape.getLayoutBounds().getMinX() < bounds.getMinX()) {
            bl3 = !bl3;
            this.positionCaret(hitInfo.getInsertionIndex(), bl3, false, false);
            return;
        }
        int n2 = this.textArea.getCaretPosition();
        this.targetCaretX = bl2 ? 0.0 : Double.MAX_VALUE;
        this.downLines(bl2 ? 1 : -1, false, false);
        this.targetCaretX = -1.0;
        if (n2 == this.textArea.getCaretPosition()) {
            if (bl2) {
                this.textArea.forward();
                return;
            }
            this.textArea.backward();
        }
    }

    private void downLines(int n2, boolean bl2, boolean bl3) {
        double d2;
        Text text = this.getTextNode();
        Bounds bounds = this.caretPath.getLayoutBounds();
        double d3 = (bounds.getMinY() + bounds.getMaxY()) / 2.0 + (double)n2 * this.lineHeight;
        if (d2 < 0.0) {
            d3 = 0.0;
        }
        double d4 = this.targetCaretX >= 0.0 ? this.targetCaretX : bounds.getMaxX();
        HitInfo hitInfo = text.hitTest(this.translateCaretPosition(new Point2D(d4, d3)));
        int n3 = hitInfo.getCharIndex();
        int n4 = text.getCaretPosition();
        boolean bl4 = text.isCaretBias();
        text.setCaretBias(hitInfo.isLeading());
        text.setCaretPosition(n3);
        tmpCaretPath.getElements().clear();
        tmpCaretPath.getElements().addAll((PathElement[])text.getCaretShape());
        tmpCaretPath.setLayoutX(text.getLayoutX());
        tmpCaretPath.setLayoutY(text.getLayoutY());
        Bounds bounds2 = tmpCaretPath.getLayoutBounds();
        double d5 = (bounds2.getMinY() + bounds2.getMaxY()) / 2.0;
        text.setCaretBias(bl4);
        text.setCaretPosition(n4);
        if (n2 == 0 || n2 > 0 && d5 > bounds.getMaxY() || n2 < 0 && d5 < bounds.getMinY()) {
            this.positionCaret(hitInfo.getInsertionIndex(), hitInfo.isLeading(), bl2, bl3);
            this.targetCaretX = d4;
        }
    }

    private void previousLine(boolean bl2) {
        this.downLines(-1, bl2, false);
    }

    private void nextLine(boolean bl2) {
        this.downLines(1, bl2, false);
    }

    private void previousPage(boolean bl2) {
        TextAreaSkin textAreaSkin = this;
        textAreaSkin.downLines(-((int)(textAreaSkin.scrollPane.getViewportBounds().getHeight() / this.lineHeight)), bl2, false);
    }

    private void nextPage(boolean bl2) {
        TextAreaSkin textAreaSkin = this;
        textAreaSkin.downLines((int)(textAreaSkin.scrollPane.getViewportBounds().getHeight() / this.lineHeight), bl2, false);
    }

    private void lineStart(boolean bl2, boolean bl3) {
        this.targetCaretX = 0.0;
        this.downLines(0, bl2, bl3);
        this.targetCaretX = -1.0;
    }

    private void lineEnd(boolean bl2, boolean bl3) {
        this.targetCaretX = Double.MAX_VALUE;
        this.downLines(0, bl2, bl3);
        this.targetCaretX = -1.0;
    }

    private void paragraphStart(boolean bl2, boolean bl3) {
        TextArea textArea = (TextArea)this.getSkinnable();
        String string = textArea.textProperty().getValueSafe();
        int n2 = textArea.getCaretPosition();
        if (n2 > 0) {
            if (bl2 && string.codePointAt(n2 - 1) == 10) {
                --n2;
            }
            while (n2 > 0 && string.codePointAt(n2 - 1) != 10) {
                --n2;
            }
            if (bl3) {
                textArea.selectPositionCaret(n2);
                return;
            }
            textArea.positionCaret(n2);
            this.setForwardBias(true);
        }
    }

    private void paragraphEnd(boolean bl2, boolean bl3) {
        TextArea textArea = (TextArea)this.getSkinnable();
        String string = textArea.textProperty().getValueSafe();
        int n2 = textArea.getCaretPosition();
        int n3 = string.length();
        boolean bl4 = false;
        boolean bl5 = PlatformUtil.isWindows();
        if (n2 < n3) {
            if (bl2 && string.codePointAt(n2) == 10) {
                ++n2;
                bl4 = true;
            }
            if (!bl5 || !bl4) {
                while (n2 < n3 && string.codePointAt(n2) != 10) {
                    ++n2;
                }
                if (bl5 && n2 < n3) {
                    ++n2;
                }
            }
            if (bl3) {
                textArea.selectPositionCaret(n2);
                return;
            }
            textArea.positionCaret(n2);
        }
    }

    @Override
    protected PathElement[] getUnderlineShape(int n2, int n3) {
        int n4 = 0;
        for (Node node : this.paragraphNodes.getChildren()) {
            int n5 = n4 + ((Text)(node = (Text)node)).textProperty().getValueSafe().length();
            if (n5 >= n2) {
                return ((Text)node).underlineShape(n2 - n4, n3 - n4);
            }
            n4 = n5 + 1;
        }
        return null;
    }

    @Override
    protected PathElement[] getRangeShape(int n2, int n3) {
        int n4 = 0;
        for (Node node : this.paragraphNodes.getChildren()) {
            int n5 = n4 + ((Text)(node = (Text)node)).textProperty().getValueSafe().length();
            if (n5 >= n2) {
                return ((Text)node).rangeShape(n2 - n4, n3 - n4);
            }
            n4 = n5 + 1;
        }
        return null;
    }

    @Override
    protected void addHighlight(List<? extends Node> list, int n2) {
        int n3 = 0;
        Node node = null;
        for (Node node2 : this.paragraphNodes.getChildren()) {
            Text node22 = (Text)node2;
            if ((n3 += node22.textProperty().getValueSafe().length()) >= n2) {
                node = node22;
                break;
            }
            ++n3;
        }
        if (node != null) {
            for (Node node3 : list) {
                node3.setLayoutX(node.getLayoutX());
                node3.setLayoutY(node.getLayoutY());
            }
        }
        this.contentView.getChildren().addAll((Collection<Node>)list);
    }

    @Override
    protected void removeHighlight(List<? extends Node> list) {
        this.contentView.getChildren().removeAll((Collection<?>)list);
    }

    @Override
    public Point2D getMenuPosition() {
        this.contentView.layoutChildren();
        Point2D point2D = super.getMenuPosition();
        if (point2D != null) {
            point2D = new Point2D(Math.max(0.0, point2D.getX() - this.contentView.snappedLeftInset() - ((TextArea)this.getSkinnable()).getScrollLeft()), Math.max(0.0, point2D.getY() - this.contentView.snappedTopInset() - ((TextArea)this.getSkinnable()).getScrollTop()));
        }
        return point2D;
    }

    public Bounds getCaretBounds() {
        return ((TextArea)this.getSkinnable()).sceneToLocal(this.caretPath.localToScene(this.caretPath.getBoundsInLocal()));
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case LINE_FOR_OFFSET: 
            case LINE_START: 
            case LINE_END: 
            case BOUNDS_FOR_RANGE: 
            case OFFSET_AT_POINT: {
                Text text = this.getTextNode();
                return ((Node)text).queryAccessibleAttribute(accessibleAttribute, objectArray);
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        ((TextArea)this.getSkinnable()).removeEventFilter(ScrollEvent.ANY, this.scrollEventFilter);
        this.getChildren().remove(this.scrollPane);
        super.dispose();
        if (this.behavior != null) {
            ((BehaviorBase)this.behavior).dispose();
        }
    }

    @Override
    public double computeBaselineOffset(double d2, double d3, double d4, double d5) {
        Text text = (Text)this.paragraphNodes.getChildren().get(0);
        return Utils.getAscent(((TextArea)this.getSkinnable()).getFont(), text.getBoundsType()) + this.contentView.snappedTopInset() + this.textArea.snappedTopInset();
    }

    private char getCharacter(int n2) {
        int n3 = this.paragraphNodes.getChildren().size();
        Object object = null;
        for (int i2 = 0; i2 < n3; ++i2) {
            object = (Text)this.paragraphNodes.getChildren().get(i2);
            int n4 = ((String)(object = ((Text)object).getText())).length() + 1;
            if (n2 < n4) break;
            n2 -= n4;
        }
        if (n2 == ((String)object).length()) {
            return '\n';
        }
        return ((String)object).charAt(n2);
    }

    @Override
    protected int getInsertionPoint(double d2, double d3) {
        Node node = (TextArea)this.getSkinnable();
        int n2 = this.paragraphNodes.getChildren().size();
        int n3 = -1;
        if (n2 > 0) {
            if (d3 < this.contentView.snappedTopInset()) {
                Text text = (Text)this.paragraphNodes.getChildren().get(0);
                n3 = this.getNextInsertionPoint(text, d2, -1, VerticalDirection.DOWN);
            } else if (d3 > this.contentView.snappedTopInset() + this.contentView.getHeight()) {
                int n4 = n2 - 1;
                Text text = (Text)this.paragraphNodes.getChildren().get(n4);
                n3 = this.getNextInsertionPoint(text, d2, -1, VerticalDirection.UP) + (((TextInputControl)node).getLength() - text.getText().length());
            } else {
                int n5 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    node = (Text)this.paragraphNodes.getChildren().get(i2);
                    Bounds bounds = node.getBoundsInLocal();
                    double d4 = node.getLayoutY() + bounds.getMinY();
                    if (d3 >= d4 && d3 < d4 + node.getBoundsInLocal().getHeight()) {
                        n3 = this.getInsertionPoint((Text)node, d2 - node.getLayoutX(), d3 - node.getLayoutY()) + n5;
                        break;
                    }
                    n5 += ((Text)node).getText().length() + 1;
                }
            }
        }
        return n3;
    }

    public void positionCaret(HitInfo hitInfo, boolean bl2) {
        this.positionCaret(hitInfo.getInsertionIndex(), hitInfo.isLeading(), bl2, false);
    }

    private void positionCaret(int n2, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5;
        boolean bl6 = bl5 = n2 > 0 && n2 <= ((TextArea)this.getSkinnable()).getLength() && ((TextArea)this.getSkinnable()).getText().codePointAt(n2 - 1) == 10;
        if (!bl2 && bl5) {
            bl2 = true;
            --n2;
        }
        if (bl3) {
            if (bl4) {
                ((TextArea)this.getSkinnable()).extendSelection(n2);
            } else {
                ((TextArea)this.getSkinnable()).selectPositionCaret(n2);
            }
        } else {
            ((TextArea)this.getSkinnable()).positionCaret(n2);
        }
        this.setForwardBias(bl2);
    }

    @Override
    public Rectangle2D getCharacterBounds(int n2) {
        double d2;
        Text text;
        TextArea textArea = (TextArea)this.getSkinnable();
        int n3 = this.paragraphNodes.getChildren().size();
        int n4 = textArea.getLength() + 1;
        while (n2 < (n4 -= (text = (Text)this.paragraphNodes.getChildren().get(--n3)).getText().length() + 1)) {
        }
        n3 = 0;
        if ((n2 -= n4) == text.getText().length()) {
            n3 = 1;
        }
        this.characterBoundingPath.getElements().clear();
        int n5 = --n2;
        this.characterBoundingPath.getElements().addAll((PathElement[])text.rangeShape(n5, n5 + 1));
        this.characterBoundingPath.setLayoutX(text.getLayoutX());
        this.characterBoundingPath.setLayoutY(text.getLayoutY());
        Bounds bounds = this.characterBoundingPath.getBoundsInLocal();
        double d3 = bounds.getMinX() + text.getLayoutX() - textArea.getScrollLeft();
        double d4 = bounds.getMinY() + text.getLayoutY() - textArea.getScrollTop();
        double d5 = bounds.isEmpty() ? 0.0 : bounds.getWidth();
        double d6 = d2 = bounds.isEmpty() ? 0.0 : bounds.getHeight();
        if (n3 != 0) {
            d3 += d5;
            d5 = 0.0;
        }
        return new Rectangle2D(d3, d4, d5, d2);
    }

    @Override
    protected void scrollCharacterToVisible(int n2) {
        Platform.runLater(() -> {
            if (((TextArea)this.getSkinnable()).getLength() == 0) {
                return;
            }
            Rectangle2D rectangle2D = ((TextInputControlSkin)this).getCharacterBounds(n2);
            this.scrollBoundsToVisible(rectangle2D);
        });
    }

    @Override
    TextAreaBehavior getBehavior() {
        return this.behavior;
    }

    private void createPromptNode() {
        if (this.promptNode == null && this.usePromptText.get()) {
            this.promptNode = new Text();
            this.contentView.getChildren().add(0, this.promptNode);
            this.promptNode.setManaged(false);
            this.promptNode.getStyleClass().add("text");
            this.promptNode.visibleProperty().bind(this.usePromptText);
            this.promptNode.fontProperty().bind(((TextArea)this.getSkinnable()).fontProperty());
            this.promptNode.textProperty().bind(((TextArea)this.getSkinnable()).promptTextProperty());
            this.promptNode.fillProperty().bind(this.promptTextFillProperty());
        }
    }

    private void addParagraphNode(int n2, String object) {
        TextArea textArea = (TextArea)this.getSkinnable();
        object = new Text((String)object);
        ((Text)object).setTextOrigin(VPos.TOP);
        ((Node)object).setManaged(false);
        ((Node)object).getStyleClass().add("text");
        ((Text)object).boundsTypeProperty().addListener((observableValue, textBoundsType, textBoundsType2) -> {
            this.invalidateMetrics();
            this.updateFontMetrics();
        });
        this.paragraphNodes.getChildren().add(n2, (Node)object);
        ((Text)object).fontProperty().bind(textArea.fontProperty());
        ((Shape)object).fillProperty().bind(this.textFillProperty());
        ((Text)object).selectionFillProperty().bind(this.highlightTextFillProperty());
    }

    private double getScrollTopMax() {
        return Math.max(0.0, this.contentView.getHeight() - this.scrollPane.getViewportBounds().getHeight());
    }

    private double getScrollLeftMax() {
        return Math.max(0.0, this.contentView.getWidth() - this.scrollPane.getViewportBounds().getWidth());
    }

    private int getInsertionPoint(Text object, double d2, double d3) {
        object = ((Text)object).hitTest(new Point2D(d2, d3));
        return ((HitInfo)object).getInsertionIndex();
    }

    private int getNextInsertionPoint(Text text, double d2, int n2, VerticalDirection verticalDirection) {
        return 0;
    }

    private void scrollCaretToVisible() {
        TextArea textArea = (TextArea)this.getSkinnable();
        Bounds bounds = this.caretPath.getLayoutBounds();
        double d2 = bounds.getMinX() - textArea.getScrollLeft();
        double d3 = bounds.getMinY() - textArea.getScrollTop();
        double d4 = bounds.getWidth();
        double d5 = bounds.getHeight();
        if (SHOW_HANDLES) {
            if (this.caretHandle.isVisible()) {
                d5 += this.caretHandle.getHeight();
            } else if (this.selectionHandle1.isVisible() && this.selectionHandle2.isVisible()) {
                d2 -= this.selectionHandle1.getWidth() / 2.0;
                d3 -= this.selectionHandle1.getHeight();
                d4 += this.selectionHandle1.getWidth() / 2.0 + this.selectionHandle2.getWidth() / 2.0;
                d5 += this.selectionHandle1.getHeight() + this.selectionHandle2.getHeight();
            }
        }
        if (d4 > 0.0 && d5 > 0.0) {
            this.scrollBoundsToVisible(new Rectangle2D(d2, d3, d4, d5));
        }
    }

    private void scrollBoundsToVisible(Rectangle2D rectangle2D) {
        double d2;
        TextArea textArea = (TextArea)this.getSkinnable();
        Bounds bounds = this.scrollPane.getViewportBounds();
        double d3 = bounds.getWidth();
        double d4 = bounds.getHeight();
        double d5 = textArea.getScrollTop();
        double d6 = textArea.getScrollLeft();
        if (rectangle2D.getMinY() < 0.0) {
            double d7;
            d2 = d5 + rectangle2D.getMinY();
            if (d7 <= this.contentView.snappedTopInset()) {
                d2 = 0.0;
            }
            textArea.setScrollTop(d2);
        } else if (this.contentView.snappedTopInset() + rectangle2D.getMaxY() > d4) {
            double d8;
            d2 = d5 + this.contentView.snappedTopInset() + rectangle2D.getMaxY() - d4;
            if (d8 >= this.getScrollTopMax() - this.contentView.snappedBottomInset()) {
                d2 = this.getScrollTopMax();
            }
            textArea.setScrollTop(d2);
        }
        if (rectangle2D.getMinX() < 0.0) {
            double d9;
            d2 = d6 + rectangle2D.getMinX() - 6.0;
            if (d9 <= this.contentView.snappedLeftInset() + 6.0) {
                d2 = 0.0;
            }
            textArea.setScrollLeft(d2);
            return;
        }
        if (this.contentView.snappedLeftInset() + rectangle2D.getMaxX() > d3) {
            double d10;
            d2 = d6 + this.contentView.snappedLeftInset() + rectangle2D.getMaxX() - d3 + 6.0;
            if (d10 >= this.getScrollLeftMax() - this.contentView.snappedRightInset() - 6.0) {
                d2 = this.getScrollLeftMax();
            }
            textArea.setScrollLeft(d2);
        }
    }

    private void updatePrefViewportWidth() {
        int n2 = ((TextArea)this.getSkinnable()).getPrefColumnCount();
        this.scrollPane.setPrefViewportWidth((double)n2 * this.characterWidth + this.contentView.snappedLeftInset() + this.contentView.snappedRightInset());
        this.scrollPane.setMinViewportWidth(this.characterWidth + this.contentView.snappedLeftInset() + this.contentView.snappedRightInset());
    }

    private void updatePrefViewportHeight() {
        int n2 = ((TextArea)this.getSkinnable()).getPrefRowCount();
        this.scrollPane.setPrefViewportHeight((double)n2 * this.lineHeight + this.contentView.snappedTopInset() + this.contentView.snappedBottomInset());
        this.scrollPane.setMinViewportHeight(this.lineHeight + this.contentView.snappedTopInset() + this.contentView.snappedBottomInset());
    }

    private void updateFontMetrics() {
        Text text = (Text)this.paragraphNodes.getChildren().get(0);
        this.lineHeight = Utils.getLineHeight(((TextArea)this.getSkinnable()).getFont(), text.getBoundsType());
        this.characterWidth = this.fontMetrics.get().getCharWidth('W');
    }

    private double getTextTranslateX() {
        return this.contentView.snappedLeftInset();
    }

    private double getTextTranslateY() {
        return this.contentView.snappedTopInset();
    }

    private double getTextLeft() {
        return 0.0;
    }

    private Point2D translateCaretPosition(Point2D point2D) {
        return point2D;
    }

    Text getTextNode() {
        return (Text)this.paragraphNodes.getChildren().get(0);
    }

    private void updateTextNodeCaretPos(int n2) {
        Text text = this.getTextNode();
        if (this.isForwardBias()) {
            text.setCaretPosition(n2);
        } else {
            text.setCaretPosition(n2 - 1);
        }
        text.caretBiasProperty().set(this.isForwardBias());
    }

    void setHandlePressed(boolean bl2) {
        this.handlePressed = bl2;
    }

    ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    Text getPromptNode() {
        return this.promptNode;
    }

    private /* synthetic */ void lambda$new$17(TextArea textArea, Observable observable) {
        this.createPromptNode();
        textArea.requestLayout();
    }

    private /* synthetic */ void lambda$new$16(TextArea textArea, Observable observable) {
        this.invalidateMetrics();
        ((Text)this.paragraphNodes.getChildren().get(0)).setText(textArea.textProperty().getValueSafe());
        this.contentView.requestLayout();
    }

    private /* synthetic */ void lambda$new$15(ListChangeListener$Change listChangeListener$Change) {
        while (listChangeListener$Change.next()) {
            int n2 = listChangeListener$Change.getFrom();
            int n3 = listChangeListener$Change.getTo();
            Object object = listChangeListener$Change.getRemoved();
            if (n2 < n3) {
                if (object.isEmpty()) {
                    while (n2 < n3) {
                        this.addParagraphNode(n2, listChangeListener$Change.getList().get(n2).toString());
                        ++n2;
                    }
                    continue;
                }
                while (n2 < n3) {
                    object = (Node)this.paragraphNodes.getChildren().get(n2);
                    object = (Text)object;
                    ((Text)object).setText(listChangeListener$Change.getList().get(n2).toString());
                    ++n2;
                }
                continue;
            }
            int n4 = n2;
            this.paragraphNodes.getChildren().subList(n4, n4 + object.size()).clear();
        }
    }

    private /* synthetic */ void lambda$new$14(TextArea textArea, ObservableValue observableValue) {
        double d2;
        double d3 = textArea.getScrollLeft();
        double d4 = d2 < this.getScrollLeftMax() ? d3 / this.getScrollLeftMax() : 1.0;
        this.scrollPane.setHvalue(d4);
    }

    private /* synthetic */ void lambda$new$13(TextArea textArea, ObservableValue observableValue) {
        double d2;
        double d3 = textArea.getScrollTop();
        double d4 = d2 < this.getScrollTopMax() ? d3 / this.getScrollTopMax() : 1.0;
        this.scrollPane.setVvalue(d4);
    }

    private /* synthetic */ void lambda$new$7(TextArea textArea, ObservableValue observableValue) {
        this.invalidateMetrics();
        this.scrollPane.setFitToWidth(textArea.isWrapText());
    }

    private /* synthetic */ void lambda$new$6(TextArea textArea, ObservableValue observableValue) {
        textArea.requestLayout();
        this.contentView.requestLayout();
    }

    private /* synthetic */ void lambda$new$2(TextArea textArea, Observable observable) {
        if (textArea.getWidth() > 0.0) {
            this.updateTextNodeCaretPos(textArea.getCaretPosition());
        }
    }

    private /* synthetic */ void lambda$new$1(TextArea textArea, ObservableValue observableValue, Number number, Number number2) {
        this.targetCaretX = -1.0;
        if (textArea.getWidth() > 0.0) {
            this.setForwardBias(true);
        }
    }
}

