/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.PasswordFieldBehavior;
import com.sun.javafx.scene.control.behavior.TextFieldBehavior;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior;
import java.util.Collection;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.skin.TextFieldSkin$1;
import javafx.scene.control.skin.TextFieldSkin$2;
import javafx.scene.control.skin.TextFieldSkin$3;
import javafx.scene.control.skin.TextFieldSkin$4;
import javafx.scene.control.skin.TextFieldSkin$5;
import javafx.scene.control.skin.TextFieldSkin$6;
import javafx.scene.control.skin.TextFieldSkin$7;
import javafx.scene.control.skin.TextInputControlSkin;
import javafx.scene.control.skin.TextInputControlSkin$Direction;
import javafx.scene.control.skin.TextInputControlSkin$TextUnit;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.HitInfo;
import javafx.scene.text.Text;

public class TextFieldSkin
extends TextInputControlSkin<TextField> {
    private final TextFieldBehavior behavior;
    private Pane textGroup = new Pane();
    private Group handleGroup;
    private Rectangle clip = new Rectangle();
    private Text textNode = new Text();
    private Text promptNode;
    private Path selectionHighlightPath = new Path();
    private Path characterBoundingPath = new Path();
    private ObservableBooleanValue usePromptText;
    private DoubleProperty textTranslateX = new SimpleDoubleProperty(this, "textTranslateX");
    private double caretWidth;
    private ObservableDoubleValue textRight;
    private double pressX;
    private double pressY;
    static final char BULLET = '\u25cf';

    public TextFieldSkin(TextField object) {
        super(object);
        this.behavior = object instanceof PasswordField ? new PasswordFieldBehavior((PasswordField)object) : new TextFieldBehavior((TextField)object);
        this.behavior.setTextFieldSkin(this);
        this.registerChangeListener(((TextInputControl)object).caretPositionProperty(), arg_0 -> this.lambda$new$0((TextField)object, arg_0));
        this.forwardBiasProperty().addListener(arg_0 -> this.lambda$new$1((TextField)object, arg_0));
        this.textRight = new TextFieldSkin$1(this);
        this.clip.setSmooth(false);
        this.clip.setX(0.0);
        this.clip.widthProperty().bind(this.textGroup.widthProperty());
        this.clip.heightProperty().bind(this.textGroup.heightProperty());
        this.textGroup.setClip(this.clip);
        this.textGroup.getChildren().addAll((Node[])new Node[]{this.selectionHighlightPath, this.textNode, new Group(this.caretPath)});
        this.getChildren().add(this.textGroup);
        if (SHOW_HANDLES) {
            this.handleGroup = new Group();
            this.handleGroup.setManaged(false);
            this.handleGroup.getChildren().addAll((Node[])new Node[]{this.caretHandle, this.selectionHandle1, this.selectionHandle2});
            this.getChildren().add(this.handleGroup);
        }
        this.textNode.setManaged(false);
        this.textNode.getStyleClass().add("text");
        this.textNode.fontProperty().bind(((TextInputControl)object).fontProperty());
        this.textNode.layoutXProperty().bind(this.textTranslateX);
        this.textNode.textProperty().bind(new TextFieldSkin$2(this, (TextField)object));
        this.textNode.fillProperty().bind(this.textFillProperty());
        this.textNode.selectionFillProperty().bind(new TextFieldSkin$3(this, (TextField)object));
        this.updateTextNodeCaretPos(((TextInputControl)object).getCaretPosition());
        this.registerInvalidationListener(((TextInputControl)object).selectionProperty(), observable -> this.updateSelection());
        this.selectionHighlightPath.setManaged(false);
        this.selectionHighlightPath.setStroke(null);
        this.selectionHighlightPath.layoutXProperty().bind(this.textTranslateX);
        this.selectionHighlightPath.visibleProperty().bind(((TextInputControl)object).anchorProperty().isNotEqualTo(((TextInputControl)object).caretPositionProperty()).and(((Node)object).focusedProperty()));
        this.selectionHighlightPath.fillProperty().bind(this.highlightFillProperty());
        TextFieldSkin textFieldSkin = this;
        textFieldSkin.registerInvalidationListener(textFieldSkin.textNode.selectionShapeProperty(), observable -> this.updateSelection());
        this.caretPath.setManaged(false);
        this.caretPath.setStrokeWidth(1.0);
        this.caretPath.fillProperty().bind(this.textFillProperty());
        this.caretPath.strokeProperty().bind(this.textFillProperty());
        this.caretPath.opacityProperty().bind(new TextFieldSkin$4(this));
        this.caretPath.layoutXProperty().bind(this.textTranslateX);
        this.textNode.caretShapeProperty().addListener(arg_0 -> this.lambda$new$4((TextField)object, arg_0));
        this.registerInvalidationListener(((TextInputControl)object).fontProperty(), arg_0 -> this.lambda$new$5((TextField)object, arg_0));
        this.registerChangeListener(((TextField)object).prefColumnCountProperty(), observableValue -> ((TextField)this.getSkinnable()).requestLayout());
        if (((Node)object).isFocused()) {
            this.setCaretAnimating(true);
        }
        this.registerInvalidationListener(((TextField)object).alignmentProperty(), arg_0 -> this.lambda$new$7((TextField)object, arg_0));
        this.usePromptText = new TextFieldSkin$5(this, (TextField)object);
        this.promptTextFillProperty().addListener(observable -> this.updateTextPos());
        this.registerInvalidationListener(((TextInputControl)object).textProperty(), observable -> {
            if (!this.behavior.isEditing()) {
                this.updateTextPos();
            }
        });
        if (this.usePromptText.get()) {
            this.createPromptNode();
        }
        TextFieldSkin textFieldSkin2 = this;
        textFieldSkin2.registerInvalidationListener(textFieldSkin2.usePromptText, arg_0 -> this.lambda$new$10((TextField)object, arg_0));
        if (SHOW_HANDLES) {
            this.selectionHandle1.setRotate(180.0);
            object = mouseEvent -> {
                this.pressX = mouseEvent.getX();
                this.pressY = mouseEvent.getY();
                mouseEvent.consume();
            };
            this.caretHandle.setOnMousePressed((EventHandler<? super MouseEvent>)object);
            this.selectionHandle1.setOnMousePressed((EventHandler<? super MouseEvent>)object);
            this.selectionHandle2.setOnMousePressed((EventHandler<? super MouseEvent>)object);
            this.caretHandle.setOnMouseDragged(mouseEvent -> {
                Object object = new Point2D(this.caretHandle.getLayoutX() + mouseEvent.getX() + this.pressX - this.textNode.getLayoutX(), this.caretHandle.getLayoutY() + mouseEvent.getY() - this.pressY - 6.0);
                object = this.textNode.hitTest((Point2D)object);
                this.positionCaret((HitInfo)object, false);
                mouseEvent.consume();
            });
            this.selectionHandle1.setOnMouseDragged(new TextFieldSkin$6(this));
            this.selectionHandle2.setOnMouseDragged(new TextFieldSkin$7(this));
        }
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        this.getChildren().removeAll((Node[])new Node[]{this.textGroup, this.handleGroup});
        super.dispose();
        if (this.behavior != null) {
            ((BehaviorBase)this.behavior).dispose();
        }
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        TextField textField = (TextField)this.getSkinnable();
        double d7 = this.fontMetrics.get().getCharWidth('W');
        int n2 = textField.getPrefColumnCount();
        return (double)n2 * d7 + d6 + d4;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.computePrefHeight(d2, d3, d4, d5, d6);
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return d3 + this.textNode.getLayoutBounds().getHeight() + d5;
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((Node)((TextField)this.getSkinnable())).prefHeight(d2);
    }

    @Override
    public double computeBaselineOffset(double d2, double d3, double d4, double d5) {
        return d2 + ((Node)this.textNode).getBaselineOffset();
    }

    public void replaceText(int n2, int n3, String string) {
        double d2 = this.textNode.getBoundsInParent().getMaxX();
        double d3 = this.caretPath.getLayoutBounds().getMaxX() + this.textTranslateX.get();
        ((TextField)this.getSkinnable()).replaceText(n2, n3, string);
        this.scrollAfterDelete(d2, d3);
    }

    public void deleteChar(boolean bl2) {
        double d2 = this.textNode.getBoundsInParent().getMaxX();
        double d3 = this.caretPath.getLayoutBounds().getMaxX() + this.textTranslateX.get();
        if (bl2 ? ((TextField)this.getSkinnable()).deletePreviousChar() : ((TextField)this.getSkinnable()).deleteNextChar()) {
            this.scrollAfterDelete(d2, d3);
        }
    }

    public HitInfo getIndex(double d2, double d3) {
        Point2D point2D = new Point2D(d2 - this.textTranslateX.get() - this.snappedLeftInset(), d3 - this.snappedTopInset());
        return this.textNode.hitTest(point2D);
    }

    public void positionCaret(HitInfo hitInfo, boolean bl2) {
        this.positionCaret(hitInfo.getInsertionIndex(), hitInfo.isLeading(), bl2);
    }

    private void positionCaret(int n2, boolean bl2, boolean bl3) {
        TextField textField = (TextField)this.getSkinnable();
        if (bl3) {
            textField.selectPositionCaret(n2);
        } else {
            textField.positionCaret(n2);
        }
        this.setForwardBias(bl2);
    }

    @Override
    public Rectangle2D getCharacterBounds(int n2) {
        double d2;
        double d3;
        double d4;
        double d5;
        Bounds bounds;
        if (n2 == this.textNode.getText().length()) {
            bounds = this.textNode.getBoundsInLocal();
            d5 = bounds.getMaxX();
            d4 = 0.0;
            d3 = 0.0;
            d2 = bounds.getMaxY();
        } else {
            this.characterBoundingPath.getElements().clear();
            int n3 = n2;
            this.characterBoundingPath.getElements().addAll((PathElement[])this.textNode.rangeShape(n3, n3 + 1));
            this.characterBoundingPath.setLayoutX(this.textNode.getLayoutX());
            this.characterBoundingPath.setLayoutY(this.textNode.getLayoutY());
            bounds = this.characterBoundingPath.getBoundsInLocal();
            d5 = bounds.getMinX();
            d4 = bounds.getMinY();
            d3 = bounds.isEmpty() ? 0.0 : bounds.getWidth();
            d2 = bounds.isEmpty() ? 0.0 : bounds.getHeight();
        }
        double d6 = d2;
        bounds = this.textGroup.getBoundsInParent();
        return new Rectangle2D(d5 + bounds.getMinX() + this.textTranslateX.get(), d4 + bounds.getMinY(), d3, d6);
    }

    @Override
    protected PathElement[] getUnderlineShape(int n2, int n3) {
        return this.textNode.underlineShape(n2, n3);
    }

    @Override
    protected PathElement[] getRangeShape(int n2, int n3) {
        return this.textNode.rangeShape(n2, n3);
    }

    @Override
    protected void addHighlight(List<? extends Node> list, int n2) {
        this.textGroup.getChildren().addAll((Collection<Node>)list);
    }

    @Override
    protected void removeHighlight(List<? extends Node> list) {
        this.textGroup.getChildren().removeAll((Collection<?>)list);
    }

    @Override
    public void moveCaret(TextInputControlSkin$TextUnit textInputControlSkin$TextUnit, TextInputControlSkin$Direction textInputControlSkin$Direction, boolean bl2) {
        switch (textInputControlSkin$TextUnit) {
            case CHARACTER: {
                switch (textInputControlSkin$Direction) {
                    case LEFT: 
                    case RIGHT: {
                        this.nextCharacterVisually(textInputControlSkin$Direction == TextInputControlSkin$Direction.RIGHT);
                        return;
                    }
                }
                throw new IllegalArgumentException(String.valueOf((Object)textInputControlSkin$Direction));
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)textInputControlSkin$TextUnit));
    }

    private void nextCharacterVisually(boolean bl2) {
        if (this.isRTL()) {
            bl2 = !bl2;
        }
        Bounds bounds = this.caretPath.getLayoutBounds();
        if (this.caretPath.getElements().size() == 4) {
            bounds = new Path((PathElement)this.caretPath.getElements().get(0), (PathElement)this.caretPath.getElements().get(1)).getLayoutBounds();
        }
        double d2 = bl2 ? bounds.getMaxX() : bounds.getMinX();
        double d3 = (bounds.getMinY() + bounds.getMaxY()) / 2.0;
        HitInfo hitInfo = this.textNode.hitTest(new Point2D(d2, d3));
        boolean bl3 = hitInfo.isLeading();
        Path path = new Path(this.textNode.rangeShape(hitInfo.getCharIndex(), hitInfo.getCharIndex() + 1));
        if (bl2 && path.getLayoutBounds().getMaxX() > bounds.getMaxX() || !bl2 && path.getLayoutBounds().getMinX() < bounds.getMinX()) {
            bl3 = !bl3;
        }
        this.positionCaret(hitInfo.getInsertionIndex(), bl3, false);
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        super.layoutChildren(d2, d3, d4, d5);
        if (this.textNode != null) {
            Bounds bounds = this.textNode.getLayoutBounds();
            double d6 = ((Node)this.textNode).getBaselineOffset();
            double d7 = bounds.getHeight() - d6;
            double d8 = switch (((TextField)this.getSkinnable()).getAlignment().getVpos()) {
                case VPos.TOP -> d6;
                case VPos.CENTER -> (d6 + this.textGroup.getHeight() - d7) / 2.0;
                default -> this.textGroup.getHeight() - d7;
            };
            this.textNode.setY(d8);
            if (this.promptNode != null) {
                this.promptNode.setY(d8);
            }
            if (((TextField)this.getSkinnable()).getWidth() > 0.0) {
                this.updateTextPos();
                this.updateCaretOff();
            }
        }
        if (SHOW_HANDLES) {
            this.handleGroup.setLayoutX(d2 + this.caretWidth / 2.0);
            this.handleGroup.setLayoutY(d3);
            ((Node)this.selectionHandle1).resize(((Node)this.selectionHandle1).prefWidth(-1.0), ((Node)this.selectionHandle1).prefHeight(-1.0));
            ((Node)this.selectionHandle2).resize(((Node)this.selectionHandle2).prefWidth(-1.0), ((Node)this.selectionHandle2).prefHeight(-1.0));
            ((Node)this.caretHandle).resize(((Node)this.caretHandle).prefWidth(-1.0), ((Node)this.caretHandle).prefHeight(-1.0));
            Bounds bounds = this.caretPath.getBoundsInParent();
            this.caretHandle.setLayoutY(bounds.getMaxY() - 1.0);
            this.selectionHandle1.setLayoutY(bounds.getMinY() - this.selectionHandle1.getHeight() + 1.0);
            this.selectionHandle2.setLayoutY(bounds.getMaxY() - 1.0);
        }
    }

    private HPos getHAlignment() {
        HPos hPos = ((TextField)this.getSkinnable()).getAlignment().getHpos();
        return hPos;
    }

    @Override
    public Point2D getMenuPosition() {
        Point2D point2D = super.getMenuPosition();
        if (point2D != null) {
            point2D = new Point2D(Math.max(0.0, point2D.getX() - this.textNode.getLayoutX() - this.snappedLeftInset() + this.textTranslateX.get()), Math.max(0.0, point2D.getY() - this.textNode.getLayoutY() - this.snappedTopInset()));
        }
        return point2D;
    }

    @Override
    protected String maskText(String string) {
        if (this.getSkinnable() instanceof PasswordField) {
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append('\u25cf');
            }
            return stringBuilder.toString();
        }
        return string;
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case BOUNDS_FOR_RANGE: 
            case OFFSET_AT_POINT: {
                return ((Node)this.textNode).queryAccessibleAttribute(accessibleAttribute, objectArray);
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    TextInputControlBehavior getBehavior() {
        return this.behavior;
    }

    private void updateTextNodeCaretPos(int n2) {
        if (n2 == 0 || this.isForwardBias()) {
            this.textNode.setCaretPosition(n2);
        } else {
            this.textNode.setCaretPosition(n2 - 1);
        }
        this.textNode.caretBiasProperty().set(this.isForwardBias());
    }

    private void createPromptNode() {
        if (this.promptNode != null || !this.usePromptText.get()) {
            return;
        }
        this.promptNode = new Text();
        this.textGroup.getChildren().add(0, this.promptNode);
        this.promptNode.setManaged(false);
        this.promptNode.getStyleClass().add("text");
        this.promptNode.visibleProperty().bind(this.usePromptText);
        this.promptNode.fontProperty().bind(((TextField)this.getSkinnable()).fontProperty());
        this.promptNode.textProperty().bind(((TextField)this.getSkinnable()).promptTextProperty());
        this.promptNode.fillProperty().bind(this.promptTextFillProperty());
        this.updateSelection();
    }

    private void updateSelection() {
        TextField textField = (TextField)this.getSkinnable();
        IndexRange indexRange = textField.getSelection();
        if (indexRange == null || indexRange.getLength() == 0) {
            this.textNode.selectionStartProperty().set(-1);
            this.textNode.selectionEndProperty().set(-1);
        } else {
            this.textNode.selectionStartProperty().set(indexRange.getStart());
            this.textNode.selectionEndProperty().set(indexRange.getStart());
            this.textNode.selectionEndProperty().set(indexRange.getEnd());
        }
        Object object = (PathElement[])this.textNode.selectionShapeProperty().get();
        if (object == null) {
            this.selectionHighlightPath.getElements().clear();
        } else {
            this.selectionHighlightPath.getElements().setAll((PathElement[])object);
        }
        if (SHOW_HANDLES && indexRange != null && indexRange.getLength() > 0) {
            int n2 = textField.getCaretPosition();
            int n3 = textField.getAnchor();
            this.updateTextNodeCaretPos(n3);
            object = this.caretPath.getBoundsInParent();
            if (n2 < n3) {
                this.selectionHandle2.setLayoutX(((Bounds)object).getMinX() - this.selectionHandle2.getWidth() / 2.0);
            } else {
                this.selectionHandle1.setLayoutX(((Bounds)object).getMinX() - this.selectionHandle1.getWidth() / 2.0);
            }
            this.updateTextNodeCaretPos(n2);
            object = this.caretPath.getBoundsInParent();
            if (n2 < n3) {
                this.selectionHandle1.setLayoutX(((Bounds)object).getMinX() - this.selectionHandle1.getWidth() / 2.0);
                return;
            }
            this.selectionHandle2.setLayoutX(((Bounds)object).getMinX() - this.selectionHandle2.getWidth() / 2.0);
        }
    }

    private void updateTextPos() {
        double d2 = this.textTranslateX.get();
        double d3 = this.textNode.getLayoutBounds().getWidth();
        switch (this.getHAlignment()) {
            case CENTER: {
                double d4;
                double d5 = this.textRight.get() / 2.0;
                if (this.usePromptText.get()) {
                    double d6;
                    double d7 = d5 - this.promptNode.getLayoutBounds().getWidth() / 2.0;
                    if (d6 > 0.0) {
                        this.promptNode.setLayoutX(d7);
                        return;
                    }
                    this.promptNode.setLayoutX(this.caretWidth / 2.0);
                    return;
                }
                double d8 = d5 - d3 / 2.0;
                if (d4 + d3 <= this.textRight.get() - this.caretWidth / 2.0) {
                    this.textTranslateX.set(d8);
                    return;
                }
                if (!(d8 < 0.0) || !(d2 > this.caretWidth / 2.0)) break;
                this.textTranslateX.set(this.caretWidth / 2.0);
                return;
            }
            case RIGHT: {
                if (this.usePromptText.get()) {
                    double d9;
                    double d10 = this.textRight.get() - this.promptNode.getLayoutBounds().getWidth() - this.caretWidth / 2.0;
                    if (d9 > 0.0) {
                        this.promptNode.setLayoutX(d10);
                        return;
                    }
                    this.promptNode.setLayoutX(this.caretWidth / 2.0);
                    return;
                }
                double d11 = this.textRight.get() - d3 - this.caretWidth / 2.0;
                if (d11 > d2 || d11 > 0.0) {
                    this.textTranslateX.set(d11);
                    return;
                }
                if (!(d11 < 0.0) || !(d2 > this.caretWidth / 2.0)) break;
                this.textTranslateX.set(this.caretWidth / 2.0);
                return;
            }
            default: {
                double d12 = this.caretWidth / 2.0;
                if (d12 < d2 || d12 + d3 <= this.textRight.get()) {
                    this.textTranslateX.set(d12);
                }
                if (!this.usePromptText.get()) break;
                this.promptNode.layoutXProperty().set(d12);
            }
        }
    }

    private void updateCaretOff() {
        double d2;
        double d3 = 0.0;
        double d4 = this.caretPath.getLayoutBounds().getMinX() + this.textTranslateX.get();
        if (d2 < 0.0) {
            d3 = d4;
        } else if (d4 > this.textRight.get() - this.caretWidth) {
            d3 = d4 - (this.textRight.get() - this.caretWidth);
        }
        switch (this.getHAlignment()) {
            case CENTER: {
                this.textTranslateX.set(this.textTranslateX.get() - d3);
                break;
            }
            case RIGHT: {
                this.textTranslateX.set(Math.max(this.textTranslateX.get() - d3, this.textRight.get() - this.textNode.getLayoutBounds().getWidth() - this.caretWidth / 2.0));
                break;
            }
            default: {
                this.textTranslateX.set(Math.min(this.textTranslateX.get() - d3, this.caretWidth / 2.0));
            }
        }
        if (SHOW_HANDLES) {
            this.caretHandle.setLayoutX(d4 - this.caretHandle.getWidth() / 2.0);
        }
    }

    private void scrollAfterDelete(double d2, double d3) {
        Bounds bounds = this.textNode.getLayoutBounds();
        bounds = this.textNode.localToParent(bounds);
        Bounds bounds2 = this.clip.getBoundsInParent();
        Bounds bounds3 = this.caretPath.getLayoutBounds();
        if (bounds.getMinX() < bounds2.getMinX() + this.caretWidth / 2.0 && bounds.getMaxX() <= bounds2.getMaxX()) {
            double d4 = d3 - bounds3.getMaxX() - this.textTranslateX.get();
            if (bounds.getMaxX() + d4 < bounds2.getMaxX()) {
                d4 = d2 <= bounds2.getMaxX() ? d2 - bounds.getMaxX() : bounds2.getMaxX() - bounds.getMaxX();
            }
            this.textTranslateX.set(this.textTranslateX.get() + d4);
        }
        this.updateCaretOff();
    }

    Text getTextNode() {
        return this.textNode;
    }

    Text getPromptNode() {
        return this.promptNode;
    }

    double getTextTranslateX() {
        return this.textTranslateX.get();
    }

    private /* synthetic */ void lambda$new$10(TextField textField, Observable observable) {
        this.createPromptNode();
        textField.requestLayout();
    }

    private /* synthetic */ void lambda$new$7(TextField textField, Observable observable) {
        if (textField.getWidth() > 0.0) {
            this.updateTextPos();
            this.updateCaretOff();
            textField.requestLayout();
        }
    }

    private /* synthetic */ void lambda$new$5(TextField textField, Observable observable) {
        textField.requestLayout();
        ((TextField)this.getSkinnable()).requestLayout();
    }

    private /* synthetic */ void lambda$new$4(TextField textField, Observable observable) {
        this.caretPath.getElements().setAll((PathElement[])((PathElement[])this.textNode.caretShapeProperty().get()));
        if (this.caretPath.getElements().size() == 0) {
            this.updateTextNodeCaretPos(textField.getCaretPosition());
            return;
        }
        if (this.caretPath.getElements().size() != 4) {
            this.caretWidth = Math.round(this.caretPath.getLayoutBounds().getWidth());
        }
    }

    private /* synthetic */ void lambda$new$1(TextField textField, Observable observable) {
        if (textField.getWidth() > 0.0) {
            this.updateTextNodeCaretPos(textField.getCaretPosition());
            this.updateCaretOff();
        }
    }

    private /* synthetic */ void lambda$new$0(TextField textField, ObservableValue observableValue) {
        if (textField.getWidth() > 0.0) {
            this.updateTextNodeCaretPos(textField.getCaretPosition());
            if (!this.isForwardBias()) {
                this.setForwardBias(true);
            }
            this.updateCaretOff();
        }
    }
}

