/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.TitledPaneBehavior;
import javafx.animation.Animation;
import javafx.animation.Animation$Status;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Accordion;
import javafx.scene.control.TitledPane;
import javafx.scene.control.skin.LabeledSkinBase;
import javafx.scene.control.skin.TitledPaneSkin$1;
import javafx.scene.control.skin.TitledPaneSkin$2;
import javafx.scene.control.skin.TitledPaneSkin$TitleRegion;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class TitledPaneSkin
extends LabeledSkinBase<TitledPane> {
    private static final Duration TRANSITION_DURATION = new Duration(350.0);
    private static final boolean CACHE_ANIMATION = PlatformUtil.isEmbedded();
    private final TitledPaneBehavior behavior;
    private final TitledPaneSkin$TitleRegion titleRegion;
    private final StackPane contentContainer;
    private Node content;
    private Timeline timeline;
    private double transitionStartValue;
    private Rectangle clipRect;
    private Pos pos;
    private HPos hpos;
    private VPos vpos;
    private DoubleProperty transition;
    private double prefHeightFromAccordion = 0.0;

    public TitledPaneSkin(TitledPane titledPane) {
        super(titledPane);
        this.behavior = new TitledPaneBehavior(titledPane);
        this.clipRect = new Rectangle();
        this.transitionStartValue = 0.0;
        this.titleRegion = new TitledPaneSkin$TitleRegion(this);
        this.content = ((TitledPane)this.getSkinnable()).getContent();
        this.contentContainer = new TitledPaneSkin$1(this);
        this.contentContainer.setClip(this.clipRect);
        this.updateClip();
        if (titledPane.isExpanded()) {
            this.setTransition(1.0);
            this.setExpanded(titledPane.isExpanded());
        } else {
            this.setTransition(0.0);
            if (this.content != null) {
                this.content.setVisible(false);
            }
        }
        this.getChildren().setAll((Node[])new Node[]{this.contentContainer, this.titleRegion});
        this.registerChangeListener(titledPane.contentProperty(), observableValue -> {
            this.content = ((TitledPane)this.getSkinnable()).getContent();
            if (this.content == null) {
                this.contentContainer.getChildren().clear();
                return;
            }
            this.contentContainer.getChildren().setAll((Node[])new Node[]{this.content});
        });
        this.registerChangeListener(titledPane.expandedProperty(), observableValue -> {
            TitledPaneSkin titledPaneSkin = this;
            titledPaneSkin.setExpanded(((TitledPane)titledPaneSkin.getSkinnable()).isExpanded());
        });
        this.registerChangeListener(titledPane.collapsibleProperty(), observableValue -> this.titleRegion.update());
        this.registerChangeListener(titledPane.alignmentProperty(), observableValue -> {
            this.pos = ((TitledPane)this.getSkinnable()).getAlignment();
            this.hpos = this.pos.getHpos();
            this.vpos = this.pos.getVpos();
        });
        this.registerChangeListener(titledPane.widthProperty(), observableValue -> this.updateClip());
        this.registerChangeListener(titledPane.heightProperty(), observableValue -> this.updateClip());
        TitledPaneSkin titledPaneSkin = this;
        titledPaneSkin.registerChangeListener(titledPaneSkin.titleRegion.alignmentProperty(), observableValue -> {
            this.pos = this.titleRegion.getAlignment();
            this.hpos = this.pos.getHpos();
            this.vpos = this.pos.getVpos();
        });
        this.pos = titledPane.getAlignment();
        this.hpos = this.pos == null ? HPos.LEFT : this.pos.getHpos();
        this.vpos = this.pos == null ? VPos.CENTER : this.pos.getVpos();
    }

    private final void setTransition(double d2) {
        this.transitionProperty().set(d2);
    }

    private final double getTransition() {
        if (this.transition == null) {
            return 0.0;
        }
        return this.transition.get();
    }

    private final DoubleProperty transitionProperty() {
        if (this.transition == null) {
            TitledPaneSkin titledPaneSkin = this;
            this.transition = new TitledPaneSkin$2(titledPaneSkin, titledPaneSkin, "transition", 0.0);
        }
        return this.transition;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected void updateChildren() {
        if (this.titleRegion != null) {
            this.titleRegion.update();
        }
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        TitledPaneSkin titledPaneSkin = this;
        double d6 = titledPaneSkin.snapSizeY(((Node)titledPaneSkin.titleRegion).prefHeight(-1.0));
        ((Node)this.titleRegion).resize(d4, d6);
        TitledPaneSkin titledPaneSkin2 = this;
        titledPaneSkin2.positionInArea(titledPaneSkin2.titleRegion, d2, d3, d4, d6, 0.0, HPos.LEFT, VPos.CENTER);
        ((Parent)this.titleRegion).requestLayout();
        double d7 = (d5 - d6) * this.getTransition();
        if (this.isInsideAccordion() && this.prefHeightFromAccordion != 0.0) {
            d7 = (this.prefHeightFromAccordion - d6) * this.getTransition();
        }
        d7 = this.snapSizeY(d7);
        ((Node)this.contentContainer).resize(d4, d7);
        this.clipRect.setHeight(d7);
        TitledPaneSkin titledPaneSkin3 = this;
        titledPaneSkin3.positionInArea(titledPaneSkin3.contentContainer, d2, d3 += d6, d4, d7, 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        TitledPaneSkin titledPaneSkin = this;
        double d7 = titledPaneSkin.snapSizeX(((Node)titledPaneSkin.titleRegion).prefWidth(d2));
        TitledPaneSkin titledPaneSkin2 = this;
        double d8 = titledPaneSkin2.snapSizeX(((Node)titledPaneSkin2.contentContainer).minWidth(d2));
        return Math.max(d7, d8) + d6 + d4;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        TitledPaneSkin titledPaneSkin = this;
        double d7 = titledPaneSkin.snapSizeY(((Node)titledPaneSkin.titleRegion).prefHeight(d2));
        double d8 = ((Node)this.contentContainer).minHeight(d2) * this.getTransition();
        return d7 + this.snapSizeY(d8) + d3 + d5;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        TitledPaneSkin titledPaneSkin = this;
        double d7 = titledPaneSkin.snapSizeX(((Node)titledPaneSkin.titleRegion).prefWidth(d2));
        TitledPaneSkin titledPaneSkin2 = this;
        double d8 = titledPaneSkin2.snapSizeX(((Node)titledPaneSkin2.contentContainer).prefWidth(d2));
        return Math.max(d7, d8) + d6 + d4;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        TitledPaneSkin titledPaneSkin = this;
        double d7 = titledPaneSkin.snapSizeY(((Node)titledPaneSkin.titleRegion).prefHeight(d2));
        double d8 = ((Node)this.contentContainer).prefHeight(d2) * this.getTransition();
        return d7 + this.snapSizeY(d8) + d3 + d5;
    }

    @Override
    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return Double.MAX_VALUE;
    }

    private void updateClip() {
        this.clipRect.setWidth(((TitledPane)this.getSkinnable()).getWidth());
        this.clipRect.setHeight(this.contentContainer.getHeight());
    }

    private void setExpanded(boolean bl2) {
        if (!((TitledPane)this.getSkinnable()).isCollapsible()) {
            this.setTransition(1.0);
            return;
        }
        if (((TitledPane)this.getSkinnable()).isAnimated()) {
            this.transitionStartValue = this.getTransition();
            this.doAnimationTransition();
            return;
        }
        if (bl2) {
            this.setTransition(1.0);
        } else {
            this.setTransition(0.0);
        }
        if (this.content != null) {
            this.content.setVisible(bl2);
        }
        ((TitledPane)this.getSkinnable()).requestLayout();
    }

    private boolean isInsideAccordion() {
        return ((TitledPane)this.getSkinnable()).getParent() != null && ((TitledPane)this.getSkinnable()).getParent() instanceof Accordion;
    }

    double getTitleRegionSize(double d2) {
        TitledPaneSkin titledPaneSkin = this;
        return titledPaneSkin.snapSizeY(((Node)titledPaneSkin.titleRegion).prefHeight(d2)) + this.snappedTopInset() + this.snappedBottomInset();
    }

    void setMaxTitledPaneHeightForAccordion(double d2) {
        this.prefHeightFromAccordion = d2;
    }

    double getTitledPaneHeightForAccordion() {
        TitledPaneSkin titledPaneSkin = this;
        double d2 = titledPaneSkin.snapSizeY(((Node)titledPaneSkin.titleRegion).prefHeight(-1.0));
        double d3 = (this.prefHeightFromAccordion - d2) * this.getTransition();
        return d2 + this.snapSizeY(d3) + this.snappedTopInset() + this.snappedBottomInset();
    }

    private void doAnimationTransition() {
        KeyFrame keyFrame;
        Object object;
        if (this.content == null) {
            return;
        }
        if (this.timeline != null && this.timeline.getStatus() != Animation$Status.STOPPED) {
            object = this.timeline.getCurrentTime();
            ((Animation)this.timeline).stop();
        } else {
            object = TRANSITION_DURATION;
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(1);
        if (((TitledPane)this.getSkinnable()).isExpanded()) {
            keyFrame = new KeyFrame(Duration.ZERO, actionEvent -> {
                if (CACHE_ANIMATION) {
                    this.content.setCache(true);
                }
                this.content.setVisible(true);
            }, new KeyValue(this.transitionProperty(), this.transitionStartValue));
            object = new KeyFrame((Duration)object, actionEvent -> {
                if (CACHE_ANIMATION) {
                    this.content.setCache(false);
                }
            }, new KeyValue(this.transitionProperty(), 1, Interpolator.LINEAR));
        } else {
            keyFrame = new KeyFrame(Duration.ZERO, actionEvent -> {
                if (CACHE_ANIMATION) {
                    this.content.setCache(true);
                }
            }, new KeyValue(this.transitionProperty(), this.transitionStartValue));
            object = new KeyFrame((Duration)object, actionEvent -> {
                this.content.setVisible(false);
                if (CACHE_ANIMATION) {
                    this.content.setCache(false);
                }
            }, new KeyValue(this.transitionProperty(), 0, Interpolator.LINEAR));
        }
        this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame, object});
        this.timeline.play();
    }
}

