/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.control.skin.ToolBarSkin;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.StackPane;
import javafx.stage.Window;

class ToolBarSkin$ToolBarOverflowMenu
extends StackPane {
    private StackPane downArrow;
    private ContextMenu popup;
    private ObservableList<MenuItem> menuItems;
    final /* synthetic */ ToolBarSkin this$0;

    public ToolBarSkin$ToolBarOverflowMenu(ToolBarSkin toolBarSkin, ObservableList<MenuItem> observableList) {
        this.this$0 = toolBarSkin;
        this.getStyleClass().setAll((String[])new String[]{"tool-bar-overflow-button"});
        this.setAccessibleRole(AccessibleRole.BUTTON);
        this.setAccessibleText(ControlResources.getString("Accessibility.title.ToolBar.OverflowButton"));
        this.setFocusTraversable(true);
        this.menuItems = observableList;
        this.downArrow = new StackPane();
        this.downArrow.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.downArrow.setOnMousePressed(mouseEvent -> this.fire());
        ToolBarSkin$ToolBarOverflowMenu toolBarSkin$ToolBarOverflowMenu = this;
        toolBarSkin$ToolBarOverflowMenu.setOnKeyPressed(keyEvent -> {
            if (KeyCode.SPACE.equals((Object)keyEvent.getCode())) {
                if (!this.popup.isShowing()) {
                    this.popup.getItems().clear();
                    this.popup.getItems().addAll((Collection<MenuItem>)this.menuItems);
                    this.popup.show(this.downArrow, Side.BOTTOM, 0.0, 0.0);
                }
                keyEvent.consume();
                return;
            }
            if (KeyCode.ESCAPE.equals((Object)keyEvent.getCode())) {
                if (this.popup.isShowing()) {
                    ((Window)this.popup).hide();
                }
                keyEvent.consume();
                return;
            }
            if (KeyCode.ENTER.equals((Object)keyEvent.getCode())) {
                this.fire();
                keyEvent.consume();
            }
        });
        this.visibleProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue() && this.this$0.box.getChildren().isEmpty()) {
                this.setFocusTraversable(true);
            }
        });
        this.popup = new ContextMenu();
        this.setVisible(false);
        this.setManaged(false);
        this.getChildren().add(this.downArrow);
    }

    private void fire() {
        if (this.popup.isShowing()) {
            ((Window)this.popup).hide();
            return;
        }
        this.popup.getItems().clear();
        this.popup.getItems().addAll((Collection<MenuItem>)this.menuItems);
        this.popup.show(this.downArrow, Side.BOTTOM, 0.0, 0.0);
    }

    @Override
    protected double computePrefWidth(double d2) {
        return this.snappedLeftInset() + this.snappedRightInset();
    }

    @Override
    protected double computePrefHeight(double d2) {
        return this.snappedTopInset() + this.snappedBottomInset();
    }

    @Override
    protected void layoutChildren() {
        ToolBarSkin$ToolBarOverflowMenu toolBarSkin$ToolBarOverflowMenu = this;
        double d2 = toolBarSkin$ToolBarOverflowMenu.snapSizeX(((Node)toolBarSkin$ToolBarOverflowMenu.downArrow).prefWidth(-1.0));
        ToolBarSkin$ToolBarOverflowMenu toolBarSkin$ToolBarOverflowMenu2 = this;
        double d3 = toolBarSkin$ToolBarOverflowMenu2.snapSizeY(((Node)toolBarSkin$ToolBarOverflowMenu2.downArrow).prefHeight(-1.0));
        ToolBarSkin$ToolBarOverflowMenu toolBarSkin$ToolBarOverflowMenu3 = this;
        double d4 = (toolBarSkin$ToolBarOverflowMenu3.snapSizeX(toolBarSkin$ToolBarOverflowMenu3.getWidth()) - d2) / 2.0;
        ToolBarSkin$ToolBarOverflowMenu toolBarSkin$ToolBarOverflowMenu4 = this;
        double d5 = (toolBarSkin$ToolBarOverflowMenu4.snapSizeY(toolBarSkin$ToolBarOverflowMenu4.getHeight()) - d3) / 2.0;
        if (((ToolBar)this.this$0.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            this.downArrow.setRotate(0.0);
        }
        ((Node)this.downArrow).resize(d2, d3);
        ToolBarSkin$ToolBarOverflowMenu toolBarSkin$ToolBarOverflowMenu5 = this;
        toolBarSkin$ToolBarOverflowMenu5.positionInArea(toolBarSkin$ToolBarOverflowMenu5.downArrow, d4, d5, d2, d3, 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
        switch (accessibleAction) {
            case FIRE: {
                this.fire();
                return;
            }
        }
        super.executeAccessibleAction(accessibleAction, new Object[0]);
    }
}

