/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ToolBarBehavior;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToolBar;
import javafx.scene.control.skin.ToolBarSkin$1;
import javafx.scene.control.skin.ToolBarSkin$2;
import javafx.scene.control.skin.ToolBarSkin$3;
import javafx.scene.control.skin.ToolBarSkin$StyleableProperties;
import javafx.scene.control.skin.ToolBarSkin$ToolBarOverflowMenu;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;

public class ToolBarSkin
extends SkinBase<ToolBar> {
    private Pane box;
    private ToolBarSkin$ToolBarOverflowMenu overflowMenu;
    private boolean overflow = false;
    private double previousWidth = 0.0;
    private double previousHeight = 0.0;
    private double savedPrefWidth = 0.0;
    private double savedPrefHeight = 0.0;
    private ObservableList<MenuItem> overflowMenuItems;
    private boolean needsUpdate = false;
    private final ParentTraversalEngine engine;
    private final BehaviorBase<ToolBar> behavior;
    private ListChangeListener<Node> itemsListener;
    private DoubleProperty spacing;
    private ObjectProperty<Pos> boxAlignment;

    public ToolBarSkin(ToolBar toolBar) {
        super(toolBar);
        this.behavior = new ToolBarBehavior(toolBar);
        this.overflowMenuItems = FXCollections.observableArrayList();
        this.initialize();
        this.registerChangeListener(toolBar.orientationProperty(), observableValue -> this.initialize());
        this.engine = new ParentTraversalEngine((Parent)((Object)this.getSkinnable()), new ToolBarSkin$1(this, toolBar));
        ParentHelper.setTraversalEngine((Parent)((Object)this.getSkinnable()), this.engine);
        this.registerChangeListener(toolBar.focusedProperty(), observableValue -> {
            if (((ToolBar)this.getSkinnable()).isFocused()) {
                if (!this.box.getChildren().isEmpty()) {
                    ((Node)this.box.getChildren().get(0)).requestFocus();
                    return;
                }
                this.overflowMenu.requestFocus();
            }
        });
        this.itemsListener = listChangeListener$Change -> {
            while (listChangeListener$Change.next()) {
                for (Node node : listChangeListener$Change.getRemoved()) {
                    this.box.getChildren().remove(node);
                }
                this.box.getChildren().addAll(listChangeListener$Change.getAddedSubList());
            }
            this.needsUpdate = true;
            ((ToolBar)this.getSkinnable()).requestLayout();
        };
        toolBar.getItems().addListener(this.itemsListener);
    }

    private double snapSpacing(double d2) {
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return this.snapSpaceY(d2);
        }
        return this.snapSpaceX(d2);
    }

    private final void setSpacing(double d2) {
        this.spacingProperty().set(this.snapSpacing(d2));
    }

    private final double getSpacing() {
        if (this.spacing == null) {
            return 0.0;
        }
        ToolBarSkin toolBarSkin = this;
        return toolBarSkin.snapSpacing(toolBarSkin.spacing.get());
    }

    private final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new ToolBarSkin$2(this);
        }
        return this.spacing;
    }

    private final void setBoxAlignment(Pos pos) {
        this.boxAlignmentProperty().set(pos);
    }

    private final Pos getBoxAlignment() {
        if (this.boxAlignment == null) {
            return Pos.TOP_LEFT;
        }
        return (Pos)((Object)this.boxAlignment.get());
    }

    private final ObjectProperty<Pos> boxAlignmentProperty() {
        if (this.boxAlignment == null) {
            this.boxAlignment = new ToolBarSkin$3(this, Pos.TOP_LEFT);
        }
        return this.boxAlignment;
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        ((ToolBar)this.getSkinnable()).getItems().removeListener(this.itemsListener);
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        ToolBar toolBar = (ToolBar)this.getSkinnable();
        if (toolBar.getOrientation() == Orientation.VERTICAL) {
            return this.computePrefWidth(-1.0, d3, d4, d5, d6);
        }
        ToolBarSkin toolBarSkin = this;
        return toolBarSkin.snapSizeX(((Node)toolBarSkin.overflowMenu).prefWidth(-1.0)) + d6 + d4;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        ToolBar toolBar = (ToolBar)this.getSkinnable();
        if (toolBar.getOrientation() == Orientation.VERTICAL) {
            ToolBarSkin toolBarSkin = this;
            return toolBarSkin.snapSizeY(((Node)toolBarSkin.overflowMenu).prefHeight(-1.0)) + d3 + d5;
        }
        return this.computePrefHeight(-1.0, d3, d4, d5, d6);
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        ToolBar toolBar = (ToolBar)this.getSkinnable();
        if (toolBar.getOrientation() == Orientation.HORIZONTAL) {
            for (Node node : toolBar.getItems()) {
                if (!node.isManaged()) continue;
                d7 += this.snapSizeX(node.prefWidth(-1.0)) + this.getSpacing();
            }
            d7 -= this.getSpacing();
        } else {
            for (Node node : toolBar.getItems()) {
                if (!node.isManaged()) continue;
                d7 = Math.max(d7, this.snapSizeX(node.prefWidth(-1.0)));
            }
            if (toolBar.getItems().size() > 0) {
                this.savedPrefWidth = d7;
            } else {
                d7 = this.savedPrefWidth;
            }
        }
        return d6 + d7 + d4;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        ToolBar toolBar = (ToolBar)this.getSkinnable();
        if (toolBar.getOrientation() == Orientation.VERTICAL) {
            for (Node node : toolBar.getItems()) {
                if (!node.isManaged()) continue;
                d7 += this.snapSizeY(node.prefHeight(-1.0)) + this.getSpacing();
            }
            d7 -= this.getSpacing();
        } else {
            for (Node node : toolBar.getItems()) {
                if (!node.isManaged()) continue;
                d7 = Math.max(d7, this.snapSizeY(node.prefHeight(-1.0)));
            }
            if (toolBar.getItems().size() > 0) {
                this.savedPrefHeight = d7;
            } else {
                d7 = this.savedPrefHeight;
            }
        }
        return d3 + d7 + d5;
    }

    @Override
    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            ToolBarSkin toolBarSkin = this;
            return toolBarSkin.snapSizeX(((Node)((ToolBar)toolBarSkin.getSkinnable())).prefWidth(-1.0));
        }
        return Double.MAX_VALUE;
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return Double.MAX_VALUE;
        }
        ToolBarSkin toolBarSkin = this;
        return toolBarSkin.snapSizeY(((Node)((ToolBar)toolBarSkin.getSkinnable())).prefHeight(-1.0));
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        ToolBar toolBar = (ToolBar)this.getSkinnable();
        double d6 = this.getToolbarLength(toolBar);
        if (toolBar.getOrientation() == Orientation.VERTICAL) {
            if (this.snapSizeY(toolBar.getHeight()) != this.previousHeight || this.needsUpdate) {
                ((VBox)this.box).setSpacing(this.getSpacing());
                ((VBox)this.box).setAlignment(this.getBoxAlignment());
                this.previousHeight = this.snapSizeY(toolBar.getHeight());
                this.addNodesToToolBar();
            } else {
                this.correctOverflow(d6);
            }
        } else if (this.snapSizeX(toolBar.getWidth()) != this.previousWidth || this.needsUpdate) {
            ((HBox)this.box).setSpacing(this.getSpacing());
            ((HBox)this.box).setAlignment(this.getBoxAlignment());
            this.previousWidth = this.snapSizeX(toolBar.getWidth());
            this.addNodesToToolBar();
        } else {
            this.correctOverflow(d6);
        }
        this.needsUpdate = false;
        double d7 = d4;
        double d8 = d5;
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            double d9;
            if (this.overflow) {
                ToolBarSkin toolBarSkin = this;
                d9 = toolBarSkin.snapSizeY(((Node)toolBarSkin.overflowMenu).prefHeight(-1.0));
            } else {
                d9 = 0.0;
            }
            d8 -= d9;
        } else {
            double d10;
            if (this.overflow) {
                ToolBarSkin toolBarSkin = this;
                d10 = toolBarSkin.snapSizeX(((Node)toolBarSkin.overflowMenu).prefWidth(-1.0));
            } else {
                d10 = 0.0;
            }
            d7 -= d10;
        }
        ((Node)this.box).resize(d7, d8);
        ToolBarSkin toolBarSkin = this;
        toolBarSkin.positionInArea(toolBarSkin.box, d2, d3, d7, d8, 0.0, HPos.CENTER, VPos.CENTER);
        if (this.overflow) {
            double d11;
            double d12;
            ToolBarSkin toolBarSkin2 = this;
            double d13 = toolBarSkin2.snapSizeX(((Node)toolBarSkin2.overflowMenu).prefWidth(-1.0));
            ToolBarSkin toolBarSkin3 = this;
            double d14 = toolBarSkin3.snapSizeY(((Node)toolBarSkin3.overflowMenu).prefHeight(-1.0));
            if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                HPos hPos;
                if (d7 == 0.0) {
                    d7 = this.savedPrefWidth;
                }
                d12 = HPos.LEFT.equals((Object)(hPos = ((VBox)this.box).getAlignment().getHpos())) ? d2 + Math.abs((d7 - d13) / 2.0) : (HPos.RIGHT.equals((Object)hPos) ? this.snapSizeX(toolBar.getWidth()) - this.snappedRightInset() - d7 + Math.abs((d7 - d13) / 2.0) : d2 + Math.abs((this.snapSizeX(toolBar.getWidth()) - d2 + this.snappedRightInset() - d13) / 2.0));
                d11 = this.snapSizeY(toolBar.getHeight()) - d14 - d3;
            } else {
                VPos vPos;
                if (d8 == 0.0) {
                    d8 = this.savedPrefHeight;
                }
                d11 = !VPos.TOP.equals((Object)(vPos = ((HBox)this.box).getAlignment().getVpos())) && VPos.BOTTOM.equals((Object)vPos) ? this.snapSizeY(toolBar.getHeight()) - this.snappedBottomInset() - d8 + Math.abs((d8 - d14) / 2.0) : d3 + Math.abs((d8 - d14) / 2.0);
                d12 = this.snapSizeX(toolBar.getWidth()) - d13 - this.snappedRightInset();
            }
            ((Node)this.overflowMenu).resize(d13, d14);
            ToolBarSkin toolBarSkin4 = this;
            toolBarSkin4.positionInArea(toolBarSkin4.overflowMenu, d12, d11, d13, d14, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    private void initialize() {
        this.box = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? new VBox() : new HBox();
        this.box.getStyleClass().add("container");
        this.box.getChildren().addAll((Collection<Node>)((ToolBar)this.getSkinnable()).getItems());
        ToolBarSkin toolBarSkin = this;
        this.overflowMenu = new ToolBarSkin$ToolBarOverflowMenu(toolBarSkin, toolBarSkin.overflowMenuItems);
        this.overflowMenu.setVisible(false);
        this.overflowMenu.setManaged(false);
        this.getChildren().clear();
        this.getChildren().add(this.box);
        this.getChildren().add(this.overflowMenu);
        this.previousWidth = 0.0;
        this.previousHeight = 0.0;
        this.savedPrefWidth = 0.0;
        this.savedPrefHeight = 0.0;
        this.needsUpdate = true;
        ((ToolBar)this.getSkinnable()).requestLayout();
    }

    private void correctOverflow(double d2) {
        boolean bl2 = this.isOverflowed(d2);
        if (bl2 != this.overflow) {
            this.organizeOverflow(d2, this.overflow);
        }
    }

    private void organizeOverflow(double d2, boolean bl2) {
        if (bl2) {
            if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                ToolBarSkin toolBarSkin = this;
                d2 -= toolBarSkin.snapSizeY(((Node)toolBarSkin.overflowMenu).prefHeight(-1.0));
            } else {
                ToolBarSkin toolBarSkin = this;
                d2 -= toolBarSkin.snapSizeX(((Node)toolBarSkin.overflowMenu).prefWidth(-1.0));
            }
            d2 -= this.getSpacing();
        }
        double d3 = 0.0;
        this.overflowMenuItems.clear();
        this.box.getChildren().clear();
        Object object = ((ToolBar)this.getSkinnable()).getItems().iterator();
        while (object.hasNext()) {
            EventTarget eventTarget;
            Object object2 = (Node)object.next();
            ((Node)object2).getStyleClass().remove("menu-item");
            ((Node)object2).getStyleClass().remove("custom-menu-item");
            if (((Node)object2).isManaged()) {
                d3 = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? (d3 += this.snapSizeY(((Node)object2).prefHeight(-1.0)) + this.getSpacing()) : (d3 += this.snapSizeX(((Node)object2).prefWidth(-1.0)) + this.getSpacing());
            }
            if (d3 <= d2) {
                this.box.getChildren().add((Node)object2);
                continue;
            }
            if (((Node)object2).isFocused()) {
                if (!this.box.getChildren().isEmpty()) {
                    eventTarget = this.engine.selectLast();
                    if (eventTarget != null) {
                        ((Node)eventTarget).requestFocus();
                    }
                } else {
                    this.overflowMenu.requestFocus();
                }
            }
            if (object2 instanceof Separator) {
                this.overflowMenuItems.add(new SeparatorMenuItem());
                continue;
            }
            eventTarget = new CustomMenuItem((Node)object2);
            switch (((Node)object2).getTypeSelector()) {
                case "Button": 
                case "Hyperlink": 
                case "Label": {
                    ((CustomMenuItem)eventTarget).setHideOnClick(true);
                    break;
                }
                default: {
                    ((CustomMenuItem)eventTarget).setHideOnClick(false);
                }
            }
            this.overflowMenuItems.add((MenuItem)eventTarget);
        }
        boolean bl3 = this.overflow = this.overflowMenuItems.size() > 0;
        if (!this.overflow && this.overflowMenu.isFocused() && (object = this.engine.selectLast()) != null) {
            ((Node)object).requestFocus();
        }
        this.overflowMenu.setVisible(this.overflow);
        this.overflowMenu.setManaged(this.overflow);
    }

    private void addNodesToToolBar() {
        ToolBar toolBar = (ToolBar)this.getSkinnable();
        double d2 = this.getToolbarLength(toolBar);
        boolean bl2 = this.isOverflowed(d2);
        this.organizeOverflow(d2, bl2);
    }

    private double getToolbarLength(ToolBar toolBar) {
        double d2 = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.snapSizeY(toolBar.getHeight()) - this.snappedTopInset() - this.snappedBottomInset() + this.getSpacing() : this.snapSizeX(toolBar.getWidth()) - this.snappedLeftInset() - this.snappedRightInset() + this.getSpacing();
        return d2;
    }

    private boolean isOverflowed(double d2) {
        double d3 = 0.0;
        boolean bl2 = false;
        for (Node node : ((ToolBar)this.getSkinnable()).getItems()) {
            if (!node.isManaged()) continue;
            d3 = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? (d3 += this.snapSizeY(node.prefHeight(-1.0)) + this.getSpacing()) : (d3 += this.snapSizeX(node.prefWidth(-1.0)) + this.getSpacing());
            if (!(d3 > d2)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return ToolBarSkin$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ToolBarSkin.getClassCssMetaData();
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case OVERFLOW_BUTTON: {
                return this.overflowMenu;
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
        switch (accessibleAction) {
            case SHOW_MENU: {
                this.overflowMenu.fire();
                return;
            }
        }
        super.executeAccessibleAction(accessibleAction, objectArray);
    }
}

