/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TreeViewBehavior;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeItem$TreeModificationEvent;
import javafx.scene.control.TreeView;
import javafx.scene.control.skin.TreeViewSkin$1;
import javafx.scene.control.skin.TreeViewSkin$2;
import javafx.scene.control.skin.VirtualContainerBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public class TreeViewSkin<T>
extends VirtualContainerBase<TreeView<T>, TreeCell<T>> {
    private static final boolean IS_PANNABLE = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.scene.control.skin.TreeViewSkin.pannable"));
    private final VirtualFlow<TreeCell<T>> flow;
    private WeakReference<TreeItem<T>> weakRoot;
    private final TreeViewBehavior<T> behavior;
    private MapChangeListener<Object, Object> propertiesMapListener = mapChangeListener$Change -> {
        if (!mapChangeListener$Change.wasAdded()) {
            return;
        }
        if ("recreateKey".equals(mapChangeListener$Change.getKey())) {
            this.requestRebuildCells();
            ((TreeView)this.getSkinnable()).getProperties().remove("recreateKey");
        }
    };
    private EventHandler<TreeItem$TreeModificationEvent<T>> rootListener = serializable -> {
        if (((TreeItem$TreeModificationEvent)serializable).wasAdded() && ((TreeItem$TreeModificationEvent)serializable).wasRemoved() && ((TreeItem$TreeModificationEvent)serializable).getAddedSize() == ((TreeItem$TreeModificationEvent)serializable).getRemovedSize()) {
            this.markItemCountDirty();
            ((TreeView)this.getSkinnable()).requestLayout();
        } else if (((Event)serializable).getEventType().equals(TreeItem.valueChangedEvent())) {
            this.requestRebuildCells();
        } else {
            for (serializable = ((Event)serializable).getEventType(); serializable != null; serializable = ((EventType)((Object)serializable)).getSuperType()) {
                if (!serializable.equals(TreeItem.expandedItemCountChangeEvent())) continue;
                this.markItemCountDirty();
                ((TreeView)this.getSkinnable()).requestLayout();
                break;
            }
        }
        ((TreeView)this.getSkinnable()).edit(null);
    };
    private WeakEventHandler<TreeItem$TreeModificationEvent<T>> weakRootListener;

    public TreeViewSkin(TreeView treeView) {
        super(treeView);
        this.behavior = new TreeViewBehavior(treeView);
        this.flow = this.getVirtualFlow();
        this.flow.setPannable(IS_PANNABLE);
        this.flow.setCellFactory(this::createCell);
        this.flow.setFixedCellSize(treeView.getFixedCellSize());
        this.getChildren().add(this.flow);
        TreeViewSkin treeViewSkin = this;
        treeViewSkin.setRoot(((TreeView)treeViewSkin.getSkinnable()).getRoot());
        Object object = mouseEvent -> {
            if (treeView.isFocusTraversable()) {
                treeView.requestFocus();
            }
        };
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, object);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, object);
        object = treeView.getProperties();
        object.remove("recreateKey");
        object.addListener(this.propertiesMapListener);
        this.behavior.setOnFocusPreviousRow(() -> this.onFocusPreviousCell());
        this.behavior.setOnFocusNextRow(() -> this.onFocusNextCell());
        this.behavior.setOnMoveToFirstCell(() -> this.onMoveToFirstCell());
        this.behavior.setOnMoveToLastCell(() -> this.onMoveToLastCell());
        this.behavior.setOnScrollPageDown(this::onScrollPageDown);
        this.behavior.setOnScrollPageUp(this::onScrollPageUp);
        this.behavior.setOnSelectPreviousRow(() -> this.onSelectPreviousCell());
        this.behavior.setOnSelectNextRow(() -> this.onSelectNextCell());
        this.registerChangeListener(treeView.rootProperty(), observableValue -> {
            TreeViewSkin treeViewSkin = this;
            treeViewSkin.setRoot(((TreeView)treeViewSkin.getSkinnable()).getRoot());
        });
        this.registerChangeListener(treeView.showRootProperty(), observableValue -> {
            if (!((TreeView)this.getSkinnable()).isShowRoot() && this.getRoot() != null) {
                this.getRoot().setExpanded(true);
            }
            this.updateItemCount();
        });
        this.registerChangeListener(treeView.cellFactoryProperty(), observableValue -> this.flow.recreateCells());
        this.registerChangeListener(treeView.fixedCellSizeProperty(), observableValue -> this.flow.setFixedCellSize(((TreeView)this.getSkinnable()).getFixedCellSize()));
        this.updateItemCount();
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        ((TreeView)this.getSkinnable()).getProperties().removeListener(this.propertiesMapListener);
        this.setRoot(null);
        this.getChildren().remove(this.flow);
        super.dispose();
        if (this.behavior != null) {
            ((BehaviorBase)this.behavior).dispose();
        }
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return this.computePrefHeight(-1.0, d3, d4, d5, d6) * 0.618033987;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return 400.0;
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        super.layoutChildren(d2, d3, d4, d5);
        this.flow.resizeRelocate(d2, d3, d4, d5);
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute object, Object ... object2) {
        switch (TreeViewSkin$2.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                object = ((TreeView)this.getSkinnable()).getFocusModel();
                int n2 = ((FocusModel)object).getFocusedIndex();
                if (n2 == -1) {
                    if (this.getItemCount() > 0) {
                        n2 = 0;
                    } else {
                        return null;
                    }
                }
                return this.flow.getPrivateCell(n2);
            }
            case 2: {
                int n3 = (Integer)object2[0];
                if (n3 < 0) {
                    return null;
                }
                return this.flow.getPrivateCell(n3);
            }
            case 3: {
                object = ((TreeView)this.getSkinnable()).getSelectionModel();
                object = ((MultipleSelectionModel)object).getSelectedIndices();
                object2 = new ArrayList(object.size());
                object = object.iterator();
                while (object.hasNext()) {
                    int n4 = (Integer)object.next();
                    TreeCell<T> treeCell = this.flow.getPrivateCell(n4);
                    if (treeCell == null) continue;
                    object2.add(treeCell);
                }
                return FXCollections.observableArrayList(object2);
            }
            case 4: {
                return this.flow.getVbar();
            }
            case 5: {
                return this.flow.getHbar();
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), (Object[])object2);
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction object, Object ... object2) {
        switch (TreeViewSkin$2.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                object = (Node)object2[0];
                if (!(object instanceof TreeCell)) break;
                object2 = (TreeCell)object;
                this.flow.scrollTo(((IndexedCell)object2).getIndex());
                return;
            }
            case 2: {
                object = (ObservableList)object2[0];
                if (object == null) break;
                object2 = ((TreeView)this.getSkinnable()).getSelectionModel();
                if (object2 != null) {
                    ((SelectionModel)object2).clearSelection();
                    object = object.iterator();
                    while (object.hasNext()) {
                        Node node = (Node)object.next();
                        if (!(node instanceof TreeCell)) continue;
                        node = (TreeCell)node;
                        ((SelectionModel)object2).select(((IndexedCell)node).getIndex());
                    }
                }
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), (Object[])object2);
            }
        }
    }

    private TreeCell<T> createCell(VirtualFlow<TreeCell<T>> region) {
        region = ((TreeView)this.getSkinnable()).getCellFactory() != null ? ((TreeView)this.getSkinnable()).getCellFactory().call((TreeView)this.getSkinnable()) : this.createDefaultCellImpl();
        if (((TreeCell)region).getDisclosureNode() == null) {
            StackPane stackPane = new StackPane();
            stackPane.getStyleClass().setAll((String[])new String[]{"tree-disclosure-node"});
            StackPane stackPane2 = new StackPane();
            stackPane2.getStyleClass().setAll((String[])new String[]{"arrow"});
            stackPane.getChildren().add(stackPane2);
            ((TreeCell)region).setDisclosureNode(stackPane);
        }
        ((TreeCell)region).updateTreeView((TreeView)this.getSkinnable());
        return region;
    }

    private TreeItem<T> getRoot() {
        if (this.weakRoot == null) {
            return null;
        }
        return (TreeItem)this.weakRoot.get();
    }

    private void setRoot(TreeItem<T> treeItem) {
        if (this.getRoot() != null && this.weakRootListener != null) {
            this.getRoot().removeEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
        this.weakRoot = new WeakReference<TreeItem<TreeItem<T>>>(treeItem);
        if (this.getRoot() != null) {
            this.weakRootListener = new WeakEventHandler<TreeItem$TreeModificationEvent<TreeItem$TreeModificationEvent<T>>>(this.rootListener);
            this.getRoot().addEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
        this.updateItemCount();
    }

    @Override
    protected int getItemCount() {
        return ((TreeView)this.getSkinnable()).getExpandedItemCount();
    }

    @Override
    protected void updateItemCount() {
        int n2 = this.getItemCount();
        this.requestRebuildCells();
        this.flow.setCellCount(n2);
        ((TreeView)this.getSkinnable()).requestLayout();
    }

    private TreeCell<T> createDefaultCellImpl() {
        return new TreeViewSkin$1(this);
    }

    private void onFocusPreviousCell() {
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.scrollTo(focusModel.getFocusedIndex());
    }

    private void onFocusNextCell() {
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.scrollTo(focusModel.getFocusedIndex());
    }

    private void onSelectPreviousCell() {
        int n2 = ((TreeView)this.getSkinnable()).getSelectionModel().getSelectedIndex();
        this.flow.scrollTo(n2);
    }

    private void onSelectNextCell() {
        int n2 = ((TreeView)this.getSkinnable()).getSelectionModel().getSelectedIndex();
        this.flow.scrollTo(n2);
    }

    private void onMoveToFirstCell() {
        this.flow.scrollTo(0);
        this.flow.setPosition(0.0);
    }

    private void onMoveToLastCell() {
        this.flow.scrollTo(this.getItemCount());
        this.flow.setPosition(1.0);
    }

    private int onScrollPageDown(boolean bl2) {
        boolean bl3;
        TreeCell<T> treeCell = this.flow.getLastVisibleCellWithinViewport();
        if (treeCell == null) {
            return -1;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getSkinnable()).getSelectionModel();
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (multipleSelectionModel == null || focusModel == null) {
            return -1;
        }
        int n2 = treeCell.getIndex();
        if (bl2) {
            bl3 = treeCell.isFocused() || focusModel.isFocused(n2);
        } else {
            boolean bl4 = bl3 = treeCell.isSelected() || multipleSelectionModel.isSelected(n2);
        }
        if (bl3 && (bl2 = bl2 && focusModel.getFocusedIndex() == n2 || !bl2 && multipleSelectionModel.getSelectedIndex() == n2)) {
            this.flow.scrollToTop(treeCell);
            TreeCell<T> treeCell2 = this.flow.getLastVisibleCellWithinViewport();
            treeCell = treeCell2 == null ? treeCell : treeCell2;
        }
        int n3 = treeCell.getIndex();
        this.flow.scrollTo(treeCell);
        return n3;
    }

    private int onScrollPageUp(boolean bl2) {
        boolean bl3;
        TreeCell<T> treeCell = this.flow.getFirstVisibleCellWithinViewport();
        if (treeCell == null) {
            return -1;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getSkinnable()).getSelectionModel();
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (multipleSelectionModel == null || focusModel == null) {
            return -1;
        }
        int n2 = treeCell.getIndex();
        if (bl2) {
            bl3 = treeCell.isFocused() || focusModel.isFocused(n2);
        } else {
            boolean bl4 = bl3 = treeCell.isSelected() || multipleSelectionModel.isSelected(n2);
        }
        if (bl3 && (bl2 = bl2 && focusModel.getFocusedIndex() == n2 || !bl2 && multipleSelectionModel.getSelectedIndex() == n2)) {
            this.flow.scrollToBottom(treeCell);
            TreeCell<T> treeCell2 = this.flow.getFirstVisibleCellWithinViewport();
            treeCell = treeCell2 == null ? treeCell : treeCell2;
        }
        int n3 = treeCell.getIndex();
        this.flow.scrollTo(treeCell);
        return n3;
    }
}

