/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.util.Utils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.BoxBlur$1;
import javafx.scene.effect.BoxBlur$2;
import javafx.scene.effect.BoxBlur$3;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Effect$EffectInputProperty;

public class BoxBlur
extends Effect {
    private ObjectProperty<Effect> input;
    private DoubleProperty width;
    private DoubleProperty height;
    private IntegerProperty iterations;

    public BoxBlur() {
    }

    public BoxBlur(double d2, double d3, int n2) {
        this.setWidth(d2);
        this.setHeight(d3);
        this.setIterations(n2);
    }

    @Override
    com.sun.scenario.effect.BoxBlur createPeer() {
        return new com.sun.scenario.effect.BoxBlur();
    }

    public final void setInput(Effect effect) {
        this.inputProperty().set(effect);
    }

    public final Effect getInput() {
        if (this.input == null) {
            return null;
        }
        return (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect$EffectInputProperty(this, "input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect effect) {
        Effect effect2 = this.getInput();
        if (effect2 == null) {
            return false;
        }
        if (effect2 == effect) {
            return true;
        }
        return effect2.checkChainContains(effect);
    }

    public final void setWidth(double d2) {
        this.widthProperty().set(d2);
    }

    public final double getWidth() {
        if (this.width == null) {
            return 5.0;
        }
        return this.width.get();
    }

    public final DoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new BoxBlur$1(this, 5.0);
        }
        return this.width;
    }

    public final void setHeight(double d2) {
        this.heightProperty().set(d2);
    }

    public final double getHeight() {
        if (this.height == null) {
            return 5.0;
        }
        return this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new BoxBlur$2(this, 5.0);
        }
        return this.height;
    }

    public final void setIterations(int n2) {
        this.iterationsProperty().set(n2);
    }

    public final int getIterations() {
        if (this.iterations == null) {
            return 1;
        }
        return this.iterations.get();
    }

    public final IntegerProperty iterationsProperty() {
        if (this.iterations == null) {
            this.iterations = new BoxBlur$3(this, 1);
        }
        return this.iterations;
    }

    private int getClampedWidth() {
        return Utils.clamp(0, (int)this.getWidth(), 255);
    }

    private int getClampedHeight() {
        return Utils.clamp(0, (int)this.getHeight(), 255);
    }

    private int getClampedIterations() {
        return Utils.clamp(0, this.getIterations(), 3);
    }

    @Override
    void update() {
        Effect effect = this.getInput();
        if (effect != null) {
            effect.sync();
        }
        com.sun.scenario.effect.BoxBlur boxBlur = (com.sun.scenario.effect.BoxBlur)this.getPeer();
        boxBlur.setInput(effect == null ? null : effect.getPeer());
        boxBlur.setHorizontalSize(this.getClampedWidth());
        boxBlur.setVerticalSize(this.getClampedHeight());
        boxBlur.setPasses(this.getClampedIterations());
    }

    @Override
    BaseBounds getBounds(BaseBounds baseBounds, BaseTransform baseTransform, Node node, BoundsAccessor boundsAccessor) {
        baseBounds = BoxBlur.getInputBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM, node, boundsAccessor, this.getInput());
        int n2 = this.getClampedIterations();
        int n3 = BoxBlur.getKernelSize(this.getClampedWidth(), n2);
        n2 = BoxBlur.getKernelSize(this.getClampedHeight(), n2);
        baseBounds = baseBounds.deriveWithPadding(n3, n2, 0.0f);
        return BoxBlur.transformBounds(baseTransform, baseBounds);
    }

    @Override
    Effect copy() {
        BoxBlur boxBlur = new BoxBlur(this.getWidth(), this.getHeight(), this.getIterations());
        boxBlur.setInput(this.getInput());
        return boxBlur;
    }
}

