/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.tk.Toolkit;
import com.sun.scenario.effect.Identity;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.effect.ImageInput$1;
import javafx.scene.effect.ImageInput$2;
import javafx.scene.effect.ImageInput$3;
import javafx.scene.effect.ImageInput$4;
import javafx.scene.image.Image;

public class ImageInput
extends Effect {
    private ObjectProperty<Image> source;
    private final AbstractNotifyListener platformImageChangeListener = new ImageInput$1(this);
    private Image oldImage;
    private DoubleProperty x;
    private DoubleProperty y;

    public ImageInput() {
    }

    public ImageInput(Image image) {
        this.setSource(image);
    }

    public ImageInput(Image image, double d2, double d3) {
        this.setSource(image);
        this.setX(d2);
        this.setY(d3);
    }

    @Override
    Identity createPeer() {
        return new Identity(null);
    }

    public final void setSource(Image image) {
        this.sourceProperty().set(image);
    }

    public final Image getSource() {
        if (this.source == null) {
            return null;
        }
        return (Image)this.source.get();
    }

    public final ObjectProperty<Image> sourceProperty() {
        if (this.source == null) {
            this.source = new ImageInput$2(this);
        }
        return this.source;
    }

    public final void setX(double d2) {
        this.xProperty().set(d2);
    }

    public final double getX() {
        if (this.x == null) {
            return 0.0;
        }
        return this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new ImageInput$3(this);
        }
        return this.x;
    }

    public final void setY(double d2) {
        this.yProperty().set(d2);
    }

    public final double getY() {
        if (this.y == null) {
            return 0.0;
        }
        return this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new ImageInput$4(this);
        }
        return this.y;
    }

    @Override
    void update() {
        Identity identity = (Identity)this.getPeer();
        Image image = this.getSource();
        if (image != null && Toolkit.getImageAccessor().getPlatformImage(image) != null) {
            identity.setSource(Toolkit.getToolkit().toFilterable(image));
        } else {
            identity.setSource(null);
        }
        identity.setLocation(new Point2D((float)this.getX(), (float)this.getY()));
    }

    @Override
    boolean checkChainContains(Effect effect) {
        return false;
    }

    @Override
    BaseBounds getBounds(BaseBounds object, BaseTransform baseTransform, Node node, BoundsAccessor boundsAccessor) {
        object = this.getSource();
        if (object != null && Toolkit.getImageAccessor().getPlatformImage((Image)object) != null) {
            float f2 = (float)this.getX();
            float f3 = (float)this.getY();
            float f4 = (float)((Image)object).getWidth();
            float f5 = (float)((Image)object).getHeight();
            RectBounds rectBounds = new RectBounds(f2, f3, f2 + f4, f3 + f5);
            return ImageInput.transformBounds(baseTransform, rectBounds);
        }
        return new RectBounds();
    }

    @Override
    Effect copy() {
        return new ImageInput(this.getSource(), this.getX(), this.getY());
    }
}

