/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.util.Utils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Effect$EffectInputProperty;
import javafx.scene.effect.Reflection$1;
import javafx.scene.effect.Reflection$2;
import javafx.scene.effect.Reflection$3;
import javafx.scene.effect.Reflection$4;

public class Reflection
extends Effect {
    private ObjectProperty<Effect> input;
    private DoubleProperty topOffset;
    private DoubleProperty topOpacity;
    private DoubleProperty bottomOpacity;
    private DoubleProperty fraction;

    public Reflection() {
    }

    public Reflection(double d2, double d3, double d4, double d5) {
        this.setBottomOpacity(d5);
        this.setTopOffset(d2);
        this.setTopOpacity(d4);
        this.setFraction(d3);
    }

    @Override
    com.sun.scenario.effect.Reflection createPeer() {
        return new com.sun.scenario.effect.Reflection();
    }

    public final void setInput(Effect effect) {
        this.inputProperty().set(effect);
    }

    public final Effect getInput() {
        if (this.input == null) {
            return null;
        }
        return (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect$EffectInputProperty(this, "input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect effect) {
        Effect effect2 = this.getInput();
        if (effect2 == null) {
            return false;
        }
        if (effect2 == effect) {
            return true;
        }
        return effect2.checkChainContains(effect);
    }

    public final void setTopOffset(double d2) {
        this.topOffsetProperty().set(d2);
    }

    public final double getTopOffset() {
        if (this.topOffset == null) {
            return 0.0;
        }
        return this.topOffset.get();
    }

    public final DoubleProperty topOffsetProperty() {
        if (this.topOffset == null) {
            this.topOffset = new Reflection$1(this);
        }
        return this.topOffset;
    }

    public final void setTopOpacity(double d2) {
        this.topOpacityProperty().set(d2);
    }

    public final double getTopOpacity() {
        if (this.topOpacity == null) {
            return 0.5;
        }
        return this.topOpacity.get();
    }

    public final DoubleProperty topOpacityProperty() {
        if (this.topOpacity == null) {
            this.topOpacity = new Reflection$2(this, 0.5);
        }
        return this.topOpacity;
    }

    public final void setBottomOpacity(double d2) {
        this.bottomOpacityProperty().set(d2);
    }

    public final double getBottomOpacity() {
        if (this.bottomOpacity == null) {
            return 0.0;
        }
        return this.bottomOpacity.get();
    }

    public final DoubleProperty bottomOpacityProperty() {
        if (this.bottomOpacity == null) {
            this.bottomOpacity = new Reflection$3(this);
        }
        return this.bottomOpacity;
    }

    public final void setFraction(double d2) {
        this.fractionProperty().set(d2);
    }

    public final double getFraction() {
        if (this.fraction == null) {
            return 0.75;
        }
        return this.fraction.get();
    }

    public final DoubleProperty fractionProperty() {
        if (this.fraction == null) {
            this.fraction = new Reflection$4(this, 0.75);
        }
        return this.fraction;
    }

    private float getClampedFraction() {
        return (float)Utils.clamp(0.0, this.getFraction(), 1.0);
    }

    private float getClampedBottomOpacity() {
        return (float)Utils.clamp(0.0, this.getBottomOpacity(), 1.0);
    }

    private float getClampedTopOpacity() {
        return (float)Utils.clamp(0.0, this.getTopOpacity(), 1.0);
    }

    @Override
    void update() {
        Effect effect = this.getInput();
        if (effect != null) {
            effect.sync();
        }
        com.sun.scenario.effect.Reflection reflection = (com.sun.scenario.effect.Reflection)this.getPeer();
        reflection.setInput(effect == null ? null : effect.getPeer());
        reflection.setFraction(this.getClampedFraction());
        reflection.setTopOffset((float)this.getTopOffset());
        reflection.setBottomOpacity(this.getClampedBottomOpacity());
        reflection.setTopOpacity(this.getClampedTopOpacity());
    }

    @Override
    BaseBounds getBounds(BaseBounds baseBounds, BaseTransform baseTransform, Node node, BoundsAccessor boundsAccessor) {
        baseBounds = Reflection.getInputBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM, node, boundsAccessor, this.getInput());
        baseBounds.roundOut();
        float f2 = baseBounds.getMinX();
        float f3 = baseBounds.getMaxY() + (float)this.getTopOffset();
        float f4 = baseBounds.getMinZ();
        float f5 = baseBounds.getMaxX();
        float f6 = f3 + this.getClampedFraction() * baseBounds.getHeight();
        float f7 = baseBounds.getMaxZ();
        BaseBounds baseBounds2 = BaseBounds.getInstance(f2, f3, f4, f5, f6, f7);
        baseBounds2 = baseBounds2.deriveWithUnion(baseBounds);
        return Reflection.transformBounds(baseTransform, baseBounds2);
    }

    @Override
    Effect copy() {
        Reflection reflection = new Reflection(this.getTopOffset(), this.getFraction(), this.getTopOpacity(), this.getBottomOpacity());
        reflection.setInput(reflection.getInput());
        return reflection;
    }
}

