/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import com.sun.scenario.effect.GeneralShadow;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Effect$EffectInputProperty;
import javafx.scene.effect.Shadow$1;
import javafx.scene.effect.Shadow$2;
import javafx.scene.effect.Shadow$3;
import javafx.scene.effect.Shadow$4;
import javafx.scene.effect.Shadow$5;
import javafx.scene.paint.Color;

public class Shadow
extends Effect {
    private boolean changeIsLocal;
    private ObjectProperty<Effect> input;
    private DoubleProperty radius;
    private DoubleProperty width;
    private DoubleProperty height;
    private ObjectProperty<BlurType> blurType;
    private ObjectProperty<Color> color;

    public Shadow() {
    }

    public Shadow(double d2, Color color) {
        this.setRadius(d2);
        this.setColor(color);
    }

    public Shadow(BlurType blurType, Color color, double d2) {
        this.setBlurType(blurType);
        this.setColor(color);
        this.setRadius(d2);
    }

    @Override
    GeneralShadow createPeer() {
        return new GeneralShadow();
    }

    public final void setInput(Effect effect) {
        this.inputProperty().set(effect);
    }

    public final Effect getInput() {
        if (this.input == null) {
            return null;
        }
        return (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect$EffectInputProperty(this, "input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect effect) {
        Effect effect2 = this.getInput();
        if (effect2 == null) {
            return false;
        }
        if (effect2 == effect) {
            return true;
        }
        return effect2.checkChainContains(effect);
    }

    public final void setRadius(double d2) {
        this.radiusProperty().set(d2);
    }

    public final double getRadius() {
        if (this.radius == null) {
            return 10.0;
        }
        return this.radius.get();
    }

    public final DoubleProperty radiusProperty() {
        if (this.radius == null) {
            this.radius = new Shadow$1(this, 10.0);
        }
        return this.radius;
    }

    private void updateRadius(double d2) {
        double d3 = d2 * 2.0 + 1.0;
        if (this.width != null && this.width.isBound()) {
            if (this.height == null || !this.height.isBound()) {
                this.setHeight(d3 * 2.0 - this.getWidth());
                return;
            }
        } else {
            if (this.height != null && this.height.isBound()) {
                this.setWidth(d3 * 2.0 - this.getHeight());
                return;
            }
            this.setWidth(d3);
            this.setHeight(d3);
        }
    }

    public final void setWidth(double d2) {
        this.widthProperty().set(d2);
    }

    public final double getWidth() {
        if (this.width == null) {
            return 21.0;
        }
        return this.width.get();
    }

    public final DoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new Shadow$2(this, 21.0);
        }
        return this.width;
    }

    private void updateWidth(double d2) {
        if (this.radius == null || !this.radius.isBound()) {
            double d3;
            double d4 = (d2 + this.getHeight()) / 2.0;
            d4 = (d4 - 1.0) / 2.0;
            if (d3 < 0.0) {
                d4 = 0.0;
            }
            this.setRadius(d4);
            return;
        }
        if (this.height == null || !this.height.isBound()) {
            double d5 = this.getRadius() * 2.0 + 1.0;
            this.setHeight(d5 * 2.0 - d2);
        }
    }

    public final void setHeight(double d2) {
        this.heightProperty().set(d2);
    }

    public final double getHeight() {
        if (this.height == null) {
            return 21.0;
        }
        return this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new Shadow$3(this, 21.0);
        }
        return this.height;
    }

    private void updateHeight(double d2) {
        if (this.radius == null || !this.radius.isBound()) {
            double d3;
            double d4 = (this.getWidth() + d2) / 2.0;
            d4 = (d4 - 1.0) / 2.0;
            if (d3 < 0.0) {
                d4 = 0.0;
            }
            this.setRadius(d4);
            return;
        }
        if (this.width == null || !this.width.isBound()) {
            double d5 = this.getRadius() * 2.0 + 1.0;
            this.setWidth(d5 * 2.0 - d2);
        }
    }

    public final void setBlurType(BlurType blurType) {
        this.blurTypeProperty().set(blurType);
    }

    public final BlurType getBlurType() {
        if (this.blurType == null) {
            return BlurType.THREE_PASS_BOX;
        }
        return (BlurType)((Object)this.blurType.get());
    }

    public final ObjectProperty<BlurType> blurTypeProperty() {
        if (this.blurType == null) {
            this.blurType = new Shadow$4(this, BlurType.THREE_PASS_BOX);
        }
        return this.blurType;
    }

    public final void setColor(Color color) {
        this.colorProperty().set(color);
    }

    public final Color getColor() {
        if (this.color == null) {
            return Color.BLACK;
        }
        return (Color)this.color.get();
    }

    public final ObjectProperty<Color> colorProperty() {
        if (this.color == null) {
            this.color = new Shadow$5(this, Color.BLACK);
        }
        return this.color;
    }

    private float getClampedWidth() {
        return (float)Utils.clamp(0.0, this.getWidth(), 255.0);
    }

    private float getClampedHeight() {
        return (float)Utils.clamp(0.0, this.getHeight(), 255.0);
    }

    private Color getColorInternal() {
        Color color = this.getColor();
        if (color == null) {
            return Color.BLACK;
        }
        return color;
    }

    private BlurType getBlurTypeInternal() {
        BlurType blurType = this.getBlurType();
        if (blurType == null) {
            return BlurType.THREE_PASS_BOX;
        }
        return blurType;
    }

    @Override
    void update() {
        Effect effect = this.getInput();
        if (effect != null) {
            effect.sync();
        }
        GeneralShadow generalShadow = (GeneralShadow)this.getPeer();
        generalShadow.setInput(effect == null ? null : effect.getPeer());
        generalShadow.setGaussianWidth(this.getClampedWidth());
        generalShadow.setGaussianHeight(this.getClampedHeight());
        generalShadow.setShadowMode(Toolkit.getToolkit().toShadowMode(this.getBlurTypeInternal()));
        generalShadow.setColor(Toolkit.getToolkit().toColor4f(this.getColorInternal()));
    }

    @Override
    BaseBounds getBounds(BaseBounds baseBounds, BaseTransform baseTransform, Node node, BoundsAccessor boundsAccessor) {
        baseBounds = Shadow.getInputBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM, node, boundsAccessor, this.getInput());
        return Shadow.getShadowBounds(baseBounds, baseTransform, this.getClampedWidth(), this.getClampedHeight(), this.getBlurTypeInternal());
    }

    @Override
    Effect copy() {
        Shadow shadow = new Shadow(this.getBlurType(), this.getColor(), this.getRadius());
        shadow.setInput(this.getInput());
        shadow.setHeight(this.getHeight());
        shadow.setWidth(this.getWidth());
        return shadow;
    }
}

