/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import com.sun.javafx.tk.ImageLoader;
import java.lang.ref.WeakReference;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.image.Image;
import javafx.scene.image.Image$Animation$1;
import javafx.util.Duration;

final class Image$Animation {
    final WeakReference<Image> imageRef;
    final Timeline timeline;
    final SimpleIntegerProperty frameIndex = new Image$Animation$1(this);

    public Image$Animation(Image image, ImageLoader imageLoader) {
        this.imageRef = new WeakReference<Image>(image);
        this.timeline = new Timeline();
        int n2 = imageLoader.getLoopCount();
        this.timeline.setCycleCount(n2 == 0 ? -1 : n2);
        n2 = imageLoader.getFrameCount();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addKeyFrame(i2, n3);
            n3 += imageLoader.getFrameDelay(i2);
        }
        this.timeline.getKeyFrames().add(new KeyFrame(Duration.millis(n3), new KeyValue[0]));
    }

    public final void start() {
        this.timeline.play();
    }

    public final void stop() {
        ((Animation)this.timeline).stop();
    }

    private void updateImage(int n2) {
        Image image = (Image)this.imageRef.get();
        if (image != null) {
            image.platformImagePropertyImpl().set(image.animFrames[n2]);
            return;
        }
        ((Animation)this.timeline).stop();
    }

    private void addKeyFrame(int n2, double d2) {
        this.timeline.getKeyFrames().add(new KeyFrame(Duration.millis(d2), new KeyValue(this.frameIndex, n2, Interpolator.DISCRETE)));
    }
}

