/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import com.sun.javafx.runtime.async.AsyncOperation;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.DataURI;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.image.Image$1;
import javafx.scene.image.Image$2;
import javafx.scene.image.Image$Animation;
import javafx.scene.image.Image$DoublePropertyImpl;
import javafx.scene.image.Image$ImageTask;
import javafx.scene.image.Image$ObjectPropertyImpl;
import javafx.scene.image.PixelBuffer;
import javafx.scene.image.PixelReader;

public class Image {
    private static final Pattern URL_QUICKMATCH;
    private final String url;
    private final InputStream inputSource;
    private ReadOnlyDoubleWrapper progress;
    private final double requestedWidth;
    private final double requestedHeight;
    private Image$DoublePropertyImpl width;
    private Image$DoublePropertyImpl height;
    private final boolean preserveRatio;
    private final boolean smooth;
    private final boolean backgroundLoading;
    private ReadOnlyBooleanWrapper error;
    private ReadOnlyObjectWrapper<Exception> exception;
    private Image$ObjectPropertyImpl<PlatformImage> platformImage;
    private Image$ImageTask backgroundTask;
    private Image$Animation animation;
    private volatile boolean isAnimated;
    private PlatformImage[] animFrames;
    private static final int MAX_RUNNING_TASKS = 4;
    private static int runningTasks;
    private static final Queue<Image$ImageTask> pendingTasks;
    private PixelReader reader;

    public final String getUrl() {
        return this.url;
    }

    final InputStream getInputSource() {
        return this.inputSource;
    }

    final void setProgress(double d2) {
        this.progressPropertyImpl().set(d2);
    }

    public final double getProgress() {
        if (this.progress == null) {
            return 0.0;
        }
        return this.progress.get();
    }

    public final ReadOnlyDoubleProperty progressProperty() {
        return this.progressPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper progressPropertyImpl() {
        if (this.progress == null) {
            this.progress = new ReadOnlyDoubleWrapper(this, "progress");
        }
        return this.progress;
    }

    public final double getRequestedWidth() {
        return this.requestedWidth;
    }

    public final double getRequestedHeight() {
        return this.requestedHeight;
    }

    public final double getWidth() {
        if (this.width == null) {
            return 0.0;
        }
        return this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.widthPropertyImpl();
    }

    private Image$DoublePropertyImpl widthPropertyImpl() {
        if (this.width == null) {
            this.width = new Image$DoublePropertyImpl(this, "width");
        }
        return this.width;
    }

    public final double getHeight() {
        if (this.height == null) {
            return 0.0;
        }
        return this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.heightPropertyImpl();
    }

    private Image$DoublePropertyImpl heightPropertyImpl() {
        if (this.height == null) {
            this.height = new Image$DoublePropertyImpl(this, "height");
        }
        return this.height;
    }

    public final boolean isPreserveRatio() {
        return this.preserveRatio;
    }

    public final boolean isSmooth() {
        return this.smooth;
    }

    public final boolean isBackgroundLoading() {
        return this.backgroundLoading;
    }

    private void setError(boolean bl2) {
        this.errorPropertyImpl().set(bl2);
    }

    public final boolean isError() {
        if (this.error == null) {
            return false;
        }
        return this.error.get();
    }

    public final ReadOnlyBooleanProperty errorProperty() {
        return this.errorPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper errorPropertyImpl() {
        if (this.error == null) {
            this.error = new ReadOnlyBooleanWrapper(this, "error");
        }
        return this.error;
    }

    private void setException(Exception exception) {
        this.exceptionPropertyImpl().set(exception);
    }

    public final Exception getException() {
        if (this.exception == null) {
            return null;
        }
        return (Exception)this.exception.get();
    }

    public final ReadOnlyObjectProperty<Exception> exceptionProperty() {
        return this.exceptionPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Exception> exceptionPropertyImpl() {
        if (this.exception == null) {
            this.exception = new ReadOnlyObjectWrapper(this, "exception");
        }
        return this.exception;
    }

    final Object getPlatformImage() {
        if (this.platformImage == null) {
            return null;
        }
        return this.platformImage.get();
    }

    final ReadOnlyObjectProperty<PlatformImage> acc_platformImageProperty() {
        return this.platformImagePropertyImpl();
    }

    private Image$ObjectPropertyImpl<PlatformImage> platformImagePropertyImpl() {
        if (this.platformImage == null) {
            this.platformImage = new Image$ObjectPropertyImpl(this, "platformImage");
        }
        return this.platformImage;
    }

    void pixelsDirty() {
        this.platformImagePropertyImpl().fireValueChangedEvent();
    }

    public Image(@NamedArg(value="url") String string) {
        this(Image.validateUrl(string), null, 0.0, 0.0, false, false, false);
        this.initialize(null);
    }

    public Image(@NamedArg(value="url") String string, @NamedArg(value="backgroundLoading") boolean bl2) {
        this(Image.validateUrl(string), null, 0.0, 0.0, false, false, bl2);
        this.initialize(null);
    }

    public Image(@NamedArg(value="url") String string, @NamedArg(value="requestedWidth") double d2, @NamedArg(value="requestedHeight") double d3, @NamedArg(value="preserveRatio") boolean bl2, @NamedArg(value="smooth") boolean bl3) {
        this(Image.validateUrl(string), null, d2, d3, bl2, bl3, false);
        this.initialize(null);
    }

    public Image(@NamedArg(value="url", defaultValue="\"\"") String string, @NamedArg(value="requestedWidth") double d2, @NamedArg(value="requestedHeight") double d3, @NamedArg(value="preserveRatio") boolean bl2, @NamedArg(value="smooth", defaultValue="true") boolean bl3, @NamedArg(value="backgroundLoading") boolean bl4) {
        this(Image.validateUrl(string), null, d2, d3, bl2, bl3, bl4);
        this.initialize(null);
    }

    public Image(@NamedArg(value="is") InputStream inputStream) {
        this(null, Image.validateInputStream(inputStream), 0.0, 0.0, false, false, false);
        this.initialize(null);
    }

    public Image(@NamedArg(value="is") InputStream inputStream, @NamedArg(value="requestedWidth") double d2, @NamedArg(value="requestedHeight") double d3, @NamedArg(value="preserveRatio") boolean bl2, @NamedArg(value="smooth") boolean bl3) {
        this(null, Image.validateInputStream(inputStream), d2, d3, bl2, bl3, false);
        this.initialize(null);
    }

    Image(int n2, int n3) {
        this(null, null, n2, n3, false, false, false);
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("Image dimensions must be positive (w,h > 0)");
        }
        this.initialize(Toolkit.getToolkit().createPlatformImage(n2, n3));
    }

    Image(PixelBuffer pixelBuffer) {
        this(null, null, pixelBuffer.getWidth(), pixelBuffer.getHeight(), false, false, false);
        this.initialize(pixelBuffer);
    }

    private Image(Object object) {
        this(null, null, 0.0, 0.0, false, false, false);
        this.initialize(object);
    }

    private Image(String string, InputStream inputStream, double d2, double d3, boolean bl2, boolean bl3, boolean bl4) {
        this.url = string;
        this.inputSource = inputStream;
        this.requestedWidth = d2;
        this.requestedHeight = d3;
        this.preserveRatio = bl2;
        this.smooth = bl3;
        this.backgroundLoading = bl4;
    }

    public void cancel() {
        if (this.backgroundTask != null) {
            this.backgroundTask.cancel();
        }
    }

    void dispose() {
        this.cancel();
        Platform.runLater(() -> {
            if (this.animation != null) {
                this.animation.stop();
            }
        });
    }

    private void initialize(Object object) {
        if (object != null) {
            object = Image.loadPlatformImage(object);
        } else {
            if (this.isBackgroundLoading() && this.inputSource == null) {
                this.loadInBackground();
                return;
            }
            object = this.inputSource != null ? Image.loadImage(this.inputSource, this.getRequestedWidth(), this.getRequestedHeight(), this.isPreserveRatio(), this.isSmooth()) : Image.loadImage(this.getUrl(), this.getRequestedWidth(), this.getRequestedHeight(), this.isPreserveRatio(), this.isSmooth());
        }
        this.finishImage((ImageLoader)object);
    }

    private void finishImage(ImageLoader imageLoader) {
        Object object = imageLoader.getException();
        if (object != null) {
            this.finishImage((Exception)object);
            return;
        }
        if (imageLoader.getFrameCount() > 1) {
            this.initializeAnimatedImage(imageLoader);
        } else {
            object = imageLoader.getFrame(0);
            double d2 = imageLoader.getWidth() / (double)object.getPixelScale();
            double d3 = imageLoader.getHeight() / (double)object.getPixelScale();
            this.setPlatformImageWH((PlatformImage)object, d2, d3);
        }
        this.setProgress(1.0);
    }

    private void finishImage(Exception exception) {
        this.setException(exception);
        this.setError(true);
        this.setPlatformImageWH(null, 0.0, 0.0);
        this.setProgress(1.0);
    }

    private void initializeAnimatedImage(ImageLoader imageLoader) {
        int n2 = imageLoader.getFrameCount();
        this.animFrames = new PlatformImage[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.animFrames[i2] = imageLoader.getFrame(i2);
        }
        PlatformImage platformImage = imageLoader.getFrame(0);
        double d2 = imageLoader.getWidth() / (double)platformImage.getPixelScale();
        double d3 = imageLoader.getHeight() / (double)platformImage.getPixelScale();
        this.setPlatformImageWH(platformImage, d2, d3);
        this.isAnimated = true;
        Platform.runLater(() -> {
            this.animation = new Image$Animation(this, imageLoader);
            this.animation.start();
        });
    }

    private void cycleTasks() {
        Queue<Image$ImageTask> queue = pendingTasks;
        synchronized (queue) {
            --runningTasks;
            Image$ImageTask image$ImageTask = pendingTasks.poll();
            if (image$ImageTask != null) {
                ++runningTasks;
                image$ImageTask.start();
            }
            return;
        }
    }

    private void loadInBackground() {
        this.backgroundTask = new Image$ImageTask(this);
        Queue<Image$ImageTask> queue = pendingTasks;
        synchronized (queue) {
            if (runningTasks >= 4) {
                pendingTasks.offer(this.backgroundTask);
            } else {
                ++runningTasks;
                this.backgroundTask.start();
            }
            return;
        }
    }

    static Image fromPlatformImage(Object object) {
        return new Image(object);
    }

    private void setPlatformImageWH(PlatformImage platformImage, double d2, double d3) {
        if (Toolkit.getImageAccessor().getPlatformImage(this) == platformImage && this.getWidth() == d2 && this.getHeight() == d3) {
            return;
        }
        Object object = Toolkit.getImageAccessor().getPlatformImage(this);
        double d4 = this.getWidth();
        double d5 = this.getHeight();
        this.storePlatformImageWH(platformImage, d2, d3);
        if (object != platformImage) {
            this.platformImagePropertyImpl().fireValueChangedEvent();
        }
        if (d4 != d2) {
            this.widthPropertyImpl().fireValueChangedEvent();
        }
        if (d5 != d3) {
            this.heightPropertyImpl().fireValueChangedEvent();
        }
    }

    private void storePlatformImageWH(PlatformImage platformImage, double d2, double d3) {
        this.platformImagePropertyImpl().store(platformImage);
        this.widthPropertyImpl().store(d2);
        this.heightPropertyImpl().store(d3);
    }

    void setPlatformImage(PlatformImage platformImage) {
        this.platformImage.set(platformImage);
    }

    private static ImageLoader loadImage(String string, double d2, double d3, boolean bl2, boolean bl3) {
        return Toolkit.getToolkit().loadImage(string, d2, d3, bl2, bl3);
    }

    private static ImageLoader loadImage(InputStream inputStream, double d2, double d3, boolean bl2, boolean bl3) {
        return Toolkit.getToolkit().loadImage(inputStream, d2, d3, bl2, bl3);
    }

    private static AsyncOperation loadImageAsync(AsyncOperationListener<? extends ImageLoader> asyncOperationListener, String string, double d2, double d3, boolean bl2, boolean bl3) {
        return Toolkit.getToolkit().loadImageAsync(asyncOperationListener, string, d2, d3, bl2, bl3);
    }

    private static ImageLoader loadPlatformImage(Object object) {
        return Toolkit.getToolkit().loadPlatformImage(object);
    }

    private static String validateUrl(String object) {
        if (object == null) {
            throw new NullPointerException("URL must not be null");
        }
        if (((String)object).trim().isEmpty()) {
            throw new IllegalArgumentException("URL must not be empty");
        }
        try {
            if (!URL_QUICKMATCH.matcher((CharSequence)object).matches()) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if ((object = ((String)object).charAt(0) == '/' ? classLoader.getResource(((String)object).substring(1)) : classLoader.getResource((String)object)) == null) {
                    throw new IllegalArgumentException("Invalid URL or resource not found");
                }
                return ((URL)object).toString();
            }
            if (DataURI.matchScheme((String)object)) {
                return object;
            }
            return new URL((String)object).toString();
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            throw new IllegalArgumentException(Image.constructDetailedExceptionMessage("Invalid URL", exception), exception);
        }
    }

    private static InputStream validateInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("Input stream must not be null");
        }
        return inputStream;
    }

    private static String constructDetailedExceptionMessage(String object, Throwable throwable) {
        while (throwable != null) {
            String string = throwable.getMessage();
            Object object2 = string != null ? (String)object + ": " + string : object;
            throwable = throwable.getCause();
            object = object2;
        }
        return object;
    }

    boolean isAnimation() {
        return this.isAnimated;
    }

    boolean pixelsReadable() {
        return this.getProgress() >= 1.0 && !this.isAnimation() && !this.isError();
    }

    public final PixelReader getPixelReader() {
        if (!this.pixelsReadable()) {
            return null;
        }
        if (this.reader == null) {
            this.reader = new Image$2(this);
        }
        return this.reader;
    }

    PlatformImage getWritablePlatformImage() {
        PlatformImage platformImage = this.platformImage.get();
        if (!platformImage.isWritable()) {
            platformImage = platformImage.promoteToWritableImage();
            this.platformImage.set(platformImage);
        }
        return platformImage;
    }

    static {
        Toolkit.setImageAccessor(new Image$1());
        URL_QUICKMATCH = Pattern.compile("^\\p{Alpha}[\\p{Alnum}+.-]*:.*$");
        runningTasks = 0;
        pendingTasks = new LinkedList<Image$ImageTask>();
    }
}

