/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.ImageViewHelper;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.sg.prism.NGImageView;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView$1;
import javafx.scene.image.ImageView$10;
import javafx.scene.image.ImageView$11;
import javafx.scene.image.ImageView$2;
import javafx.scene.image.ImageView$3;
import javafx.scene.image.ImageView$4;
import javafx.scene.image.ImageView$5;
import javafx.scene.image.ImageView$6;
import javafx.scene.image.ImageView$7;
import javafx.scene.image.ImageView$8;
import javafx.scene.image.ImageView$9;
import javafx.scene.image.ImageView$StyleableProperties;

@DefaultProperty(value="image")
public class ImageView
extends Node {
    private ObjectProperty<Image> image;
    private Image oldImage;
    private StringProperty imageUrl;
    private final AbstractNotifyListener platformImageChangeListener;
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty fitWidth;
    private DoubleProperty fitHeight;
    private BooleanProperty preserveRatio;
    private BooleanProperty smooth;
    public static final boolean SMOOTH_DEFAULT;
    private ObjectProperty<Rectangle2D> viewport;
    private double destWidth;
    private double destHeight;
    private boolean validWH;
    private static final String DEFAULT_STYLE_CLASS = "image-view";

    public ImageView() {
        ImageViewHelper.initHelper(this);
        this.imageUrl = null;
        this.platformImageChangeListener = new ImageView$4(this);
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setAccessibleRole(AccessibleRole.IMAGE_VIEW);
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
    }

    public ImageView(String string) {
        this(new Image(string));
    }

    public ImageView(Image image) {
        ImageViewHelper.initHelper(this);
        this.imageUrl = null;
        this.platformImageChangeListener = new ImageView$4(this);
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setAccessibleRole(AccessibleRole.IMAGE_VIEW);
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.setImage(image);
    }

    public final void setImage(Image image) {
        this.imageProperty().set(image);
    }

    public final Image getImage() {
        if (this.image == null) {
            return null;
        }
        return (Image)this.image.get();
    }

    public final ObjectProperty<Image> imageProperty() {
        if (this.image == null) {
            this.image = new ImageView$2(this);
        }
        return this.image;
    }

    private StringProperty imageUrlProperty() {
        if (this.imageUrl == null) {
            this.imageUrl = new ImageView$3(this);
        }
        return this.imageUrl;
    }

    public final void setX(double d2) {
        this.xProperty().set(d2);
    }

    public final double getX() {
        if (this.x == null) {
            return 0.0;
        }
        return this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new ImageView$5(this);
        }
        return this.x;
    }

    public final void setY(double d2) {
        this.yProperty().set(d2);
    }

    public final double getY() {
        if (this.y == null) {
            return 0.0;
        }
        return this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new ImageView$6(this);
        }
        return this.y;
    }

    public final void setFitWidth(double d2) {
        this.fitWidthProperty().set(d2);
    }

    public final double getFitWidth() {
        if (this.fitWidth == null) {
            return 0.0;
        }
        return this.fitWidth.get();
    }

    public final DoubleProperty fitWidthProperty() {
        if (this.fitWidth == null) {
            this.fitWidth = new ImageView$7(this);
        }
        return this.fitWidth;
    }

    public final void setFitHeight(double d2) {
        this.fitHeightProperty().set(d2);
    }

    public final double getFitHeight() {
        if (this.fitHeight == null) {
            return 0.0;
        }
        return this.fitHeight.get();
    }

    public final DoubleProperty fitHeightProperty() {
        if (this.fitHeight == null) {
            this.fitHeight = new ImageView$8(this);
        }
        return this.fitHeight;
    }

    public final void setPreserveRatio(boolean bl2) {
        this.preserveRatioProperty().set(bl2);
    }

    public final boolean isPreserveRatio() {
        if (this.preserveRatio == null) {
            return false;
        }
        return this.preserveRatio.get();
    }

    public final BooleanProperty preserveRatioProperty() {
        if (this.preserveRatio == null) {
            this.preserveRatio = new ImageView$9(this);
        }
        return this.preserveRatio;
    }

    public final void setSmooth(boolean bl2) {
        this.smoothProperty().set(bl2);
    }

    public final boolean isSmooth() {
        if (this.smooth == null) {
            return SMOOTH_DEFAULT;
        }
        return this.smooth.get();
    }

    public final BooleanProperty smoothProperty() {
        if (this.smooth == null) {
            this.smooth = new ImageView$10(this, SMOOTH_DEFAULT);
        }
        return this.smooth;
    }

    public final void setViewport(Rectangle2D rectangle2D) {
        this.viewportProperty().set(rectangle2D);
    }

    public final Rectangle2D getViewport() {
        if (this.viewport == null) {
            return null;
        }
        return (Rectangle2D)this.viewport.get();
    }

    public final ObjectProperty<Rectangle2D> viewportProperty() {
        if (this.viewport == null) {
            this.viewport = new ImageView$11(this);
        }
        return this.viewport;
    }

    private NGNode doCreatePeer() {
        return new NGImageView();
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        this.recomputeWidthHeight();
        BaseBounds baseBounds2 = baseBounds = baseBounds.deriveWithNewBounds((float)this.getX(), (float)this.getY(), 0.0f, (float)(this.getX() + this.destWidth), (float)(this.getY() + this.destHeight), 0.0f);
        baseBounds = baseTransform.transform(baseBounds2, baseBounds2);
        return baseBounds;
    }

    private void invalidateWidthHeight() {
        this.validWH = false;
    }

    private void recomputeWidthHeight() {
        if (this.validWH) {
            return;
        }
        Image image = this.getImage();
        Rectangle2D rectangle2D = this.getViewport();
        double d2 = 0.0;
        double d3 = 0.0;
        if (rectangle2D != null && rectangle2D.getWidth() > 0.0 && rectangle2D.getHeight() > 0.0) {
            d2 = rectangle2D.getWidth();
            d3 = rectangle2D.getHeight();
        } else if (image != null) {
            d2 = image.getWidth();
            d3 = image.getHeight();
        }
        double d4 = this.getFitWidth();
        double d5 = this.getFitHeight();
        if (this.isPreserveRatio() && d2 > 0.0 && d3 > 0.0 && (d4 > 0.0 || d5 > 0.0)) {
            if (d4 <= 0.0 || d5 > 0.0 && d4 * d3 > d5 * d2) {
                d2 = d2 * d5 / d3;
                d3 = d5;
            } else {
                d3 = d3 * d4 / d2;
                d2 = d4;
            }
        } else {
            if (d4 > 0.0) {
                d2 = d4;
            }
            if (d5 > 0.0) {
                d3 = d5;
            }
        }
        this.destWidth = d2;
        this.destHeight = d3;
        this.validWH = true;
    }

    private boolean doComputeContains(double d2, double d3) {
        if (this.getImage() == null) {
            return false;
        }
        this.recomputeWidthHeight();
        double d4 = d2 - this.getX();
        double d5 = d3 - this.getY();
        Image image = this.getImage();
        double d6 = image.getWidth();
        double d7 = image.getHeight();
        double d8 = d6;
        double d9 = d7;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        Rectangle2D rectangle2D = this.getViewport();
        if (rectangle2D != null) {
            d10 = rectangle2D.getWidth();
            d11 = rectangle2D.getHeight();
            d12 = rectangle2D.getMinX();
            d13 = rectangle2D.getMinY();
        }
        if (d10 > 0.0 && d11 > 0.0) {
            d8 = d10;
            d9 = d11;
        }
        d4 = d12 + d4 * d8 / this.destWidth;
        d5 = d13 + d5 * d9 / this.destHeight;
        if (d4 < 0.0 || d5 < 0.0 || d4 >= d6 || d5 >= d7 || d4 < d12 || d5 < d13 || d4 >= d12 + d8 || d5 >= d13 + d9) {
            return false;
        }
        return Toolkit.getToolkit().imageContains(Toolkit.getImageAccessor().getPlatformImage(image), (float)d4, (float)d5);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return ImageView$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ImageView.getClassCssMetaData();
    }

    void updateViewport() {
        this.recomputeWidthHeight();
        if (this.getImage() == null || Toolkit.getImageAccessor().getPlatformImage(this.getImage()) == null) {
            return;
        }
        Rectangle2D rectangle2D = this.getViewport();
        NGImageView nGImageView = (NGImageView)NodeHelper.getPeer(this);
        if (rectangle2D != null) {
            nGImageView.setViewport((float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight(), (float)this.destWidth, (float)this.destHeight);
            return;
        }
        nGImageView.setViewport(0.0f, 0.0f, 0.0f, 0.0f, (float)this.destWidth, (float)this.destHeight);
    }

    private void doUpdatePeer() {
        NGImageView nGImageView = (NGImageView)NodeHelper.getPeer(this);
        if (NodeHelper.isDirty(this, DirtyBits.NODE_GEOMETRY)) {
            nGImageView.setX((float)this.getX());
            nGImageView.setY((float)this.getY());
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_SMOOTH)) {
            nGImageView.setSmooth(this.isSmooth());
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_CONTENTS)) {
            nGImageView.setImage(this.getImage() != null ? Toolkit.getImageAccessor().getPlatformImage(this.getImage()) : null);
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_VIEWPORT) || NodeHelper.isDirty(this, DirtyBits.NODE_CONTENTS)) {
            this.updateViewport();
        }
    }

    static {
        ImageViewHelper.setImageViewAccessor(new ImageView$1());
        SMOOTH_DEFAULT = Toolkit.getToolkit().getDefaultImageSmooth();
    }
}

