/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.Toolkit;
import java.nio.Buffer;
import java.util.Objects;
import javafx.beans.NamedArg;
import javafx.scene.image.Image;
import javafx.scene.image.PixelBuffer;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage$1;
import javafx.scene.image.WritableImage$2;

public class WritableImage
extends Image {
    private ImageLoader tkImageLoader;
    private PixelBuffer<? extends Buffer> pixelBuffer = null;
    private PixelWriter writer;

    public WritableImage(@NamedArg(value="width") int n2, @NamedArg(value="height") int n3) {
        super(n2, n3);
    }

    public WritableImage(@NamedArg(value="PixelBuffer") PixelBuffer<? extends Buffer> pixelBuffer) {
        super(WritableImage.validatePixelBuffer(pixelBuffer));
        pixelBuffer.addImage(this);
        this.pixelBuffer = pixelBuffer;
    }

    public WritableImage(@NamedArg(value="reader") PixelReader pixelReader, @NamedArg(value="width") int n2, @NamedArg(value="height") int n3) {
        super(n2, n3);
        this.getPixelWriter().setPixels(0, 0, n2, n3, pixelReader, 0, 0);
    }

    public WritableImage(@NamedArg(value="reader") PixelReader pixelReader, @NamedArg(value="x") int n2, @NamedArg(value="y") int n3, @NamedArg(value="width") int n4, @NamedArg(value="height") int n5) {
        super(n4, n5);
        this.getPixelWriter().setPixels(0, 0, n4, n5, pixelReader, n2, n3);
    }

    @Override
    boolean isAnimation() {
        return true;
    }

    @Override
    boolean pixelsReadable() {
        return true;
    }

    void bufferDirty(Rectangle rectangle) {
        this.getWritablePlatformImage().bufferDirty(rectangle);
        this.pixelsDirty();
    }

    private static PixelBuffer<? extends Buffer> validatePixelBuffer(PixelBuffer<? extends Buffer> pixelBuffer) {
        return Objects.requireNonNull(pixelBuffer, "pixelBuffer must not be null.");
    }

    public final PixelWriter getPixelWriter() {
        if (this.pixelBuffer != null) {
            throw new UnsupportedOperationException("PixelWriter is not supported with PixelBuffer");
        }
        if (this.getProgress() < 1.0 || this.isError()) {
            return null;
        }
        if (this.writer == null) {
            this.writer = new WritableImage$2(this);
        }
        return this.writer;
    }

    private void loadTkImage(Object object) {
        if (!(object instanceof ImageLoader)) {
            throw new IllegalArgumentException("Unrecognized image loader: " + String.valueOf(object));
        }
        if ((object = (ImageLoader)object).getWidth() != (double)((int)this.getWidth()) || object.getHeight() != (double)((int)this.getHeight())) {
            throw new IllegalArgumentException("Size of loader does not match size of image");
        }
        super.setPlatformImage(object.getFrame(0));
        this.tkImageLoader = object;
    }

    private Object getTkImageLoader() {
        return this.tkImageLoader;
    }

    static {
        Toolkit.setWritableImageAccessor(new WritableImage$1());
    }
}

