/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Locale;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination$1;
import javafx.scene.input.KeyCombination$Modifier;
import javafx.scene.input.KeyCombination$ModifierValue;
import javafx.scene.input.KeyEvent;

public abstract class KeyCombination {
    public static final KeyCombination$Modifier SHIFT_DOWN = new KeyCombination$Modifier(KeyCode.SHIFT, KeyCombination$ModifierValue.DOWN);
    public static final KeyCombination$Modifier SHIFT_ANY = new KeyCombination$Modifier(KeyCode.SHIFT, KeyCombination$ModifierValue.ANY);
    public static final KeyCombination$Modifier CONTROL_DOWN = new KeyCombination$Modifier(KeyCode.CONTROL, KeyCombination$ModifierValue.DOWN);
    public static final KeyCombination$Modifier CONTROL_ANY = new KeyCombination$Modifier(KeyCode.CONTROL, KeyCombination$ModifierValue.ANY);
    public static final KeyCombination$Modifier ALT_DOWN = new KeyCombination$Modifier(KeyCode.ALT, KeyCombination$ModifierValue.DOWN);
    public static final KeyCombination$Modifier ALT_ANY = new KeyCombination$Modifier(KeyCode.ALT, KeyCombination$ModifierValue.ANY);
    public static final KeyCombination$Modifier META_DOWN = new KeyCombination$Modifier(KeyCode.META, KeyCombination$ModifierValue.DOWN);
    public static final KeyCombination$Modifier META_ANY = new KeyCombination$Modifier(KeyCode.META, KeyCombination$ModifierValue.ANY);
    public static final KeyCombination$Modifier SHORTCUT_DOWN = new KeyCombination$Modifier(KeyCode.SHORTCUT, KeyCombination$ModifierValue.DOWN);
    public static final KeyCombination$Modifier SHORTCUT_ANY = new KeyCombination$Modifier(KeyCode.SHORTCUT, KeyCombination$ModifierValue.ANY);
    private static final KeyCombination$Modifier[] POSSIBLE_MODIFIERS = new KeyCombination$Modifier[]{SHIFT_DOWN, SHIFT_ANY, CONTROL_DOWN, CONTROL_ANY, ALT_DOWN, ALT_ANY, META_DOWN, META_ANY, SHORTCUT_DOWN, SHORTCUT_ANY};
    public static final KeyCombination NO_MATCH = new KeyCombination$1(new KeyCombination$Modifier[0]);
    private final KeyCombination$ModifierValue shift;
    private final KeyCombination$ModifierValue control;
    private final KeyCombination$ModifierValue alt;
    private final KeyCombination$ModifierValue meta;
    private final KeyCombination$ModifierValue shortcut;

    public final KeyCombination$ModifierValue getShift() {
        return this.shift;
    }

    public final KeyCombination$ModifierValue getControl() {
        return this.control;
    }

    public final KeyCombination$ModifierValue getAlt() {
        return this.alt;
    }

    public final KeyCombination$ModifierValue getMeta() {
        return this.meta;
    }

    public final KeyCombination$ModifierValue getShortcut() {
        return this.shortcut;
    }

    protected KeyCombination(KeyCombination$ModifierValue keyCombination$ModifierValue, KeyCombination$ModifierValue keyCombination$ModifierValue2, KeyCombination$ModifierValue keyCombination$ModifierValue3, KeyCombination$ModifierValue keyCombination$ModifierValue4, KeyCombination$ModifierValue keyCombination$ModifierValue5) {
        if (keyCombination$ModifierValue == null || keyCombination$ModifierValue2 == null || keyCombination$ModifierValue3 == null || keyCombination$ModifierValue4 == null || keyCombination$ModifierValue5 == null) {
            throw new NullPointerException("Modifier value must not be null!");
        }
        this.shift = keyCombination$ModifierValue;
        this.control = keyCombination$ModifierValue2;
        this.alt = keyCombination$ModifierValue3;
        this.meta = keyCombination$ModifierValue4;
        this.shortcut = keyCombination$ModifierValue5;
    }

    protected KeyCombination(KeyCombination$Modifier ... keyCombination$ModifierArray) {
        this(KeyCombination.getModifierValue(keyCombination$ModifierArray, KeyCode.SHIFT), KeyCombination.getModifierValue(keyCombination$ModifierArray, KeyCode.CONTROL), KeyCombination.getModifierValue(keyCombination$ModifierArray, KeyCode.ALT), KeyCombination.getModifierValue(keyCombination$ModifierArray, KeyCode.META), KeyCombination.getModifierValue(keyCombination$ModifierArray, KeyCode.SHORTCUT));
    }

    public boolean match(KeyEvent keyEvent) {
        KeyCode keyCode = Toolkit.getToolkit().getPlatformShortcutKey();
        return KeyCombination.test(KeyCode.SHIFT, this.shift, keyCode, this.shortcut, keyEvent.isShiftDown()) && KeyCombination.test(KeyCode.CONTROL, this.control, keyCode, this.shortcut, keyEvent.isControlDown()) && KeyCombination.test(KeyCode.ALT, this.alt, keyCode, this.shortcut, keyEvent.isAltDown()) && KeyCombination.test(KeyCode.META, this.meta, keyCode, this.shortcut, keyEvent.isMetaDown());
    }

    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        this.addModifiersIntoString(stringBuilder);
        return stringBuilder.toString();
    }

    public String getDisplayText() {
        StringBuilder stringBuilder = new StringBuilder();
        if (PlatformUtil.isMac()) {
            if (this.getControl() == KeyCombination$ModifierValue.DOWN) {
                stringBuilder.append("\u2303");
            }
            if (this.getAlt() == KeyCombination$ModifierValue.DOWN) {
                stringBuilder.append("\u2325");
            }
            if (this.getShift() == KeyCombination$ModifierValue.DOWN) {
                stringBuilder.append("\u21e7");
            }
            if (this.getMeta() == KeyCombination$ModifierValue.DOWN || this.getShortcut() == KeyCombination$ModifierValue.DOWN) {
                stringBuilder.append("\u2318");
            }
        } else {
            if (this.getControl() == KeyCombination$ModifierValue.DOWN || this.getShortcut() == KeyCombination$ModifierValue.DOWN) {
                stringBuilder.append("Ctrl+");
            }
            if (this.getAlt() == KeyCombination$ModifierValue.DOWN) {
                stringBuilder.append("Alt+");
            }
            if (this.getShift() == KeyCombination$ModifierValue.DOWN) {
                stringBuilder.append("Shift+");
            }
            if (this.getMeta() == KeyCombination$ModifierValue.DOWN) {
                stringBuilder.append("Meta+");
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeyCombination)) {
            return false;
        }
        object = (KeyCombination)object;
        return this.shift == ((KeyCombination)object).shift && this.control == ((KeyCombination)object).control && this.alt == ((KeyCombination)object).alt && this.meta == ((KeyCombination)object).meta && this.shortcut == ((KeyCombination)object).shortcut;
    }

    public int hashCode() {
        int n2 = 161 + this.shift.hashCode();
        n2 = n2 * 23 + this.control.hashCode();
        n2 = n2 * 23 + this.alt.hashCode();
        n2 = n2 * 23 + this.meta.hashCode();
        n2 = n2 * 23 + this.shortcut.hashCode();
        return n2;
    }

    public String toString() {
        return this.getName();
    }

    public static KeyCombination valueOf(String string) {
        ArrayList<KeyCombination$Modifier> arrayList = new ArrayList<KeyCombination$Modifier>(4);
        Object[] objectArray = KeyCombination.splitName(string);
        KeyCode keyCode = null;
        String string2 = null;
        for (String string3 : objectArray) {
            String string4;
            KeyCombination$Modifier keyCombination$Modifier;
            if (string3.length() > 2 && string3.charAt(0) == '\'') {
                String string5 = string3;
                if (string5.charAt(string5.length() - 1) == '\'') {
                    if (keyCode != null || string2 != null) {
                        throw new IllegalArgumentException("Cannot parse key binding " + string);
                    }
                    string2 = string3.substring(1, string3.length() - 1).replace("\\'", "'");
                    continue;
                }
            }
            if ((keyCombination$Modifier = KeyCombination.getModifier(string4 = KeyCombination.normalizeToken(string3))) != null) {
                arrayList.add(keyCombination$Modifier);
                continue;
            }
            if (keyCode != null || string2 != null) {
                throw new IllegalArgumentException("Cannot parse key binding " + string);
            }
            keyCode = KeyCode.getKeyCode(string4);
            if (keyCode != null) continue;
            string2 = string3;
        }
        if (keyCode == null && string2 == null) {
            throw new IllegalArgumentException("Cannot parse key binding " + string);
        }
        ArrayList<KeyCombination$Modifier> arrayList2 = arrayList;
        objectArray = arrayList2.toArray(new KeyCombination$Modifier[arrayList2.size()]);
        if (keyCode != null) {
            return new KeyCodeCombination(keyCode, (KeyCombination$Modifier[])objectArray);
        }
        return new KeyCharacterCombination(string2, (KeyCombination$Modifier[])objectArray);
    }

    public static KeyCombination keyCombination(String string) {
        return KeyCombination.valueOf(string);
    }

    private void addModifiersIntoString(StringBuilder stringBuilder) {
        KeyCombination.addModifierIntoString(stringBuilder, KeyCode.SHIFT, this.shift);
        KeyCombination.addModifierIntoString(stringBuilder, KeyCode.CONTROL, this.control);
        KeyCombination.addModifierIntoString(stringBuilder, KeyCode.ALT, this.alt);
        KeyCombination.addModifierIntoString(stringBuilder, KeyCode.META, this.meta);
        KeyCombination.addModifierIntoString(stringBuilder, KeyCode.SHORTCUT, this.shortcut);
    }

    private static void addModifierIntoString(StringBuilder stringBuilder, KeyCode keyCode, KeyCombination$ModifierValue keyCombination$ModifierValue) {
        if (keyCombination$ModifierValue == KeyCombination$ModifierValue.UP) {
            return;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("+");
        }
        if (keyCombination$ModifierValue == KeyCombination$ModifierValue.ANY) {
            stringBuilder.append("Ignore ");
        }
        stringBuilder.append(keyCode.getName());
    }

    private static boolean test(KeyCode enum_, KeyCombination$ModifierValue keyCombination$ModifierValue, KeyCode keyCode, KeyCombination$ModifierValue keyCombination$ModifierValue2, boolean bl2) {
        enum_ = enum_ == keyCode ? KeyCombination.resolveModifierValue(keyCombination$ModifierValue, keyCombination$ModifierValue2) : keyCombination$ModifierValue;
        return KeyCombination.test((KeyCombination$ModifierValue)enum_, bl2);
    }

    private static boolean test(KeyCombination$ModifierValue keyCombination$ModifierValue, boolean bl2) {
        switch (keyCombination$ModifierValue) {
            case DOWN: {
                return bl2;
            }
            case UP: {
                return !bl2;
            }
        }
        return true;
    }

    private static KeyCombination$ModifierValue resolveModifierValue(KeyCombination$ModifierValue keyCombination$ModifierValue, KeyCombination$ModifierValue keyCombination$ModifierValue2) {
        if (keyCombination$ModifierValue == KeyCombination$ModifierValue.DOWN || keyCombination$ModifierValue2 == KeyCombination$ModifierValue.DOWN) {
            return KeyCombination$ModifierValue.DOWN;
        }
        if (keyCombination$ModifierValue == KeyCombination$ModifierValue.ANY || keyCombination$ModifierValue2 == KeyCombination$ModifierValue.ANY) {
            return KeyCombination$ModifierValue.ANY;
        }
        return KeyCombination$ModifierValue.UP;
    }

    static KeyCombination$Modifier getModifier(String string) {
        KeyCombination$Modifier[] keyCombination$ModifierArray = POSSIBLE_MODIFIERS;
        int n2 = POSSIBLE_MODIFIERS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            KeyCombination$Modifier keyCombination$Modifier = keyCombination$ModifierArray[i2];
            if (!keyCombination$Modifier.toString().equals(string)) continue;
            return keyCombination$Modifier;
        }
        return null;
    }

    private static KeyCombination$ModifierValue getModifierValue(KeyCombination$Modifier[] keyCombination$ModifierArray, KeyCode keyCode) {
        KeyCombination$ModifierValue keyCombination$ModifierValue = KeyCombination$ModifierValue.UP;
        for (KeyCombination$Modifier keyCombination$Modifier : keyCombination$ModifierArray) {
            if (keyCombination$Modifier == null) {
                throw new NullPointerException("Modifier must not be null!");
            }
            if (keyCombination$Modifier.getKey() != keyCode) continue;
            if (keyCombination$ModifierValue != KeyCombination$ModifierValue.UP) {
                throw new IllegalArgumentException(keyCombination$Modifier.getValue() != keyCombination$ModifierValue ? "Conflicting modifiers specified!" : "Duplicate modifiers specified!");
            }
            keyCombination$ModifierValue = keyCombination$Modifier.getValue();
        }
        return keyCombination$ModifierValue;
    }

    private static String normalizeToken(String stringArray) {
        stringArray = stringArray.split("\\s+");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string.substring(0, 1).toUpperCase(Locale.ROOT));
            stringBuilder.append(string.substring(1).toLowerCase(Locale.ROOT));
        }
        return stringBuilder.toString();
    }

    private static String[] splitName(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = string.trim().toCharArray();
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        block24: for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            switch (n2) {
                case 0: {
                    switch (c2) {
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            n4 = i2;
                            n2 = 1;
                            continue block24;
                        }
                        case '+': {
                            n4 = i2;
                            n2 = 2;
                            continue block24;
                        }
                        case '\'': {
                            if (i2 != 0 && cArray[i2 - 1] == '\\') continue block24;
                            n2 = 3;
                            continue block24;
                        }
                    }
                    continue block24;
                }
                case 1: {
                    switch (c2) {
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block24;
                        }
                        case '+': {
                            n2 = 2;
                            continue block24;
                        }
                        case '\'': {
                            n2 = 3;
                            n4 = -1;
                            continue block24;
                        }
                    }
                    n2 = 0;
                    n4 = -1;
                    continue block24;
                }
                case 2: {
                    switch (c2) {
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block24;
                        }
                        case '+': {
                            throw new IllegalArgumentException("Cannot parse key binding " + string);
                        }
                    }
                    if (n4 <= n3) {
                        throw new IllegalArgumentException("Cannot parse key binding " + string);
                    }
                    arrayList.add(new String(cArray, n3, n4 - n3));
                    n3 = i2;
                    n4 = -1;
                    n2 = c2 == '\'' ? 3 : 0;
                    continue block24;
                }
                case 3: {
                    if (c2 != '\'' || cArray[i2 - 1] == '\\') continue block24;
                    n2 = 0;
                }
            }
        }
        switch (n2) {
            case 0: 
            case 1: {
                arrayList.add(new String(cArray, n3, cArray.length - n3));
                break;
            }
            case 2: 
            case 3: {
                throw new IllegalArgumentException("Cannot parse key binding " + string);
            }
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }
}

