/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import java.util.Collections;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.InputEvent;
import javafx.scene.input.TouchPoint;

public final class TouchEvent
extends InputEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<TouchEvent> ANY = new EventType<InputEvent>(InputEvent.ANY, "TOUCH");
    public static final EventType<TouchEvent> TOUCH_PRESSED = new EventType<TouchEvent>(ANY, "TOUCH_PRESSED");
    public static final EventType<TouchEvent> TOUCH_MOVED = new EventType<TouchEvent>(ANY, "TOUCH_MOVED");
    public static final EventType<TouchEvent> TOUCH_RELEASED = new EventType<TouchEvent>(ANY, "TOUCH_RELEASED");
    public static final EventType<TouchEvent> TOUCH_STATIONARY = new EventType<TouchEvent>(ANY, "TOUCH_STATIONARY");
    private final int eventSetId;
    private final boolean shiftDown;
    private final boolean controlDown;
    private final boolean altDown;
    private final boolean metaDown;
    private final TouchPoint touchPoint;
    private final List<TouchPoint> touchPoints;

    public TouchEvent(@NamedArg(value="source") Object object, @NamedArg(value="target") EventTarget eventTarget, @NamedArg(value="eventType") EventType<TouchEvent> eventType, @NamedArg(value="touchPoint") TouchPoint touchPoint, @NamedArg(value="touchPoints") List<TouchPoint> list, @NamedArg(value="eventSetId") int n2, @NamedArg(value="shiftDown") boolean bl2, @NamedArg(value="controlDown") boolean bl3, @NamedArg(value="altDown") boolean bl4, @NamedArg(value="metaDown") boolean bl5) {
        super(object, eventTarget, (EventType<? extends InputEvent>)eventType);
        this.touchPoints = list != null ? Collections.unmodifiableList(list) : null;
        this.eventSetId = n2;
        this.shiftDown = bl2;
        this.controlDown = bl3;
        this.altDown = bl4;
        this.metaDown = bl5;
        this.touchPoint = touchPoint;
    }

    public TouchEvent(@NamedArg(value="eventType") EventType<TouchEvent> eventType, @NamedArg(value="touchPoint") TouchPoint touchPoint, @NamedArg(value="touchPoints") List<TouchPoint> list, @NamedArg(value="eventSetId") int n2, @NamedArg(value="shiftDown") boolean bl2, @NamedArg(value="controlDown") boolean bl3, @NamedArg(value="altDown") boolean bl4, @NamedArg(value="metaDown") boolean bl5) {
        this(null, null, eventType, touchPoint, list, n2, bl2, bl3, bl4, bl5);
    }

    public final int getTouchCount() {
        return this.touchPoints.size();
    }

    private static void recomputeToSource(TouchEvent object, Object object2, Object object3) {
        for (TouchPoint touchPoint : ((TouchEvent)object).touchPoints) {
            touchPoint.recomputeToSource(object2, object3);
        }
    }

    @Override
    public final TouchEvent copyFor(Object object, EventTarget object2) {
        object2 = (TouchEvent)super.copyFor(object, (EventTarget)object2);
        TouchEvent.recomputeToSource((TouchEvent)object2, this.getSource(), object);
        return object2;
    }

    public final TouchEvent copyFor(Object object, EventTarget eventTarget, EventType<TouchEvent> eventType) {
        object = this.copyFor(object, eventTarget);
        v0.eventType = eventType;
        return object;
    }

    public final EventType<TouchEvent> getEventType() {
        return super.getEventType();
    }

    public final int getEventSetId() {
        return this.eventSetId;
    }

    public final boolean isShiftDown() {
        return this.shiftDown;
    }

    public final boolean isControlDown() {
        return this.controlDown;
    }

    public final boolean isAltDown() {
        return this.altDown;
    }

    public final boolean isMetaDown() {
        return this.metaDown;
    }

    public final TouchPoint getTouchPoint() {
        return this.touchPoint;
    }

    public final List<TouchPoint> getTouchPoints() {
        return this.touchPoints;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("TouchEvent [");
        stringBuilder.append("source = ").append(this.getSource());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", eventType = ").append(((Event)this).getEventType());
        stringBuilder.append(", consumed = ").append(this.isConsumed());
        stringBuilder.append(", touchCount = ").append(this.getTouchCount());
        stringBuilder.append(", eventSetId = ").append(this.getEventSetId());
        stringBuilder.append(", touchPoint = ").append(this.getTouchPoint().toString());
        return stringBuilder.append("]").toString();
    }
}

