/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.geom.Vec2d;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane$BorderPositionProperty;
import javafx.scene.layout.Pane;

public class BorderPane
extends Pane {
    private static final String MARGIN = "borderpane-margin";
    private static final String ALIGNMENT = "borderpane-alignment";
    private ObjectProperty<Node> center;
    private ObjectProperty<Node> top;
    private ObjectProperty<Node> bottom;
    private ObjectProperty<Node> left;
    private ObjectProperty<Node> right;

    public static void setAlignment(Node node, Pos pos) {
        BorderPane.setConstraint(node, ALIGNMENT, (Object)pos);
    }

    public static Pos getAlignment(Node node) {
        return (Pos)((Object)BorderPane.getConstraint(node, ALIGNMENT));
    }

    public static void setMargin(Node node, Insets insets) {
        BorderPane.setConstraint(node, MARGIN, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)BorderPane.getConstraint(node, MARGIN);
    }

    private static Insets getNodeMargin(Node object) {
        if ((object = BorderPane.getMargin((Node)object)) != null) {
            return object;
        }
        return Insets.EMPTY;
    }

    public static void clearConstraints(Node node) {
        BorderPane.setAlignment(node, null);
        BorderPane.setMargin(node, null);
    }

    public BorderPane() {
    }

    public BorderPane(Node node) {
        this.setCenter(node);
    }

    public BorderPane(Node node, Node node2, Node node3, Node node4, Node node5) {
        this.setCenter(node);
        this.setTop(node2);
        this.setRight(node3);
        this.setBottom(node4);
        this.setLeft(node5);
    }

    public final ObjectProperty<Node> centerProperty() {
        if (this.center == null) {
            this.center = new BorderPane$BorderPositionProperty(this, "center");
        }
        return this.center;
    }

    public final void setCenter(Node node) {
        this.centerProperty().set(node);
    }

    public final Node getCenter() {
        if (this.center == null) {
            return null;
        }
        return (Node)this.center.get();
    }

    public final ObjectProperty<Node> topProperty() {
        if (this.top == null) {
            this.top = new BorderPane$BorderPositionProperty(this, "top");
        }
        return this.top;
    }

    public final void setTop(Node node) {
        this.topProperty().set(node);
    }

    public final Node getTop() {
        if (this.top == null) {
            return null;
        }
        return (Node)this.top.get();
    }

    public final ObjectProperty<Node> bottomProperty() {
        if (this.bottom == null) {
            this.bottom = new BorderPane$BorderPositionProperty(this, "bottom");
        }
        return this.bottom;
    }

    public final void setBottom(Node node) {
        this.bottomProperty().set(node);
    }

    public final Node getBottom() {
        if (this.bottom == null) {
            return null;
        }
        return (Node)this.bottom.get();
    }

    public final ObjectProperty<Node> leftProperty() {
        if (this.left == null) {
            this.left = new BorderPane$BorderPositionProperty(this, "left");
        }
        return this.left;
    }

    public final void setLeft(Node node) {
        this.leftProperty().set(node);
    }

    public final Node getLeft() {
        if (this.left == null) {
            return null;
        }
        return (Node)this.left.get();
    }

    public final ObjectProperty<Node> rightProperty() {
        if (this.right == null) {
            this.right = new BorderPane$BorderPositionProperty(this, "right");
        }
        return this.right;
    }

    public final void setRight(Node node) {
        this.rightProperty().set(node);
    }

    public final Node getRight() {
        if (this.right == null) {
            return null;
        }
        return (Node)this.right.get();
    }

    @Override
    public Orientation getContentBias() {
        Node node = this.getCenter();
        if (node != null && node.isManaged() && node.getContentBias() != null) {
            return node.getContentBias();
        }
        node = this.getRight();
        if (node != null && node.isManaged() && node.getContentBias() == Orientation.VERTICAL) {
            return node.getContentBias();
        }
        node = this.getLeft();
        if (node != null && node.isManaged() && node.getContentBias() == Orientation.VERTICAL) {
            return node.getContentBias();
        }
        node = this.getBottom();
        if (node != null && node.isManaged() && node.getContentBias() == Orientation.HORIZONTAL) {
            return node.getContentBias();
        }
        node = this.getTop();
        if (node != null && node.isManaged() && node.getContentBias() == Orientation.HORIZONTAL) {
            return node.getContentBias();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected double computeMinWidth(double var1_1) {
        v0 = this;
        var3_2 = v0.getAreaWidth(v0.getTop(), -1.0, true);
        v1 = this;
        var5_3 = v1.getAreaWidth(v1.getBottom(), -1.0, true);
        if (var1_1 == -1.0) ** GOTO lbl-1000
        v2 = this;
        if (v2.childHasContentBias(v2.getLeft(), Orientation.VERTICAL)) ** GOTO lbl-1000
        v3 = this;
        if (v3.childHasContentBias(v3.getRight(), Orientation.VERTICAL)) ** GOTO lbl-1000
        v4 = this;
        if (v4.childHasContentBias(v4.getCenter(), Orientation.VERTICAL)) lbl-1000:
        // 3 sources

        {
            v5 = this;
            var13_4 = v5.getAreaHeight(v5.getTop(), -1.0, false);
            v6 = this;
            var15_6 = v6.getAreaHeight(v6.getBottom(), -1.0, false);
            var17_7 = Math.max(0.0, var1_1 - var13_4 - var15_6);
            v7 = this;
            var7_8 = v7.getAreaWidth(v7.getLeft(), var17_7, false);
            v8 = this;
            var9_9 = v8.getAreaWidth(v8.getRight(), var17_7, false);
            v9 = this;
            var11_10 = v9.getAreaWidth(v9.getCenter(), var17_7, true);
        } else lbl-1000:
        // 2 sources

        {
            v10 = this;
            var7_8 = v10.getAreaWidth(v10.getLeft(), -1.0, false);
            v11 = this;
            var9_9 = v11.getAreaWidth(v11.getRight(), -1.0, false);
            v12 = this;
            var11_10 = v12.getAreaWidth(v12.getCenter(), -1.0, true);
        }
        var13_5 = this.getInsets();
        return var13_5.getLeft() + Math.max(var7_8 + var11_10 + var9_9, Math.max(var3_2, var5_3)) + var13_5.getRight();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected double computeMinHeight(double var1_1) {
        var3_2 = this.getInsets();
        v0 = this;
        var4_3 = v0.getAreaHeight(v0.getTop(), var1_1, false);
        v1 = this;
        var6_4 = v1.getAreaHeight(v1.getBottom(), var1_1, false);
        v2 = this;
        var8_5 = v2.getAreaHeight(v2.getLeft(), -1.0, true);
        v3 = this;
        var10_6 = v3.getAreaHeight(v3.getRight(), -1.0, true);
        if (var1_1 == -1.0) ** GOTO lbl-1000
        v4 = this;
        if (v4.childHasContentBias(v4.getCenter(), Orientation.HORIZONTAL)) {
            v5 = this;
            var14_7 = v5.getAreaWidth(v5.getLeft(), -1.0, false);
            v6 = this;
            var16_8 = v6.getAreaWidth(v6.getRight(), -1.0, false);
            v7 = this;
            var12_9 = v7.getAreaHeight(v7.getCenter(), Math.max(0.0, var1_1 - var14_7 - var16_8), true);
        } else lbl-1000:
        // 2 sources

        {
            v8 = this;
            var12_9 = v8.getAreaHeight(v8.getCenter(), -1.0, true);
        }
        var14_7 = Math.max(var12_9, Math.max(var10_6, var8_5));
        return var3_2.getTop() + var4_3 + var14_7 + var6_4 + var3_2.getBottom();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected double computePrefWidth(double var1_1) {
        v0 = this;
        var3_2 = v0.getAreaWidth(v0.getTop(), -1.0, false);
        v1 = this;
        var5_3 = v1.getAreaWidth(v1.getBottom(), -1.0, false);
        if (var1_1 == -1.0) ** GOTO lbl-1000
        v2 = this;
        if (v2.childHasContentBias(v2.getLeft(), Orientation.VERTICAL)) ** GOTO lbl-1000
        v3 = this;
        if (v3.childHasContentBias(v3.getRight(), Orientation.VERTICAL)) ** GOTO lbl-1000
        v4 = this;
        if (v4.childHasContentBias(v4.getCenter(), Orientation.VERTICAL)) lbl-1000:
        // 3 sources

        {
            v5 = this;
            var13_4 = v5.getAreaHeight(v5.getTop(), -1.0, false);
            v6 = this;
            var15_6 = v6.getAreaHeight(v6.getBottom(), -1.0, false);
            var17_7 = Math.max(0.0, var1_1 - var13_4 - var15_6);
            v7 = this;
            var7_8 = v7.getAreaWidth(v7.getLeft(), var17_7, false);
            v8 = this;
            var9_9 = v8.getAreaWidth(v8.getRight(), var17_7, false);
            v9 = this;
            var11_10 = v9.getAreaWidth(v9.getCenter(), var17_7, false);
        } else lbl-1000:
        // 2 sources

        {
            v10 = this;
            var7_8 = v10.getAreaWidth(v10.getLeft(), -1.0, false);
            v11 = this;
            var9_9 = v11.getAreaWidth(v11.getRight(), -1.0, false);
            v12 = this;
            var11_10 = v12.getAreaWidth(v12.getCenter(), -1.0, false);
        }
        var13_5 = this.getInsets();
        return var13_5.getLeft() + Math.max(var7_8 + var11_10 + var9_9, Math.max(var3_2, var5_3)) + var13_5.getRight();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected double computePrefHeight(double var1_1) {
        var3_2 = this.getInsets();
        v0 = this;
        var4_3 = v0.getAreaHeight(v0.getTop(), var1_1, false);
        v1 = this;
        var6_4 = v1.getAreaHeight(v1.getBottom(), var1_1, false);
        v2 = this;
        var8_5 = v2.getAreaHeight(v2.getLeft(), -1.0, false);
        v3 = this;
        var10_6 = v3.getAreaHeight(v3.getRight(), -1.0, false);
        if (var1_1 == -1.0) ** GOTO lbl-1000
        v4 = this;
        if (v4.childHasContentBias(v4.getCenter(), Orientation.HORIZONTAL)) {
            v5 = this;
            var14_7 = v5.getAreaWidth(v5.getLeft(), -1.0, false);
            v6 = this;
            var16_8 = v6.getAreaWidth(v6.getRight(), -1.0, false);
            v7 = this;
            var12_9 = v7.getAreaHeight(v7.getCenter(), Math.max(0.0, var1_1 - var14_7 - var16_8), false);
        } else lbl-1000:
        // 2 sources

        {
            v8 = this;
            var12_9 = v8.getAreaHeight(v8.getCenter(), -1.0, false);
        }
        var14_7 = Math.max(var12_9, Math.max(var10_6, var8_5));
        return var3_2.getTop() + var4_3 + var14_7 + var6_4 + var3_2.getBottom();
    }

    @Override
    protected void layoutChildren() {
        Object object;
        double d2;
        double d3;
        double d4;
        Object object2 = this.getInsets();
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        Orientation orientation = ((Node)this).getContentBias();
        if (orientation == null) {
            d4 = ((Node)this).minWidth(-1.0);
            d3 = ((Node)this).minHeight(-1.0);
            d5 = d5 < d4 ? d4 : d5;
            d6 = d6 < d3 ? d3 : d6;
        } else if (orientation == Orientation.HORIZONTAL) {
            d4 = ((Node)this).minWidth(-1.0);
            d5 = d5 < d4 ? d4 : d5;
            d3 = ((Node)this).minHeight(d5);
            d6 = d6 < d3 ? d3 : d6;
        } else {
            d4 = ((Node)this).minHeight(-1.0);
            d6 = d6 < d4 ? d4 : d6;
            d3 = ((Node)this).minWidth(d6);
            d5 = d5 < d3 ? d3 : d5;
        }
        d4 = ((Insets)object2).getLeft();
        d3 = ((Insets)object2).getTop();
        double d7 = d5 - d4 - ((Insets)object2).getRight();
        double d8 = d6 - d3 - ((Insets)object2).getBottom();
        object2 = this.getCenter();
        Node node = this.getRight();
        Object object3 = this.getBottom();
        Node node2 = this.getLeft();
        Node node3 = this.getTop();
        double d9 = 0.0;
        if (node3 != null && node3.isManaged()) {
            Insets insets = BorderPane.getNodeMargin(node3);
            double d10 = this.adjustWidthByMargin(d7, insets);
            d2 = this.adjustHeightByMargin(d8, insets);
            d9 = this.snapSizeY(node3.prefHeight(d10));
            d9 = Math.min(d9, d2);
            Vec2d vec2d = BorderPane.boundedNodeSizeWithBias(node3, d10, d9, true, true, TEMP_VEC2D);
            d9 = this.snapSizeY(vec2d.y);
            node3.resize(this.snapSizeX(vec2d.x), d9);
            d9 = this.snapSpaceY(insets.getBottom()) + d9 + this.snapSpaceY(insets.getTop());
            object = BorderPane.getAlignment(node3);
            BorderPane.positionInArea(node3, d4, d3, d7, d9, 0.0, insets, object != null ? ((Pos)((Object)object)).getHpos() : HPos.LEFT, object != null ? ((Pos)((Object)object)).getVpos() : VPos.TOP, this.isSnapToPixel());
        }
        double d11 = 0.0;
        if (object3 != null && ((Node)object3).isManaged()) {
            Insets insets = BorderPane.getNodeMargin((Node)object3);
            d2 = this.adjustWidthByMargin(d7, insets);
            double d12 = this.adjustHeightByMargin(d8 - d9, insets);
            d11 = this.snapSizeY(((Node)object3).prefHeight(d2));
            d11 = Math.min(d11, d12);
            Vec2d vec2d = BorderPane.boundedNodeSizeWithBias((Node)object3, d2, d11, true, true, TEMP_VEC2D);
            d11 = this.snapSizeY(vec2d.y);
            ((Node)object3).resize(this.snapSizeX(vec2d.x), d11);
            d11 = this.snapSpaceY(insets.getBottom()) + d11 + this.snapSpaceY(insets.getTop());
            Pos pos = BorderPane.getAlignment((Node)object3);
            BorderPane.positionInArea((Node)object3, d4, d3 + d8 - d11, d7, d11, 0.0, insets, pos != null ? pos.getHpos() : HPos.LEFT, pos != null ? pos.getVpos() : VPos.BOTTOM, this.isSnapToPixel());
        }
        double d13 = 0.0;
        if (node2 != null && node2.isManaged()) {
            Insets insets = BorderPane.getNodeMargin(node2);
            double d14 = this.adjustWidthByMargin(d7, insets);
            double d15 = this.adjustHeightByMargin(d8 - d9 - d11, insets);
            d13 = this.snapSizeX(node2.prefWidth(d15));
            d13 = Math.min(d13, d14);
            Vec2d vec2d = BorderPane.boundedNodeSizeWithBias(node2, d13, d15, true, true, TEMP_VEC2D);
            d13 = this.snapSizeX(vec2d.x);
            node2.resize(d13, this.snapSizeY(vec2d.y));
            d13 = this.snapSpaceX(insets.getLeft()) + d13 + this.snapSpaceX(insets.getRight());
            Pos pos = BorderPane.getAlignment(node2);
            BorderPane.positionInArea(node2, d4, d3 + d9, d13, d8 - d9 - d11, 0.0, insets, pos != null ? pos.getHpos() : HPos.LEFT, pos != null ? pos.getVpos() : VPos.TOP, this.isSnapToPixel());
        }
        double d16 = 0.0;
        if (node != null && node.isManaged()) {
            object = BorderPane.getNodeMargin(node);
            double d17 = this.adjustWidthByMargin(d7 - d13, (Insets)object);
            double d18 = this.adjustHeightByMargin(d8 - d9 - d11, (Insets)object);
            d16 = this.snapSizeX(node.prefWidth(d18));
            d16 = Math.min(d16, d17);
            object3 = BorderPane.boundedNodeSizeWithBias(node, d16, d18, true, true, TEMP_VEC2D);
            d16 = this.snapSizeX(((Vec2d)object3).x);
            node.resize(d16, this.snapSizeY(((Vec2d)object3).y));
            d16 = this.snapSpaceX(((Insets)object).getLeft()) + d16 + this.snapSpaceX(((Insets)object).getRight());
            object3 = BorderPane.getAlignment(node);
            BorderPane.positionInArea(node, d4 + d7 - d16, d3 + d9, d16, d8 - d9 - d11, 0.0, (Insets)object, object3 != null ? ((Pos)((Object)object3)).getHpos() : HPos.RIGHT, object3 != null ? ((Pos)((Object)object3)).getVpos() : VPos.TOP, this.isSnapToPixel());
        }
        if (object2 != null && ((Node)object2).isManaged()) {
            object = BorderPane.getAlignment((Node)object2);
            this.layoutInArea((Node)object2, d4 + d13, d3 + d9, d7 - d13 - d16, d8 - d9 - d11, 0.0, BorderPane.getNodeMargin((Node)object2), object != null ? ((Pos)((Object)object)).getHpos() : HPos.CENTER, object != null ? ((Pos)((Object)object)).getVpos() : VPos.CENTER);
        }
    }

    private double getAreaWidth(Node node, double d2, boolean bl2) {
        if (node != null && node.isManaged()) {
            Insets insets = BorderPane.getNodeMargin(node);
            if (bl2) {
                return this.computeChildMinAreaWidth(node, -1.0, insets, d2, false);
            }
            return this.computeChildPrefAreaWidth(node, -1.0, insets, d2, false);
        }
        return 0.0;
    }

    private double getAreaHeight(Node node, double d2, boolean bl2) {
        if (node != null && node.isManaged()) {
            Insets insets = BorderPane.getNodeMargin(node);
            if (bl2) {
                return this.computeChildMinAreaHeight(node, -1.0, insets, d2);
            }
            return this.computeChildPrefAreaHeight(node, -1.0, insets, d2);
        }
        return 0.0;
    }

    private boolean childHasContentBias(Node node, Orientation orientation) {
        if (node != null && node.isManaged()) {
            return node.getContentBias() == orientation;
        }
        return false;
    }
}

