/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane$1;
import javafx.scene.layout.FlowPane$2;
import javafx.scene.layout.FlowPane$3;
import javafx.scene.layout.FlowPane$4;
import javafx.scene.layout.FlowPane$5;
import javafx.scene.layout.FlowPane$6;
import javafx.scene.layout.FlowPane$7;
import javafx.scene.layout.FlowPane$LayoutRect;
import javafx.scene.layout.FlowPane$Run;
import javafx.scene.layout.FlowPane$StyleableProperties;
import javafx.scene.layout.Pane;
import javafx.util.Callback;

public class FlowPane
extends Pane {
    private static final String MARGIN_CONSTRAINT = "flowpane-margin";
    private static final Callback<Node, Insets> marginAccessor = node -> FlowPane.getMargin(node);
    private ObjectProperty<Orientation> orientation;
    private DoubleProperty hgap;
    private DoubleProperty vgap;
    private DoubleProperty prefWrapLength;
    private ObjectProperty<Pos> alignment;
    private ObjectProperty<HPos> columnHalignment;
    private ObjectProperty<VPos> rowValignment;
    private List<FlowPane$Run> runs = null;
    private double lastMaxRunLength = -1.0;
    boolean computingRuns = false;

    public static void setMargin(Node node, Insets insets) {
        FlowPane.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)FlowPane.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        FlowPane.setMargin(node, null);
    }

    public FlowPane() {
    }

    public FlowPane(Orientation orientation) {
        this();
        this.setOrientation(orientation);
    }

    public FlowPane(double d2, double d3) {
        this();
        this.setHgap(d2);
        this.setVgap(d3);
    }

    public FlowPane(Orientation orientation, double d2, double d3) {
        this();
        this.setOrientation(orientation);
        this.setHgap(d2);
        this.setVgap(d3);
    }

    public FlowPane(Node ... nodeArray) {
        this.getChildren().addAll((Node[])nodeArray);
    }

    public FlowPane(Orientation orientation, Node ... nodeArray) {
        this();
        this.setOrientation(orientation);
        this.getChildren().addAll((Node[])nodeArray);
    }

    public FlowPane(double d2, double d3, Node ... nodeArray) {
        this();
        this.setHgap(d2);
        this.setVgap(d3);
        this.getChildren().addAll((Node[])nodeArray);
    }

    public FlowPane(Orientation orientation, double d2, double d3, Node ... nodeArray) {
        this();
        this.setOrientation(orientation);
        this.setHgap(d2);
        this.setVgap(d3);
        this.getChildren().addAll((Node[])nodeArray);
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new FlowPane$1(this, (Object)Orientation.HORIZONTAL);
        }
        return this.orientation;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        if (this.orientation == null) {
            return Orientation.HORIZONTAL;
        }
        return (Orientation)((Object)this.orientation.get());
    }

    public final DoubleProperty hgapProperty() {
        if (this.hgap == null) {
            this.hgap = new FlowPane$2(this);
        }
        return this.hgap;
    }

    public final void setHgap(double d2) {
        this.hgapProperty().set(d2);
    }

    public final double getHgap() {
        if (this.hgap == null) {
            return 0.0;
        }
        return this.hgap.get();
    }

    public final DoubleProperty vgapProperty() {
        if (this.vgap == null) {
            this.vgap = new FlowPane$3(this);
        }
        return this.vgap;
    }

    public final void setVgap(double d2) {
        this.vgapProperty().set(d2);
    }

    public final double getVgap() {
        if (this.vgap == null) {
            return 0.0;
        }
        return this.vgap.get();
    }

    public final DoubleProperty prefWrapLengthProperty() {
        if (this.prefWrapLength == null) {
            this.prefWrapLength = new FlowPane$4(this, 400.0);
        }
        return this.prefWrapLength;
    }

    public final void setPrefWrapLength(double d2) {
        this.prefWrapLengthProperty().set(d2);
    }

    public final double getPrefWrapLength() {
        if (this.prefWrapLength == null) {
            return 400.0;
        }
        return this.prefWrapLength.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new FlowPane$5(this, Pos.TOP_LEFT);
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        if (this.alignment == null) {
            return Pos.TOP_LEFT;
        }
        return (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos pos = this.getAlignment();
        if (pos == null) {
            return Pos.TOP_LEFT;
        }
        return pos;
    }

    public final ObjectProperty<HPos> columnHalignmentProperty() {
        if (this.columnHalignment == null) {
            this.columnHalignment = new FlowPane$6(this, HPos.LEFT);
        }
        return this.columnHalignment;
    }

    public final void setColumnHalignment(HPos hPos) {
        this.columnHalignmentProperty().set(hPos);
    }

    public final HPos getColumnHalignment() {
        if (this.columnHalignment == null) {
            return HPos.LEFT;
        }
        return (HPos)((Object)this.columnHalignment.get());
    }

    private HPos getColumnHalignmentInternal() {
        HPos hPos = this.getColumnHalignment();
        if (hPos == null) {
            return HPos.LEFT;
        }
        return hPos;
    }

    public final ObjectProperty<VPos> rowValignmentProperty() {
        if (this.rowValignment == null) {
            this.rowValignment = new FlowPane$7(this, VPos.CENTER);
        }
        return this.rowValignment;
    }

    public final void setRowValignment(VPos vPos) {
        this.rowValignmentProperty().set(vPos);
    }

    public final VPos getRowValignment() {
        if (this.rowValignment == null) {
            return VPos.CENTER;
        }
        return (VPos)((Object)this.rowValignment.get());
    }

    private VPos getRowValignmentInternal() {
        VPos vPos = this.getRowValignment();
        if (vPos == null) {
            return VPos.CENTER;
        }
        return vPos;
    }

    @Override
    public Orientation getContentBias() {
        return this.getOrientation();
    }

    @Override
    protected double computeMinWidth(double d2) {
        if (((Node)this).getContentBias() == Orientation.HORIZONTAL) {
            double d3 = 0.0;
            ObservableList<Node> observableList = this.getChildren();
            int n2 = observableList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = (Node)observableList.get(i2);
                if (!node.isManaged()) continue;
                d3 = Math.max(d3, node.prefWidth(-1.0));
            }
            Insets insets = this.getInsets();
            return insets.getLeft() + this.snapSizeX(d3) + insets.getRight();
        }
        return this.computePrefWidth(d2);
    }

    @Override
    protected double computeMinHeight(double d2) {
        if (((Node)this).getContentBias() == Orientation.VERTICAL) {
            double d3 = 0.0;
            ObservableList<Node> observableList = this.getChildren();
            int n2 = observableList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = (Node)observableList.get(i2);
                if (!node.isManaged()) continue;
                d3 = Math.max(d3, node.prefHeight(-1.0));
            }
            Insets insets = this.getInsets();
            return insets.getTop() + this.snapSizeY(d3) + insets.getBottom();
        }
        return this.computePrefHeight(d2);
    }

    @Override
    protected double computePrefWidth(double d2) {
        Insets insets = this.getInsets();
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            double d3 = this.getPrefWrapLength();
            List<FlowPane$Run> list = this.getRuns(d3);
            double d4 = this.computeContentWidth(list);
            d4 = this.getPrefWrapLength() > d4 ? this.getPrefWrapLength() : d4;
            return insets.getLeft() + this.snapSizeX(d4) + insets.getRight();
        }
        double d5 = d2 != -1.0 ? d2 - insets.getTop() - insets.getBottom() : this.getPrefWrapLength();
        List<FlowPane$Run> list = this.getRuns(d5);
        return insets.getLeft() + this.computeContentWidth(list) + insets.getRight();
    }

    @Override
    protected double computePrefHeight(double d2) {
        Insets insets = this.getInsets();
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            double d3 = d2 != -1.0 ? d2 - insets.getLeft() - insets.getRight() : this.getPrefWrapLength();
            List<FlowPane$Run> list = this.getRuns(d3);
            return insets.getTop() + this.computeContentHeight(list) + insets.getBottom();
        }
        double d4 = this.getPrefWrapLength();
        List<FlowPane$Run> list = this.getRuns(d4);
        double d5 = this.computeContentHeight(list);
        d5 = this.getPrefWrapLength() > d5 ? this.getPrefWrapLength() : d5;
        return insets.getTop() + this.snapSizeY(d5) + insets.getBottom();
    }

    @Override
    public void requestLayout() {
        if (!this.computingRuns) {
            this.runs = null;
        }
        super.requestLayout();
    }

    private List<FlowPane$Run> getRuns(double d2) {
        if (this.runs == null || d2 != this.lastMaxRunLength) {
            this.computingRuns = true;
            this.lastMaxRunLength = d2;
            this.runs = new ArrayList<FlowPane$Run>();
            double d3 = 0.0;
            double d4 = 0.0;
            FlowPane$Run flowPane$Run = new FlowPane$Run();
            FlowPane flowPane = this;
            double d5 = flowPane.snapSpaceY(flowPane.getVgap());
            FlowPane flowPane2 = this;
            double d6 = flowPane2.snapSpaceX(flowPane2.getHgap());
            ObservableList<Node> observableList = this.getChildren();
            int n2 = observableList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                double d7;
                Node node = (Node)observableList.get(i2);
                if (!node.isManaged()) continue;
                FlowPane$LayoutRect flowPane$LayoutRect = new FlowPane$LayoutRect();
                new FlowPane$LayoutRect().node = node;
                Insets insets = FlowPane.getMargin(node);
                flowPane$LayoutRect.width = this.computeChildPrefAreaWidth(node, insets);
                flowPane$LayoutRect.height = this.computeChildPrefAreaHeight(node, insets);
                double d8 = d7 = this.getOrientation() == Orientation.HORIZONTAL ? flowPane$LayoutRect.width : flowPane$LayoutRect.height;
                if (d3 + d7 > d2 && d3 > 0.0) {
                    this.normalizeRun(flowPane$Run, d4);
                    d4 = this.getOrientation() == Orientation.HORIZONTAL ? (d4 += flowPane$Run.height + d5) : (d4 += flowPane$Run.width + d6);
                    this.runs.add(flowPane$Run);
                    d3 = 0.0;
                    flowPane$Run = new FlowPane$Run();
                }
                if (this.getOrientation() == Orientation.HORIZONTAL) {
                    flowPane$LayoutRect.x = d3;
                    d3 += flowPane$LayoutRect.width + d6;
                } else {
                    flowPane$LayoutRect.y = d3;
                    d3 += flowPane$LayoutRect.height + d5;
                }
                flowPane$Run.rects.add(flowPane$LayoutRect);
            }
            this.normalizeRun(flowPane$Run, d4);
            this.runs.add(flowPane$Run);
            this.computingRuns = false;
        }
        return this.runs;
    }

    private void normalizeRun(FlowPane$Run flowPane$Run, double d2) {
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            FlowPane flowPane = this;
            flowPane$Run.width = (double)(flowPane$Run.rects.size() - 1) * flowPane.snapSpaceX(flowPane.getHgap());
            int n3 = flowPane$Run.rects.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                FlowPane$LayoutRect flowPane$LayoutRect = flowPane$Run.rects.get(i2);
                arrayList.add(flowPane$LayoutRect.node);
                flowPane$Run.width += flowPane$LayoutRect.width;
                flowPane$LayoutRect.y = d2;
            }
            flowPane$Run.height = this.computeMaxPrefAreaHeight(arrayList, marginAccessor, this.getRowValignment());
            flowPane$Run.baselineOffset = this.getRowValignment() == VPos.BASELINE ? this.getAreaBaselineOffset(arrayList, marginAccessor, n2 -> flowPane$Run.rects.get((int)n2.intValue()).width, flowPane$Run.height, true) : 0.0;
            return;
        }
        FlowPane flowPane = this;
        flowPane$Run.height = (double)(flowPane$Run.rects.size() - 1) * flowPane.snapSpaceY(flowPane.getVgap());
        double d3 = 0.0;
        int n4 = flowPane$Run.rects.size();
        for (int i3 = 0; i3 < n4; ++i3) {
            FlowPane$LayoutRect flowPane$LayoutRect = flowPane$Run.rects.get(i3);
            flowPane$Run.height += flowPane$LayoutRect.height;
            flowPane$LayoutRect.x = d2;
            d3 = Math.max(d3, flowPane$LayoutRect.width);
        }
        flowPane$Run.width = d3;
        flowPane$Run.baselineOffset = flowPane$Run.height;
    }

    private double computeContentWidth(List<FlowPane$Run> list) {
        double d2;
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            d2 = 0.0;
        } else {
            FlowPane flowPane = this;
            d2 = (double)(list.size() - 1) * flowPane.snapSpaceX(flowPane.getHgap());
        }
        double d3 = d2;
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FlowPane$Run flowPane$Run = list.get(i2);
            if (this.getOrientation() == Orientation.HORIZONTAL) {
                d3 = Math.max(d3, flowPane$Run.width);
                continue;
            }
            d3 += flowPane$Run.width;
        }
        return d3;
    }

    private double computeContentHeight(List<FlowPane$Run> list) {
        double d2;
        if (this.getOrientation() == Orientation.VERTICAL) {
            d2 = 0.0;
        } else {
            FlowPane flowPane = this;
            d2 = (double)(list.size() - 1) * flowPane.snapSpaceY(flowPane.getVgap());
        }
        double d3 = d2;
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FlowPane$Run flowPane$Run = list.get(i2);
            if (this.getOrientation() == Orientation.VERTICAL) {
                d3 = Math.max(d3, flowPane$Run.height);
                continue;
            }
            d3 += flowPane$Run.height;
        }
        return d3;
    }

    @Override
    protected void layoutChildren() {
        Object object = this.getInsets();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = ((Insets)object).getTop();
        double d5 = ((Insets)object).getLeft();
        double d6 = ((Insets)object).getBottom();
        double d7 = ((Insets)object).getRight();
        double d8 = d2 - d5 - d7;
        double d9 = d3 - d4 - d6;
        FlowPane flowPane = this;
        object = flowPane.getRuns(flowPane.getOrientation() == Orientation.HORIZONTAL ? d8 : d9);
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FlowPane$Run flowPane$Run = (FlowPane$Run)object.get(i2);
            double d10 = d5 + FlowPane.computeXOffset(d8, this.getOrientation() == Orientation.HORIZONTAL ? flowPane$Run.width : this.computeContentWidth((List<FlowPane$Run>)object), this.getAlignmentInternal().getHpos());
            double d11 = d4 + FlowPane.computeYOffset(d9, this.getOrientation() == Orientation.VERTICAL ? flowPane$Run.height : this.computeContentHeight((List<FlowPane$Run>)object), this.getAlignmentInternal().getVpos());
            for (int i3 = 0; i3 < flowPane$Run.rects.size(); ++i3) {
                FlowPane$LayoutRect flowPane$LayoutRect = flowPane$Run.rects.get(i3);
                double d12 = d10 + flowPane$LayoutRect.x;
                double d13 = d11 + flowPane$LayoutRect.y;
                this.layoutInArea(flowPane$LayoutRect.node, d12, d13, this.getOrientation() == Orientation.HORIZONTAL ? flowPane$LayoutRect.width : flowPane$Run.width, this.getOrientation() == Orientation.VERTICAL ? flowPane$LayoutRect.height : flowPane$Run.height, flowPane$Run.baselineOffset, FlowPane.getMargin(flowPane$LayoutRect.node), this.getColumnHalignmentInternal(), this.getRowValignmentInternal());
            }
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return FlowPane$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FlowPane.getClassCssMetaData();
    }
}

