/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.Vec2d;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.layout.RegionHelper;
import com.sun.javafx.scene.layout.ScaledMath;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGRegion;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.Toolkit$ImageAccessor;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.TempState;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderImage;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region$1;
import javafx.scene.layout.Region$10;
import javafx.scene.layout.Region$11;
import javafx.scene.layout.Region$2;
import javafx.scene.layout.Region$3;
import javafx.scene.layout.Region$4;
import javafx.scene.layout.Region$5;
import javafx.scene.layout.Region$6;
import javafx.scene.layout.Region$7;
import javafx.scene.layout.Region$8;
import javafx.scene.layout.Region$9;
import javafx.scene.layout.Region$InsetsProperty;
import javafx.scene.layout.Region$MinPrefMaxProperty;
import javafx.scene.layout.Region$ShapeProperty;
import javafx.scene.layout.Region$StyleableProperties;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.stage.Window;
import javafx.util.Callback;

public class Region
extends Parent {
    public static final double USE_PREF_SIZE = Double.NEGATIVE_INFINITY;
    public static final double USE_COMPUTED_SIZE = -1.0;
    static Vec2d TEMP_VEC2D;
    private InvalidationListener imageChangeListener = object -> {
        object = (ReadOnlyObjectPropertyBase)object;
        object = (Image)object.getBean();
        Toolkit$ImageAccessor toolkit$ImageAccessor = Toolkit.getImageAccessor();
        if (((Image)((Object)object)).getProgress() == 1.0 && !toolkit$ImageAccessor.isAnimation((Image)((Object)object))) {
            this.removeImageListener((Image)((Object)object));
        }
        NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
    };
    private BooleanProperty snapToPixel;
    private boolean _snapToPixel;
    private ObjectProperty<Insets> padding;
    private final ObjectProperty<Background> background;
    private final ObjectProperty<Border> border;
    private ObjectProperty<Insets> opaqueInsets;
    private final Region$InsetsProperty insets;
    private double snappedTopInset;
    private double snappedRightInset;
    private double snappedBottomInset;
    private double snappedLeftInset;
    private double lastUsedSnapScaleY;
    private double lastUsedSnapScaleX;
    private ReadOnlyDoubleWrapper width;
    private double _width;
    private ReadOnlyDoubleWrapper height;
    private double _height;
    private DoubleProperty minWidth;
    private double _minWidth;
    private DoubleProperty minHeight;
    private double _minHeight;
    private DoubleProperty prefWidth;
    private double _prefWidth;
    private DoubleProperty prefHeight;
    private double _prefHeight;
    private DoubleProperty maxWidth;
    private double _maxWidth;
    private DoubleProperty maxHeight;
    private double _maxHeight;
    private ObjectProperty<javafx.scene.shape.Shape> shape;
    private javafx.scene.shape.Shape _shape;
    private BooleanProperty scaleShape;
    private BooleanProperty centerShape;
    private BooleanProperty cacheShape;
    private boolean cornersValid;
    private List<CornerRadii> normalizedFillCorners;
    private List<CornerRadii> normalizedStrokeCorners;
    private Bounds boundingBox;

    static double boundedSize(double d2, double d3, double d4) {
        double d5;
        double d6 = d3 >= d2 ? d3 : d2;
        double d7 = d5 = d2 >= d4 ? d2 : d4;
        if (d6 <= d5) {
            return d6;
        }
        return d5;
    }

    double adjustWidthByMargin(double d2, Insets insets) {
        if (insets == null || insets == Insets.EMPTY) {
            return d2;
        }
        boolean bl2 = this.isSnapToPixel();
        return d2 - this.snapSpaceX(insets.getLeft(), bl2) - this.snapSpaceX(insets.getRight(), bl2);
    }

    double adjustHeightByMargin(double d2, Insets insets) {
        if (insets == null || insets == Insets.EMPTY) {
            return d2;
        }
        boolean bl2 = this.isSnapToPixel();
        return d2 - this.snapSpaceY(insets.getTop(), bl2) - this.snapSpaceY(insets.getBottom(), bl2);
    }

    static double getSnapScaleX(Node node) {
        return Region._getSnapScaleXimpl(node.getScene());
    }

    private static double _getSnapScaleXimpl(Scene eventTarget) {
        if (eventTarget == null) {
            return 1.0;
        }
        if ((eventTarget = ((Scene)eventTarget).getWindow()) == null) {
            return 1.0;
        }
        return ((Window)eventTarget).getRenderScaleX();
    }

    static double getSnapScaleY(Node node) {
        return Region._getSnapScaleYimpl(node.getScene());
    }

    private static double _getSnapScaleYimpl(Scene eventTarget) {
        if (eventTarget == null) {
            return 1.0;
        }
        if ((eventTarget = ((Scene)eventTarget).getWindow()) == null) {
            return 1.0;
        }
        return ((Window)eventTarget).getRenderScaleY();
    }

    private double getSnapScaleX() {
        return Region._getSnapScaleXimpl(this.getScene());
    }

    private double getSnapScaleY() {
        return Region._getSnapScaleYimpl(this.getScene());
    }

    private double snapSpaceX(double d2, boolean bl2) {
        if (bl2) {
            return ScaledMath.round(d2, this.getSnapScaleX());
        }
        return d2;
    }

    private double snapSpaceY(double d2, boolean bl2) {
        if (bl2) {
            return ScaledMath.round(d2, this.getSnapScaleY());
        }
        return d2;
    }

    private static double snapSpace(double d2, boolean bl2, double d3) {
        if (bl2) {
            return ScaledMath.round(d2, d3);
        }
        return d2;
    }

    private double snapSizeX(double d2, boolean bl2) {
        if (bl2) {
            return ScaledMath.ceil(d2, this.getSnapScaleX());
        }
        return d2;
    }

    private double snapSizeY(double d2, boolean bl2) {
        if (bl2) {
            return ScaledMath.ceil(d2, this.getSnapScaleY());
        }
        return d2;
    }

    private static double snapSize(double d2, boolean bl2, double d3) {
        if (bl2) {
            return ScaledMath.ceil(d2, d3);
        }
        return d2;
    }

    private double snapPositionX(double d2, boolean bl2) {
        if (bl2) {
            return ScaledMath.round(d2, this.getSnapScaleX());
        }
        return d2;
    }

    private double snapPositionY(double d2, boolean bl2) {
        if (bl2) {
            return ScaledMath.round(d2, this.getSnapScaleY());
        }
        return d2;
    }

    private static double snapPosition(double d2, boolean bl2, double d3) {
        if (bl2) {
            return ScaledMath.round(d2, d3);
        }
        return d2;
    }

    private double snapPortionX(double d2, boolean bl2) {
        if (!bl2 || d2 == 0.0) {
            return d2;
        }
        double d3 = this.getSnapScaleX();
        if (d2 > 0.0) {
            return ScaledMath.floor(d2, d3);
        }
        return ScaledMath.ceil(d2, d3);
    }

    private double snapPortionY(double d2, boolean bl2) {
        if (!bl2 || d2 == 0.0) {
            return d2;
        }
        double d3 = this.getSnapScaleY();
        if (d2 > 0.0) {
            return ScaledMath.floor(d2, d3);
        }
        return ScaledMath.ceil(d2, d3);
    }

    double getAreaBaselineOffset(List<Node> list, Callback<Node, Insets> callback, Function<Integer, Double> function, double d2, boolean bl2) {
        return Region.getAreaBaselineOffset(list, callback, function, d2, bl2, this.isSnapToPixel());
    }

    static double getAreaBaselineOffset(List<Node> list, Callback<Node, Insets> callback, Function<Integer, Double> function, double d2, boolean bl2, boolean bl3) {
        return Region.getAreaBaselineOffset(list, callback, function, d2, bl2, Region.getMinBaselineComplement(list), bl3);
    }

    double getAreaBaselineOffset(List<Node> list, Callback<Node, Insets> callback, Function<Integer, Double> function, double d2, boolean bl2, double d3) {
        return Region.getAreaBaselineOffset(list, callback, function, d2, bl2, d3, this.isSnapToPixel());
    }

    static double getAreaBaselineOffset(List<Node> list, Callback<Node, Insets> callback, Function<Integer, Double> function, double d2, boolean bl2, double d3, boolean bl3) {
        return Region.getAreaBaselineOffset(list, callback, function, d2, n2 -> bl2, d3, bl3);
    }

    double getAreaBaselineOffset(List<Node> list, Callback<Node, Insets> callback, Function<Integer, Double> function, double d2, Function<Integer, Boolean> function2, double d3) {
        return Region.getAreaBaselineOffset(list, callback, function, d2, function2, d3, this.isSnapToPixel());
    }

    static double getAreaBaselineOffset(List<Node> list, Callback<Node, Insets> callback, Function<Integer, Double> function, double d2, Function<Integer, Boolean> function2, double d3, boolean bl2) {
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Insets insets;
            Node node = list.get(i2);
            if (bl2 && i2 == 0) {
                d5 = Region.getSnapScaleY(node.getParent());
            }
            double d6 = (insets = callback.call(node)) != null ? Region.snapSpace(insets.getTop(), bl2, d5) : 0.0;
            double d7 = insets != null ? Region.snapSpace(insets.getBottom(), bl2, d5) : 0.0;
            double d8 = node.getBaselineOffset();
            if (d8 == Double.NEGATIVE_INFINITY) {
                double d9 = -1.0;
                if (node.getContentBias() == Orientation.HORIZONTAL) {
                    d9 = function.apply(i2);
                }
                if (function2.apply(i2).booleanValue()) {
                    d4 = Math.max(d4, d6 + Region.boundedSize(node.minHeight(d9), d2 - d3 - d6 - d7, node.maxHeight(d9)));
                    continue;
                }
                d4 = Math.max(d4, d6 + Region.boundedSize(node.minHeight(d9), node.prefHeight(d9), Math.min(node.maxHeight(d9), d2 - d3 - d6 - d7)));
                continue;
            }
            d4 = Math.max(d4, d6 + d8);
        }
        return d4;
    }

    static double getMinBaselineComplement(List<Node> list) {
        return Region.getBaselineComplement(list, true, false);
    }

    static double getPrefBaselineComplement(List<Node> list) {
        return Region.getBaselineComplement(list, false, false);
    }

    static double getMaxBaselineComplement(List<Node> list) {
        return Region.getBaselineComplement(list, false, true);
    }

    private static double getBaselineComplement(List<Node> object, boolean bl2, boolean bl3) {
        double d2 = 0.0;
        object = object.iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            double d3 = node.getBaselineOffset();
            if (d3 == Double.NEGATIVE_INFINITY) continue;
            if (node.isResizable()) {
                d2 = Math.max(d2, (bl2 ? node.minHeight(-1.0) : (bl3 ? node.maxHeight(-1.0) : node.prefHeight(-1.0))) - d3);
                continue;
            }
            d2 = Math.max(d2, node.getLayoutBounds().getHeight() - d3);
        }
        return d2;
    }

    static double computeXOffset(double d2, double d3, HPos hPos) {
        switch (hPos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (d2 - d3) / 2.0;
            }
            case RIGHT: {
                return d2 - d3;
            }
        }
        throw new AssertionError((Object)"Unhandled hPos");
    }

    static double computeYOffset(double d2, double d3, VPos vPos) {
        switch (vPos) {
            case BASELINE: 
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (d2 - d3) / 2.0;
            }
            case BOTTOM: {
                return d2 - d3;
            }
        }
        throw new AssertionError((Object)"Unhandled vPos");
    }

    static double[] createDoubleArray(int n2, double d2) {
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = d2;
        }
        return dArray;
    }

    public Region() {
        RegionHelper.initHelper(this);
        this._snapToPixel = true;
        this.padding = new Region$3(this, Insets.EMPTY);
        this.background = new Region$4(this, null);
        this.border = new Region$5(this, null);
        this.insets = new Region$InsetsProperty(this);
        this.snappedTopInset = 0.0;
        this.snappedRightInset = 0.0;
        this.snappedBottomInset = 0.0;
        this.snappedLeftInset = 0.0;
        this.lastUsedSnapScaleY = 0.0;
        this.lastUsedSnapScaleX = 0.0;
        this._minWidth = -1.0;
        this._minHeight = -1.0;
        this._prefWidth = -1.0;
        this._prefHeight = -1.0;
        this._maxWidth = -1.0;
        this._maxHeight = -1.0;
        this.shape = null;
        this.scaleShape = null;
        this.centerShape = null;
        this.cacheShape = null;
        this.setPickOnBounds(true);
    }

    public final boolean isSnapToPixel() {
        return this._snapToPixel;
    }

    public final void setSnapToPixel(boolean bl2) {
        if (this.snapToPixel == null) {
            if (this._snapToPixel != bl2) {
                this._snapToPixel = bl2;
                this.updateSnappedInsets();
                this.requestParentLayout();
                return;
            }
        } else {
            this.snapToPixel.set(bl2);
        }
    }

    public final BooleanProperty snapToPixelProperty() {
        if (this.snapToPixel == null) {
            Region region = this;
            this.snapToPixel = new Region$2(region, region._snapToPixel);
        }
        return this.snapToPixel;
    }

    public final void setPadding(Insets insets) {
        this.padding.set(insets);
    }

    public final Insets getPadding() {
        return (Insets)this.padding.get();
    }

    public final ObjectProperty<Insets> paddingProperty() {
        return this.padding;
    }

    public final void setBackground(Background background) {
        this.background.set(background);
    }

    public final Background getBackground() {
        return (Background)this.background.get();
    }

    public final ObjectProperty<Background> backgroundProperty() {
        return this.background;
    }

    public final void setBorder(Border border) {
        this.border.set(border);
    }

    public final Border getBorder() {
        return (Border)this.border.get();
    }

    public final ObjectProperty<Border> borderProperty() {
        return this.border;
    }

    void addImageListener(Image image) {
        Toolkit$ImageAccessor toolkit$ImageAccessor = Toolkit.getImageAccessor();
        toolkit$ImageAccessor.getImageProperty(image).addListener(this.imageChangeListener);
    }

    void removeImageListener(Image image) {
        Toolkit$ImageAccessor toolkit$ImageAccessor = Toolkit.getImageAccessor();
        toolkit$ImageAccessor.getImageProperty(image).removeListener(this.imageChangeListener);
    }

    public final ObjectProperty<Insets> opaqueInsetsProperty() {
        if (this.opaqueInsets == null) {
            this.opaqueInsets = new Region$6(this);
        }
        return this.opaqueInsets;
    }

    public final void setOpaqueInsets(Insets insets) {
        this.opaqueInsetsProperty().set(insets);
    }

    public final Insets getOpaqueInsets() {
        if (this.opaqueInsets == null) {
            return null;
        }
        return (Insets)this.opaqueInsets.get();
    }

    public final Insets getInsets() {
        return this.insets.get();
    }

    public final ReadOnlyObjectProperty<Insets> insetsProperty() {
        return this.insets;
    }

    private void updateSnappedInsets() {
        this.lastUsedSnapScaleX = this.getSnapScaleX();
        this.lastUsedSnapScaleY = this.getSnapScaleY();
        Insets insets = this.getInsets();
        boolean bl2 = this.isSnapToPixel();
        this.snappedTopInset = this.snapSpaceY(insets.getTop(), bl2);
        this.snappedRightInset = this.snapSpaceX(insets.getRight(), bl2);
        this.snappedBottomInset = this.snapSpaceY(insets.getBottom(), bl2);
        this.snappedLeftInset = this.snapSpaceX(insets.getLeft(), bl2);
    }

    protected void setWidth(double d2) {
        if (this.width == null) {
            this.widthChanged(d2);
            return;
        }
        this.width.set(d2);
    }

    private void widthChanged(double d2) {
        if (d2 != this._width) {
            this._width = d2;
            this.cornersValid = false;
            this.boundingBox = null;
            NodeHelper.layoutBoundsChanged(this);
            NodeHelper.geomChanged(this);
            NodeHelper.markDirty(this, DirtyBits.NODE_GEOMETRY);
            this.setNeedsLayout(true);
            this.requestParentLayout();
        }
    }

    public final double getWidth() {
        if (this.width == null) {
            return this._width;
        }
        return this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        if (this.width == null) {
            Region region = this;
            this.width = new Region$7(region, region._width);
        }
        return this.width.getReadOnlyProperty();
    }

    protected void setHeight(double d2) {
        if (this.height == null) {
            this.heightChanged(d2);
            return;
        }
        this.height.set(d2);
    }

    private void heightChanged(double d2) {
        if (this._height != d2) {
            this._height = d2;
            this.cornersValid = false;
            this.boundingBox = null;
            NodeHelper.geomChanged(this);
            NodeHelper.layoutBoundsChanged(this);
            NodeHelper.markDirty(this, DirtyBits.NODE_GEOMETRY);
            this.setNeedsLayout(true);
            this.requestParentLayout();
        }
    }

    public final double getHeight() {
        if (this.height == null) {
            return this._height;
        }
        return this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        if (this.height == null) {
            Region region = this;
            this.height = new Region$8(region, region._height);
        }
        return this.height.getReadOnlyProperty();
    }

    public final void setMinWidth(double d2) {
        if (this.minWidth == null) {
            this._minWidth = d2;
            this.requestParentLayout();
            return;
        }
        this.minWidth.set(d2);
    }

    public final double getMinWidth() {
        if (this.minWidth == null) {
            return this._minWidth;
        }
        return this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new Region$MinPrefMaxProperty(this, "minWidth", this._minWidth, Region$StyleableProperties.MIN_WIDTH);
        }
        return this.minWidth;
    }

    public final void setMinHeight(double d2) {
        if (this.minHeight == null) {
            this._minHeight = d2;
            this.requestParentLayout();
            return;
        }
        this.minHeight.set(d2);
    }

    public final double getMinHeight() {
        if (this.minHeight == null) {
            return this._minHeight;
        }
        return this.minHeight.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new Region$MinPrefMaxProperty(this, "minHeight", this._minHeight, Region$StyleableProperties.MIN_HEIGHT);
        }
        return this.minHeight;
    }

    public void setMinSize(double d2, double d3) {
        this.setMinWidth(d2);
        this.setMinHeight(d3);
    }

    public final void setPrefWidth(double d2) {
        if (this.prefWidth == null) {
            this._prefWidth = d2;
            this.requestParentLayout();
            return;
        }
        this.prefWidth.set(d2);
    }

    public final double getPrefWidth() {
        if (this.prefWidth == null) {
            return this._prefWidth;
        }
        return this.prefWidth.get();
    }

    public final DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new Region$MinPrefMaxProperty(this, "prefWidth", this._prefWidth, Region$StyleableProperties.PREF_WIDTH);
        }
        return this.prefWidth;
    }

    public final void setPrefHeight(double d2) {
        if (this.prefHeight == null) {
            this._prefHeight = d2;
            this.requestParentLayout();
            return;
        }
        this.prefHeight.set(d2);
    }

    public final double getPrefHeight() {
        if (this.prefHeight == null) {
            return this._prefHeight;
        }
        return this.prefHeight.get();
    }

    public final DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new Region$MinPrefMaxProperty(this, "prefHeight", this._prefHeight, Region$StyleableProperties.PREF_HEIGHT);
        }
        return this.prefHeight;
    }

    public void setPrefSize(double d2, double d3) {
        this.setPrefWidth(d2);
        this.setPrefHeight(d3);
    }

    public final void setMaxWidth(double d2) {
        if (this.maxWidth == null) {
            this._maxWidth = d2;
            this.requestParentLayout();
            return;
        }
        this.maxWidth.set(d2);
    }

    public final double getMaxWidth() {
        if (this.maxWidth == null) {
            return this._maxWidth;
        }
        return this.maxWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new Region$MinPrefMaxProperty(this, "maxWidth", this._maxWidth, Region$StyleableProperties.MAX_WIDTH);
        }
        return this.maxWidth;
    }

    public final void setMaxHeight(double d2) {
        if (this.maxHeight == null) {
            this._maxHeight = d2;
            this.requestParentLayout();
            return;
        }
        this.maxHeight.set(d2);
    }

    public final double getMaxHeight() {
        if (this.maxHeight == null) {
            return this._maxHeight;
        }
        return this.maxHeight.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new Region$MinPrefMaxProperty(this, "maxHeight", this._maxHeight, Region$StyleableProperties.MAX_HEIGHT);
        }
        return this.maxHeight;
    }

    public void setMaxSize(double d2, double d3) {
        this.setMaxWidth(d2);
        this.setMaxHeight(d3);
    }

    public final javafx.scene.shape.Shape getShape() {
        if (this.shape == null) {
            return this._shape;
        }
        return (javafx.scene.shape.Shape)this.shape.get();
    }

    public final void setShape(javafx.scene.shape.Shape shape) {
        this.shapeProperty().set(shape);
    }

    public final ObjectProperty<javafx.scene.shape.Shape> shapeProperty() {
        if (this.shape == null) {
            this.shape = new Region$ShapeProperty(this);
        }
        return this.shape;
    }

    public final void setScaleShape(boolean bl2) {
        this.scaleShapeProperty().set(bl2);
    }

    public final boolean isScaleShape() {
        if (this.scaleShape == null) {
            return true;
        }
        return this.scaleShape.get();
    }

    public final BooleanProperty scaleShapeProperty() {
        if (this.scaleShape == null) {
            this.scaleShape = new Region$9(this, true);
        }
        return this.scaleShape;
    }

    public final void setCenterShape(boolean bl2) {
        this.centerShapeProperty().set(bl2);
    }

    public final boolean isCenterShape() {
        if (this.centerShape == null) {
            return true;
        }
        return this.centerShape.get();
    }

    public final BooleanProperty centerShapeProperty() {
        if (this.centerShape == null) {
            this.centerShape = new Region$10(this, true);
        }
        return this.centerShape;
    }

    public final void setCacheShape(boolean bl2) {
        this.cacheShapeProperty().set(bl2);
    }

    public final boolean isCacheShape() {
        if (this.cacheShape == null) {
            return true;
        }
        return this.cacheShape.get();
    }

    public final BooleanProperty cacheShapeProperty() {
        if (this.cacheShape == null) {
            this.cacheShape = new Region$11(this, true);
        }
        return this.cacheShape;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(double d2, double d3) {
        this.setWidth(d2);
        this.setHeight(d3);
        PlatformLogger platformLogger = Logging.getLayoutLogger();
        if (platformLogger.isLoggable(PlatformLogger$Level.FINER)) {
            platformLogger.finer(this.toString() + " resized to " + d2 + " x " + d3);
        }
    }

    @Override
    public final double minWidth(double d2) {
        double d3 = this.getMinWidth();
        if (d3 == -1.0) {
            return super.minWidth(d2);
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            return ((Node)this).prefWidth(d2);
        }
        if (Double.isNaN(d3) || d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    @Override
    public final double minHeight(double d2) {
        double d3 = this.getMinHeight();
        if (d3 == -1.0) {
            return super.minHeight(d2);
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            return ((Node)this).prefHeight(d2);
        }
        if (Double.isNaN(d3) || d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    @Override
    public final double prefWidth(double d2) {
        double d3 = this.getPrefWidth();
        if (d3 == -1.0) {
            return super.prefWidth(d2);
        }
        if (Double.isNaN(d3) || d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    @Override
    public final double prefHeight(double d2) {
        double d3 = this.getPrefHeight();
        if (d3 == -1.0) {
            return super.prefHeight(d2);
        }
        if (Double.isNaN(d3) || d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    @Override
    public final double maxWidth(double d2) {
        double d3 = this.getMaxWidth();
        if (d3 == -1.0) {
            return this.computeMaxWidth(d2);
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            return ((Node)this).prefWidth(d2);
        }
        if (Double.isNaN(d3) || d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    @Override
    public final double maxHeight(double d2) {
        double d3 = this.getMaxHeight();
        if (d3 == -1.0) {
            return this.computeMaxHeight(d2);
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            return ((Node)this).prefHeight(d2);
        }
        if (Double.isNaN(d3) || d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    @Override
    protected double computeMinWidth(double d2) {
        return this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d2) {
        return this.getInsets().getTop() + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double d2) {
        double d3 = super.computePrefWidth(d2);
        return this.getInsets().getLeft() + d3 + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d2) {
        double d3 = super.computePrefHeight(d2);
        return this.getInsets().getTop() + d3 + this.getInsets().getBottom();
    }

    protected double computeMaxWidth(double d2) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxHeight(double d2) {
        return Double.MAX_VALUE;
    }

    @Deprecated(since="9")
    protected double snapSpace(double d2) {
        return this.snapSpaceX(d2, this.isSnapToPixel());
    }

    public double snapSpaceX(double d2) {
        return this.snapSpaceX(d2, this.isSnapToPixel());
    }

    public double snapSpaceY(double d2) {
        return this.snapSpaceY(d2, this.isSnapToPixel());
    }

    @Deprecated(since="9")
    protected double snapSize(double d2) {
        return this.snapSizeX(d2, this.isSnapToPixel());
    }

    public double snapSizeX(double d2) {
        return this.snapSizeX(d2, this.isSnapToPixel());
    }

    public double snapSizeY(double d2) {
        return this.snapSizeY(d2, this.isSnapToPixel());
    }

    @Deprecated(since="9")
    protected double snapPosition(double d2) {
        return this.snapPositionX(d2, this.isSnapToPixel());
    }

    public double snapPositionX(double d2) {
        return this.snapPositionX(d2, this.isSnapToPixel());
    }

    public double snapPositionY(double d2) {
        return this.snapPositionY(d2, this.isSnapToPixel());
    }

    double snapPortionX(double d2) {
        return this.snapPortionX(d2, this.isSnapToPixel());
    }

    double snapPortionY(double d2) {
        return this.snapPortionY(d2, this.isSnapToPixel());
    }

    public final double snappedTopInset() {
        if (this.lastUsedSnapScaleY != this.getSnapScaleY()) {
            this.updateSnappedInsets();
        }
        return this.snappedTopInset;
    }

    public final double snappedBottomInset() {
        if (this.lastUsedSnapScaleY != this.getSnapScaleY()) {
            this.updateSnappedInsets();
        }
        return this.snappedBottomInset;
    }

    public final double snappedLeftInset() {
        if (this.lastUsedSnapScaleX != this.getSnapScaleX()) {
            this.updateSnappedInsets();
        }
        return this.snappedLeftInset;
    }

    public final double snappedRightInset() {
        if (this.lastUsedSnapScaleX != this.getSnapScaleX()) {
            this.updateSnappedInsets();
        }
        return this.snappedRightInset;
    }

    double computeChildMinAreaWidth(Node node, Insets insets) {
        return this.computeChildMinAreaWidth(node, -1.0, insets, -1.0, false);
    }

    double computeChildMinAreaWidth(Node node, double d2, Insets insets, double d3, boolean bl2) {
        boolean bl3 = this.isSnapToPixel();
        double d4 = insets != null ? this.snapSpaceX(insets.getLeft(), bl3) : 0.0;
        double d5 = insets != null ? this.snapSpaceX(insets.getRight(), bl3) : 0.0;
        double d6 = -1.0;
        if (d3 != -1.0 && node.isResizable() && node.getContentBias() == Orientation.VERTICAL) {
            double d7 = insets != null ? this.snapSpaceY(insets.getTop(), bl3) : 0.0;
            double d8 = insets != null ? this.snapSpaceY(insets.getBottom(), bl3) : 0.0;
            double d9 = node.getBaselineOffset();
            double d10 = d9 == Double.NEGATIVE_INFINITY && d2 != -1.0 ? d3 - d7 - d8 - d2 : d3 - d7 - d8;
            d6 = bl2 ? this.snapSizeY(Region.boundedSize(node.minHeight(-1.0), d10, node.maxHeight(-1.0))) : this.snapSizeY(Region.boundedSize(node.minHeight(-1.0), node.prefHeight(-1.0), Math.min(node.maxHeight(-1.0), d10)));
        }
        return d4 + this.snapSizeX(node.minWidth(d6)) + d5;
    }

    double computeChildMinAreaHeight(Node node, Insets insets) {
        return this.computeChildMinAreaHeight(node, -1.0, insets, -1.0);
    }

    double computeChildMinAreaHeight(Node node, double d2, Insets insets, double d3) {
        double d4;
        boolean bl2 = this.isSnapToPixel();
        double d5 = insets != null ? this.snapSpaceY(insets.getTop(), bl2) : 0.0;
        double d6 = insets != null ? this.snapSpaceY(insets.getBottom(), bl2) : 0.0;
        double d7 = -1.0;
        if (node.isResizable() && node.getContentBias() == Orientation.HORIZONTAL) {
            d4 = insets != null ? this.snapSpaceX(insets.getLeft(), bl2) : 0.0;
            double d8 = insets != null ? this.snapSpaceX(insets.getRight(), bl2) : 0.0;
            d7 = this.snapSizeX(d3 != -1.0 ? Region.boundedSize(node.minWidth(-1.0), d3 - d4 - d8, node.maxWidth(-1.0)) : node.maxWidth(-1.0));
        }
        if (d2 != -1.0) {
            d4 = node.getBaselineOffset();
            if (node.isResizable() && d4 == Double.NEGATIVE_INFINITY) {
                return d5 + this.snapSizeY(node.minHeight(d7)) + d6 + d2;
            }
            return d4 + d2;
        }
        return d5 + this.snapSizeY(node.minHeight(d7)) + d6;
    }

    double computeChildPrefAreaWidth(Node node, Insets insets) {
        return this.computeChildPrefAreaWidth(node, -1.0, insets, -1.0, false);
    }

    double computeChildPrefAreaWidth(Node node, double d2, Insets insets, double d3, boolean bl2) {
        boolean bl3 = this.isSnapToPixel();
        double d4 = insets != null ? this.snapSpaceX(insets.getLeft(), bl3) : 0.0;
        double d5 = insets != null ? this.snapSpaceX(insets.getRight(), bl3) : 0.0;
        double d6 = -1.0;
        if (d3 != -1.0 && node.isResizable() && node.getContentBias() == Orientation.VERTICAL) {
            double d7 = insets != null ? this.snapSpaceY(insets.getTop(), bl3) : 0.0;
            double d8 = insets != null ? this.snapSpaceY(insets.getBottom(), bl3) : 0.0;
            double d9 = node.getBaselineOffset();
            double d10 = d9 == Double.NEGATIVE_INFINITY && d2 != -1.0 ? d3 - d7 - d8 - d2 : d3 - d7 - d8;
            d6 = bl2 ? this.snapSizeY(Region.boundedSize(node.minHeight(-1.0), d10, node.maxHeight(-1.0))) : this.snapSizeY(Region.boundedSize(node.minHeight(-1.0), node.prefHeight(-1.0), Math.min(node.maxHeight(-1.0), d10)));
        }
        return d4 + this.snapSizeX(Region.boundedSize(node.minWidth(d6), node.prefWidth(d6), node.maxWidth(d6))) + d5;
    }

    double computeChildPrefAreaHeight(Node node, Insets insets) {
        return this.computeChildPrefAreaHeight(node, -1.0, insets, -1.0);
    }

    double computeChildPrefAreaHeight(Node node, double d2, Insets insets, double d3) {
        double d4;
        boolean bl2 = this.isSnapToPixel();
        double d5 = insets != null ? this.snapSpaceY(insets.getTop(), bl2) : 0.0;
        double d6 = insets != null ? this.snapSpaceY(insets.getBottom(), bl2) : 0.0;
        double d7 = -1.0;
        if (node.isResizable() && node.getContentBias() == Orientation.HORIZONTAL) {
            d4 = insets != null ? this.snapSpaceX(insets.getLeft(), bl2) : 0.0;
            double d8 = insets != null ? this.snapSpaceX(insets.getRight(), bl2) : 0.0;
            d7 = this.snapSizeX(Region.boundedSize(node.minWidth(-1.0), d3 != -1.0 ? d3 - d4 - d8 : node.prefWidth(-1.0), node.maxWidth(-1.0)));
        }
        if (d2 != -1.0) {
            d4 = node.getBaselineOffset();
            if (node.isResizable() && d4 == Double.NEGATIVE_INFINITY) {
                return d5 + this.snapSizeY(Region.boundedSize(node.minHeight(d7), node.prefHeight(d7), node.maxHeight(d7))) + d6 + d2;
            }
            return d5 + d4 + d2 + d6;
        }
        return d5 + this.snapSizeY(Region.boundedSize(node.minHeight(d7), node.prefHeight(d7), node.maxHeight(d7))) + d6;
    }

    double computeChildMaxAreaWidth(Node node, double d2, Insets insets, double d3, boolean bl2) {
        double d4 = node.maxWidth(-1.0);
        if (d4 == Double.MAX_VALUE) {
            return d4;
        }
        boolean bl3 = this.isSnapToPixel();
        double d5 = insets != null ? this.snapSpaceX(insets.getLeft(), bl3) : 0.0;
        double d6 = insets != null ? this.snapSpaceX(insets.getRight(), bl3) : 0.0;
        double d7 = -1.0;
        if (d3 != -1.0 && node.isResizable() && node.getContentBias() == Orientation.VERTICAL) {
            double d8 = insets != null ? this.snapSpaceY(insets.getTop(), bl3) : 0.0;
            double d9 = insets != null ? this.snapSpaceY(insets.getBottom(), bl3) : 0.0;
            double d10 = node.getBaselineOffset();
            double d11 = d10 == Double.NEGATIVE_INFINITY && d2 != -1.0 ? d3 - d8 - d9 - d2 : d3 - d8 - d9;
            d7 = bl2 ? this.snapSizeY(Region.boundedSize(node.minHeight(-1.0), d11, node.maxHeight(-1.0))) : this.snapSizeY(Region.boundedSize(node.minHeight(-1.0), node.prefHeight(-1.0), Math.min(node.maxHeight(-1.0), d11)));
            d4 = node.maxWidth(d7);
        }
        return d5 + this.snapSizeX(Region.boundedSize(node.minWidth(d7), d4, Double.MAX_VALUE)) + d6;
    }

    double computeChildMaxAreaHeight(Node node, double d2, Insets insets, double d3) {
        double d4;
        double d5 = node.maxHeight(-1.0);
        if (d5 == Double.MAX_VALUE) {
            return d5;
        }
        boolean bl2 = this.isSnapToPixel();
        double d6 = insets != null ? this.snapSpaceY(insets.getTop(), bl2) : 0.0;
        double d7 = insets != null ? this.snapSpaceY(insets.getBottom(), bl2) : 0.0;
        double d8 = -1.0;
        if (node.isResizable() && node.getContentBias() == Orientation.HORIZONTAL) {
            d4 = insets != null ? this.snapSpaceX(insets.getLeft(), bl2) : 0.0;
            double d9 = insets != null ? this.snapSpaceX(insets.getRight(), bl2) : 0.0;
            d8 = this.snapSizeX(d3 != -1.0 ? Region.boundedSize(node.minWidth(-1.0), d3 - d4 - d9, node.maxWidth(-1.0)) : node.minWidth(-1.0));
            d5 = node.maxHeight(d8);
        }
        if (d2 != -1.0) {
            d4 = node.getBaselineOffset();
            if (node.isResizable() && d4 == Double.NEGATIVE_INFINITY) {
                return d6 + this.snapSizeY(Region.boundedSize(node.minHeight(d8), node.maxHeight(d8), Double.MAX_VALUE)) + d7 + d2;
            }
            return d6 + d4 + d2 + d7;
        }
        return d6 + this.snapSizeY(Region.boundedSize(node.minHeight(d8), d5, Double.MAX_VALUE)) + d7;
    }

    double computeMaxMinAreaWidth(List<Node> list, Callback<Node, Insets> callback) {
        return this.getMaxAreaWidth(list, callback, new double[]{-1.0}, false, true);
    }

    double computeMaxMinAreaWidth(List<Node> list, Callback<Node, Insets> callback, double d2, boolean bl2) {
        return this.getMaxAreaWidth(list, callback, new double[]{d2}, bl2, true);
    }

    double computeMaxMinAreaWidth(List<Node> list, Callback<Node, Insets> callback, double[] dArray, boolean bl2) {
        return this.getMaxAreaWidth(list, callback, dArray, bl2, true);
    }

    double computeMaxMinAreaHeight(List<Node> list, Callback<Node, Insets> callback, VPos vPos) {
        return this.getMaxAreaHeight(list, callback, null, vPos, true);
    }

    double computeMaxMinAreaHeight(List<Node> list, Callback<Node, Insets> callback, VPos vPos, double d2) {
        return this.getMaxAreaHeight(list, callback, new double[]{d2}, vPos, true);
    }

    double computeMaxMinAreaHeight(List<Node> list, Callback<Node, Insets> callback, double[] dArray, VPos vPos) {
        return this.getMaxAreaHeight(list, callback, dArray, vPos, true);
    }

    double computeMaxPrefAreaWidth(List<Node> list, Callback<Node, Insets> callback) {
        return this.getMaxAreaWidth(list, callback, new double[]{-1.0}, false, false);
    }

    double computeMaxPrefAreaWidth(List<Node> list, Callback<Node, Insets> callback, double d2, boolean bl2) {
        return this.getMaxAreaWidth(list, callback, new double[]{d2}, bl2, false);
    }

    double computeMaxPrefAreaWidth(List<Node> list, Callback<Node, Insets> callback, double[] dArray, boolean bl2) {
        return this.getMaxAreaWidth(list, callback, dArray, bl2, false);
    }

    double computeMaxPrefAreaHeight(List<Node> list, Callback<Node, Insets> callback, VPos vPos) {
        return this.getMaxAreaHeight(list, callback, null, vPos, false);
    }

    double computeMaxPrefAreaHeight(List<Node> list, Callback<Node, Insets> callback, double d2, VPos vPos) {
        return this.getMaxAreaHeight(list, callback, new double[]{d2}, vPos, false);
    }

    double computeMaxPrefAreaHeight(List<Node> list, Callback<Node, Insets> callback, double[] dArray, VPos vPos) {
        return this.getMaxAreaHeight(list, callback, dArray, vPos, false);
    }

    static Vec2d boundedNodeSizeWithBias(Node node, double d2, double d3, boolean bl2, boolean bl3, Vec2d vec2d) {
        double d4;
        double d5;
        Orientation orientation;
        if (vec2d == null) {
            vec2d = new Vec2d();
        }
        if ((orientation = node.getContentBias()) == null) {
            d5 = Region.boundedSize(node.minWidth(-1.0), bl2 ? d2 : Math.min(d2, node.prefWidth(-1.0)), node.maxWidth(-1.0));
            d4 = Region.boundedSize(node.minHeight(-1.0), bl3 ? d3 : Math.min(d3, node.prefHeight(-1.0)), node.maxHeight(-1.0));
        } else if (orientation == Orientation.HORIZONTAL) {
            d5 = Region.boundedSize(node.minWidth(-1.0), bl2 ? d2 : Math.min(d2, node.prefWidth(-1.0)), node.maxWidth(-1.0));
            d4 = Region.boundedSize(node.minHeight(d5), bl3 ? d3 : Math.min(d3, node.prefHeight(d5)), node.maxHeight(d5));
        } else {
            d4 = Region.boundedSize(node.minHeight(-1.0), bl3 ? d3 : Math.min(d3, node.prefHeight(-1.0)), node.maxHeight(-1.0));
            d5 = Region.boundedSize(node.minWidth(d4), bl2 ? d2 : Math.min(d2, node.prefWidth(d4)), node.maxWidth(d4));
        }
        vec2d.set(d5, d4);
        return vec2d;
    }

    private double getMaxAreaHeight(List<Node> list, Callback<Node, Insets> callback, double[] dArray, VPos object, boolean bl2) {
        double d2;
        double d3 = dArray == null ? -1.0 : (d2 = dArray.length == 1 ? dArray[0] : Double.NaN);
        if (object == VPos.BASELINE) {
            double d4 = 0.0;
            double d5 = 0.0;
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                double d6;
                Node node = list.get(i2);
                double d7 = Double.isNaN(d2) ? dArray[i2] : d2;
                Insets insets = callback.call(node);
                double d8 = insets != null ? this.snapSpaceY(insets.getTop()) : 0.0;
                double d9 = insets != null ? this.snapSpaceY(insets.getBottom()) : 0.0;
                double d10 = node.getBaselineOffset();
                double d11 = d6 = bl2 ? this.snapSizeY(node.minHeight(d7)) : this.snapSizeY(node.prefHeight(d7));
                if (d10 == Double.NEGATIVE_INFINITY) {
                    d4 = Math.max(d4, d6 + d8);
                    continue;
                }
                d4 = Math.max(d4, d10 + d8);
                d5 = Math.max(d5, this.snapSpaceY(bl2 ? this.snapSizeY(node.minHeight(d7)) : this.snapSizeY(node.prefHeight(d7))) - d10 + d9);
            }
            return d4 + d5;
        }
        double d12 = 0.0;
        int n3 = list.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            object = list.get(i3);
            Insets insets = callback.call((Node)object);
            double d13 = Double.isNaN(d2) ? dArray[i3] : d2;
            d12 = Math.max(d12, bl2 ? this.computeChildMinAreaHeight((Node)object, -1.0, insets, d13) : this.computeChildPrefAreaHeight((Node)object, -1.0, insets, d13));
        }
        return d12;
    }

    private double getMaxAreaWidth(List<Node> list, Callback<Node, Insets> callback, double[] dArray, boolean bl2, boolean bl3) {
        double d2 = dArray == null ? -1.0 : (dArray.length == 1 ? dArray[0] : Double.NaN);
        double d3 = 0.0;
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = list.get(i2);
            Insets insets = callback.call(node);
            double d4 = Double.isNaN(d2) ? dArray[i2] : d2;
            d3 = Math.max(d3, bl3 ? this.computeChildMinAreaWidth(list.get(i2), -1.0, insets, d4, bl2) : this.computeChildPrefAreaWidth(node, -1.0, insets, d4, bl2));
        }
        return d3;
    }

    protected void positionInArea(Node node, double d2, double d3, double d4, double d5, double d6, HPos hPos, VPos vPos) {
        Region.positionInArea(node, d2, d3, d4, d5, d6, Insets.EMPTY, hPos, vPos, this.isSnapToPixel());
    }

    public static void positionInArea(Node node, double d2, double d3, double d4, double d5, double d6, Insets insets, HPos hPos, VPos vPos, boolean bl2) {
        insets = insets != null ? insets : Insets.EMPTY;
        double d7 = bl2 ? Region.getSnapScaleX(node) : 1.0;
        double d8 = bl2 ? Region.getSnapScaleY(node) : 1.0;
        Region.position(node, d2, d3, d4, d5, d6, Region.snapSpace(insets.getTop(), bl2, d8), Region.snapSpace(insets.getRight(), bl2, d7), Region.snapSpace(insets.getBottom(), bl2, d8), Region.snapSpace(insets.getLeft(), bl2, d7), hPos, vPos, bl2);
    }

    protected void layoutInArea(Node node, double d2, double d3, double d4, double d5, double d6, HPos hPos, VPos vPos) {
        this.layoutInArea(node, d2, d3, d4, d5, d6, Insets.EMPTY, hPos, vPos);
    }

    protected void layoutInArea(Node node, double d2, double d3, double d4, double d5, double d6, Insets insets, HPos hPos, VPos vPos) {
        this.layoutInArea(node, d2, d3, d4, d5, d6, insets, true, true, hPos, vPos);
    }

    protected void layoutInArea(Node node, double d2, double d3, double d4, double d5, double d6, Insets insets, boolean bl2, boolean bl3, HPos hPos, VPos vPos) {
        Region.layoutInArea(node, d2, d3, d4, d5, d6, insets, bl2, bl3, hPos, vPos, this.isSnapToPixel());
    }

    public static void layoutInArea(Node node, double d2, double d3, double d4, double d5, double d6, Insets insets, boolean bl2, boolean bl3, HPos hPos, VPos vPos, boolean bl4) {
        insets = insets != null ? insets : Insets.EMPTY;
        double d7 = bl4 ? Region.getSnapScaleX(node) : 1.0;
        double d8 = bl4 ? Region.getSnapScaleY(node) : 1.0;
        double d9 = Region.snapSpace(insets.getTop(), bl4, d8);
        double d10 = Region.snapSpace(insets.getBottom(), bl4, d8);
        double d11 = Region.snapSpace(insets.getLeft(), bl4, d7);
        double d12 = Region.snapSpace(insets.getRight(), bl4, d7);
        if (vPos == VPos.BASELINE) {
            double d13 = node.getBaselineOffset();
            if (d13 == Double.NEGATIVE_INFINITY) {
                if (node.isResizable()) {
                    d10 += Region.snapSpace(d5 - d6, bl4, d8);
                } else {
                    d9 = Region.snapSpace(d6 - node.getLayoutBounds().getHeight(), bl4, d8);
                }
            } else {
                d9 = Region.snapSpace(d6 - d13, bl4, d8);
            }
        }
        if (node.isResizable()) {
            Vec2d vec2d = Region.boundedNodeSizeWithBias(node, d4 - d11 - d12, d5 - d9 - d10, bl2, bl3, TEMP_VEC2D);
            node.resize(Region.snapSize(vec2d.x, bl4, d7), Region.snapSize(vec2d.y, bl4, d8));
        }
        Region.position(node, d2, d3, d4, d5, d6, d9, d12, d10, d11, hPos, vPos, bl4);
    }

    private static void position(Node node, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, HPos hPos, VPos vPos, boolean bl2) {
        double d11;
        double d12 = d10 + Region.computeXOffset(d4 - d10 - d8, node.getLayoutBounds().getWidth(), hPos);
        double d13 = vPos == VPos.BASELINE ? ((d11 = node.getBaselineOffset()) == Double.NEGATIVE_INFINITY ? d6 - node.getLayoutBounds().getHeight() : d6 - d11) : d7 + Region.computeYOffset(d5 - d7 - d9, node.getLayoutBounds().getHeight(), vPos);
        d11 = d2 + d12;
        double d14 = d3 + d13;
        if (bl2) {
            d11 = Region.snapPosition(d11, true, Region.getSnapScaleX(node));
            d14 = Region.snapPosition(d14, true, Region.getSnapScaleY(node));
        }
        node.relocate(d11, d14);
    }

    private void doUpdatePeer() {
        boolean bl2;
        boolean bl3;
        if (this._shape != null) {
            NodeHelper.syncPeer(this._shape);
        }
        NGRegion nGRegion = (NGRegion)NodeHelper.getPeer(this);
        if (!this.cornersValid) {
            this.validateCorners();
        }
        if (bl3 = NodeHelper.isDirty(this, DirtyBits.NODE_GEOMETRY)) {
            nGRegion.setSize((float)this.getWidth(), (float)this.getHeight());
        }
        if (bl2 = NodeHelper.isDirty(this, DirtyBits.REGION_SHAPE)) {
            nGRegion.updateShape(this._shape, this.isScaleShape(), this.isCenterShape(), this.isCacheShape());
        }
        nGRegion.updateFillCorners(this.normalizedFillCorners);
        boolean bl4 = NodeHelper.isDirty(this, DirtyBits.SHAPE_FILL);
        Background background = this.getBackground();
        if (bl4) {
            nGRegion.updateBackground(background);
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_CONTENTS)) {
            nGRegion.imagesUpdated();
        }
        nGRegion.updateStrokeCorners(this.normalizedStrokeCorners);
        if (NodeHelper.isDirty(this, DirtyBits.SHAPE_STROKE)) {
            nGRegion.updateBorder(this.getBorder());
        }
        if (bl3 || bl4 || bl2) {
            Insets insets = this.getOpaqueInsets();
            if (this._shape != null) {
                if (insets != null) {
                    nGRegion.setOpaqueInsets((float)insets.getTop(), (float)insets.getRight(), (float)insets.getBottom(), (float)insets.getLeft());
                    return;
                }
                nGRegion.setOpaqueInsets(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
                return;
            }
            if (background == null || background.isEmpty()) {
                nGRegion.setOpaqueInsets(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
                return;
            }
            double[] dArray = new double[4];
            background.computeOpaqueInsets(this.getWidth(), this.getHeight(), dArray);
            if (insets != null) {
                double d2 = Double.isNaN(dArray[0]) ? insets.getTop() : (dArray[0] = Double.isNaN(insets.getTop()) ? dArray[0] : Math.min(dArray[0], insets.getTop()));
                double d3 = Double.isNaN(dArray[1]) ? insets.getRight() : (dArray[1] = Double.isNaN(insets.getRight()) ? dArray[1] : Math.min(dArray[1], insets.getRight()));
                double d4 = Double.isNaN(dArray[2]) ? insets.getBottom() : (dArray[2] = Double.isNaN(insets.getBottom()) ? dArray[2] : Math.min(dArray[2], insets.getBottom()));
                dArray[3] = Double.isNaN(dArray[3]) ? insets.getLeft() : (Double.isNaN(insets.getLeft()) ? dArray[3] : Math.min(dArray[3], insets.getLeft()));
            }
            nGRegion.setOpaqueInsets((float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3]);
        }
    }

    private NGNode doCreatePeer() {
        return new NGRegion();
    }

    private boolean shapeContains(Shape shape, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d2;
        double d9 = d3;
        RectBounds rectBounds = shape.getBounds();
        if (this.isScaleShape()) {
            d8 -= d7;
            d9 -= d4;
            d8 *= (double)((BaseBounds)rectBounds).getWidth() / (this.getWidth() - d7 - d5);
            d9 *= (double)((BaseBounds)rectBounds).getHeight() / (this.getHeight() - d4 - d6);
            if (this.isCenterShape()) {
                d8 += (double)((BaseBounds)rectBounds).getMinX();
                d9 += (double)((BaseBounds)rectBounds).getMinY();
            }
        } else if (this.isCenterShape()) {
            double d10 = ((BaseBounds)rectBounds).getWidth();
            double d11 = ((BaseBounds)rectBounds).getHeight();
            double d12 = d10;
            double d13 = d12 / (d12 - d7 - d5);
            double d14 = d11;
            double d15 = d14 / (d14 - d4 - d6);
            d8 = d13 * (d8 - (d7 + (this.getWidth() - d10) / 2.0)) + (double)((BaseBounds)rectBounds).getMinX();
            d9 = d15 * (d9 - (d4 + (this.getHeight() - d11) / 2.0)) + (double)((BaseBounds)rectBounds).getMinY();
        } else if (d4 != 0.0 || d5 != 0.0 || d6 != 0.0 || d7 != 0.0) {
            double d16 = (double)((BaseBounds)rectBounds).getWidth() / ((double)((BaseBounds)rectBounds).getWidth() - d7 - d5);
            double d17 = (double)((BaseBounds)rectBounds).getHeight() / ((double)((BaseBounds)rectBounds).getHeight() - d4 - d6);
            d8 = d16 * (d8 - d7 - (double)((BaseBounds)rectBounds).getMinX()) + (double)((BaseBounds)rectBounds).getMinX();
            d9 = d17 * (d9 - d4 - (double)((BaseBounds)rectBounds).getMinY()) + (double)((BaseBounds)rectBounds).getMinY();
        }
        return shape.contains((float)d8, (float)d9);
    }

    private boolean doComputeContains(double d2, double d3) {
        int n2;
        double d4 = this.getWidth();
        double d5 = this.getHeight();
        List<BackgroundFill> list = this.getBackground();
        if (this._shape != null) {
            if (list != null && !((Background)((Object)list)).getFills().isEmpty()) {
                list = ((Background)((Object)list)).getFills();
                double d6 = Double.MAX_VALUE;
                double d7 = Double.MAX_VALUE;
                double d8 = Double.MAX_VALUE;
                double d9 = Double.MAX_VALUE;
                int n3 = list.size();
                for (int i2 = 0; i2 < n3; ++i2) {
                    BackgroundFill backgroundFill = list.get(0);
                    d6 = Math.min(d6, backgroundFill.getInsets().getTop());
                    d7 = Math.min(d7, backgroundFill.getInsets().getLeft());
                    d8 = Math.min(d8, backgroundFill.getInsets().getBottom());
                    d9 = Math.min(d9, backgroundFill.getInsets().getRight());
                }
                Region region = this;
                return region.shapeContains(ShapeHelper.configShape(region._shape), d2, d3, d6, d7, d8, d9);
            }
            return false;
        }
        if (list != null) {
            list = ((Background)((Object)list)).getFills();
            n2 = list.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                BackgroundFill backgroundFill = list.get(i3);
                if (!this.contains(d2, d3, 0.0, 0.0, d4, d5, backgroundFill.getInsets(), this.getNormalizedFillCorner(i3))) continue;
                return true;
            }
        }
        if ((list = this.getBorder()) != null) {
            List<BorderStroke> list2 = ((Border)((Object)list)).getStrokes();
            int n4 = list2.size();
            for (n2 = 0; n2 < n4; ++n2) {
                BorderStroke borderStroke = list2.get(n2);
                if (!this.contains(d2, d3, 0.0, 0.0, d4, d5, borderStroke.getWidths(), false, borderStroke.getInsets(), this.getNormalizedStrokeCorner(n2))) continue;
                return true;
            }
            List<BorderImage> list3 = ((Border)((Object)list)).getImages();
            int n5 = list3.size();
            for (n4 = 0; n4 < n5; ++n4) {
                BorderImage borderImage = list3.get(n4);
                if (!this.contains(d2, d3, 0.0, 0.0, d4, d5, borderImage.getWidths(), borderImage.isFilled(), borderImage.getInsets(), CornerRadii.EMPTY)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(double d2, double d3, double d4, double d5, double d6, double d7, BorderWidths borderWidths, boolean bl2, Insets insets, CornerRadii cornerRadii) {
        boolean bl3;
        return bl2 ? this.contains(d2, d3, d4, d5, d6, d7, insets, cornerRadii) : (bl2 = this.contains(d2, d3, d4, d5, d6, d7, insets, cornerRadii)) && (bl3 = !this.contains(d2, d3, d4 + (borderWidths.isLeftAsPercentage() ? this.getWidth() * borderWidths.getLeft() : borderWidths.getLeft()), d5 + (borderWidths.isTopAsPercentage() ? this.getHeight() * borderWidths.getTop() : borderWidths.getTop()), d6 - (borderWidths.isRightAsPercentage() ? this.getWidth() * borderWidths.getRight() : borderWidths.getRight()), d7 - (borderWidths.isBottomAsPercentage() ? this.getHeight() * borderWidths.getBottom() : borderWidths.getBottom()), insets, cornerRadii));
    }

    private boolean contains(double d2, double d3, double d4, double d5, double d6, double d7, Insets insets, CornerRadii cornerRadii) {
        double d8 = d4 + insets.getLeft();
        double d9 = d5 + insets.getTop();
        double d10 = d6 - insets.getRight();
        double d11 = d7 - insets.getBottom();
        if (d2 >= d8 && d3 >= d9 && d2 <= d10 && d3 <= d11) {
            double d12;
            double d13;
            double d14;
            double d15;
            double d16;
            double d17 = cornerRadii.getTopLeftHorizontalRadius();
            if (cornerRadii.isUniform() && d17 == 0.0) {
                return true;
            }
            double d18 = cornerRadii.getTopLeftVerticalRadius();
            double d19 = cornerRadii.getTopRightHorizontalRadius();
            double d20 = cornerRadii.getTopRightVerticalRadius();
            double d21 = cornerRadii.getBottomLeftHorizontalRadius();
            double d22 = cornerRadii.getBottomLeftVerticalRadius();
            double d23 = cornerRadii.getBottomRightHorizontalRadius();
            double d24 = cornerRadii.getBottomRightVerticalRadius();
            if (d2 <= d8 + d17 && d3 <= d9 + d18) {
                d16 = d8 + d17;
                d15 = d9 + d18;
                d14 = d17;
                d13 = d18;
            } else if (d2 >= d10 - d19 && d3 <= d9 + d20) {
                d16 = d10 - d19;
                d15 = d9 + d20;
                d14 = d19;
                d13 = d20;
            } else if (d2 >= d10 - d23 && d3 >= d11 - d24) {
                d16 = d10 - d23;
                d15 = d11 - d24;
                d14 = d23;
                d13 = d24;
            } else if (d2 <= d8 + d21 && d3 >= d11 - d22) {
                d16 = d8 + d21;
                d15 = d11 - d22;
                d14 = d21;
                d13 = d22;
            } else {
                return true;
            }
            double d25 = d2 - d16;
            double d26 = d3 - d15;
            double d27 = d25;
            double d28 = d14;
            double d29 = d26;
            double d30 = d13;
            double d31 = d27 * d27 / (d28 * d28) + d29 * d29 / (d30 * d30);
            if (d12 - 1.0E-7 <= 1.0) {
                return true;
            }
        }
        return false;
    }

    private CornerRadii getNormalizedFillCorner(int n2) {
        if (!this.cornersValid) {
            this.validateCorners();
        }
        if (this.normalizedFillCorners == null) {
            return this.getBackground().getFills().get(n2).getRadii();
        }
        return this.normalizedFillCorners.get(n2);
    }

    private CornerRadii getNormalizedStrokeCorner(int n2) {
        if (!this.cornersValid) {
            this.validateCorners();
        }
        if (this.normalizedStrokeCorners == null) {
            return this.getBorder().getStrokes().get(n2).getRadii();
        }
        return this.normalizedStrokeCorners.get(n2);
    }

    private void validateCorners() {
        int n2;
        Object object;
        CornerRadii cornerRadii;
        Object object2;
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        List<Object> list = null;
        List<Object> list2 = null;
        Object object3 = this.getBackground();
        object3 = object3 == null ? Collections.EMPTY_LIST : ((Background)object3).getFills();
        for (int i2 = 0; i2 < object3.size(); ++i2) {
            object2 = (BackgroundFill)object3.get(i2);
            CornerRadii cornerRadii2 = ((BackgroundFill)object2).getRadii();
            if (cornerRadii2 == (cornerRadii = Region.normalize(cornerRadii2, (Insets)(object = ((BackgroundFill)object2).getInsets()), d2, d3))) continue;
            if (list == null) {
                list = Arrays.asList(new CornerRadii[object3.size()]);
            }
            list.set(i2, cornerRadii);
        }
        Object object4 = this.getBorder();
        object2 = object4 == null ? Collections.EMPTY_LIST : ((Border)object4).getStrokes();
        for (n2 = 0; n2 < object2.size(); ++n2) {
            object = (BorderStroke)object2.get(n2);
            cornerRadii = ((BorderStroke)object).getRadii();
            object4 = ((BorderStroke)object).getInsets();
            if (cornerRadii == (object4 = Region.normalize(cornerRadii, (Insets)object4, d2, d3))) continue;
            if (list2 == null) {
                list2 = Arrays.asList(new CornerRadii[object2.size()]);
            }
            list2.set(n2, object4);
        }
        if (list != null) {
            for (n2 = 0; n2 < object3.size(); ++n2) {
                if (list.get(n2) != null) continue;
                list.set(n2, ((BackgroundFill)object3.get(n2)).getRadii());
            }
            list = Collections.unmodifiableList(list);
        }
        if (list2 != null) {
            for (n2 = 0; n2 < object2.size(); ++n2) {
                if (list2.get(n2) != null) continue;
                list2.set(n2, ((BorderStroke)object2.get(n2)).getRadii());
            }
            list2 = Collections.unmodifiableList(list2);
        }
        this.normalizedFillCorners = list;
        this.normalizedStrokeCorners = list2;
        this.cornersValid = true;
    }

    private static CornerRadii normalize(CornerRadii cornerRadii, Insets insets, double d2, double d3) {
        d3 -= insets.getTop() + insets.getBottom();
        if ((d2 -= insets.getLeft() + insets.getRight()) <= 0.0 || d3 <= 0.0) {
            return CornerRadii.EMPTY;
        }
        double d4 = cornerRadii.getTopLeftVerticalRadius();
        double d5 = cornerRadii.getTopLeftHorizontalRadius();
        double d6 = cornerRadii.getTopRightVerticalRadius();
        double d7 = cornerRadii.getTopRightHorizontalRadius();
        double d8 = cornerRadii.getBottomRightVerticalRadius();
        double d9 = cornerRadii.getBottomRightHorizontalRadius();
        double d10 = cornerRadii.getBottomLeftVerticalRadius();
        double d11 = cornerRadii.getBottomLeftHorizontalRadius();
        if (cornerRadii.hasPercentBasedRadii) {
            if (cornerRadii.isTopLeftVerticalRadiusAsPercentage()) {
                d4 *= d3;
            }
            if (cornerRadii.isTopLeftHorizontalRadiusAsPercentage()) {
                d5 *= d2;
            }
            if (cornerRadii.isTopRightVerticalRadiusAsPercentage()) {
                d6 *= d3;
            }
            if (cornerRadii.isTopRightHorizontalRadiusAsPercentage()) {
                d7 *= d2;
            }
            if (cornerRadii.isBottomRightVerticalRadiusAsPercentage()) {
                d8 *= d3;
            }
            if (cornerRadii.isBottomRightHorizontalRadiusAsPercentage()) {
                d9 *= d2;
            }
            if (cornerRadii.isBottomLeftVerticalRadiusAsPercentage()) {
                d10 *= d3;
            }
            if (cornerRadii.isBottomLeftHorizontalRadiusAsPercentage()) {
                d11 *= d2;
            }
        }
        double d12 = 1.0;
        if (d5 + d7 > d2) {
            d12 = Math.min(1.0, d2 / (d5 + d7));
        }
        if (d11 + d9 > d2) {
            d12 = Math.min(d12, d2 / (d11 + d9));
        }
        if (d4 + d10 > d3) {
            d12 = Math.min(d12, d3 / (d4 + d10));
        }
        if (d6 + d8 > d3) {
            d12 = Math.min(d12, d3 / (d6 + d8));
        }
        if (d12 < 1.0) {
            d4 *= d12;
            d5 *= d12;
            d6 *= d12;
            d7 *= d12;
            d8 *= d12;
            d9 *= d12;
            d10 *= d12;
            d11 *= d12;
        }
        if (cornerRadii.hasPercentBasedRadii || d12 < 1.0) {
            return new CornerRadii(d5, d4, d6, d7, d9, d8, d10, d11, false, false, false, false, false, false, false, false);
        }
        return cornerRadii;
    }

    private void doPickNodeLocal(PickRay pickRay, PickResultChooser pickResultChooser) {
        double d2 = NodeHelper.intersectsBounds(this, pickRay);
        if (!Double.isNaN(d2) && ParentHelper.pickChildrenNode(this, pickRay, pickResultChooser)) {
            NodeHelper.intersects(this, pickRay, pickResultChooser);
        }
    }

    private Bounds doComputeLayoutBounds() {
        if (this.boundingBox == null) {
            this.boundingBox = new BoundingBox(0.0, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0);
        }
        return this.boundingBox;
    }

    private void doNotifyLayoutBoundsChanged() {
    }

    private BaseBounds computeShapeBounds(BaseBounds baseBounds) {
        Border border;
        Shape shape = ShapeHelper.configShape(this._shape);
        float[] fArray = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        Object object2 = this.getBackground();
        if (object2 != null) {
            RectBounds object3 = shape.getBounds();
            object2 = ((Background)object2).getOutsets();
            fArray[0] = ((BaseBounds)object3).getMinX() - (float)((Insets)object2).getLeft();
            fArray[1] = ((BaseBounds)object3).getMinY() - (float)((Insets)object2).getTop();
            fArray[2] = ((BaseBounds)object3).getMaxX() + (float)((Insets)object2).getBottom();
            fArray[3] = ((BaseBounds)object3).getMaxY() + (float)((Insets)object2).getRight();
        }
        if ((border = this.getBorder()) != null && border.getStrokes().size() > 0) {
            for (BorderStroke borderStroke : border.getStrokes()) {
                BorderStrokeStyle borderStrokeStyle;
                if ((borderStroke.getTopStyle() != null ? borderStroke.getTopStyle() : (borderStroke.getLeftStyle() != null ? borderStroke.getLeftStyle() : (borderStroke.getBottomStyle() != null ? borderStroke.getBottomStyle() : (borderStrokeStyle = borderStroke.getRightStyle() != null ? borderStroke.getRightStyle() : null)))) == null || borderStrokeStyle == BorderStrokeStyle.NONE) continue;
                StrokeType strokeType = borderStrokeStyle.getType();
                double d2 = Math.max(borderStroke.getWidths().top, 0.0);
                StrokeLineCap strokeLineCap = borderStrokeStyle.getLineCap();
                StrokeLineJoin strokeLineJoin = borderStrokeStyle.getLineJoin();
                float f2 = (float)Math.max(borderStrokeStyle.getMiterLimit(), 1.0);
                Toolkit.getToolkit().accumulateStrokeBounds(shape, fArray, strokeType, d2, strokeLineCap, strokeLineJoin, f2, BaseTransform.IDENTITY_TRANSFORM);
            }
        }
        if (fArray[2] < fArray[0] || fArray[3] < fArray[1]) {
            return baseBounds.makeEmpty();
        }
        return baseBounds.deriveWithNewBounds(fArray[0], fArray[1], 0.0f, fArray[2], fArray[3], 0.0f);
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        Object object;
        double d2;
        double d3;
        Object object2;
        double d4 = this.getWidth();
        double d5 = this.getHeight();
        if (this._shape != null && !this.isScaleShape()) {
            object2 = this.computeShapeBounds(baseBounds);
            double d6 = ((BaseBounds)object2).getWidth();
            double d7 = ((BaseBounds)object2).getHeight();
            if (this.isCenterShape()) {
                d3 = (d4 - d6) / 2.0;
                d2 = (d5 - d7) / 2.0;
                d4 = d3 + d6;
                d5 = d2 + d7;
            } else {
                d3 = ((BaseBounds)object2).getMinX();
                d2 = ((BaseBounds)object2).getMinY();
                d4 = ((BaseBounds)object2).getMaxX();
                d5 = ((BaseBounds)object2).getMaxY();
            }
        } else {
            object2 = this.getBackground();
            Border border = this.getBorder();
            object = object2 == null ? Insets.EMPTY : ((Background)object2).getOutsets();
            Insets insets = border == null ? Insets.EMPTY : border.getOutsets();
            d3 = 0.0 - Math.max(((Insets)object).getLeft(), insets.getLeft());
            d2 = 0.0 - Math.max(((Insets)object).getTop(), insets.getTop());
            d4 += Math.max(((Insets)object).getRight(), insets.getRight());
            d5 += Math.max(((Insets)object).getBottom(), insets.getBottom());
        }
        object2 = RegionHelper.superComputeGeomBounds(this, baseBounds, baseTransform);
        if (((BaseBounds)object2).isEmpty()) {
            BaseBounds baseBounds2 = baseBounds = baseBounds.deriveWithNewBounds((float)d3, (float)d2, 0.0f, (float)d4, (float)d5, 0.0f);
            baseBounds = baseTransform.transform(baseBounds2, baseBounds2);
            return baseBounds;
        }
        BaseBounds baseBounds3 = TempState.getInstance().bounds;
        BaseBounds baseBounds4 = baseBounds3 = baseBounds3.deriveWithNewBounds((float)d3, (float)d2, 0.0f, (float)d4, (float)d5, 0.0f);
        object = baseTransform.transform(baseBounds4, baseBounds4);
        object2 = ((BaseBounds)object2).deriveWithUnion((BaseBounds)object);
        return object2;
    }

    public String getUserAgentStylesheet() {
        return null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Region$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Region.getClassCssMetaData();
    }

    static /* synthetic */ void access$000(Region region) {
        region.requestParentLayout();
    }

    static /* synthetic */ void access$100(Region region) {
        region.requestParentLayout();
    }

    static {
        RegionHelper.setRegionAccessor(new Region$1());
        TEMP_VEC2D = new Vec2d();
    }
}

