/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.TilePane$1;
import javafx.scene.layout.TilePane$10;
import javafx.scene.layout.TilePane$11;
import javafx.scene.layout.TilePane$2;
import javafx.scene.layout.TilePane$3;
import javafx.scene.layout.TilePane$4;
import javafx.scene.layout.TilePane$5;
import javafx.scene.layout.TilePane$6;
import javafx.scene.layout.TilePane$7;
import javafx.scene.layout.TilePane$8;
import javafx.scene.layout.TilePane$9;
import javafx.scene.layout.TilePane$StyleableProperties;
import javafx.scene.layout.TilePane$TileSizeProperty;
import javafx.util.Callback;

public class TilePane
extends Pane {
    private static final String MARGIN_CONSTRAINT = "tilepane-margin";
    private static final String ALIGNMENT_CONSTRAINT = "tilepane-alignment";
    private static final Callback<Node, Insets> marginAccessor = node -> TilePane.getMargin(node);
    private double _tileWidth = -1.0;
    private double _tileHeight = -1.0;
    private ObjectProperty<Orientation> orientation;
    private IntegerProperty prefRows;
    private IntegerProperty prefColumns;
    private DoubleProperty prefTileWidth;
    private DoubleProperty prefTileHeight;
    private TilePane$TileSizeProperty tileWidth;
    private TilePane$TileSizeProperty tileHeight;
    private DoubleProperty hgap;
    private DoubleProperty vgap;
    private ObjectProperty<Pos> alignment;
    private ObjectProperty<Pos> tileAlignment;
    private int actualRows = 0;
    private int actualColumns = 0;

    public static void setAlignment(Node node, Pos pos) {
        TilePane.setConstraint(node, ALIGNMENT_CONSTRAINT, (Object)pos);
    }

    public static Pos getAlignment(Node node) {
        return (Pos)((Object)TilePane.getConstraint(node, ALIGNMENT_CONSTRAINT));
    }

    public static void setMargin(Node node, Insets insets) {
        TilePane.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)TilePane.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        TilePane.setAlignment(node, null);
        TilePane.setMargin(node, null);
    }

    public TilePane() {
    }

    public TilePane(Orientation orientation) {
        this.setOrientation(orientation);
    }

    public TilePane(double d2, double d3) {
        this.setHgap(d2);
        this.setVgap(d3);
    }

    public TilePane(Orientation orientation, double d2, double d3) {
        this();
        this.setOrientation(orientation);
        this.setHgap(d2);
        this.setVgap(d3);
    }

    public TilePane(Node ... nodeArray) {
        this.getChildren().addAll((Node[])nodeArray);
    }

    public TilePane(Orientation orientation, Node ... nodeArray) {
        this.setOrientation(orientation);
        this.getChildren().addAll((Node[])nodeArray);
    }

    public TilePane(double d2, double d3, Node ... nodeArray) {
        this.setHgap(d2);
        this.setVgap(d3);
        this.getChildren().addAll((Node[])nodeArray);
    }

    public TilePane(Orientation orientation, double d2, double d3, Node ... nodeArray) {
        this();
        this.setOrientation(orientation);
        this.setHgap(d2);
        this.setVgap(d3);
        this.getChildren().addAll((Node[])nodeArray);
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new TilePane$1(this, (Object)Orientation.HORIZONTAL);
        }
        return this.orientation;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        if (this.orientation == null) {
            return Orientation.HORIZONTAL;
        }
        return (Orientation)((Object)this.orientation.get());
    }

    public final IntegerProperty prefRowsProperty() {
        if (this.prefRows == null) {
            this.prefRows = new TilePane$2(this, 5);
        }
        return this.prefRows;
    }

    public final void setPrefRows(int n2) {
        this.prefRowsProperty().set(n2);
    }

    public final int getPrefRows() {
        if (this.prefRows == null) {
            return 5;
        }
        return this.prefRows.get();
    }

    public final IntegerProperty prefColumnsProperty() {
        if (this.prefColumns == null) {
            this.prefColumns = new TilePane$3(this, 5);
        }
        return this.prefColumns;
    }

    public final void setPrefColumns(int n2) {
        this.prefColumnsProperty().set(n2);
    }

    public final int getPrefColumns() {
        if (this.prefColumns == null) {
            return 5;
        }
        return this.prefColumns.get();
    }

    public final DoubleProperty prefTileWidthProperty() {
        if (this.prefTileWidth == null) {
            this.prefTileWidth = new TilePane$4(this, -1.0);
        }
        return this.prefTileWidth;
    }

    public final void setPrefTileWidth(double d2) {
        this.prefTileWidthProperty().set(d2);
    }

    public final double getPrefTileWidth() {
        if (this.prefTileWidth == null) {
            return -1.0;
        }
        return this.prefTileWidth.get();
    }

    public final DoubleProperty prefTileHeightProperty() {
        if (this.prefTileHeight == null) {
            this.prefTileHeight = new TilePane$5(this, -1.0);
        }
        return this.prefTileHeight;
    }

    public final void setPrefTileHeight(double d2) {
        this.prefTileHeightProperty().set(d2);
    }

    public final double getPrefTileHeight() {
        if (this.prefTileHeight == null) {
            return -1.0;
        }
        return this.prefTileHeight.get();
    }

    public final ReadOnlyDoubleProperty tileWidthProperty() {
        if (this.tileWidth == null) {
            this.tileWidth = new TilePane$6(this, "tileWidth", this._tileWidth);
        }
        return this.tileWidth;
    }

    private void invalidateTileWidth() {
        if (this.tileWidth != null) {
            this.tileWidth.invalidate();
            return;
        }
        this._tileWidth = -1.0;
    }

    public final double getTileWidth() {
        if (this.tileWidth != null) {
            return this.tileWidth.get();
        }
        if (this._tileWidth == -1.0) {
            this._tileWidth = this.computeTileWidth();
        }
        return this._tileWidth;
    }

    public final ReadOnlyDoubleProperty tileHeightProperty() {
        if (this.tileHeight == null) {
            this.tileHeight = new TilePane$7(this, "tileHeight", this._tileHeight);
        }
        return this.tileHeight;
    }

    private void invalidateTileHeight() {
        if (this.tileHeight != null) {
            this.tileHeight.invalidate();
            return;
        }
        this._tileHeight = -1.0;
    }

    public final double getTileHeight() {
        if (this.tileHeight != null) {
            return this.tileHeight.get();
        }
        if (this._tileHeight == -1.0) {
            this._tileHeight = this.computeTileHeight();
        }
        return this._tileHeight;
    }

    public final DoubleProperty hgapProperty() {
        if (this.hgap == null) {
            this.hgap = new TilePane$8(this);
        }
        return this.hgap;
    }

    public final void setHgap(double d2) {
        this.hgapProperty().set(d2);
    }

    public final double getHgap() {
        if (this.hgap == null) {
            return 0.0;
        }
        return this.hgap.get();
    }

    public final DoubleProperty vgapProperty() {
        if (this.vgap == null) {
            this.vgap = new TilePane$9(this);
        }
        return this.vgap;
    }

    public final void setVgap(double d2) {
        this.vgapProperty().set(d2);
    }

    public final double getVgap() {
        if (this.vgap == null) {
            return 0.0;
        }
        return this.vgap.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new TilePane$10(this, Pos.TOP_LEFT);
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        if (this.alignment == null) {
            return Pos.TOP_LEFT;
        }
        return (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos pos = this.getAlignment();
        if (pos == null) {
            return Pos.TOP_LEFT;
        }
        return pos;
    }

    public final ObjectProperty<Pos> tileAlignmentProperty() {
        if (this.tileAlignment == null) {
            this.tileAlignment = new TilePane$11(this, Pos.CENTER);
        }
        return this.tileAlignment;
    }

    public final void setTileAlignment(Pos pos) {
        this.tileAlignmentProperty().set(pos);
    }

    public final Pos getTileAlignment() {
        if (this.tileAlignment == null) {
            return Pos.CENTER;
        }
        return (Pos)((Object)this.tileAlignment.get());
    }

    private Pos getTileAlignmentInternal() {
        Pos pos = this.getTileAlignment();
        if (pos == null) {
            return Pos.CENTER;
        }
        return pos;
    }

    @Override
    public Orientation getContentBias() {
        return this.getOrientation();
    }

    @Override
    public void requestLayout() {
        this.invalidateTileWidth();
        this.invalidateTileHeight();
        super.requestLayout();
    }

    @Override
    protected double computeMinWidth(double d2) {
        if (((Node)this).getContentBias() == Orientation.HORIZONTAL) {
            return this.getInsets().getLeft() + this.getTileWidth() + this.getInsets().getRight();
        }
        return this.computePrefWidth(d2);
    }

    @Override
    protected double computeMinHeight(double d2) {
        if (((Node)this).getContentBias() == Orientation.VERTICAL) {
            return this.getInsets().getTop() + this.getTileHeight() + this.getInsets().getBottom();
        }
        return this.computePrefHeight(d2);
    }

    @Override
    protected double computePrefWidth(double d2) {
        int n2;
        int n3;
        List list = this.getManagedChildren();
        Insets insets = this.getInsets();
        if (d2 != -1.0) {
            n3 = this.computeRows(d2 - this.snapSpaceY(insets.getTop()) - this.snapSpaceY(insets.getBottom()), this.getTileHeight());
            n2 = this.computeOther(list.size(), n3);
        } else {
            n2 = this.getOrientation() == Orientation.HORIZONTAL ? this.getPrefColumns() : this.computeOther(list.size(), this.getPrefRows());
        }
        n3 = n2;
        return this.snapSpaceX(insets.getLeft()) + this.computeContentWidth(n3, this.getTileWidth()) + this.snapSpaceX(insets.getRight());
    }

    @Override
    protected double computePrefHeight(double d2) {
        int n2;
        int n3;
        List list = this.getManagedChildren();
        Insets insets = this.getInsets();
        if (d2 != -1.0) {
            n3 = this.computeColumns(d2 - this.snapSpaceX(insets.getLeft()) - this.snapSpaceX(insets.getRight()), this.getTileWidth());
            n2 = this.computeOther(list.size(), n3);
        } else {
            n2 = this.getOrientation() == Orientation.HORIZONTAL ? this.computeOther(list.size(), this.getPrefColumns()) : this.getPrefRows();
        }
        n3 = n2;
        return this.snapSpaceY(insets.getTop()) + this.computeContentHeight(n3, this.getTileHeight()) + this.snapSpaceY(insets.getBottom());
    }

    private double computeTileWidth() {
        List<Node> list = this.getManagedChildren();
        double d2 = this.getPrefTileWidth();
        if (d2 == -1.0) {
            double d3 = -1.0;
            boolean bl2 = false;
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = (Node)list.get(i2);
                if (node.getContentBias() != Orientation.VERTICAL) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                d3 = this.computeMaxPrefAreaHeight(list, marginAccessor, -1.0, this.getTileAlignmentInternal().getVpos());
            }
            TilePane tilePane = this;
            return tilePane.snapSizeX(tilePane.computeMaxPrefAreaWidth(list, marginAccessor, d3, true));
        }
        return this.snapSizeX(d2);
    }

    private double computeTileHeight() {
        List<Node> list = this.getManagedChildren();
        double d2 = this.getPrefTileHeight();
        if (d2 == -1.0) {
            double d3 = -1.0;
            boolean bl2 = false;
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = (Node)list.get(i2);
                if (node.getContentBias() != Orientation.HORIZONTAL) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                d3 = this.computeMaxPrefAreaWidth(list, marginAccessor);
            }
            TilePane tilePane = this;
            return tilePane.snapSizeY(tilePane.computeMaxPrefAreaHeight(list, marginAccessor, d3, this.getTileAlignmentInternal().getVpos()));
        }
        return this.snapSizeY(d2);
    }

    private int computeOther(int n2, int n3) {
        double d2 = (double)n2 / (double)Math.max(1, n3);
        return (int)Math.ceil(d2);
    }

    private int computeColumns(double d2, double d3) {
        TilePane tilePane = this;
        double d4 = tilePane.snapSpaceX(tilePane.getHgap());
        return Math.max(1, (int)((d2 + d4) / (d3 + d4)));
    }

    private int computeRows(double d2, double d3) {
        TilePane tilePane = this;
        double d4 = tilePane.snapSpaceY(tilePane.getVgap());
        return Math.max(1, (int)((d2 + d4) / (d3 + d4)));
    }

    private double computeContentWidth(int n2, double d2) {
        if (n2 == 0) {
            return 0.0;
        }
        TilePane tilePane = this;
        return (double)n2 * d2 + (double)(n2 - 1) * tilePane.snapSpaceX(tilePane.getHgap());
    }

    private double computeContentHeight(int n2, double d2) {
        if (n2 == 0) {
            return 0.0;
        }
        TilePane tilePane = this;
        return (double)n2 * d2 + (double)(n2 - 1) * tilePane.snapSpaceY(tilePane.getVgap());
    }

    @Override
    protected void layoutChildren() {
        List<Node> list = this.getManagedChildren();
        HPos hPos = this.getAlignmentInternal().getHpos();
        VPos vPos = this.getAlignmentInternal().getVpos();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        TilePane tilePane = this;
        double d4 = tilePane.snapSpaceY(tilePane.getInsets().getTop());
        TilePane tilePane2 = this;
        double d5 = tilePane2.snapSpaceX(tilePane2.getInsets().getLeft());
        TilePane tilePane3 = this;
        double d6 = tilePane3.snapSpaceY(tilePane3.getInsets().getBottom());
        TilePane tilePane4 = this;
        double d7 = tilePane4.snapSpaceX(tilePane4.getInsets().getRight());
        TilePane tilePane5 = this;
        double d8 = tilePane5.snapSpaceY(tilePane5.getVgap());
        TilePane tilePane6 = this;
        double d9 = tilePane6.snapSpaceX(tilePane6.getHgap());
        double d10 = d2 - d5 - d7;
        double d11 = d3 - d4 - d6;
        double d12 = this.getTileWidth() > d10 ? d10 : this.getTileWidth();
        double d13 = this.getTileHeight() > d11 ? d11 : this.getTileHeight();
        int n3 = 0;
        int n4 = 0;
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            this.actualColumns = this.computeColumns(d10, d12);
            this.actualRows = this.computeOther(list.size(), this.actualColumns);
            n3 = hPos != HPos.LEFT ? this.actualColumns - (this.actualColumns * this.actualRows - list.size()) : 0;
        } else {
            this.actualRows = this.computeRows(d11, d13);
            this.actualColumns = this.computeOther(list.size(), this.actualRows);
            n4 = vPos != VPos.TOP ? this.actualRows - (this.actualColumns * this.actualRows - list.size()) : 0;
        }
        TilePane tilePane7 = this;
        double d14 = d5 + TilePane.computeXOffset(d10, tilePane7.computeContentWidth(tilePane7.actualColumns, d12), hPos);
        TilePane tilePane8 = this;
        double d15 = d4 + TilePane.computeYOffset(d11, tilePane8.computeContentHeight(tilePane8.actualRows, d13), vPos);
        double d16 = n3 > 0 ? d5 + TilePane.computeXOffset(d10, this.computeContentWidth(n3, d12), hPos) : d14;
        double d17 = n4 > 0 ? d4 + TilePane.computeYOffset(d11, this.computeContentHeight(n4, d13), vPos) : d15;
        double d18 = this.getTileAlignmentInternal().getVpos() == VPos.BASELINE ? this.getAreaBaselineOffset(list, marginAccessor, n2 -> d12, d13, false) : -1.0;
        int n5 = 0;
        int n6 = 0;
        n4 = list.size();
        for (n3 = 0; n3 < n4; ++n3) {
            Node node = list.get(n3);
            double d19 = n5 == this.actualRows - 1 ? d16 : d14;
            double d20 = n6 == this.actualColumns - 1 ? d17 : d15;
            double d21 = d19 + (double)n6 * (d12 + d9);
            double d22 = d20 + (double)n5 * (d13 + d8);
            Pos pos = TilePane.getAlignment(node);
            this.layoutInArea(node, d21, d22, d12, d13, d18, TilePane.getMargin(node), pos != null ? pos.getHpos() : this.getTileAlignmentInternal().getHpos(), pos != null ? pos.getVpos() : this.getTileAlignmentInternal().getVpos());
            if (this.getOrientation() == Orientation.HORIZONTAL) {
                if (++n6 != this.actualColumns) continue;
                n6 = 0;
                ++n5;
                continue;
            }
            if (++n5 != this.actualRows) continue;
            n5 = 0;
            ++n6;
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TilePane$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TilePane.getClassCssMetaData();
    }
}

