/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox$1;
import javafx.scene.layout.VBox$2;
import javafx.scene.layout.VBox$3;
import javafx.scene.layout.VBox$StyleableProperties;
import javafx.util.Callback;

public class VBox
extends Pane {
    private boolean biasDirty = true;
    private Orientation bias;
    private double[][] tempArray;
    private static final String MARGIN_CONSTRAINT = "vbox-margin";
    private static final String VGROW_CONSTRAINT = "vbox-vgrow";
    private static final Callback<Node, Insets> marginAccessor = node -> VBox.getMargin(node);
    private DoubleProperty spacing;
    private ObjectProperty<Pos> alignment;
    private BooleanProperty fillWidth;

    public static void setVgrow(Node node, Priority priority) {
        VBox.setConstraint(node, VGROW_CONSTRAINT, (Object)priority);
    }

    public static Priority getVgrow(Node node) {
        return (Priority)((Object)VBox.getConstraint(node, VGROW_CONSTRAINT));
    }

    public static void setMargin(Node node, Insets insets) {
        VBox.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)VBox.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        VBox.setVgrow(node, null);
        VBox.setMargin(node, null);
    }

    public VBox() {
    }

    public VBox(double d2) {
        this();
        this.setSpacing(d2);
    }

    public VBox(Node ... nodeArray) {
        this.getChildren().addAll((Node[])nodeArray);
    }

    public VBox(double d2, Node ... nodeArray) {
        this();
        this.setSpacing(d2);
        this.getChildren().addAll((Node[])nodeArray);
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new VBox$1(this);
        }
        return this.spacing;
    }

    public final void setSpacing(double d2) {
        this.spacingProperty().set(d2);
    }

    public final double getSpacing() {
        if (this.spacing == null) {
            return 0.0;
        }
        return this.spacing.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new VBox$2(this, Pos.TOP_LEFT);
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        if (this.alignment == null) {
            return Pos.TOP_LEFT;
        }
        return (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos pos = this.getAlignment();
        if (pos == null) {
            return Pos.TOP_LEFT;
        }
        return pos;
    }

    public final BooleanProperty fillWidthProperty() {
        if (this.fillWidth == null) {
            this.fillWidth = new VBox$3(this, true);
        }
        return this.fillWidth;
    }

    public final void setFillWidth(boolean bl2) {
        this.fillWidthProperty().set(bl2);
    }

    public final boolean isFillWidth() {
        if (this.fillWidth == null) {
            return true;
        }
        return this.fillWidth.get();
    }

    @Override
    public Orientation getContentBias() {
        if (this.biasDirty) {
            this.bias = null;
            Object object = this.getManagedChildren();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Node)object.next();
                if ((object2 = object2.getContentBias()) == null) continue;
                this.bias = object2;
                if (object2 != Orientation.HORIZONTAL) continue;
            }
            this.biasDirty = false;
        }
        return this.bias;
    }

    @Override
    protected double computeMinWidth(double d2) {
        double d3;
        Insets insets = this.getInsets();
        List<Node> list = this.getManagedChildren();
        if (d2 != -1.0 && ((Node)this).getContentBias() != null) {
            double[][] dArray = this.getAreaHeights(list, -1.0, false);
            this.adjustAreaHeights(list, dArray, d2, -1.0);
            d3 = this.computeMaxMinAreaWidth(list, marginAccessor, dArray[0], false);
        } else {
            d3 = this.computeMaxMinAreaWidth(list, marginAccessor);
        }
        return this.snapSpaceX(insets.getLeft()) + d3 + this.snapSpaceX(insets.getRight());
    }

    @Override
    protected double computeMinHeight(double d2) {
        Insets insets = this.getInsets();
        VBox vBox = this;
        return this.snapSpaceY(insets.getTop()) + vBox.computeContentHeight(vBox.getManagedChildren(), d2, true) + this.snapSpaceY(insets.getBottom());
    }

    @Override
    protected double computePrefWidth(double d2) {
        double d3;
        Insets insets = this.getInsets();
        List<Node> list = this.getManagedChildren();
        if (d2 != -1.0 && ((Node)this).getContentBias() != null) {
            double[][] dArray = this.getAreaHeights(list, -1.0, false);
            this.adjustAreaHeights(list, dArray, d2, -1.0);
            d3 = this.computeMaxPrefAreaWidth(list, marginAccessor, dArray[0], false);
        } else {
            d3 = this.computeMaxPrefAreaWidth(list, marginAccessor);
        }
        return this.snapSpaceX(insets.getLeft()) + d3 + this.snapSpaceX(insets.getRight());
    }

    @Override
    protected double computePrefHeight(double d2) {
        Insets insets = this.getInsets();
        VBox vBox = this;
        double d3 = this.snapSpaceY(insets.getTop()) + vBox.computeContentHeight(vBox.getManagedChildren(), d2, false) + this.snapSpaceY(insets.getBottom());
        return d3;
    }

    private double[][] getAreaHeights(List<Node> list, double d2, boolean bl2) {
        double d3;
        double[][] dArray = this.getTempArray(list.size());
        if (d2 == -1.0) {
            d3 = -1.0;
        } else {
            VBox vBox = this;
            VBox vBox2 = this;
            d3 = d2 - vBox.snapSpaceX(vBox.getInsets().getLeft()) - vBox2.snapSpaceX(vBox2.getInsets().getRight());
        }
        double d4 = d3;
        boolean bl3 = this.isFillWidth();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = list.get(i2);
            Insets insets = VBox.getMargin(node);
            if (bl2) {
                if (d4 != -1.0 && bl3) {
                    dArray[0][i2] = this.computeChildMinAreaHeight(node, -1.0, insets, d4);
                    continue;
                }
                dArray[0][i2] = this.computeChildMinAreaHeight(node, -1.0, insets, -1.0);
                continue;
            }
            dArray[0][i2] = d4 != -1.0 && bl3 ? this.computeChildPrefAreaHeight(node, -1.0, insets, d4) : this.computeChildPrefAreaHeight(node, -1.0, insets, -1.0);
        }
        return dArray;
    }

    private double adjustAreaHeights(List<Node> list, double[][] dArray, double d2, double d3) {
        Insets insets = this.getInsets();
        double d4 = this.snapSpaceX(insets.getLeft());
        double d5 = this.snapSpaceX(insets.getRight());
        VBox vBox = this;
        double d6 = VBox.sum(dArray[0], list.size()) + (double)(list.size() - 1) * vBox.snapSpaceY(vBox.getSpacing());
        double d7 = d2 - this.snapSpaceY(insets.getTop()) - this.snapSpaceY(insets.getBottom()) - d6;
        if (d7 != 0.0) {
            double d8 = this.isFillWidth() && d3 != -1.0 ? d3 - d4 - d5 : -1.0;
            double d9 = this.growOrShrinkAreaHeights(list, dArray, Priority.ALWAYS, d7, d8);
            d9 = this.growOrShrinkAreaHeights(list, dArray, Priority.SOMETIMES, d9, d8);
            d6 += d7 - d9;
        }
        return d6;
    }

    private double growOrShrinkAreaHeights(List<Node> list, double[][] object, Priority priority, double d2, double d3) {
        boolean bl2 = d2 < 0.0;
        int n2 = 0;
        Object dArray = object[0];
        object = object[1];
        if (bl2) {
            n2 = list.size();
            var13_13 = list.size();
            for (var12_11 = 0; var12_11 < var13_13; ++var12_11) {
                var14_14 = list.get(var12_11);
                object[var12_11] = this.computeChildMinAreaHeight(var14_14, -1.0, VBox.getMargin(var14_14), d3);
            }
        } else {
            var13_13 = list.size();
            for (var12_11 = 0; var12_11 < var13_13; ++var12_11) {
                var14_14 = list.get(var12_11);
                if (VBox.getVgrow(var14_14) == priority) {
                    object[var12_11] = this.computeChildMaxAreaHeight(var14_14, -1.0, VBox.getMargin(var14_14), d3);
                    ++n2;
                    continue;
                }
                object[var12_11] = -1.0;
            }
        }
        double d4 = this.isSnapToPixel() ? 1.0 / Region.getSnapScaleY(this) : 0.0;
        double d5 = d2;
        block2: while (Math.abs(d5) >= d4 && n2 > 0) {
            double d6 = this.snapPortionY(d5 / (double)n2);
            if (d6 == 0.0) {
                if (d4 == 0.0) break;
                d6 = d4 * Math.signum(d5);
            }
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                reference v0;
                if (object[i2] == -1.0) continue;
                reference var20_17 = object[i2] - dArray[i2];
                reference var22_18 = Math.abs((double)v0) <= Math.abs(d6) ? var20_17 : (reference)d6;
                Object object2 = dArray;
                int n4 = i2;
                object2[n4] = object2[n4] + var22_18;
                if (Math.abs(d5 -= var22_18) < d4) break block2;
                if (!(Math.abs((double)var22_18) < Math.abs(d6))) continue;
                object[i2] = -1.0;
                --n2;
            }
        }
        return d5;
    }

    private double computeContentHeight(List<Node> list, double d2, boolean bl2) {
        VBox vBox = this;
        return VBox.sum(this.getAreaHeights(list, d2, bl2)[0], list.size()) + (double)(list.size() - 1) * vBox.snapSpaceY(vBox.getSpacing());
    }

    private static double sum(double[] dArray, int n2) {
        int n3 = 0;
        double d2 = 0.0;
        while (n3 != n2) {
            d2 += dArray[n3++];
        }
        return d2;
    }

    @Override
    public void requestLayout() {
        this.biasDirty = true;
        this.bias = null;
        super.requestLayout();
    }

    @Override
    protected void layoutChildren() {
        List<Node> list = this.getManagedChildren();
        Object object = this.getInsets();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = this.snapSpaceY(object.getTop());
        double d5 = this.snapSpaceX(object.getLeft());
        double d6 = this.snapSpaceY(object.getBottom());
        double d7 = this.snapSpaceX(object.getRight());
        VBox vBox = this;
        double d8 = vBox.snapSpaceY(vBox.getSpacing());
        object = this.getAlignmentInternal().getHpos();
        VPos vPos = this.getAlignmentInternal().getVpos();
        boolean bl2 = this.isFillWidth();
        double[][] dArray = this.getAreaHeights(list, d2, false);
        double d9 = d2 - d5 - d7;
        double d10 = this.adjustAreaHeights(list, dArray, d3, d2);
        double d11 = d5;
        double d12 = d4 + VBox.computeYOffset(d3 - d4 - d6, d10, vPos);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = list.get(i2);
            this.layoutInArea(node, d11, d12, d9, dArray[0][i2], dArray[0][i2], VBox.getMargin(node), bl2, true, (HPos)((Object)object), vPos);
            d12 += dArray[0][i2] + d8;
        }
    }

    private double[][] getTempArray(int n2) {
        if (this.tempArray == null) {
            this.tempArray = new double[2][n2];
        } else if (this.tempArray[0].length < n2) {
            this.tempArray = new double[2][Math.max(this.tempArray.length * 3, n2)];
        }
        return this.tempArray;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return VBox$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return VBox.getClassCssMetaData();
    }
}

