/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.scene.paint.MaterialHelper;
import com.sun.javafx.sg.prism.NGPhongMaterial;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial$1;
import javafx.scene.paint.PhongMaterial$2;
import javafx.scene.paint.PhongMaterial$3;
import javafx.scene.paint.PhongMaterial$4;
import javafx.scene.paint.PhongMaterial$5;
import javafx.scene.paint.PhongMaterial$6;
import javafx.scene.paint.PhongMaterial$7;
import javafx.scene.paint.PhongMaterial$8;

public class PhongMaterial
extends Material {
    private boolean diffuseColorDirty = true;
    private boolean specularColorDirty = true;
    private boolean specularPowerDirty = true;
    private boolean diffuseMapDirty = true;
    private boolean specularMapDirty = true;
    private boolean bumpMapDirty = true;
    private boolean selfIlluminationMapDirty = true;
    private ObjectProperty<Color> diffuseColor;
    private ObjectProperty<Color> specularColor;
    private DoubleProperty specularPower;
    private final AbstractNotifyListener platformImageChangeListener = new PhongMaterial$4(this);
    private ObjectProperty<Image> diffuseMap;
    private Image oldDiffuseMap;
    private ObjectProperty<Image> specularMap;
    private Image oldSpecularMap;
    private ObjectProperty<Image> bumpMap;
    private Image oldBumpMap;
    private ObjectProperty<Image> selfIlluminationMap;
    private Image oldSelfIlluminationMap;
    private NGPhongMaterial peer;

    public PhongMaterial() {
        this.setDiffuseColor(Color.WHITE);
    }

    public PhongMaterial(Color color) {
        this.setDiffuseColor(color);
    }

    public PhongMaterial(Color color, Image image, Image image2, Image image3, Image image4) {
        this.setDiffuseColor(color);
        this.setDiffuseMap(image);
        this.setSpecularMap(image2);
        this.setBumpMap(image3);
        this.setSelfIlluminationMap(image4);
    }

    public final void setDiffuseColor(Color color) {
        this.diffuseColorProperty().set(color);
    }

    public final Color getDiffuseColor() {
        if (this.diffuseColor == null) {
            return null;
        }
        return (Color)this.diffuseColor.get();
    }

    public final ObjectProperty<Color> diffuseColorProperty() {
        if (this.diffuseColor == null) {
            PhongMaterial phongMaterial = this;
            this.diffuseColor = new PhongMaterial$1(phongMaterial, phongMaterial, "diffuseColor");
        }
        return this.diffuseColor;
    }

    public final void setSpecularColor(Color color) {
        this.specularColorProperty().set(color);
    }

    public final Color getSpecularColor() {
        if (this.specularColor == null) {
            return null;
        }
        return (Color)this.specularColor.get();
    }

    public final ObjectProperty<Color> specularColorProperty() {
        if (this.specularColor == null) {
            PhongMaterial phongMaterial = this;
            this.specularColor = new PhongMaterial$2(phongMaterial, phongMaterial, "specularColor");
        }
        return this.specularColor;
    }

    public final void setSpecularPower(double d2) {
        this.specularPowerProperty().set(d2);
    }

    public final double getSpecularPower() {
        if (this.specularPower == null) {
            return 32.0;
        }
        return this.specularPower.get();
    }

    public final DoubleProperty specularPowerProperty() {
        if (this.specularPower == null) {
            PhongMaterial phongMaterial = this;
            this.specularPower = new PhongMaterial$3(phongMaterial, phongMaterial, "specularPower", 32.0);
        }
        return this.specularPower;
    }

    public final void setDiffuseMap(Image image) {
        this.diffuseMapProperty().set(image);
    }

    public final Image getDiffuseMap() {
        if (this.diffuseMap == null) {
            return null;
        }
        return (Image)this.diffuseMap.get();
    }

    public final ObjectProperty<Image> diffuseMapProperty() {
        if (this.diffuseMap == null) {
            PhongMaterial phongMaterial = this;
            this.diffuseMap = new PhongMaterial$5(phongMaterial, phongMaterial, "diffuseMap");
        }
        return this.diffuseMap;
    }

    public final void setSpecularMap(Image image) {
        this.specularMapProperty().set(image);
    }

    public final Image getSpecularMap() {
        if (this.specularMap == null) {
            return null;
        }
        return (Image)this.specularMap.get();
    }

    public final ObjectProperty<Image> specularMapProperty() {
        if (this.specularMap == null) {
            PhongMaterial phongMaterial = this;
            this.specularMap = new PhongMaterial$6(phongMaterial, phongMaterial, "specularMap");
        }
        return this.specularMap;
    }

    public final void setBumpMap(Image image) {
        this.bumpMapProperty().set(image);
    }

    public final Image getBumpMap() {
        if (this.bumpMap == null) {
            return null;
        }
        return (Image)this.bumpMap.get();
    }

    public final ObjectProperty<Image> bumpMapProperty() {
        if (this.bumpMap == null) {
            PhongMaterial phongMaterial = this;
            this.bumpMap = new PhongMaterial$7(phongMaterial, phongMaterial, "bumpMap");
        }
        return this.bumpMap;
    }

    public final void setSelfIlluminationMap(Image image) {
        this.selfIlluminationMapProperty().set(image);
    }

    public final Image getSelfIlluminationMap() {
        if (this.selfIlluminationMap == null) {
            return null;
        }
        return (Image)this.selfIlluminationMap.get();
    }

    public final ObjectProperty<Image> selfIlluminationMapProperty() {
        if (this.selfIlluminationMap == null) {
            PhongMaterial phongMaterial = this;
            this.selfIlluminationMap = new PhongMaterial$8(phongMaterial, phongMaterial, "selfIlluminationMap");
        }
        return this.selfIlluminationMap;
    }

    @Override
    void setDirty(boolean bl2) {
        super.setDirty(bl2);
        if (!bl2) {
            this.diffuseColorDirty = false;
            this.specularColorDirty = false;
            this.specularPowerDirty = false;
            this.diffuseMapDirty = false;
            this.specularMapDirty = false;
            this.bumpMapDirty = false;
            this.selfIlluminationMapDirty = false;
        }
    }

    @Override
    NGPhongMaterial getNGMaterial() {
        if (this.peer == null) {
            this.peer = new NGPhongMaterial();
        }
        return this.peer;
    }

    @Override
    void updatePG() {
        if (!this.isDirty()) {
            return;
        }
        NGPhongMaterial nGPhongMaterial = MaterialHelper.getNGMaterial(this);
        if (this.diffuseColorDirty) {
            nGPhongMaterial.setDiffuseColor(this.getDiffuseColor() == null ? null : Toolkit.getPaintAccessor().getPlatformPaint(this.getDiffuseColor()));
        }
        if (this.specularColorDirty) {
            nGPhongMaterial.setSpecularColor(this.getSpecularColor() == null ? null : Toolkit.getPaintAccessor().getPlatformPaint(this.getSpecularColor()));
        }
        if (this.specularPowerDirty) {
            nGPhongMaterial.setSpecularPower((float)this.getSpecularPower());
        }
        if (this.diffuseMapDirty) {
            nGPhongMaterial.setDiffuseMap(this.getDiffuseMap() == null ? null : Toolkit.getImageAccessor().getPlatformImage(this.getDiffuseMap()));
        }
        if (this.specularMapDirty) {
            nGPhongMaterial.setSpecularMap(this.getSpecularMap() == null ? null : Toolkit.getImageAccessor().getPlatformImage(this.getSpecularMap()));
        }
        if (this.bumpMapDirty) {
            nGPhongMaterial.setBumpMap(this.getBumpMap() == null ? null : Toolkit.getImageAccessor().getPlatformImage(this.getBumpMap()));
        }
        if (this.selfIlluminationMapDirty) {
            nGPhongMaterial.setSelfIllumMap(this.getSelfIlluminationMap() == null ? null : Toolkit.getImageAccessor().getPlatformImage(this.getSelfIlluminationMap()));
        }
        this.setDirty(false);
    }

    public String toString() {
        return "PhongMaterial[diffuseColor=" + String.valueOf(this.getDiffuseColor()) + ", specularColor=" + String.valueOf(this.getSpecularColor()) + ", specularPower=" + this.getSpecularPower() + ", diffuseMap=" + String.valueOf(this.getDiffuseMap()) + ", specularMap=" + String.valueOf(this.getSpecularMap()) + ", bumpMap=" + String.valueOf(this.getBumpMap()) + ", selfIlluminationMap=" + String.valueOf(this.getSelfIlluminationMap()) + "]";
    }
}

