/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.scene.paint.Color;

public final class Stop {
    static final List<Stop> NO_STOPS = List.of(new Stop(0.0, Color.TRANSPARENT), new Stop(1.0, Color.TRANSPARENT));
    private double offset;
    private Color color;
    private int hash = 0;

    static List<Stop> normalize(Stop[] object) {
        object = object == null ? null : Arrays.asList(object);
        return Stop.normalize(object);
    }

    static List<Stop> normalize(List<Stop> object) {
        if (object == null) {
            return NO_STOPS;
        }
        Stop stop = null;
        Stop stop2 = null;
        ArrayList<Stop> arrayList = new ArrayList<Stop>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            double d2;
            Stop stop3 = (Stop)object.next();
            if (stop3 == null || stop3.getColor() == null) continue;
            double d3 = stop3.getOffset();
            if (d2 <= 0.0) {
                if (stop != null && !(d3 >= stop.getOffset())) continue;
                stop = stop3;
                continue;
            }
            if (d3 >= 1.0) {
                if (stop2 != null && !(d3 < stop2.getOffset())) continue;
                stop2 = stop3;
                continue;
            }
            double d4 = d3;
            if (d4 != d4) continue;
            for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
                Stop stop4;
                Stop stop5 = (Stop)arrayList.get(i2);
                if (!(stop4.getOffset() <= d3)) continue;
                if (stop5.getOffset() == d3) {
                    if (i2 > 0 && ((Stop)arrayList.get(i2 - 1)).getOffset() == d3) {
                        arrayList.set(i2, stop3);
                    } else {
                        arrayList.add(i2 + 1, stop3);
                    }
                } else {
                    arrayList.add(i2 + 1, stop3);
                }
                stop3 = null;
                break;
            }
            if (stop3 == null) continue;
            arrayList.add(0, stop3);
        }
        if (stop == null) {
            if (arrayList.isEmpty()) {
                if (stop2 == null) {
                    return NO_STOPS;
                }
                object = stop2.getColor();
            } else {
                object = ((Stop)arrayList.get(0)).getColor();
                if (stop2 == null && arrayList.size() == 1) {
                    arrayList.clear();
                }
            }
            stop = new Stop(0.0, (Color)object);
        } else if (stop.getOffset() < 0.0) {
            stop = new Stop(0.0, stop.getColor());
        }
        arrayList.add(0, stop);
        if (stop2 == null) {
            ArrayList<Stop> arrayList2 = arrayList;
            stop2 = new Stop(1.0, ((Stop)arrayList2.get(arrayList2.size() - 1)).getColor());
        } else if (stop2.getOffset() > 1.0) {
            stop2 = new Stop(1.0, stop2.getColor());
        }
        arrayList.add(stop2);
        return Collections.unmodifiableList(arrayList);
    }

    public final double getOffset() {
        return this.offset;
    }

    public final Color getColor() {
        return this.color;
    }

    public Stop(@NamedArg(value="offset") double d2, @NamedArg(value="color", defaultValue="BLACK") Color color) {
        this.offset = d2;
        this.color = color;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Stop) {
            object = (Stop)object;
            return this.offset == ((Stop)object).offset && (this.color == null ? ((Stop)object).color == null : this.color.equals(((Stop)object).color));
        }
        return false;
    }

    public final int hashCode() {
        if (this.hash == 0) {
            long l2 = 629L + Double.doubleToLongBits(this.offset);
            long l3 = l2 = 37L * l2 + (long)this.color.hashCode();
            this.hash = (int)(l3 ^ l3 >> 32);
        }
        return this.hash;
    }

    public final String toString() {
        return String.valueOf(this.color) + " " + this.offset * 100.0 + "%";
    }
}

