/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.ArcHelper;
import com.sun.javafx.sg.prism.NGArc;
import com.sun.javafx.sg.prism.NGNode;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.shape.Arc$1;
import javafx.scene.shape.Arc$2;
import javafx.scene.shape.Arc$3;
import javafx.scene.shape.Arc$4;
import javafx.scene.shape.Arc$5;
import javafx.scene.shape.Arc$6;
import javafx.scene.shape.Arc$7;
import javafx.scene.shape.Arc$8;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Shape;

public class Arc
extends Shape {
    private final Arc2D shape = new Arc2D();
    private DoubleProperty centerX;
    private DoubleProperty centerY;
    private final DoubleProperty radiusX;
    private final DoubleProperty radiusY;
    private DoubleProperty startAngle;
    private final DoubleProperty length;
    private ObjectProperty<ArcType> type;

    public Arc() {
        ArcHelper.initHelper(this);
        this.radiusX = new Arc$4(this);
        this.radiusY = new Arc$5(this);
        this.length = new Arc$7(this);
    }

    public Arc(double d2, double d3, double d4, double d5, double d6, double d7) {
        ArcHelper.initHelper(this);
        this.radiusX = new Arc$4(this);
        this.radiusY = new Arc$5(this);
        this.length = new Arc$7(this);
        this.setCenterX(d2);
        this.setCenterY(d3);
        this.setRadiusX(d4);
        this.setRadiusY(d5);
        this.setStartAngle(d6);
        this.setLength(d7);
    }

    public final void setCenterX(double d2) {
        if (this.centerX != null || d2 != 0.0) {
            this.centerXProperty().set(d2);
        }
    }

    public final double getCenterX() {
        if (this.centerX == null) {
            return 0.0;
        }
        return this.centerX.get();
    }

    public final DoubleProperty centerXProperty() {
        if (this.centerX == null) {
            this.centerX = new Arc$2(this);
        }
        return this.centerX;
    }

    public final void setCenterY(double d2) {
        if (this.centerY != null || d2 != 0.0) {
            this.centerYProperty().set(d2);
        }
    }

    public final double getCenterY() {
        if (this.centerY == null) {
            return 0.0;
        }
        return this.centerY.get();
    }

    public final DoubleProperty centerYProperty() {
        if (this.centerY == null) {
            this.centerY = new Arc$3(this);
        }
        return this.centerY;
    }

    public final void setRadiusX(double d2) {
        this.radiusX.set(d2);
    }

    public final double getRadiusX() {
        return this.radiusX.get();
    }

    public final DoubleProperty radiusXProperty() {
        return this.radiusX;
    }

    public final void setRadiusY(double d2) {
        this.radiusY.set(d2);
    }

    public final double getRadiusY() {
        return this.radiusY.get();
    }

    public final DoubleProperty radiusYProperty() {
        return this.radiusY;
    }

    public final void setStartAngle(double d2) {
        if (this.startAngle != null || d2 != 0.0) {
            this.startAngleProperty().set(d2);
        }
    }

    public final double getStartAngle() {
        if (this.startAngle == null) {
            return 0.0;
        }
        return this.startAngle.get();
    }

    public final DoubleProperty startAngleProperty() {
        if (this.startAngle == null) {
            this.startAngle = new Arc$6(this);
        }
        return this.startAngle;
    }

    public final void setLength(double d2) {
        this.length.set(d2);
    }

    public final double getLength() {
        return this.length.get();
    }

    public final DoubleProperty lengthProperty() {
        return this.length;
    }

    public final void setType(ArcType arcType) {
        if (this.type != null || arcType != ArcType.OPEN) {
            this.typeProperty().set(arcType);
        }
    }

    public final ArcType getType() {
        if (this.type == null) {
            return ArcType.OPEN;
        }
        return (ArcType)((Object)this.type.get());
    }

    public final ObjectProperty<ArcType> typeProperty() {
        if (this.type == null) {
            this.type = new Arc$8(this, ArcType.OPEN);
        }
        return this.type;
    }

    private NGNode doCreatePeer() {
        return new NGArc();
    }

    private Arc2D doConfigShape() {
        this.shape.setArc((float)(this.getCenterX() - this.getRadiusX()), (float)(this.getCenterY() - this.getRadiusY()), (float)(this.getRadiusX() * 2.0), (float)(this.getRadiusY() * 2.0), (float)this.getStartAngle(), (float)this.getLength(), switch (this.getTypeInternal()) {
            case ArcType.OPEN -> 0;
            case ArcType.CHORD -> 1;
            default -> 2;
        });
        return this.shape;
    }

    private final ArcType getTypeInternal() {
        ArcType arcType = this.getType();
        if (arcType == null) {
            return ArcType.OPEN;
        }
        return arcType;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.NODE_GEOMETRY)) {
            NGArc nGArc = (NGArc)NodeHelper.getPeer(this);
            nGArc.updateArc((float)this.getCenterX(), (float)this.getCenterY(), (float)this.getRadiusX(), (float)this.getRadiusY(), (float)this.getStartAngle(), (float)this.getLength(), this.getTypeInternal());
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Arc[");
        Object object = this.getId();
        if (object != null) {
            stringBuilder.append("id=").append((String)object).append(", ");
        }
        stringBuilder.append("centerX=").append(this.getCenterX());
        stringBuilder.append(", centerY=").append(this.getCenterY());
        stringBuilder.append(", radiusX=").append(this.getRadiusX());
        stringBuilder.append(", radiusY=").append(this.getRadiusY());
        stringBuilder.append(", startAngle=").append(this.getStartAngle());
        stringBuilder.append(", length=").append(this.getLength());
        stringBuilder.append(", type=").append((Object)this.getType());
        stringBuilder.append(", fill=").append(this.getFill());
        object = this.getStroke();
        if (object != null) {
            stringBuilder.append(", stroke=").append(object);
            stringBuilder.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return stringBuilder.append("]").toString();
    }

    static {
        ArcHelper.setArcAccessor(new Arc$1());
    }
}

