/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.RectangularShape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.EllipseHelper;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.sg.prism.NGEllipse;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape$Mode;
import javafx.beans.property.DoubleProperty;
import javafx.scene.shape.Ellipse$1;
import javafx.scene.shape.Ellipse$2;
import javafx.scene.shape.Ellipse$3;
import javafx.scene.shape.Ellipse$4;
import javafx.scene.shape.Ellipse$5;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class Ellipse
extends Shape {
    private final Ellipse2D shape = new Ellipse2D();
    private static final int NON_RECTILINEAR_TYPE_MASK = -80;
    private DoubleProperty centerX;
    private DoubleProperty centerY;
    private final DoubleProperty radiusX;
    private final DoubleProperty radiusY;

    public Ellipse() {
        EllipseHelper.initHelper(this);
        this.radiusX = new Ellipse$4(this);
        this.radiusY = new Ellipse$5(this);
    }

    public Ellipse(double d2, double d3) {
        EllipseHelper.initHelper(this);
        this.radiusX = new Ellipse$4(this);
        this.radiusY = new Ellipse$5(this);
        this.setRadiusX(d2);
        this.setRadiusY(d3);
    }

    public Ellipse(double d2, double d3, double d4, double d5) {
        this(d4, d5);
        this.setCenterX(d2);
        this.setCenterY(d3);
    }

    public final void setCenterX(double d2) {
        if (this.centerX != null || d2 != 0.0) {
            this.centerXProperty().set(d2);
        }
    }

    public final double getCenterX() {
        if (this.centerX == null) {
            return 0.0;
        }
        return this.centerX.get();
    }

    public final DoubleProperty centerXProperty() {
        if (this.centerX == null) {
            this.centerX = new Ellipse$2(this);
        }
        return this.centerX;
    }

    public final void setCenterY(double d2) {
        if (this.centerY != null || d2 != 0.0) {
            this.centerYProperty().set(d2);
        }
    }

    public final double getCenterY() {
        if (this.centerY == null) {
            return 0.0;
        }
        return this.centerY.get();
    }

    public final DoubleProperty centerYProperty() {
        if (this.centerY == null) {
            this.centerY = new Ellipse$3(this);
        }
        return this.centerY;
    }

    public final void setRadiusX(double d2) {
        this.radiusX.set(d2);
    }

    public final double getRadiusX() {
        return this.radiusX.get();
    }

    public final DoubleProperty radiusXProperty() {
        return this.radiusX;
    }

    public final void setRadiusY(double d2) {
        this.radiusY.set(d2);
    }

    public final double getRadiusY() {
        return this.radiusY.get();
    }

    public final DoubleProperty radiusYProperty() {
        return this.radiusY;
    }

    private NGNode doCreatePeer() {
        return new NGEllipse();
    }

    @Override
    StrokeLineJoin convertLineJoin(StrokeLineJoin strokeLineJoin) {
        return StrokeLineJoin.BEVEL;
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        double d2;
        if (this.getMode() == NGShape$Mode.EMPTY) {
            return baseBounds.makeEmpty();
        }
        if ((baseTransform.getType() & 0xFFFFFFB0) != 0) {
            return this.computeShapeBounds(baseBounds, baseTransform, ShapeHelper.configShape(this));
        }
        double d3 = this.getCenterX() - this.getRadiusX();
        double d4 = this.getCenterY() - this.getRadiusY();
        double d5 = 2.0 * this.getRadiusX();
        double d6 = 2.0 * this.getRadiusY();
        if (this.getMode() == NGShape$Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
            d2 = 0.0;
        } else {
            d2 = this.getStrokeWidth();
            if (this.getStrokeType() == StrokeType.CENTERED) {
                d2 /= 2.0;
            }
        }
        return this.computeBounds(baseBounds, baseTransform, d2, 0.0, d3, d4, d5, d6);
    }

    private Ellipse2D doConfigShape() {
        ((RectangularShape)this.shape).setFrame((float)(this.getCenterX() - this.getRadiusX()), (float)(this.getCenterY() - this.getRadiusY()), (float)(this.getRadiusX() * 2.0), (float)(this.getRadiusY() * 2.0));
        return this.shape;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.NODE_GEOMETRY)) {
            NGEllipse nGEllipse = (NGEllipse)NodeHelper.getPeer(this);
            nGEllipse.updateEllipse((float)this.getCenterX(), (float)this.getCenterY(), (float)this.getRadiusX(), (float)this.getRadiusY());
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Ellipse[");
        Object object = this.getId();
        if (object != null) {
            stringBuilder.append("id=").append((String)object).append(", ");
        }
        stringBuilder.append("centerX=").append(this.getCenterX());
        stringBuilder.append(", centerY=").append(this.getCenterY());
        stringBuilder.append(", radiusX=").append(this.getRadiusX());
        stringBuilder.append(", radiusY=").append(this.getRadiusY());
        stringBuilder.append(", fill=").append(this.getFill());
        object = this.getStroke();
        if (object != null) {
            stringBuilder.append(", stroke=").append(object);
            stringBuilder.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return stringBuilder.append("]").toString();
    }

    static {
        EllipseHelper.setEllipseAccessor(new Ellipse$1());
    }
}

