/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.PathHelper;
import com.sun.javafx.scene.shape.PathUtils;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPath;
import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.StyleableProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path$1;
import javafx.scene.shape.Path$2;
import javafx.scene.shape.Path$3;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;

public class Path
extends Shape {
    private Path2D path2d = null;
    private ObjectProperty<FillRule> fillRule;
    private boolean isPathValid;
    private final ObservableList<PathElement> elements;

    public Path() {
        PathHelper.initHelper(this);
        ((StyleableProperty)((Object)this.fillProperty())).applyStyle(null, null);
        ((StyleableProperty)((Object)this.strokeProperty())).applyStyle(null, Color.BLACK);
        this.elements = new Path$3(this);
    }

    public Path(PathElement ... pathElementArray) {
        PathHelper.initHelper(this);
        ((StyleableProperty)((Object)this.fillProperty())).applyStyle(null, null);
        ((StyleableProperty)((Object)this.strokeProperty())).applyStyle(null, Color.BLACK);
        this.elements = new Path$3(this);
        if (pathElementArray != null) {
            this.elements.addAll((PathElement[])pathElementArray);
        }
    }

    public Path(Collection<? extends PathElement> collection) {
        PathHelper.initHelper(this);
        ((StyleableProperty)((Object)this.fillProperty())).applyStyle(null, null);
        ((StyleableProperty)((Object)this.strokeProperty())).applyStyle(null, Color.BLACK);
        this.elements = new Path$3(this);
        if (collection != null) {
            this.elements.addAll(collection);
        }
    }

    void markPathDirty() {
        this.path2d = null;
        NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
        NodeHelper.geomChanged(this);
    }

    public final void setFillRule(FillRule fillRule) {
        if (this.fillRule != null || fillRule != FillRule.NON_ZERO) {
            this.fillRuleProperty().set(fillRule);
        }
    }

    public final FillRule getFillRule() {
        if (this.fillRule == null) {
            return FillRule.NON_ZERO;
        }
        return (FillRule)((Object)this.fillRule.get());
    }

    public final ObjectProperty<FillRule> fillRuleProperty() {
        if (this.fillRule == null) {
            this.fillRule = new Path$2(this, FillRule.NON_ZERO);
        }
        return this.fillRule;
    }

    public final ObservableList<PathElement> getElements() {
        return this.elements;
    }

    private NGNode doCreatePeer() {
        return new NGPath();
    }

    private Path2D doConfigShape() {
        if (this.isPathValid) {
            if (this.path2d == null) {
                this.path2d = PathUtils.configShape(this.getElements(), this.getFillRule() == FillRule.EVEN_ODD);
            } else {
                this.path2d.setWindingRule(this.getFillRule() == FillRule.NON_ZERO ? 1 : 0);
            }
            return this.path2d;
        }
        return new Path2D();
    }

    private Bounds doComputeLayoutBounds() {
        if (this.isPathValid) {
            return null;
        }
        return new BoundingBox(0.0, 0.0, -1.0, -1.0);
    }

    private boolean isFirstPathElementValid() {
        ObservableList<PathElement> observableList = this.getElements();
        if (observableList != null && observableList.size() > 0) {
            if (!((PathElement)((Object)(observableList = (PathElement)observableList.get(0)))).isAbsolute()) {
                System.err.printf("First element of the path can not be relative. Path: %s\n", this);
                return false;
            }
            if (observableList instanceof MoveTo) {
                return true;
            }
            System.err.printf("Missing initial moveto in path definition. Path: %s\n", this);
            return false;
        }
        return true;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.NODE_CONTENTS)) {
            NGPath nGPath = (NGPath)NodeHelper.getPeer(this);
            if (nGPath.acceptsPath2dOnUpdate()) {
                nGPath.updateWithPath2d((Path2D)ShapeHelper.configShape(this));
                return;
            }
            nGPath.reset();
            if (this.isPathValid) {
                nGPath.setFillRule(this.getFillRule());
                for (PathElement pathElement : this.getElements()) {
                    pathElement.addTo(nGPath);
                }
                nGPath.update();
            }
        }
    }

    private Paint doCssGetFillInitialValue() {
        return null;
    }

    private Paint doCssGetStrokeInitialValue() {
        return Color.BLACK;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Path[");
        Object object = this.getId();
        if (object != null) {
            stringBuilder.append("id=").append((String)object).append(", ");
        }
        stringBuilder.append("elements=").append(this.getElements());
        stringBuilder.append(", fill=").append(this.getFill());
        stringBuilder.append(", fillRule=").append((Object)this.getFillRule());
        object = this.getStroke();
        if (object != null) {
            stringBuilder.append(", stroke=").append(object);
            stringBuilder.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return stringBuilder.append("]").toString();
    }

    static {
        PathHelper.setPathAccessor(new Path$1());
    }
}

