/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.RectangleHelper;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGRectangle;
import com.sun.javafx.sg.prism.NGShape$Mode;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle$1;
import javafx.scene.shape.Rectangle$2;
import javafx.scene.shape.Rectangle$3;
import javafx.scene.shape.Rectangle$4;
import javafx.scene.shape.Rectangle$5;
import javafx.scene.shape.Rectangle$6;
import javafx.scene.shape.Rectangle$7;
import javafx.scene.shape.Rectangle$StyleableProperties;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class Rectangle
extends Shape {
    private final RoundRectangle2D shape = new RoundRectangle2D();
    private static final int NON_RECTILINEAR_TYPE_MASK = -80;
    private DoubleProperty x;
    private DoubleProperty y;
    private final DoubleProperty width;
    private final DoubleProperty height;
    private DoubleProperty arcWidth;
    private DoubleProperty arcHeight;

    public Rectangle() {
        RectangleHelper.initHelper(this);
        this.width = new Rectangle$4(this);
        this.height = new Rectangle$5(this);
    }

    public Rectangle(double d2, double d3) {
        RectangleHelper.initHelper(this);
        this.width = new Rectangle$4(this);
        this.height = new Rectangle$5(this);
        this.setWidth(d2);
        this.setHeight(d3);
    }

    public Rectangle(double d2, double d3, Paint paint) {
        RectangleHelper.initHelper(this);
        this.width = new Rectangle$4(this);
        this.height = new Rectangle$5(this);
        this.setWidth(d2);
        this.setHeight(d3);
        this.setFill(paint);
    }

    public Rectangle(double d2, double d3, double d4, double d5) {
        this(d4, d5);
        this.setX(d2);
        this.setY(d3);
    }

    public final void setX(double d2) {
        if (this.x != null || d2 != 0.0) {
            this.xProperty().set(d2);
        }
    }

    public final double getX() {
        if (this.x == null) {
            return 0.0;
        }
        return this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new Rectangle$2(this);
        }
        return this.x;
    }

    public final void setY(double d2) {
        if (this.y != null || d2 != 0.0) {
            this.yProperty().set(d2);
        }
    }

    public final double getY() {
        if (this.y == null) {
            return 0.0;
        }
        return this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new Rectangle$3(this);
        }
        return this.y;
    }

    public final void setWidth(double d2) {
        this.width.set(d2);
    }

    public final double getWidth() {
        return this.width.get();
    }

    public final DoubleProperty widthProperty() {
        return this.width;
    }

    public final void setHeight(double d2) {
        this.height.set(d2);
    }

    public final double getHeight() {
        return this.height.get();
    }

    public final DoubleProperty heightProperty() {
        return this.height;
    }

    public final void setArcWidth(double d2) {
        if (this.arcWidth != null || d2 != 0.0) {
            this.arcWidthProperty().set(d2);
        }
    }

    public final double getArcWidth() {
        if (this.arcWidth == null) {
            return 0.0;
        }
        return this.arcWidth.get();
    }

    public final DoubleProperty arcWidthProperty() {
        if (this.arcWidth == null) {
            this.arcWidth = new Rectangle$6(this);
        }
        return this.arcWidth;
    }

    public final void setArcHeight(double d2) {
        if (this.arcHeight != null || d2 != 0.0) {
            this.arcHeightProperty().set(d2);
        }
    }

    public final double getArcHeight() {
        if (this.arcHeight == null) {
            return 0.0;
        }
        return this.arcHeight.get();
    }

    public final DoubleProperty arcHeightProperty() {
        if (this.arcHeight == null) {
            this.arcHeight = new Rectangle$7(this);
        }
        return this.arcHeight;
    }

    private NGNode doCreatePeer() {
        return new NGRectangle();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Rectangle$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Rectangle.getClassCssMetaData();
    }

    @Override
    StrokeLineJoin convertLineJoin(StrokeLineJoin strokeLineJoin) {
        if (this.getArcWidth() > 0.0 && this.getArcHeight() > 0.0) {
            return StrokeLineJoin.BEVEL;
        }
        return strokeLineJoin;
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        double d2;
        if (this.getMode() == NGShape$Mode.EMPTY) {
            return baseBounds.makeEmpty();
        }
        if (this.getArcWidth() > 0.0 && this.getArcHeight() > 0.0 && (baseTransform.getType() & 0xFFFFFFB0) != 0) {
            return this.computeShapeBounds(baseBounds, baseTransform, ShapeHelper.configShape(this));
        }
        if (this.getMode() == NGShape$Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
            d2 = 0.0;
        } else {
            d2 = this.getStrokeWidth();
            if (this.getStrokeType() == StrokeType.CENTERED) {
                d2 /= 2.0;
            }
        }
        return this.computeBounds(baseBounds, baseTransform, d2, 0.0, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    private RoundRectangle2D doConfigShape() {
        if (this.getArcWidth() > 0.0 && this.getArcHeight() > 0.0) {
            this.shape.setRoundRect((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), (float)this.getArcWidth(), (float)this.getArcHeight());
        } else {
            this.shape.setRoundRect((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), 0.0f, 0.0f);
        }
        return this.shape;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.NODE_GEOMETRY)) {
            NGRectangle nGRectangle = (NGRectangle)NodeHelper.getPeer(this);
            nGRectangle.updateRectangle((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), (float)this.getArcWidth(), (float)this.getArcHeight());
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Rectangle[");
        Object object = this.getId();
        if (object != null) {
            stringBuilder.append("id=").append((String)object).append(", ");
        }
        stringBuilder.append("x=").append(this.getX());
        stringBuilder.append(", y=").append(this.getY());
        stringBuilder.append(", width=").append(this.getWidth());
        stringBuilder.append(", height=").append(this.getHeight());
        stringBuilder.append(", fill=").append(this.getFill());
        object = this.getStroke();
        if (object != null) {
            stringBuilder.append(", stroke=").append(object);
            stringBuilder.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return stringBuilder.append("]").toString();
    }

    static {
        RectangleHelper.setRectangleAccessor(new Rectangle$1());
    }
}

