/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.SVGPathHelper;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGSVGPath;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Logging;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.SVGPath$1;
import javafx.scene.shape.SVGPath$2;
import javafx.scene.shape.SVGPath$3;
import javafx.scene.shape.Shape;

public class SVGPath
extends Shape {
    private ObjectProperty<FillRule> fillRule;
    private Path2D path2d;
    private StringProperty content;
    private Object svgPathObject;

    public SVGPath() {
        SVGPathHelper.initHelper(this);
    }

    public final void setFillRule(FillRule fillRule) {
        if (this.fillRule != null || fillRule != FillRule.NON_ZERO) {
            this.fillRuleProperty().set(fillRule);
        }
    }

    public final FillRule getFillRule() {
        if (this.fillRule == null) {
            return FillRule.NON_ZERO;
        }
        return (FillRule)((Object)this.fillRule.get());
    }

    public final ObjectProperty<FillRule> fillRuleProperty() {
        if (this.fillRule == null) {
            this.fillRule = new SVGPath$2(this, FillRule.NON_ZERO);
        }
        return this.fillRule;
    }

    public final void setContent(String string) {
        this.contentProperty().set(string);
    }

    public final String getContent() {
        if (this.content == null) {
            return "";
        }
        return (String)this.content.get();
    }

    public final StringProperty contentProperty() {
        if (this.content == null) {
            this.content = new SVGPath$3(this, "");
        }
        return this.content;
    }

    private NGNode doCreatePeer() {
        return new NGSVGPath();
    }

    private Path2D doConfigShape() {
        if (this.path2d == null) {
            this.path2d = this.createSVGPath2D();
        } else {
            this.path2d.setWindingRule(this.getFillRule() == FillRule.NON_ZERO ? 1 : 0);
        }
        return this.path2d;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.SHAPE_FILLRULE) || NodeHelper.isDirty(this, DirtyBits.NODE_CONTENTS)) {
            NGSVGPath nGSVGPath = (NGSVGPath)NodeHelper.getPeer(this);
            if (nGSVGPath.acceptsPath2dOnUpdate()) {
                if (this.svgPathObject == null) {
                    this.svgPathObject = new Path2D();
                }
                Path2D path2D = (Path2D)this.svgPathObject;
                path2D.setTo((Path2D)ShapeHelper.configShape(this));
            } else {
                this.svgPathObject = this.createSVGPathObject();
            }
            nGSVGPath.setContent(this.svgPathObject);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SVGPath[");
        Object object = this.getId();
        if (object != null) {
            stringBuilder.append("id=").append((String)object).append(", ");
        }
        stringBuilder.append("content=\"").append(this.getContent()).append("\"");
        stringBuilder.append(", fill=").append(this.getFill());
        stringBuilder.append(", fillRule=").append((Object)this.getFillRule());
        object = this.getStroke();
        if (object != null) {
            stringBuilder.append(", stroke=").append(object);
            stringBuilder.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return stringBuilder.append("]").toString();
    }

    private Path2D createSVGPath2D() {
        try {
            return Toolkit.getToolkit().createSVGPath2D(this);
        }
        catch (RuntimeException runtimeException) {
            Logging.getJavaFXLogger().warning("Failed to configure svg path \"{0}\": {1}", this.getContent(), runtimeException.getMessage());
            return Toolkit.getToolkit().createSVGPath2D(new SVGPath());
        }
    }

    private Object createSVGPathObject() {
        try {
            return Toolkit.getToolkit().createSVGPathObject(this);
        }
        catch (RuntimeException runtimeException) {
            Logging.getJavaFXLogger().warning("Failed to configure svg path \"{0}\": {1}", this.getContent(), runtimeException.getMessage());
            return Toolkit.getToolkit().createSVGPathObject(new SVGPath());
        }
    }

    static {
        SVGPathHelper.setSVGPathAccessor(new SVGPath$1());
    }
}

