/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.paint.MaterialHelper;
import com.sun.javafx.scene.shape.Shape3DHelper;
import com.sun.javafx.sg.prism.NGShape3D;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.PredefinedMeshManager;
import javafx.scene.shape.Shape3D$1;
import javafx.scene.shape.Shape3D$2;
import javafx.scene.shape.Shape3D$3;
import javafx.scene.shape.Shape3D$4;
import javafx.scene.shape.Shape3D$Key;

public abstract class Shape3D
extends Node {
    private static final PhongMaterial DEFAULT_MATERIAL;
    PredefinedMeshManager manager = PredefinedMeshManager.getInstance();
    Shape3D$Key key;
    private ObjectProperty<Material> material;
    private ObjectProperty<DrawMode> drawMode;
    private ObjectProperty<CullFace> cullFace;

    protected Shape3D() {
        if (!Platform.isSupported(ConditionalFeature.SCENE3D)) {
            String string = Shape3D.class.getName();
            PlatformLogger.getLogger(string).warning("System can't support ConditionalFeature.SCENE3D");
        }
    }

    public final void setMaterial(Material material) {
        this.materialProperty().set(material);
    }

    public final Material getMaterial() {
        if (this.material == null) {
            return null;
        }
        return (Material)this.material.get();
    }

    public final ObjectProperty<Material> materialProperty() {
        if (this.material == null) {
            Shape3D shape3D = this;
            this.material = new Shape3D$2(shape3D, shape3D, "material");
        }
        return this.material;
    }

    public final void setDrawMode(DrawMode drawMode) {
        this.drawModeProperty().set(drawMode);
    }

    public final DrawMode getDrawMode() {
        if (this.drawMode == null) {
            return DrawMode.FILL;
        }
        return (DrawMode)((Object)this.drawMode.get());
    }

    public final ObjectProperty<DrawMode> drawModeProperty() {
        if (this.drawMode == null) {
            Shape3D shape3D = this;
            this.drawMode = new Shape3D$3(shape3D, shape3D, "drawMode", DrawMode.FILL);
        }
        return this.drawMode;
    }

    public final void setCullFace(CullFace cullFace) {
        this.cullFaceProperty().set(cullFace);
    }

    public final CullFace getCullFace() {
        if (this.cullFace == null) {
            return CullFace.BACK;
        }
        return (CullFace)((Object)this.cullFace.get());
    }

    public final ObjectProperty<CullFace> cullFaceProperty() {
        if (this.cullFace == null) {
            Shape3D shape3D = this;
            this.cullFace = new Shape3D$4(shape3D, shape3D, "cullFace", CullFace.BACK);
        }
        return this.cullFace;
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        return new BoxBounds(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    private boolean doComputeContains(double d2, double d3) {
        return false;
    }

    private void doUpdatePeer() {
        NGShape3D nGShape3D = (NGShape3D)NodeHelper.getPeer(this);
        if (NodeHelper.isDirty(this, DirtyBits.MATERIAL)) {
            Material material = this.getMaterial() == null ? DEFAULT_MATERIAL : this.getMaterial();
            MaterialHelper.updatePG(material);
            nGShape3D.setMaterial(MaterialHelper.getNGMaterial(material));
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_DRAWMODE)) {
            nGShape3D.setDrawMode((Object)(this.getDrawMode() == null ? DrawMode.FILL : this.getDrawMode()));
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_CULLFACE)) {
            nGShape3D.setCullFace((Object)(this.getCullFace() == null ? CullFace.BACK : this.getCullFace()));
        }
    }

    static {
        Shape3DHelper.setShape3DAccessor(new Shape3D$1());
        DEFAULT_MATERIAL = new PhongMaterial();
    }
}

