/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.shape.MeshHelper;
import com.sun.javafx.scene.shape.SphereHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGSphere;
import javafx.animation.Interpolatable;
import javafx.beans.property.DoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.Sphere$1;
import javafx.scene.shape.Sphere$2;
import javafx.scene.shape.Sphere$SphereKey;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Rotate;

public class Sphere
extends Shape3D {
    static final int DEFAULT_DIVISIONS = 64;
    static final double DEFAULT_RADIUS = 1.0;
    private int divisions = 64;
    private TriangleMesh mesh;
    private DoubleProperty radius;

    public Sphere() {
        this(1.0, 64);
    }

    public Sphere(double d2) {
        this(d2, 64);
    }

    public Sphere(double d2, int n2) {
        SphereHelper.initHelper(this);
        this.divisions = n2 <= 0 ? 1 : n2;
        this.setRadius(d2);
    }

    public final void setRadius(double d2) {
        this.radiusProperty().set(d2);
    }

    public final double getRadius() {
        if (this.radius == null) {
            return 1.0;
        }
        return this.radius.get();
    }

    public final DoubleProperty radiusProperty() {
        if (this.radius == null) {
            Sphere sphere = this;
            this.radius = new Sphere$2(sphere, sphere, "radius", 1.0);
        }
        return this.radius;
    }

    public int getDivisions() {
        return this.divisions;
    }

    private NGNode doCreatePeer() {
        return new NGSphere();
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.MESH_GEOM)) {
            float f2;
            NGSphere nGSphere = (NGSphere)NodeHelper.getPeer(this);
            float f3 = (float)this.getRadius();
            if (f2 < 0.0f) {
                nGSphere.updateMesh(null);
                return;
            }
            if (this.key == null) {
                this.key = new Sphere$SphereKey(f3, this.divisions);
            }
            this.mesh = this.manager.getSphereMesh(f3, this.divisions, this.key);
            this.mesh.updatePG();
            nGSphere.updateMesh(this.mesh.getPGTriangleMesh());
        }
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        float f2;
        float f3 = (float)this.getRadius();
        if (f2 < 0.0f) {
            return baseBounds.makeEmpty();
        }
        float f4 = f3;
        BaseBounds baseBounds2 = baseBounds = baseBounds.deriveWithNewBounds(-f3, -f3, -f3, f4, f4, f3);
        baseBounds = baseTransform.transform(baseBounds2, baseBounds2);
        return baseBounds;
    }

    private boolean doComputeContains(double d2, double d3) {
        double d4;
        double d5 = this.getRadius();
        double d6 = d2;
        double d7 = d3;
        double d8 = d6 * d6 + d7 * d7;
        double d9 = d5;
        return d4 <= d9 * d9;
    }

    private boolean doComputeIntersects(PickRay object, PickResultChooser pickResultChooser) {
        double d2;
        double d3;
        double d4;
        boolean bl2 = this.divisions < 64 && this.mesh != null;
        double d5 = this.getRadius();
        Object object2 = ((PickRay)object).getDirectionNoClone();
        double d6 = ((Vec3d)object2).x;
        double d7 = ((Vec3d)object2).y;
        double d8 = ((Vec3d)object2).z;
        object2 = ((PickRay)object).getOriginNoClone();
        double d9 = ((Vec3d)object2).x;
        double d10 = ((Vec3d)object2).y;
        double d11 = ((Vec3d)object2).z;
        double d12 = d6;
        double d13 = d7;
        double d14 = d8;
        double d15 = d12 * d12 + d13 * d13 + d14 * d14;
        double d16 = 2.0 * (d6 * d9 + d7 * d10 + d8 * d11);
        double d17 = d9;
        double d18 = d10;
        double d19 = d11;
        double d20 = d5;
        double d21 = d17 * d17 + d18 * d18 + d19 * d19 - d20 * d20;
        double d22 = d16;
        double d23 = d22 * d22 - d15 * 4.0 * d21;
        if (d4 < 0.0) {
            return false;
        }
        double d24 = Math.sqrt(d23);
        double d25 = d16 < 0.0 ? (-d16 - d24) / 2.0 : (-d16 + d24) / 2.0;
        double d26 = d25 / d15;
        if (d26 > (d3 = d21 / d25)) {
            d2 = d26;
            d26 = d3;
            d3 = d2;
        }
        d2 = ((PickRay)object).getNearClip();
        double d27 = ((PickRay)object).getFarClip();
        if (d3 < d2 || d26 > d27) {
            return false;
        }
        double d28 = d26;
        object2 = this.getCullFace();
        if (d26 < d2 || object2 == CullFace.FRONT) {
            if (d3 <= d27 && this.getCullFace() != CullFace.BACK) {
                d28 = d3;
            } else if (!bl2) {
                return false;
            }
        }
        if (Double.isInfinite(d28) || Double.isNaN(d28)) {
            return false;
        }
        if (bl2) {
            return MeshHelper.computeIntersects(this.mesh, (PickRay)object, pickResultChooser, this, (CullFace)((Object)object2), false);
        }
        if (pickResultChooser != null && pickResultChooser.isCloser(d28)) {
            object = PickResultChooser.computePoint((PickRay)object, d28);
            Interpolatable<Point3D> interpolatable = new Point3D(((Point3D)object).getX(), 0.0, ((Point3D)object).getZ());
            object2 = interpolatable.crossProduct(Rotate.Z_AXIS);
            double d29 = interpolatable.angle(Rotate.Z_AXIS);
            if (((Point3D)object2).getY() > 0.0) {
                d29 = 360.0 - d29;
            }
            interpolatable = new Point2D(1.0 - d29 / 360.0, 0.5 + ((Point3D)object).getY() / (d5 * 2.0));
            pickResultChooser.offer(this, d28, -1, (Point3D)object, (Point2D)interpolatable);
        }
        return true;
    }

    private static int correctDivisions(int n2) {
        return (n2 + 3) / 4 << 2;
    }

    static TriangleMesh createMesh(int n2, float f2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        n2 = Sphere.correctDivisions(n2);
        int n8 = n2 / 2;
        int n9 = n2 * (n8 - 1) + 2;
        int n10 = (n2 + 1) * (n8 - 1) + (n2 << 1);
        int n11 = (n2 * (n8 - 2) << 1) + (n2 << 1);
        float f3 = 1.0f / (float)n2;
        float[] fArray = new float[n9 * 3];
        float[] fArray2 = new float[n10 << 1];
        int[] nArray = new int[n11 * 6];
        int n12 = 0;
        int n13 = 0;
        for (n7 = 0; n7 < n8 - 1; ++n7) {
            float f4 = f3 * (float)(n7 + 1 - n8 / 2) * 2.0f * (float)Math.PI;
            float f5 = (float)Math.sin(f4);
            f4 = (float)Math.cos(f4);
            float f6 = 0.5f + f5 * 0.5f;
            for (n6 = 0; n6 < n2; ++n6) {
                double d2 = f3 * (float)n6 * 2.0f * (float)Math.PI;
                float f7 = (float)Math.sin(d2);
                float f8 = (float)Math.cos(d2);
                fArray[n12] = f7 * f4 * f2;
                fArray[n12 + 2] = f8 * f4 * f2;
                fArray[n12 + 1] = f5 * f2;
                fArray2[n13] = 1.0f - f3 * (float)n6;
                fArray2[n13 + 1] = f6;
                n12 += 3;
                n13 += 2;
            }
            fArray2[n13] = 0.0f;
            fArray2[n13 + 1] = f6;
            n13 += 2;
        }
        fArray[n12] = 0.0f;
        fArray[n12 + 1] = -f2;
        fArray[n12 + 2] = 0.0f;
        fArray[n12 + 3] = 0.0f;
        fArray[n12 + 4] = f2;
        fArray[n12 + 5] = 0.0f;
        n7 = (n8 - 1) * n2;
        for (n5 = 0; n5 < n2; ++n5) {
            fArray2[n13] = 1.0f - f3 * (0.5f + (float)n5);
            fArray2[n13 + 1] = 0.00390625f;
            n13 += 2;
        }
        for (n5 = 0; n5 < n2; ++n5) {
            fArray2[n13] = 1.0f - f3 * (0.5f + (float)n5);
            fArray2[n13 + 1] = 0.99609375f;
            n13 += 2;
        }
        n5 = 0;
        for (n4 = 0; n4 < n8 - 2; ++n4) {
            for (int i2 = 0; i2 < n2; ++i2) {
                n6 = n4 * n2 + i2;
                int n14 = n6 + 1;
                n3 = n6 + n2;
                int n15 = n14 + n2;
                int n16 = n6 + n4;
                int n17 = n16 + 1;
                int n18 = n16 + (n2 + 1);
                n12 = n17 + (n2 + 1);
                nArray[n5] = n6;
                nArray[n5 + 1] = n16;
                nArray[n5 + 2] = n14 % n2 == 0 ? n14 - n2 : n14;
                nArray[n5 + 3] = n17;
                nArray[n5 + 4] = n3;
                nArray[n5 + 5] = n18;
                nArray[n5 += 6] = n15 % n2 == 0 ? n15 - n2 : n15;
                nArray[n5 + 1] = n12;
                nArray[n5 + 2] = n3;
                nArray[n5 + 3] = n18;
                nArray[n5 + 4] = n14 % n2 == 0 ? n14 - n2 : n14;
                nArray[n5 + 5] = n17;
                n5 += 6;
            }
        }
        n4 = n7;
        int n19 = (n8 - 1) * (n2 + 1);
        for (n6 = 0; n6 < n2; ++n6) {
            int n20 = n6;
            n3 = n6 + 1;
            int n21 = n19 + n6;
            nArray[n5] = n4;
            nArray[n5 + 1] = n21;
            nArray[n5 + 2] = n3 == n2 ? 0 : n3;
            nArray[n5 + 3] = n3;
            nArray[n5 + 4] = n20;
            nArray[n5 + 5] = n20;
            n5 += 6;
        }
        ++n4;
        n19 += n2;
        n6 = (n8 - 2) * n2;
        for (int i3 = 0; i3 < n2; ++i3) {
            n3 = n6 + i3;
            int n22 = n6 + i3 + 1;
            int n23 = n19 + i3;
            int n24 = (n8 - 2) * (n2 + 1) + i3;
            int n25 = n24 + 1;
            nArray[n5] = n4;
            nArray[n5 + 1] = n23;
            nArray[n5 + 2] = n3;
            nArray[n5 + 3] = n24;
            nArray[n5 + 4] = n22 % n2 == 0 ? n22 - n2 : n22;
            nArray[n5 + 5] = n25;
            n5 += 6;
        }
        TriangleMesh triangleMesh = new TriangleMesh(true);
        triangleMesh.getPoints().setAll(fArray);
        triangleMesh.getTexCoords().setAll(fArray2);
        triangleMesh.getFaces().setAll(nArray);
        return triangleMesh;
    }

    static {
        SphereHelper.setSphereAccessor(new Sphere$1());
    }
}

