/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.shape.ObservableFaceArrayImpl;
import com.sun.javafx.scene.shape.TriangleMeshHelper;
import com.sun.javafx.sg.prism.NGTriangleMesh;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableArray;
import javafx.collections.ObservableFloatArray;
import javafx.collections.ObservableIntegerArray;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.ObservableFaceArray;
import javafx.scene.shape.TriangleMesh$1;
import javafx.scene.shape.TriangleMesh$2;
import javafx.scene.shape.TriangleMesh$Listener;
import javafx.scene.shape.VertexFormat;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate;

public class TriangleMesh
extends Mesh {
    private final ObservableFloatArray points = FXCollections.observableFloatArray();
    private final ObservableFloatArray normals = FXCollections.observableFloatArray();
    private final ObservableFloatArray texCoords = FXCollections.observableFloatArray();
    private final ObservableFaceArray faces = new ObservableFaceArrayImpl();
    private final ObservableIntegerArray faceSmoothingGroups = FXCollections.observableIntegerArray();
    private final TriangleMesh$Listener pointsSyncer;
    private final TriangleMesh$Listener normalsSyncer;
    private final TriangleMesh$Listener texCoordsSyncer;
    private final TriangleMesh$Listener facesSyncer;
    private final TriangleMesh$Listener faceSmoothingGroupsSyncer;
    private final boolean isPredefinedShape;
    private boolean isValidDirty;
    private boolean isPointsValid;
    private boolean isNormalsValid;
    private boolean isTexCoordsValid;
    private boolean isFacesValid;
    private boolean isFaceSmoothingGroupValid;
    private int refCount;
    private BaseBounds cachedBounds;
    private ObjectProperty<VertexFormat> vertexFormat;
    private NGTriangleMesh peer;

    public TriangleMesh() {
        this(false);
        TriangleMeshHelper.initHelper(this);
    }

    public TriangleMesh(VertexFormat vertexFormat) {
        this(false);
        this.setVertexFormat(vertexFormat);
        TriangleMeshHelper.initHelper(this);
    }

    TriangleMesh(boolean bl2) {
        TriangleMesh triangleMesh = this;
        this.pointsSyncer = new TriangleMesh$Listener(triangleMesh, (ObservableArray)triangleMesh.points);
        TriangleMesh triangleMesh2 = this;
        this.normalsSyncer = new TriangleMesh$Listener(triangleMesh2, (ObservableArray)triangleMesh2.normals);
        TriangleMesh triangleMesh3 = this;
        this.texCoordsSyncer = new TriangleMesh$Listener(triangleMesh3, (ObservableArray)triangleMesh3.texCoords);
        TriangleMesh triangleMesh4 = this;
        this.facesSyncer = new TriangleMesh$Listener(triangleMesh4, (ObservableArray)triangleMesh4.faces);
        TriangleMesh triangleMesh5 = this;
        this.faceSmoothingGroupsSyncer = new TriangleMesh$Listener(triangleMesh5, (ObservableArray)triangleMesh5.faceSmoothingGroups);
        this.isValidDirty = true;
        this.refCount = 1;
        this.isPredefinedShape = bl2;
        if (bl2) {
            this.isPointsValid = true;
            this.isNormalsValid = true;
            this.isTexCoordsValid = true;
            this.isFacesValid = true;
            this.isFaceSmoothingGroupValid = true;
        } else {
            this.isPointsValid = false;
            this.isNormalsValid = false;
            this.isTexCoordsValid = false;
            this.isFacesValid = false;
            this.isFaceSmoothingGroupValid = false;
        }
        TriangleMeshHelper.initHelper(this);
    }

    public final void setVertexFormat(VertexFormat vertexFormat) {
        this.vertexFormatProperty().set(vertexFormat);
    }

    public final VertexFormat getVertexFormat() {
        if (this.vertexFormat == null) {
            return VertexFormat.POINT_TEXCOORD;
        }
        return (VertexFormat)this.vertexFormat.get();
    }

    public final ObjectProperty<VertexFormat> vertexFormatProperty() {
        if (this.vertexFormat == null) {
            TriangleMesh triangleMesh = this;
            this.vertexFormat = new TriangleMesh$2(triangleMesh, triangleMesh, "vertexFormat");
        }
        return this.vertexFormat;
    }

    public final int getPointElementSize() {
        return this.getVertexFormat().getPointElementSize();
    }

    public final int getNormalElementSize() {
        return this.getVertexFormat().getNormalElementSize();
    }

    public final int getTexCoordElementSize() {
        return this.getVertexFormat().getTexCoordElementSize();
    }

    public final int getFaceElementSize() {
        return this.getVertexFormat().getVertexIndexSize() * 3;
    }

    public final ObservableFloatArray getPoints() {
        return this.points;
    }

    public final ObservableFloatArray getNormals() {
        return this.normals;
    }

    public final ObservableFloatArray getTexCoords() {
        return this.texCoords;
    }

    public final ObservableFaceArray getFaces() {
        return this.faces;
    }

    public final ObservableIntegerArray getFaceSmoothingGroups() {
        return this.faceSmoothingGroups;
    }

    @Override
    void setDirty(boolean bl2) {
        super.setDirty(bl2);
        if (!bl2) {
            this.pointsSyncer.setDirty(false);
            this.normalsSyncer.setDirty(false);
            this.texCoordsSyncer.setDirty(false);
            this.facesSyncer.setDirty(false);
            this.faceSmoothingGroupsSyncer.setDirty(false);
        }
    }

    int getRefCount() {
        return this.refCount;
    }

    synchronized void incRef() {
        ++this.refCount;
    }

    synchronized void decRef() {
        --this.refCount;
    }

    NGTriangleMesh getPGTriangleMesh() {
        if (this.peer == null) {
            this.peer = new NGTriangleMesh();
        }
        return this.peer;
    }

    @Override
    NGTriangleMesh getPGMesh() {
        return this.getPGTriangleMesh();
    }

    private boolean validatePoints() {
        if (this.points.size() == 0) {
            return false;
        }
        if (this.points.size() % this.getVertexFormat().getPointElementSize() != 0) {
            String string = TriangleMesh.class.getName();
            PlatformLogger.getLogger(string).warning("points.size() has to be divisible by getPointElementSize(). It is to store multiple x, y, and z coordinates of this mesh");
            return false;
        }
        return true;
    }

    private boolean validateNormals() {
        if (this.getVertexFormat() != VertexFormat.POINT_NORMAL_TEXCOORD) {
            return true;
        }
        if (this.normals.size() == 0) {
            return false;
        }
        if (this.normals.size() % this.getVertexFormat().getNormalElementSize() != 0) {
            String string = TriangleMesh.class.getName();
            PlatformLogger.getLogger(string).warning("normals.size() has to be divisible by getNormalElementSize(). It is to store multiple nx, ny, and nz coordinates of this mesh");
            return false;
        }
        return true;
    }

    private boolean validateTexCoords() {
        if (this.texCoords.size() == 0) {
            return false;
        }
        if (this.texCoords.size() % this.getVertexFormat().getTexCoordElementSize() != 0) {
            String string = TriangleMesh.class.getName();
            PlatformLogger.getLogger(string).warning("texCoords.size() has to be divisible by getTexCoordElementSize(). It is to store multiple u and v texture coordinates of this mesh");
            return false;
        }
        return true;
    }

    private boolean validateFaces() {
        if (this.faces.size() == 0) {
            return false;
        }
        String string = TriangleMesh.class.getName();
        if (this.faces.size() % this.getFaceElementSize() != 0) {
            PlatformLogger.getLogger(string).warning("faces.size() has to be divisible by getFaceElementSize().");
            return false;
        }
        if (this.getVertexFormat() == VertexFormat.POINT_TEXCOORD) {
            int n2 = this.points.size() / this.getVertexFormat().getPointElementSize();
            int n3 = this.texCoords.size() / this.getVertexFormat().getTexCoordElementSize();
            for (int i2 = 0; i2 < this.faces.size(); ++i2) {
                if ((i2 % 2 != 0 || this.faces.get(i2) < n2 && this.faces.get(i2) >= 0) && (i2 % 2 == 0 || this.faces.get(i2) < n3 && this.faces.get(i2) >= 0)) continue;
                PlatformLogger.getLogger(string).warning("The values in the faces array must be within the range of the number of vertices in the points array (0 to points.length / 3 - 1) for the point indices and within the range of the number of the vertices in the texCoords array (0 to texCoords.length / 2 - 1) for the texture coordinate indices.");
                return false;
            }
        } else if (this.getVertexFormat() == VertexFormat.POINT_NORMAL_TEXCOORD) {
            int n4 = this.points.size() / this.getVertexFormat().getPointElementSize();
            int n5 = this.normals.size() / this.getVertexFormat().getNormalElementSize();
            int n6 = this.texCoords.size() / this.getVertexFormat().getTexCoordElementSize();
            for (int i3 = 0; i3 < this.faces.size(); i3 += 3) {
                if (this.faces.get(i3) < n4 && this.faces.get(i3) >= 0 && this.faces.get(i3 + 1) < n5 && this.faces.get(i3 + 1) >= 0 && this.faces.get(i3 + 2) < n6 && this.faces.get(i3 + 2) >= 0) continue;
                PlatformLogger.getLogger(string).warning("The values in the faces array must be within the range of the number of vertices in the points array (0 to points.length / 3 - 1) for the point indices, and within the range of the number of the vertices in the normals array (0 to normals.length / 3 - 1) for the normals indices, and number of the vertices in the texCoords array (0 to texCoords.length / 2 - 1) for the texture coordinate indices.");
                return false;
            }
        } else {
            PlatformLogger.getLogger(string).warning("Unsupported VertexFormat: " + this.getVertexFormat().toString());
            return false;
        }
        return true;
    }

    private boolean validateFaceSmoothingGroups() {
        if (this.faceSmoothingGroups.size() != 0 && this.faceSmoothingGroups.size() != this.faces.size() / this.getFaceElementSize()) {
            String string = TriangleMesh.class.getName();
            PlatformLogger.getLogger(string).warning("faceSmoothingGroups.size() has to equal to number of faces.");
            return false;
        }
        return true;
    }

    private boolean validate() {
        if (this.isPredefinedShape) {
            return true;
        }
        if (this.isValidDirty) {
            if (this.pointsSyncer.dirtyInFull) {
                this.isPointsValid = this.validatePoints();
            }
            if (this.normalsSyncer.dirtyInFull) {
                this.isNormalsValid = this.validateNormals();
            }
            if (this.texCoordsSyncer.dirtyInFull) {
                this.isTexCoordsValid = this.validateTexCoords();
            }
            if (this.facesSyncer.dirty || this.pointsSyncer.dirtyInFull || this.normalsSyncer.dirtyInFull || this.texCoordsSyncer.dirtyInFull) {
                boolean bl2 = this.isFacesValid = this.isPointsValid && this.isNormalsValid && this.isTexCoordsValid && this.validateFaces();
            }
            if (this.faceSmoothingGroupsSyncer.dirtyInFull || this.facesSyncer.dirtyInFull) {
                this.isFaceSmoothingGroupValid = this.isFacesValid && this.validateFaceSmoothingGroups();
            }
            this.isValidDirty = false;
        }
        return this.isPointsValid && this.isNormalsValid && this.isTexCoordsValid && this.isFaceSmoothingGroupValid && this.isFacesValid;
    }

    @Override
    void updatePG() {
        if (!this.isDirty()) {
            return;
        }
        NGTriangleMesh nGTriangleMesh = this.getPGTriangleMesh();
        if (this.validate()) {
            nGTriangleMesh.setUserDefinedNormals(this.getVertexFormat() == VertexFormat.POINT_NORMAL_TEXCOORD);
            nGTriangleMesh.syncPoints(this.pointsSyncer);
            nGTriangleMesh.syncNormals(this.normalsSyncer);
            nGTriangleMesh.syncTexCoords(this.texCoordsSyncer);
            nGTriangleMesh.syncFaces(this.facesSyncer);
            nGTriangleMesh.syncFaceSmoothingGroups(this.faceSmoothingGroupsSyncer);
        } else {
            nGTriangleMesh.setUserDefinedNormals(false);
            nGTriangleMesh.syncPoints(null);
            nGTriangleMesh.syncNormals(null);
            nGTriangleMesh.syncTexCoords(null);
            nGTriangleMesh.syncFaces(null);
            nGTriangleMesh.syncFaceSmoothingGroups(null);
        }
        this.setDirty(false);
    }

    @Override
    BaseBounds computeBounds(BaseBounds baseBounds) {
        if (this.isDirty() || this.cachedBounds == null) {
            this.cachedBounds = new BoxBounds();
            if (this.validate()) {
                int n2 = this.points.size();
                int n3 = this.getVertexFormat().getPointElementSize();
                for (int i2 = 0; i2 < n2; i2 += n3) {
                    this.cachedBounds.add(this.points.get(i2), this.points.get(i2 + 1), this.points.get(i2 + 2));
                }
            }
        }
        return baseBounds.deriveWithNewBounds(this.cachedBounds);
    }

    private Point3D computeCentroid(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        return new Point3D(d2 + (d8 + (d5 - d8) / 2.0 - d2) / 3.0, d3 + (d9 + (d6 - d9) / 2.0 - d3) / 3.0, d4 + (d10 + (d7 - d10) / 2.0 - d4) / 3.0);
    }

    private Point2D computeCentroid(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        point2D2 = point2D2.midpoint(point2D3);
        point2D2 = point2D2.subtract(point2D);
        return point2D.add(new Point2D(point2D2.getX() / 3.0, point2D2.getY() / 3.0));
    }

    private boolean computeIntersectsFace(PickRay object, Vec3d object2, Vec3d object3, int n2, CullFace object4, Node node, boolean bl2, PickResultChooser pickResultChooser) {
        double d2;
        double d3;
        float f2;
        float f3;
        double d4;
        float f4;
        float f5;
        int n3 = this.getVertexFormat().getVertexIndexSize();
        int n4 = this.getVertexFormat().getPointElementSize();
        int n5 = this.faces.get(n2) * n4;
        int n6 = this.faces.get(n2 + n3) * n4;
        n4 = this.faces.get(n2 + 2 * n3) * n4;
        float f6 = this.points.get(n5);
        float f7 = this.points.get(n5 + 1);
        float f8 = this.points.get(n5 + 2);
        float f9 = this.points.get(n6);
        float f10 = this.points.get(n6 + 1);
        float f11 = this.points.get(n6 + 2);
        float f12 = this.points.get(n4);
        float f13 = this.points.get(n4 + 1);
        float f14 = f9 - f6;
        float f15 = this.points.get(n4 + 2);
        float f16 = f15 - f8;
        double d5 = ((Vec3d)object3).y * (double)f16 - ((Vec3d)object3).z * (double)(f5 = f13 - f7);
        double d6 = (double)f14 * d5 + (double)(f4 = f10 - f7) * (d4 = ((Vec3d)object3).z * (double)(f3 = f12 - f6) - ((Vec3d)object3).x * (double)f16) + (double)(f2 = f11 - f8) * (d3 = ((Vec3d)object3).x * (double)f5 - ((Vec3d)object3).y * (double)f3);
        if (d6 == 0.0) {
            return false;
        }
        double d7 = 1.0 / d6;
        double d8 = ((Vec3d)object2).x - (double)f6;
        double d9 = ((Vec3d)object2).y - (double)f7;
        double d10 = ((Vec3d)object2).z - (double)f8;
        double d11 = d7 * (d8 * d5 + d9 * d4 + d10 * d3);
        if (d11 < 0.0 || d11 > 1.0) {
            return false;
        }
        double d12 = d9 * (double)f2 - d10 * (double)f4;
        double d13 = d10 * (double)f14 - d8 * (double)f2;
        double d14 = d8 * (double)f4 - d9 * (double)f14;
        double d15 = d7 * (((Vec3d)object3).x * d12 + ((Vec3d)object3).y * d13 + ((Vec3d)object3).z * d14);
        if (d15 < 0.0 || d11 + d15 > 1.0) {
            return false;
        }
        double d16 = d7 * ((double)f3 * d12 + (double)f5 * d13 + (double)f16 * d14);
        if (d2 >= ((PickRay)object).getNearClip() && d16 <= ((PickRay)object).getFarClip()) {
            Point3D point3D;
            double d17;
            if (object4 != CullFace.NONE && ((d17 = ((Point3D)(object2 = new Point3D(f4 * f16 - f2 * f5, f2 * f3 - f14 * f16, f14 * f5 - f4 * f3))).angle(new Point3D(-((Vec3d)object3).x, -((Vec3d)object3).y, -((Vec3d)object3).z))) >= 90.0 || object4 != CullFace.BACK) && (d17 <= 90.0 || object4 != CullFace.FRONT)) {
                return false;
            }
            if (Double.isInfinite(d16) || Double.isNaN(d16)) {
                return false;
            }
            if (pickResultChooser == null || !pickResultChooser.isCloser(d16)) {
                return true;
            }
            object2 = PickResultChooser.computePoint((PickRay)object, d16);
            Point3D point3D2 = this.computeCentroid(f6, f7, f8, f9, f10, f11, f12, f13, f15);
            Point3D point3D3 = new Point3D((double)f6 - point3D2.getX(), (double)f7 - point3D2.getY(), (double)f8 - point3D2.getZ());
            object = new Point3D((double)f9 - point3D2.getX(), (double)f10 - point3D2.getY(), (double)f11 - point3D2.getZ());
            object3 = new Point3D((double)f12 - point3D2.getX(), (double)f13 - point3D2.getY(), (double)f15 - point3D2.getZ());
            object4 = ((Point3D)object).subtract(point3D3);
            Point3D point3D4 = ((Point3D)object3).subtract(point3D3);
            Point3D point3D5 = ((Point3D)object4).crossProduct(point3D4);
            if (point3D.getZ() < 0.0) {
                point3D5 = new Point3D(-point3D5.getX(), -point3D5.getY(), -point3D5.getZ());
            }
            Point3D point3D6 = point3D5.crossProduct(Rotate.Z_AXIS);
            double d18 = Math.atan2(point3D6.magnitude(), point3D5.dotProduct(Rotate.Z_AXIS));
            Rotate rotate = new Rotate(Math.toDegrees(d18), point3D6);
            Point3D point3D7 = rotate.transform(point3D3);
            Point3D point3D8 = rotate.transform((Point3D)object);
            Point3D point3D9 = rotate.transform((Point3D)object3);
            Point3D point3D10 = rotate.transform(((Point3D)object2).subtract(point3D2));
            Point2D point2D = new Point2D(point3D7.getX(), point3D7.getY());
            Point2D point2D2 = new Point2D(point3D8.getX(), point3D8.getY());
            Point2D point2D3 = new Point2D(point3D9.getX(), point3D9.getY());
            Point2D point2D4 = new Point2D(point3D10.getX(), point3D10.getY());
            int n7 = this.getVertexFormat().getTexCoordElementSize();
            int n8 = this.getVertexFormat().getTexCoordIndexOffset();
            int n9 = this.faces.get(n2 + n8) * n7;
            int n10 = this.faces.get(n2 + n3 + n8) * n7;
            int n11 = this.faces.get(n2 + (n3 << 1) + n8) * n7;
            Point2D point2D5 = new Point2D(this.texCoords.get(n9), this.texCoords.get(n9 + 1));
            Point2D point2D6 = new Point2D(this.texCoords.get(n10), this.texCoords.get(n10 + 1));
            Point2D point2D7 = new Point2D(this.texCoords.get(n11), this.texCoords.get(n11 + 1));
            Point2D point2D8 = this.computeCentroid(point2D5, point2D6, point2D7);
            Point2D point2D9 = point2D5.subtract(point2D8);
            Point2D point2D10 = point2D6.subtract(point2D8);
            Point2D point2D11 = point2D7.subtract(point2D8);
            Affine affine = new Affine(point2D.getX(), point2D2.getX(), point2D3.getX(), point2D.getY(), point2D2.getY(), point2D3.getY());
            Affine affine2 = new Affine(point2D9.getX(), point2D10.getX(), point2D11.getX(), point2D9.getY(), point2D10.getY(), point2D11.getY());
            Point2D point2D12 = null;
            try {
                affine.invert();
                affine2.append(affine);
                point2D12 = point2D8.add(affine2.transform(point2D4));
            }
            catch (NonInvertibleTransformException nonInvertibleTransformException) {}
            pickResultChooser.offer(node, d16, bl2 ? n2 / this.getFaceElementSize() : -1, (Point3D)object2, point2D12);
            return true;
        }
        return false;
    }

    private boolean doComputeIntersects(PickRay pickRay, PickResultChooser pickResultChooser, Node node, CullFace cullFace, boolean bl2) {
        boolean bl3 = false;
        if (this.validate()) {
            int n2 = this.faces.size();
            Vec3d vec3d = pickRay.getOriginNoClone();
            Vec3d vec3d2 = pickRay.getDirectionNoClone();
            for (int i2 = 0; i2 < n2; i2 += this.getFaceElementSize()) {
                if (!this.computeIntersectsFace(pickRay, vec3d, vec3d2, i2, cullFace, node, bl2, pickResultChooser)) continue;
                bl3 = true;
            }
        }
        return bl3;
    }

    static {
        TriangleMeshHelper.setTriangleMeshAccessor(new TriangleMesh$1());
    }
}

