/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.text;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.TransformedShape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.scene.shape.TextHelper;
import com.sun.javafx.scene.text.FontHelper;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLayout$Hit;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape$Mode;
import com.sun.javafx.sg.prism.NGText;
import com.sun.javafx.tk.Toolkit;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.HitInfo;
import javafx.scene.text.Text$1;
import javafx.scene.text.Text$10;
import javafx.scene.text.Text$2;
import javafx.scene.text.Text$3;
import javafx.scene.text.Text$4;
import javafx.scene.text.Text$5;
import javafx.scene.text.Text$6;
import javafx.scene.text.Text$7;
import javafx.scene.text.Text$8;
import javafx.scene.text.Text$9;
import javafx.scene.text.Text$StyleableProperties;
import javafx.scene.text.Text$TextAttribute;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextBoundsType;
import javafx.scene.text.TextFlow;

@DefaultProperty(value="text")
public class Text
extends javafx.scene.shape.Shape {
    private TextLayout layout;
    private static final PathElement[] EMPTY_PATH_ELEMENT_ARRAY;
    private boolean isSpan;
    private TextSpan textSpan;
    private GlyphList[] textRuns;
    private BaseBounds spanBounds;
    private boolean spanBoundsInvalid;
    private StringProperty text;
    private DoubleProperty x;
    private DoubleProperty y;
    private ObjectProperty<Font> font;
    private ObjectProperty<TextBoundsType> boundsType;
    private DoubleProperty wrappingWidth;
    private ObjectProperty<FontSmoothingType> fontSmoothingType;
    private Text$TextAttribute attributes;
    private static final VPos DEFAULT_TEXT_ORIGIN;
    private static final TextBoundsType DEFAULT_BOUNDS_TYPE;
    private static final boolean DEFAULT_UNDERLINE = false;
    private static final boolean DEFAULT_STRIKETHROUGH = false;
    private static final TextAlignment DEFAULT_TEXT_ALIGNMENT;
    private static final double DEFAULT_LINE_SPACING = 0.0;
    private static final int DEFAULT_CARET_POSITION = -1;
    private static final int DEFAULT_SELECTION_START = -1;
    private static final int DEFAULT_SELECTION_END = -1;
    private static final Color DEFAULT_SELECTION_FILL;
    private static final boolean DEFAULT_CARET_BIAS = true;

    public Text() {
        TextHelper.initHelper(this);
        this.textRuns = null;
        this.spanBounds = new RectBounds();
        this.spanBoundsInvalid = true;
        this.setAccessibleRole(AccessibleRole.TEXT);
        InvalidationListener invalidationListener = observable -> this.checkSpan();
        this.parentProperty().addListener(invalidationListener);
        this.managedProperty().addListener(invalidationListener);
        this.effectiveNodeOrientationProperty().addListener(observable -> this.checkOrientation());
        this.setPickOnBounds(true);
    }

    public Text(String string) {
        this();
        this.setText(string);
    }

    public Text(double d2, double d3, String string) {
        this(string);
        this.setX(d2);
        this.setY(d3);
    }

    private NGNode doCreatePeer() {
        return new NGText();
    }

    private boolean isSpan() {
        return this.isSpan;
    }

    private void checkSpan() {
        boolean bl2 = this.isSpan = this.isManaged() && this.getParent() instanceof TextFlow;
        if (this.isSpan() && !this.pickOnBoundsProperty().isBound()) {
            this.setPickOnBounds(false);
        }
    }

    private void checkOrientation() {
        if (!this.isSpan()) {
            NodeOrientation nodeOrientation = this.getEffectiveNodeOrientation();
            int n2 = nodeOrientation == NodeOrientation.RIGHT_TO_LEFT ? 1 : 0;
            n2 = n2 != 0 ? 2048 : 1024;
            TextLayout textLayout = this.getTextLayout();
            if (textLayout.setDirection(n2)) {
                this.needsTextLayout();
            }
        }
    }

    @Override
    public boolean usesMirroring() {
        return false;
    }

    private void needsFullTextLayout() {
        if (this.isSpan()) {
            this.textSpan = null;
        } else {
            TextLayout textLayout = this.getTextLayout();
            String string = this.getTextInternal();
            Object object = this.getFontInternal();
            textLayout.setContent(string, object);
        }
        this.needsTextLayout();
    }

    private void needsTextLayout() {
        this.textRuns = null;
        NodeHelper.geomChanged(this);
        NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
    }

    TextSpan getTextSpan() {
        if (this.textSpan == null) {
            this.textSpan = new Text$2(this);
        }
        return this.textSpan;
    }

    private TextLayout getTextLayout() {
        if (this.isSpan()) {
            this.layout = null;
            TextFlow textFlow = (TextFlow)this.getParent();
            return textFlow.getTextLayout();
        }
        if (this.layout == null) {
            Object object = Toolkit.getToolkit().getTextLayoutFactory();
            this.layout = object.createLayout();
            object = this.getTextInternal();
            Object object2 = this.getFontInternal();
            TextAlignment textAlignment = this.getTextAlignment();
            if (textAlignment == null) {
                textAlignment = DEFAULT_TEXT_ALIGNMENT;
            }
            this.layout.setContent((String)object, object2);
            this.layout.setAlignment(textAlignment.ordinal());
            this.layout.setLineSpacing((float)this.getLineSpacing());
            this.layout.setWrapWidth((float)this.getWrappingWidth());
            if (this.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                this.layout.setDirection(2048);
            } else {
                this.layout.setDirection(1024);
            }
            this.layout.setTabSize(this.getTabSize());
        }
        return this.layout;
    }

    void layoutSpan(GlyphList[] glyphListArray) {
        GlyphList glyphList;
        int n2;
        TextSpan textSpan = this.getTextSpan();
        int n3 = 0;
        for (n2 = 0; n2 < glyphListArray.length; ++n2) {
            glyphList = glyphListArray[n2];
            if (glyphList.getTextSpan() != textSpan) continue;
            ++n3;
        }
        this.textRuns = new GlyphList[n3];
        n3 = 0;
        for (n2 = 0; n2 < glyphListArray.length; ++n2) {
            glyphList = glyphListArray[n2];
            if (glyphList.getTextSpan() != textSpan) continue;
            this.textRuns[n3++] = glyphList;
        }
        this.spanBoundsInvalid = true;
        NodeHelper.geomChanged(this);
        NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
    }

    BaseBounds getSpanBounds() {
        if (this.spanBoundsInvalid) {
            GlyphList[] glyphListArray = this.getRuns();
            if (glyphListArray.length != 0) {
                float f2 = Float.POSITIVE_INFINITY;
                float f3 = Float.POSITIVE_INFINITY;
                float f4 = 0.0f;
                float f5 = 0.0f;
                for (int i2 = 0; i2 < glyphListArray.length; ++i2) {
                    GlyphList glyphList = glyphListArray[i2];
                    com.sun.javafx.geom.Point2D point2D = glyphList.getLocation();
                    float f6 = glyphList.getWidth();
                    float f7 = ((BaseBounds)glyphList.getLineBounds()).getHeight();
                    f2 = Math.min(point2D.x, f2);
                    f3 = Math.min(point2D.y, f3);
                    f4 = Math.max(point2D.x + f6, f4);
                    f5 = Math.max(point2D.y + f7, f5);
                }
                this.spanBounds = this.spanBounds.deriveWithNewBounds(f2, f3, 0.0f, f4, f5, 0.0f);
            } else {
                this.spanBounds = this.spanBounds.makeEmpty();
            }
            this.spanBoundsInvalid = false;
        }
        return this.spanBounds;
    }

    private GlyphList[] getRuns() {
        if (this.textRuns != null) {
            return this.textRuns;
        }
        if (this.isSpan()) {
            this.getParent().layout();
        } else {
            TextLayout textLayout = this.getTextLayout();
            this.textRuns = textLayout.getRuns();
        }
        return this.textRuns;
    }

    private Shape getShape() {
        TextLayout textLayout = this.getTextLayout();
        int n2 = 1;
        if (this.isStrikethrough()) {
            n2 = 5;
        }
        if (this.isUnderline()) {
            n2 |= 2;
        }
        TextSpan textSpan = null;
        if (this.isSpan()) {
            n2 |= 0x10;
            textSpan = this.getTextSpan();
        } else {
            n2 |= 8;
        }
        return textLayout.getShape(n2, textSpan);
    }

    private BaseBounds getVisualBounds() {
        if (ShapeHelper.getMode(this) == NGShape$Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
            int n2 = 1;
            if (this.isStrikethrough()) {
                n2 = 5;
            }
            if (this.isUnderline()) {
                n2 |= 2;
            }
            return this.getTextLayout().getVisualBounds(n2);
        }
        return this.getShape().getBounds();
    }

    private BaseBounds getLogicalBounds() {
        TextLayout textLayout = this.getTextLayout();
        return textLayout.getBounds();
    }

    public final void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.textProperty().set(string);
    }

    public final String getText() {
        if (this.text == null) {
            return "";
        }
        return (String)this.text.get();
    }

    private String getTextInternal() {
        String string = this.getText();
        if (string == null) {
            return "";
        }
        return string;
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new Text$3(this, "");
        }
        return this.text;
    }

    public final void setX(double d2) {
        this.xProperty().set(d2);
    }

    public final double getX() {
        if (this.x == null) {
            return 0.0;
        }
        return this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new Text$4(this);
        }
        return this.x;
    }

    public final void setY(double d2) {
        this.yProperty().set(d2);
    }

    public final double getY() {
        if (this.y == null) {
            return 0.0;
        }
        return this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new Text$5(this);
        }
        return this.y;
    }

    public final void setFont(Font font) {
        this.fontProperty().set(font);
    }

    public final Font getFont() {
        if (this.font == null) {
            return Font.getDefault();
        }
        return (Font)this.font.get();
    }

    private Object getFontInternal() {
        Font font = this.getFont();
        if (font == null) {
            font = Font.getDefault();
        }
        return FontHelper.getNativeFont(font);
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new Text$6(this, Font.getDefault());
        }
        return this.font;
    }

    public final void setTextOrigin(VPos vPos) {
        this.textOriginProperty().set(vPos);
    }

    public final VPos getTextOrigin() {
        if (this.attributes == null || this.attributes.textOrigin == null) {
            return DEFAULT_TEXT_ORIGIN;
        }
        return this.attributes.getTextOrigin();
    }

    public final ObjectProperty<VPos> textOriginProperty() {
        return this.getTextAttribute().textOriginProperty();
    }

    public final void setBoundsType(TextBoundsType textBoundsType) {
        this.boundsTypeProperty().set(textBoundsType);
    }

    public final TextBoundsType getBoundsType() {
        if (this.boundsType == null) {
            return DEFAULT_BOUNDS_TYPE;
        }
        return (TextBoundsType)((Object)this.boundsTypeProperty().get());
    }

    public final ObjectProperty<TextBoundsType> boundsTypeProperty() {
        if (this.boundsType == null) {
            this.boundsType = new Text$7(this, DEFAULT_BOUNDS_TYPE);
        }
        return this.boundsType;
    }

    public final void setWrappingWidth(double d2) {
        this.wrappingWidthProperty().set(d2);
    }

    public final double getWrappingWidth() {
        if (this.wrappingWidth == null) {
            return 0.0;
        }
        return this.wrappingWidth.get();
    }

    public final DoubleProperty wrappingWidthProperty() {
        if (this.wrappingWidth == null) {
            this.wrappingWidth = new Text$8(this);
        }
        return this.wrappingWidth;
    }

    public final void setUnderline(boolean bl2) {
        this.underlineProperty().set(bl2);
    }

    public final boolean isUnderline() {
        if (this.attributes == null || this.attributes.underline == null) {
            return false;
        }
        return this.attributes.isUnderline();
    }

    public final BooleanProperty underlineProperty() {
        return this.getTextAttribute().underlineProperty();
    }

    public final void setStrikethrough(boolean bl2) {
        this.strikethroughProperty().set(bl2);
    }

    public final boolean isStrikethrough() {
        if (this.attributes == null || this.attributes.strikethrough == null) {
            return false;
        }
        return this.attributes.isStrikethrough();
    }

    public final BooleanProperty strikethroughProperty() {
        return this.getTextAttribute().strikethroughProperty();
    }

    public final void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignmentProperty().set(textAlignment);
    }

    public final TextAlignment getTextAlignment() {
        if (this.attributes == null || this.attributes.textAlignment == null) {
            return DEFAULT_TEXT_ALIGNMENT;
        }
        return this.attributes.getTextAlignment();
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        return this.getTextAttribute().textAlignmentProperty();
    }

    public final void setLineSpacing(double d2) {
        this.lineSpacingProperty().set(d2);
    }

    public final double getLineSpacing() {
        if (this.attributes == null || this.attributes.lineSpacing == null) {
            return 0.0;
        }
        return this.attributes.getLineSpacing();
    }

    public final DoubleProperty lineSpacingProperty() {
        return this.getTextAttribute().lineSpacingProperty();
    }

    @Override
    public final double getBaselineOffset() {
        return this.baselineOffsetProperty().get();
    }

    public final ReadOnlyDoubleProperty baselineOffsetProperty() {
        return this.getTextAttribute().baselineOffsetProperty();
    }

    public final void setFontSmoothingType(FontSmoothingType fontSmoothingType) {
        this.fontSmoothingTypeProperty().set(fontSmoothingType);
    }

    public final FontSmoothingType getFontSmoothingType() {
        if (this.fontSmoothingType == null) {
            return FontSmoothingType.GRAY;
        }
        return (FontSmoothingType)((Object)this.fontSmoothingType.get());
    }

    public final ObjectProperty<FontSmoothingType> fontSmoothingTypeProperty() {
        if (this.fontSmoothingType == null) {
            this.fontSmoothingType = new Text$9(this, FontSmoothingType.GRAY);
        }
        return this.fontSmoothingType;
    }

    private void doGeomChanged() {
        if (this.attributes != null) {
            if (this.attributes.caretBinding != null) {
                this.attributes.caretBinding.invalidate();
            }
            if (this.attributes.selectionBinding != null) {
                this.attributes.selectionBinding.invalidate();
            }
        }
        NodeHelper.markDirty(this, DirtyBits.NODE_GEOMETRY);
    }

    public final PathElement[] getSelectionShape() {
        return (PathElement[])this.selectionShapeProperty().get();
    }

    public final ReadOnlyObjectProperty<PathElement[]> selectionShapeProperty() {
        return this.getTextAttribute().selectionShapeProperty();
    }

    public final void setSelectionStart(int n2) {
        if (n2 == -1 && (this.attributes == null || this.attributes.selectionStart == null)) {
            return;
        }
        this.selectionStartProperty().set(n2);
    }

    public final int getSelectionStart() {
        if (this.attributes == null || this.attributes.selectionStart == null) {
            return -1;
        }
        return this.attributes.getSelectionStart();
    }

    public final IntegerProperty selectionStartProperty() {
        return this.getTextAttribute().selectionStartProperty();
    }

    public final void setSelectionEnd(int n2) {
        if (n2 == -1 && (this.attributes == null || this.attributes.selectionEnd == null)) {
            return;
        }
        this.selectionEndProperty().set(n2);
    }

    public final int getSelectionEnd() {
        if (this.attributes == null || this.attributes.selectionEnd == null) {
            return -1;
        }
        return this.attributes.getSelectionEnd();
    }

    public final IntegerProperty selectionEndProperty() {
        return this.getTextAttribute().selectionEndProperty();
    }

    public final ObjectProperty<Paint> selectionFillProperty() {
        return this.getTextAttribute().selectionFillProperty();
    }

    public final void setSelectionFill(Paint paint) {
        this.selectionFillProperty().set(paint);
    }

    public final Paint getSelectionFill() {
        return (Paint)this.selectionFillProperty().get();
    }

    public final PathElement[] getCaretShape() {
        return (PathElement[])this.caretShapeProperty().get();
    }

    public final ReadOnlyObjectProperty<PathElement[]> caretShapeProperty() {
        return this.getTextAttribute().caretShapeProperty();
    }

    public final void setCaretPosition(int n2) {
        if (n2 == -1 && (this.attributes == null || this.attributes.caretPosition == null)) {
            return;
        }
        this.caretPositionProperty().set(n2);
    }

    public final int getCaretPosition() {
        if (this.attributes == null || this.attributes.caretPosition == null) {
            return -1;
        }
        return this.attributes.getCaretPosition();
    }

    public final IntegerProperty caretPositionProperty() {
        return this.getTextAttribute().caretPositionProperty();
    }

    public final void setCaretBias(boolean bl2) {
        if (bl2 && (this.attributes == null || this.attributes.caretBias == null)) {
            return;
        }
        this.caretBiasProperty().set(bl2);
    }

    public final boolean isCaretBias() {
        if (this.attributes == null || this.attributes.caretBias == null) {
            return true;
        }
        return this.getTextAttribute().isCaretBias();
    }

    public final BooleanProperty caretBiasProperty() {
        return this.getTextAttribute().caretBiasProperty();
    }

    public final HitInfo hitTest(Point2D object) {
        if (object == null) {
            return null;
        }
        TextLayout textLayout = this.getTextLayout();
        double d2 = ((Point2D)object).getX() - this.getX();
        double d3 = ((Point2D)object).getY() - this.getY() + (double)this.getYRendering();
        object = textLayout.getHitInfo((float)d2, (float)d3);
        return new HitInfo(((TextLayout$Hit)object).getCharIndex(), ((TextLayout$Hit)object).getInsertionIndex(), ((TextLayout$Hit)object).isLeading());
    }

    private PathElement[] getRange(int n2, int n3, int n4) {
        int n5 = this.getTextInternal().length();
        if (n2 >= 0 && n2 < n3 && n3 <= n5) {
            TextLayout textLayout = this.getTextLayout();
            float f2 = (float)this.getX();
            float f3 = (float)this.getY() - this.getYRendering();
            return textLayout.getRange(n2, n3, n4, f2, f3);
        }
        return EMPTY_PATH_ELEMENT_ARRAY;
    }

    public final PathElement[] caretShape(int n2, boolean bl2) {
        if (n2 >= 0 && n2 <= this.getTextInternal().length()) {
            float f2 = (float)this.getX();
            float f3 = (float)this.getY() - this.getYRendering();
            return this.getTextLayout().getCaretShape(n2, bl2, f2, f3);
        }
        return null;
    }

    public final PathElement[] rangeShape(int n2, int n3) {
        return this.getRange(n2, n3, 1);
    }

    public final PathElement[] underlineShape(int n2, int n3) {
        return this.getRange(n2, n3, 2);
    }

    private float getYAdjustment(BaseBounds baseBounds) {
        VPos vPos = this.getTextOrigin();
        if (vPos == null) {
            vPos = DEFAULT_TEXT_ORIGIN;
        }
        switch (vPos) {
            case TOP: {
                return -baseBounds.getMinY();
            }
            case BASELINE: {
                return 0.0f;
            }
            case CENTER: {
                return -baseBounds.getMinY() - baseBounds.getHeight() / 2.0f;
            }
            case BOTTOM: {
                return -baseBounds.getMinY() - baseBounds.getHeight();
            }
        }
        return 0.0f;
    }

    private float getYRendering() {
        if (this.isSpan()) {
            return 0.0f;
        }
        BaseBounds baseBounds = this.getLogicalBounds();
        VPos vPos = this.getTextOrigin();
        if (vPos == null) {
            vPos = DEFAULT_TEXT_ORIGIN;
        }
        if (this.getBoundsType() == TextBoundsType.VISUAL) {
            BaseBounds baseBounds2 = this.getVisualBounds();
            float f2 = baseBounds2.getMinY() - baseBounds.getMinY();
            switch (vPos) {
                case TOP: {
                    return f2;
                }
                case BASELINE: {
                    return -baseBounds2.getMinY() + f2;
                }
                case CENTER: {
                    return baseBounds2.getHeight() / 2.0f + f2;
                }
                case BOTTOM: {
                    return baseBounds2.getHeight() + f2;
                }
            }
            return 0.0f;
        }
        switch (vPos) {
            case TOP: {
                return 0.0f;
            }
            case BASELINE: {
                return -baseBounds.getMinY();
            }
            case CENTER: {
                return baseBounds.getHeight() / 2.0f;
            }
            case BOTTOM: {
                return baseBounds.getHeight();
            }
        }
        return 0.0f;
    }

    private Bounds doComputeLayoutBounds() {
        if (this.isSpan()) {
            BaseBounds baseBounds = this.getSpanBounds();
            double d2 = baseBounds.getWidth();
            double d3 = baseBounds.getHeight();
            return new BoundingBox(0.0, 0.0, d2, d3);
        }
        if (this.getBoundsType() == TextBoundsType.VISUAL) {
            return TextHelper.superComputeLayoutBounds(this);
        }
        BaseBounds baseBounds = this.getLogicalBounds();
        double d4 = (double)baseBounds.getMinX() + this.getX();
        double d5 = (double)baseBounds.getMinY() + this.getY() + (double)this.getYAdjustment(baseBounds);
        double d6 = baseBounds.getWidth();
        double d7 = baseBounds.getHeight();
        double d8 = this.getWrappingWidth();
        if (d8 != 0.0) {
            d6 = d8;
        }
        return new BoundingBox(d4, d5, d6, d7);
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        NodeOrientation nodeOrientation;
        float f2;
        if (this.isSpan()) {
            if (ShapeHelper.getMode(this) != NGShape$Mode.FILL && this.getStrokeType() != StrokeType.INSIDE) {
                return TextHelper.superComputeGeomBounds(this, baseBounds, baseTransform);
            }
            TextLayout textLayout = this.getTextLayout();
            baseBounds = textLayout.getBounds(this.getTextSpan(), baseBounds);
            BaseBounds baseBounds2 = this.getSpanBounds();
            float f3 = baseBounds.getMinX() - baseBounds2.getMinX();
            float f4 = baseBounds.getMinY() - baseBounds2.getMinY();
            float f5 = f3 + baseBounds.getWidth();
            float f6 = f4 + baseBounds.getHeight();
            BaseBounds baseBounds3 = baseBounds = baseBounds.deriveWithNewBounds(f3, f4, 0.0f, f5, f6, 0.0f);
            return baseTransform.transform(baseBounds3, baseBounds3);
        }
        if (this.getBoundsType() == TextBoundsType.VISUAL) {
            if (this.getTextInternal().length() == 0 || ShapeHelper.getMode(this) == NGShape$Mode.EMPTY) {
                return baseBounds.makeEmpty();
            }
            if (ShapeHelper.getMode(this) == NGShape$Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
                BaseBounds baseBounds4 = this.getVisualBounds();
                float f7 = baseBounds4.getMinX() + (float)this.getX();
                float f8 = this.getYAdjustment(baseBounds4);
                float f9 = baseBounds4.getMinY() + f8 + (float)this.getY();
                baseBounds.deriveWithNewBounds(f7, f9, 0.0f, f7 + baseBounds4.getWidth(), f9 + baseBounds4.getHeight(), 0.0f);
                BaseBounds baseBounds5 = baseBounds;
                return baseTransform.transform(baseBounds5, baseBounds5);
            }
            return TextHelper.superComputeGeomBounds(this, baseBounds, baseTransform);
        }
        BaseBounds baseBounds6 = this.getLogicalBounds();
        float f10 = baseBounds6.getMinX() + (float)this.getX();
        float f11 = this.getYAdjustment(baseBounds6);
        float f12 = baseBounds6.getMinY() + f11 + (float)this.getY();
        float f13 = baseBounds6.getWidth();
        float f14 = baseBounds6.getHeight();
        float f15 = (float)this.getWrappingWidth();
        if (f2 > f13) {
            f13 = f15;
        } else if (f15 > 0.0f && (nodeOrientation = this.getEffectiveNodeOrientation()) == NodeOrientation.RIGHT_TO_LEFT) {
            f10 -= f13 - f15;
        }
        RectBounds rectBounds = new RectBounds(f10, f12, f10 + f13, f12 + f14);
        if (ShapeHelper.getMode(this) != NGShape$Mode.FILL && this.getStrokeType() != StrokeType.INSIDE) {
            baseBounds = TextHelper.superComputeGeomBounds(this, baseBounds, BaseTransform.IDENTITY_TRANSFORM);
        } else {
            TextLayout textLayout = this.getTextLayout();
            baseBounds = textLayout.getBounds(null, baseBounds);
            f10 = baseBounds.getMinX() + (float)this.getX();
            f13 = baseBounds.getWidth();
            baseBounds = baseBounds.deriveWithNewBounds(f10, f12, 0.0f, f10 + f13, f12 + f14, 0.0f);
        }
        BaseBounds baseBounds7 = baseBounds = baseBounds.deriveWithUnion(rectBounds);
        return baseTransform.transform(baseBounds7, baseBounds7);
    }

    private boolean doComputeContains(double d2, double d3) {
        double d4 = d2 + (double)this.getSpanBounds().getMinX();
        double d5 = d3 + (double)this.getSpanBounds().getMinY();
        GlyphList[] glyphListArray = this.getRuns();
        if (glyphListArray.length != 0) {
            for (int i2 = 0; i2 < glyphListArray.length; ++i2) {
                Object object = glyphListArray[i2];
                com.sun.javafx.geom.Point2D point2D = object.getLocation();
                float f2 = object.getWidth();
                object = object.getLineBounds();
                float f3 = ((BaseBounds)object).getHeight();
                if (!((double)point2D.x <= d4) || !(d4 < (double)(point2D.x + f2)) || !((double)point2D.y <= d5) || !(d5 < (double)(point2D.y + f3))) continue;
                return true;
            }
        }
        return false;
    }

    private Shape doConfigShape() {
        float f2;
        float f3;
        if (ShapeHelper.getMode(this) == NGShape$Mode.EMPTY || this.getTextInternal().length() == 0) {
            return new Path2D();
        }
        Shape shape = this.getShape();
        if (this.isSpan()) {
            BaseBounds baseBounds = this.getSpanBounds();
            f3 = -baseBounds.getMinX();
            f2 = -baseBounds.getMinY();
        } else {
            f3 = (float)this.getX();
            Text text = this;
            f2 = text.getYAdjustment(text.getVisualBounds()) + (float)this.getY();
        }
        return TransformedShape.translatedShape(shape, f3, f2);
    }

    public final IntegerProperty tabSizeProperty() {
        return this.getTextAttribute().tabSizeProperty();
    }

    public final int getTabSize() {
        if (this.attributes == null || this.attributes.tabSize == null) {
            return 8;
        }
        return this.getTextAttribute().getTabSize();
    }

    public final void setTabSize(int n2) {
        this.tabSizeProperty().set(n2);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Text$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Text.getClassCssMetaData();
    }

    private void updatePGText() {
        Object object;
        NGText nGText = (NGText)NodeHelper.getPeer(this);
        if (NodeHelper.isDirty(this, DirtyBits.TEXT_ATTRS)) {
            nGText.setUnderline(this.isUnderline());
            nGText.setStrikethrough(this.isStrikethrough());
            object = this.getFontSmoothingType();
            if (object == null) {
                object = FontSmoothingType.GRAY;
            }
            nGText.setFontSmoothingType(((Enum)object).ordinal());
        }
        if (NodeHelper.isDirty(this, DirtyBits.TEXT_FONT)) {
            nGText.setFont(this.getFontInternal());
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_CONTENTS)) {
            nGText.setGlyphs(this.getRuns());
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_GEOMETRY)) {
            if (this.isSpan()) {
                object = this.getSpanBounds();
                nGText.setLayoutLocation(((BaseBounds)object).getMinX(), ((BaseBounds)object).getMinY());
            } else {
                float f2 = (float)this.getX();
                float f3 = (float)this.getY();
                float f4 = this.getYRendering();
                nGText.setLayoutLocation(-f2, f4 - f3);
            }
        }
        if (NodeHelper.isDirty(this, DirtyBits.TEXT_SELECTION)) {
            Paint paint = null;
            int n2 = this.getSelectionStart();
            int n3 = this.getSelectionEnd();
            int n4 = this.getTextInternal().length();
            if (n2 >= 0 && n2 < n3 && n3 <= n4) {
                paint = (Paint)this.selectionFillProperty().get();
                paint = paint != null ? Toolkit.getPaintAccessor().getPlatformPaint(paint) : null;
            }
            nGText.setSelection(n2, n3, paint);
        }
    }

    private void doUpdatePeer() {
        this.updatePGText();
    }

    private Text$TextAttribute getTextAttribute() {
        if (this.attributes == null) {
            this.attributes = new Text$TextAttribute(this);
        }
        return this.attributes;
    }

    @Override
    public String toString() {
        int n2;
        double d2;
        StringBuilder stringBuilder = new StringBuilder("Text[");
        String string = this.getId();
        if (string != null) {
            stringBuilder.append("id=").append(string).append(", ");
        }
        stringBuilder.append("text=\"").append(this.getText()).append("\"");
        stringBuilder.append(", x=").append(this.getX());
        stringBuilder.append(", y=").append(this.getY());
        stringBuilder.append(", alignment=").append((Object)this.getTextAlignment());
        stringBuilder.append(", origin=").append((Object)this.getTextOrigin());
        stringBuilder.append(", boundsType=").append((Object)this.getBoundsType());
        double d3 = this.getLineSpacing();
        if (d3 != 0.0) {
            stringBuilder.append(", lineSpacing=").append(d3);
        }
        if ((d2 = this.getWrappingWidth()) != 0.0) {
            stringBuilder.append(", wrappingWidth=").append(d2);
        }
        if ((n2 = this.getTabSize()) != 8) {
            stringBuilder.append(", tabSize=").append(n2);
        }
        stringBuilder.append(", font=").append(this.getFont());
        stringBuilder.append(", fontSmoothingType=").append((Object)this.getFontSmoothingType());
        if (this.isStrikethrough()) {
            stringBuilder.append(", strikethrough");
        }
        if (this.isUnderline()) {
            stringBuilder.append(", underline");
        }
        stringBuilder.append(", fill=").append(this.getFill());
        Paint paint = this.getStroke();
        if (paint != null) {
            stringBuilder.append(", stroke=").append(paint);
            stringBuilder.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return stringBuilder.append("]").toString();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (Text$10.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                object = this.getAccessibleText();
                if (object != null && !((String)object).isEmpty()) {
                    return object;
                }
                return this.getText();
            }
            case 2: {
                return this.getFont();
            }
            case 3: {
                int n2 = this.getCaretPosition();
                if (n2 >= 0) {
                    return n2;
                }
                return this.getText().length();
            }
            case 4: {
                int n3 = this.getSelectionStart();
                if (n3 >= 0) {
                    return n3;
                }
                n3 = this.getCaretPosition();
                if (n3 >= 0) {
                    return n3;
                }
                return this.getText().length();
            }
            case 5: {
                int n4 = this.getSelectionEnd();
                if (n4 >= 0) {
                    return n4;
                }
                n4 = this.getCaretPosition();
                if (n4 >= 0) {
                    return n4;
                }
                return this.getText().length();
            }
            case 6: {
                Object object2;
                int n5 = (Integer)objectArray[0];
                if (n5 > this.getTextInternal().length()) {
                    return null;
                }
                objectArray = this.getTextLayout().getLines();
                int n6 = 0;
                for (int i2 = 1; i2 < objectArray.length && (object2 = objectArray[i2]).getStart() <= n5; ++i2) {
                    ++n6;
                }
                return n6;
            }
            case 7: {
                int n7 = (Integer)objectArray[0];
                objectArray = this.getTextLayout().getLines();
                if (n7 >= 0 && n7 < objectArray.length) {
                    Object object3 = objectArray[n7];
                    return object3.getStart();
                }
                return null;
            }
            case 8: {
                int n8 = (Integer)objectArray[0];
                objectArray = this.getTextLayout().getLines();
                if (n8 >= 0 && n8 < objectArray.length) {
                    Object object4 = objectArray[n8];
                    return object4.getStart() + object4.getLength();
                }
                return null;
            }
            case 9: {
                object = (Point2D)objectArray[0];
                object = this.screenToLocal((Point2D)object);
                return this.hitTest((Point2D)object).getCharIndex();
            }
            case 10: {
                int n9 = (Integer)objectArray[0];
                int n10 = (Integer)objectArray[1];
                PathElement[] pathElementArray = this.rangeShape(n9, n10 + 1);
                Bounds[] boundsArray = new Bounds[pathElementArray.length / 5];
                int n11 = 0;
                for (n9 = 0; n9 < boundsArray.length; ++n9) {
                    Object object5 = (MoveTo)pathElementArray[n11];
                    LineTo lineTo = (LineTo)pathElementArray[n11 + 1];
                    LineTo lineTo2 = (LineTo)pathElementArray[n11 + 2];
                    object5 = new BoundingBox(((MoveTo)object5).getX(), ((MoveTo)object5).getY(), lineTo.getX() - ((MoveTo)object5).getX(), lineTo2.getY() - lineTo.getY());
                    boundsArray[n9] = this.localToScreen((Bounds)object5);
                    n11 += 5;
                }
                return boundsArray;
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }

    static {
        TextHelper.setTextAccessor(new Text$1());
        EMPTY_PATH_ELEMENT_ARRAY = new PathElement[0];
        DEFAULT_TEXT_ORIGIN = VPos.BASELINE;
        DEFAULT_BOUNDS_TYPE = TextBoundsType.LOGICAL;
        DEFAULT_TEXT_ALIGNMENT = TextAlignment.LEFT;
        DEFAULT_SELECTION_FILL = Color.WHITE;
    }
}

