/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.text;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLayout$Hit;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.tk.Toolkit;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.PathElement;
import javafx.scene.text.HitInfo;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow$1;
import javafx.scene.text.TextFlow$2;
import javafx.scene.text.TextFlow$3;
import javafx.scene.text.TextFlow$4;
import javafx.scene.text.TextFlow$EmbeddedSpan;
import javafx.scene.text.TextFlow$StyleableProperties;

public class TextFlow
extends Pane {
    private TextLayout layout;
    private boolean needsContent;
    private boolean inLayout;
    private ObjectProperty<TextAlignment> textAlignment;
    private DoubleProperty lineSpacing;
    private IntegerProperty tabSize;

    public TextFlow() {
        this.effectiveNodeOrientationProperty().addListener(observable -> this.checkOrientation());
        this.setAccessibleRole(AccessibleRole.TEXT);
    }

    public TextFlow(Node ... nodeArray) {
        this();
        this.getChildren().addAll((Node[])nodeArray);
    }

    private void checkOrientation() {
        NodeOrientation nodeOrientation = this.getEffectiveNodeOrientation();
        int n2 = nodeOrientation == NodeOrientation.RIGHT_TO_LEFT ? 1 : 0;
        n2 = n2 != 0 ? 2048 : 1024;
        TextLayout textLayout = this.getTextLayout();
        if (textLayout.setDirection(n2)) {
            ((Parent)this).requestLayout();
        }
    }

    public final HitInfo hitTest(Point2D object) {
        if (object != null) {
            TextLayout textLayout = this.getTextLayout();
            double d2 = ((Point2D)object).getX();
            double d3 = ((Point2D)object).getY();
            object = textLayout.getHitInfo((float)d2, (float)d3);
            return new HitInfo(((TextLayout$Hit)object).getCharIndex(), ((TextLayout$Hit)object).getInsertionIndex(), ((TextLayout$Hit)object).isLeading());
        }
        return null;
    }

    public PathElement[] caretShape(int n2, boolean bl2) {
        return this.getTextLayout().getCaretShape(n2, bl2, 0.0f, 0.0f);
    }

    public final PathElement[] rangeShape(int n2, int n3) {
        return this.getRange(n2, n3, 1);
    }

    public final PathElement[] underlineShape(int n2, int n3) {
        return this.getRange(n2, n3, 2);
    }

    @Override
    public boolean usesMirroring() {
        return false;
    }

    @Override
    protected void setWidth(double d2) {
        if (d2 != this.getWidth()) {
            TextLayout textLayout = this.getTextLayout();
            Insets insets = this.getInsets();
            double d3 = this.snapSpaceX(insets.getLeft());
            double d4 = this.snapSpaceX(insets.getRight());
            double d5 = Math.max(1.0, d2 - d3 - d4);
            textLayout.setWrapWidth((float)d5);
            super.setWidth(d2);
        }
    }

    @Override
    protected double computePrefWidth(double d2) {
        TextLayout textLayout = this.getTextLayout();
        textLayout.setWrapWidth(0.0f);
        double d3 = textLayout.getBounds().getWidth();
        Insets insets = this.getInsets();
        double d4 = this.snapSpaceX(insets.getLeft());
        double d5 = this.snapSpaceX(insets.getRight());
        double d6 = Math.max(1.0, this.getWidth() - d4 - d5);
        textLayout.setWrapWidth((float)d6);
        return d4 + d3 + d5;
    }

    @Override
    protected double computePrefHeight(double d2) {
        double d3;
        TextLayout textLayout = this.getTextLayout();
        Insets insets = this.getInsets();
        double d4 = this.snapSpaceX(insets.getLeft());
        double d5 = this.snapSpaceX(insets.getRight());
        if (d2 == -1.0) {
            textLayout.setWrapWidth(0.0f);
        } else {
            d3 = Math.max(1.0, d2 - d4 - d5);
            textLayout.setWrapWidth((float)d3);
        }
        d3 = textLayout.getBounds().getHeight();
        double d6 = Math.max(1.0, this.getWidth() - d4 - d5);
        textLayout.setWrapWidth((float)d6);
        double d7 = this.snapSpaceY(insets.getTop());
        double d8 = this.snapSpaceY(insets.getBottom());
        return d7 + d3 + d8;
    }

    @Override
    protected double computeMinHeight(double d2) {
        return this.computePrefHeight(d2);
    }

    @Override
    public void requestLayout() {
        if (this.inLayout) {
            return;
        }
        this.needsContent = true;
        super.requestLayout();
    }

    @Override
    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    @Override
    protected void layoutChildren() {
        Object object;
        this.inLayout = true;
        GlyphList[] glyphListArray = this.getInsets();
        double d2 = this.snapSpaceY(glyphListArray.getTop());
        double d3 = this.snapSpaceX(glyphListArray.getLeft());
        glyphListArray = this.getTextLayout().getRuns();
        for (int i2 = 0; i2 < glyphListArray.length; ++i2) {
            GlyphList glyphList = glyphListArray[i2];
            Object object2 = glyphList.getTextSpan();
            if (!(object2 instanceof TextFlow$EmbeddedSpan)) continue;
            object2 = ((TextFlow$EmbeddedSpan)object2).getNode();
            object = glyphList.getLocation();
            double d4 = -((BaseBounds)glyphList.getLineBounds()).getMinY();
            this.layoutInArea((Node)object2, d3 + (double)((com.sun.javafx.geom.Point2D)object).x, d2 + (double)((com.sun.javafx.geom.Point2D)object).y, glyphList.getWidth(), glyphList.getHeight(), d4, null, true, true, HPos.CENTER, VPos.BASELINE);
        }
        List list = this.getManagedChildren();
        for (Object object2 : list) {
            if (!(object2 instanceof Text)) continue;
            object2 = (Text)object2;
            ((Text)object2).layoutSpan(glyphListArray);
            object = ((Text)object2).getSpanBounds();
            ((Node)object2).relocate(d3 + (double)((BaseBounds)object).getMinX(), d2 + (double)((BaseBounds)object).getMinY());
        }
        this.inLayout = false;
    }

    private PathElement[] getRange(int n2, int n3, int n4) {
        TextLayout textLayout = this.getTextLayout();
        return textLayout.getRange(n2, n3, n4, 0.0f, 0.0f);
    }

    TextLayout getTextLayout() {
        Object object;
        if (this.layout == null) {
            object = Toolkit.getToolkit().getTextLayoutFactory();
            this.layout = object.createLayout();
            this.layout.setTabSize(this.getTabSize());
            this.needsContent = true;
        }
        if (this.needsContent) {
            object = this.getManagedChildren();
            TextSpan[] textSpanArray = new TextSpan[object.size()];
            for (int i2 = 0; i2 < textSpanArray.length; ++i2) {
                Node node = (Node)object.get(i2);
                if (node instanceof Text) {
                    textSpanArray[i2] = ((Text)node).getTextSpan();
                    continue;
                }
                double d2 = node.getBaselineOffset();
                if (d2 == Double.NEGATIVE_INFINITY) {
                    d2 = node.getLayoutBounds().getHeight();
                }
                double d3 = this.computeChildPrefAreaWidth(node, null);
                double d4 = this.computeChildPrefAreaHeight(node, null);
                textSpanArray[i2] = new TextFlow$EmbeddedSpan(node, d2, d3, d4);
            }
            this.layout.setContent(textSpanArray);
            this.needsContent = false;
        }
        return this.layout;
    }

    public final void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignmentProperty().set(textAlignment);
    }

    public final TextAlignment getTextAlignment() {
        if (this.textAlignment == null) {
            return TextAlignment.LEFT;
        }
        return (TextAlignment)((Object)this.textAlignment.get());
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        if (this.textAlignment == null) {
            this.textAlignment = new TextFlow$1(this, TextAlignment.LEFT);
        }
        return this.textAlignment;
    }

    public final void setLineSpacing(double d2) {
        this.lineSpacingProperty().set(d2);
    }

    public final double getLineSpacing() {
        if (this.lineSpacing == null) {
            return 0.0;
        }
        return this.lineSpacing.get();
    }

    public final DoubleProperty lineSpacingProperty() {
        if (this.lineSpacing == null) {
            this.lineSpacing = new TextFlow$2(this, 0.0);
        }
        return this.lineSpacing;
    }

    public final IntegerProperty tabSizeProperty() {
        if (this.tabSize == null) {
            this.tabSize = new TextFlow$3(this, 8);
        }
        return this.tabSize;
    }

    public final int getTabSize() {
        if (this.tabSize == null) {
            return 8;
        }
        return this.tabSize.get();
    }

    public final void setTabSize(int n2) {
        this.tabSizeProperty().set(n2);
    }

    @Override
    public final double getBaselineOffset() {
        Insets insets = this.getInsets();
        double d2 = this.snapSpaceY(insets.getTop());
        return d2 - (double)this.getTextLayout().getBounds().getMinY();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TextFlow$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TextFlow.getClassCssMetaData();
    }

    static double boundedSize(double d2, double d3, double d4) {
        double d5;
        double d6 = d3 >= d2 ? d3 : d2;
        double d7 = d5 = d2 >= d4 ? d2 : d4;
        if (d6 <= d5) {
            return d6;
        }
        return d5;
    }

    double computeChildPrefAreaWidth(Node node, Insets insets) {
        return this.computeChildPrefAreaWidth(node, insets, -1.0);
    }

    double computeChildPrefAreaWidth(Node node, Insets insets, double d2) {
        double d3 = insets != null ? this.snapSpaceY(insets.getTop()) : 0.0;
        double d4 = insets != null ? this.snapSpaceY(insets.getBottom()) : 0.0;
        double d5 = insets != null ? this.snapSpaceX(insets.getLeft()) : 0.0;
        double d6 = insets != null ? this.snapSpaceX(insets.getRight()) : 0.0;
        double d7 = -1.0;
        if (node.getContentBias() == Orientation.VERTICAL) {
            d7 = this.snapSizeY(TextFlow.boundedSize(node.minHeight(-1.0), d2 != -1.0 ? d2 - d3 - d4 : node.prefHeight(-1.0), node.maxHeight(-1.0)));
        }
        return d5 + this.snapSizeX(TextFlow.boundedSize(node.minWidth(d7), node.prefWidth(d7), node.maxWidth(d7))) + d6;
    }

    double computeChildPrefAreaHeight(Node node, Insets insets) {
        return this.computeChildPrefAreaHeight(node, insets, -1.0);
    }

    double computeChildPrefAreaHeight(Node node, Insets insets, double d2) {
        double d3 = insets != null ? this.snapSpaceY(insets.getTop()) : 0.0;
        double d4 = insets != null ? this.snapSpaceY(insets.getBottom()) : 0.0;
        double d5 = insets != null ? this.snapSpaceX(insets.getLeft()) : 0.0;
        double d6 = insets != null ? this.snapSpaceX(insets.getRight()) : 0.0;
        double d7 = -1.0;
        if (node.getContentBias() == Orientation.HORIZONTAL) {
            d7 = this.snapSizeX(TextFlow.boundedSize(node.minWidth(-1.0), d2 != -1.0 ? d2 - d5 - d6 : node.prefWidth(-1.0), node.maxWidth(-1.0)));
        }
        return d3 + this.snapSizeY(TextFlow.boundedSize(node.minHeight(d7), node.prefHeight(d7), node.maxHeight(d7))) + d4;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (TextFlow$4.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                object = this.getAccessibleText();
                if (object != null && !((String)object).isEmpty()) {
                    return object;
                }
                object = new StringBuilder();
                for (Node node : this.getChildren()) {
                    Object object2 = node.queryAccessibleAttribute(AccessibleAttribute.TEXT, objectArray);
                    if (object2 == null) continue;
                    ((StringBuilder)object).append(object2.toString());
                }
                return ((StringBuilder)object).toString();
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }
}

