/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.transform;

import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate$1;
import javafx.scene.transform.Rotate$2;
import javafx.scene.transform.Rotate$3;
import javafx.scene.transform.Rotate$4;
import javafx.scene.transform.Rotate$5;
import javafx.scene.transform.Rotate$MatrixCache;
import javafx.scene.transform.Transform;

public class Rotate
extends Transform {
    public static final Point3D X_AXIS = new Point3D(1.0, 0.0, 0.0);
    public static final Point3D Y_AXIS = new Point3D(0.0, 1.0, 0.0);
    public static final Point3D Z_AXIS = new Point3D(0.0, 0.0, 1.0);
    private Rotate$MatrixCache cache;
    private Rotate$MatrixCache inverseCache;
    private DoubleProperty angle;
    private DoubleProperty pivotX;
    private DoubleProperty pivotY;
    private DoubleProperty pivotZ;
    private ObjectProperty<Point3D> axis;

    public Rotate() {
    }

    public Rotate(double d2) {
        this.setAngle(d2);
    }

    public Rotate(double d2, Point3D point3D) {
        this.setAngle(d2);
        this.setAxis(point3D);
    }

    public Rotate(double d2, double d3, double d4) {
        this.setAngle(d2);
        this.setPivotX(d3);
        this.setPivotY(d4);
    }

    public Rotate(double d2, double d3, double d4, double d5) {
        this(d2, d3, d4);
        this.setPivotZ(d5);
    }

    public Rotate(double d2, double d3, double d4, double d5, Point3D point3D) {
        this(d2, d3, d4);
        this.setPivotZ(d5);
        this.setAxis(point3D);
    }

    public final void setAngle(double d2) {
        this.angleProperty().set(d2);
    }

    public final double getAngle() {
        if (this.angle == null) {
            return 0.0;
        }
        return this.angle.get();
    }

    public final DoubleProperty angleProperty() {
        if (this.angle == null) {
            this.angle = new Rotate$1(this);
        }
        return this.angle;
    }

    public final void setPivotX(double d2) {
        this.pivotXProperty().set(d2);
    }

    public final double getPivotX() {
        if (this.pivotX == null) {
            return 0.0;
        }
        return this.pivotX.get();
    }

    public final DoubleProperty pivotXProperty() {
        if (this.pivotX == null) {
            this.pivotX = new Rotate$2(this);
        }
        return this.pivotX;
    }

    public final void setPivotY(double d2) {
        this.pivotYProperty().set(d2);
    }

    public final double getPivotY() {
        if (this.pivotY == null) {
            return 0.0;
        }
        return this.pivotY.get();
    }

    public final DoubleProperty pivotYProperty() {
        if (this.pivotY == null) {
            this.pivotY = new Rotate$3(this);
        }
        return this.pivotY;
    }

    public final void setPivotZ(double d2) {
        this.pivotZProperty().set(d2);
    }

    public final double getPivotZ() {
        if (this.pivotZ == null) {
            return 0.0;
        }
        return this.pivotZ.get();
    }

    public final DoubleProperty pivotZProperty() {
        if (this.pivotZ == null) {
            this.pivotZ = new Rotate$4(this);
        }
        return this.pivotZ;
    }

    public final void setAxis(Point3D point3D) {
        this.axisProperty().set(point3D);
    }

    public final Point3D getAxis() {
        if (this.axis == null) {
            return Z_AXIS;
        }
        return (Point3D)this.axis.get();
    }

    public final ObjectProperty<Point3D> axisProperty() {
        if (this.axis == null) {
            this.axis = new Rotate$5(this, Z_AXIS);
        }
        return this.axis;
    }

    @Override
    public double getMxx() {
        this.updateCache();
        return this.cache.mxx;
    }

    @Override
    public double getMxy() {
        this.updateCache();
        return this.cache.mxy;
    }

    @Override
    public double getMxz() {
        this.updateCache();
        return this.cache.mxz;
    }

    @Override
    public double getTx() {
        this.updateCache();
        return this.cache.tx;
    }

    @Override
    public double getMyx() {
        this.updateCache();
        return this.cache.myx;
    }

    @Override
    public double getMyy() {
        this.updateCache();
        return this.cache.myy;
    }

    @Override
    public double getMyz() {
        this.updateCache();
        return this.cache.myz;
    }

    @Override
    public double getTy() {
        this.updateCache();
        return this.cache.ty;
    }

    @Override
    public double getMzx() {
        this.updateCache();
        return this.cache.mzx;
    }

    @Override
    public double getMzy() {
        this.updateCache();
        return this.cache.mzy;
    }

    @Override
    public double getMzz() {
        this.updateCache();
        return this.cache.mzz;
    }

    @Override
    public double getTz() {
        this.updateCache();
        return this.cache.tz;
    }

    @Override
    boolean computeIs2D() {
        Point3D point3D = this.getAxis();
        return point3D.getX() == 0.0 && point3D.getY() == 0.0 || this.getAngle() == 0.0;
    }

    @Override
    boolean computeIsIdentity() {
        if (this.getAngle() == 0.0) {
            return true;
        }
        Point3D point3D = this.getAxis();
        return point3D.getX() == 0.0 && point3D.getY() == 0.0 && point3D.getZ() == 0.0;
    }

    @Override
    void fill2DArray(double[] dArray) {
        this.updateCache();
        dArray[0] = this.cache.mxx;
        dArray[1] = this.cache.mxy;
        dArray[2] = this.cache.tx;
        dArray[3] = this.cache.myx;
        dArray[4] = this.cache.myy;
        dArray[5] = this.cache.ty;
    }

    @Override
    void fill3DArray(double[] dArray) {
        this.updateCache();
        dArray[0] = this.cache.mxx;
        dArray[1] = this.cache.mxy;
        dArray[2] = this.cache.mxz;
        dArray[3] = this.cache.tx;
        dArray[4] = this.cache.myx;
        dArray[5] = this.cache.myy;
        dArray[6] = this.cache.myz;
        dArray[7] = this.cache.ty;
        dArray[8] = this.cache.mzx;
        dArray[9] = this.cache.mzy;
        dArray[10] = this.cache.mzz;
        dArray[11] = this.cache.tz;
    }

    @Override
    public Transform createConcatenation(Transform transform) {
        Transform transform2;
        if (transform instanceof Rotate) {
            transform2 = (Rotate)transform;
            double d2 = this.getPivotX();
            double d3 = this.getPivotY();
            double d4 = this.getPivotZ();
            if ((((Rotate)transform2).getAxis() == this.getAxis() || ((Rotate)transform2).getAxis().normalize().equals(this.getAxis().normalize())) && d2 == ((Rotate)transform2).getPivotX() && d3 == ((Rotate)transform2).getPivotY() && d4 == ((Rotate)transform2).getPivotZ()) {
                return new Rotate(this.getAngle() + ((Rotate)transform2).getAngle(), d2, d3, d4, this.getAxis());
            }
        }
        if (transform instanceof Affine) {
            transform2 = (Affine)transform.clone();
            ((Affine)transform2).prepend(this);
            return transform2;
        }
        return super.createConcatenation(transform);
    }

    @Override
    public Transform createInverse() throws NonInvertibleTransformException {
        return new Rotate(-this.getAngle(), this.getPivotX(), this.getPivotY(), this.getPivotZ(), this.getAxis());
    }

    @Override
    public Rotate clone() {
        return new Rotate(this.getAngle(), this.getPivotX(), this.getPivotY(), this.getPivotZ(), this.getAxis());
    }

    @Override
    public Point2D transform(double d2, double d3) {
        this.ensureCanTransform2DPoint();
        this.updateCache();
        return new Point2D(this.cache.mxx * d2 + this.cache.mxy * d3 + this.cache.tx, this.cache.myx * d2 + this.cache.myy * d3 + this.cache.ty);
    }

    @Override
    public Point3D transform(double d2, double d3, double d4) {
        this.updateCache();
        return new Point3D(this.cache.mxx * d2 + this.cache.mxy * d3 + this.cache.mxz * d4 + this.cache.tx, this.cache.myx * d2 + this.cache.myy * d3 + this.cache.myz * d4 + this.cache.ty, this.cache.mzx * d2 + this.cache.mzy * d3 + this.cache.mzz * d4 + this.cache.tz);
    }

    @Override
    void transform2DPointsImpl(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        this.updateCache();
        while (--n4 >= 0) {
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            dArray2[n3++] = this.cache.mxx * d2 + this.cache.mxy * d3 + this.cache.tx;
            dArray2[n3++] = this.cache.myx * d2 + this.cache.myy * d3 + this.cache.ty;
        }
    }

    @Override
    void transform3DPointsImpl(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        this.updateCache();
        while (--n4 >= 0) {
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            double d4 = dArray[n2++];
            dArray2[n3++] = this.cache.mxx * d2 + this.cache.mxy * d3 + this.cache.mxz * d4 + this.cache.tx;
            dArray2[n3++] = this.cache.myx * d2 + this.cache.myy * d3 + this.cache.myz * d4 + this.cache.ty;
            dArray2[n3++] = this.cache.mzx * d2 + this.cache.mzy * d3 + this.cache.mzz * d4 + this.cache.tz;
        }
    }

    @Override
    public Point2D deltaTransform(double d2, double d3) {
        this.ensureCanTransform2DPoint();
        this.updateCache();
        return new Point2D(this.cache.mxx * d2 + this.cache.mxy * d3, this.cache.myx * d2 + this.cache.myy * d3);
    }

    @Override
    public Point3D deltaTransform(double d2, double d3, double d4) {
        this.updateCache();
        return new Point3D(this.cache.mxx * d2 + this.cache.mxy * d3 + this.cache.mxz * d4, this.cache.myx * d2 + this.cache.myy * d3 + this.cache.myz * d4, this.cache.mzx * d2 + this.cache.mzy * d3 + this.cache.mzz * d4);
    }

    @Override
    public Point2D inverseTransform(double d2, double d3) {
        this.ensureCanTransform2DPoint();
        this.updateInverseCache();
        return new Point2D(this.inverseCache.mxx * d2 + this.inverseCache.mxy * d3 + this.inverseCache.tx, this.inverseCache.myx * d2 + this.inverseCache.myy * d3 + this.inverseCache.ty);
    }

    @Override
    public Point3D inverseTransform(double d2, double d3, double d4) {
        this.updateInverseCache();
        return new Point3D(this.inverseCache.mxx * d2 + this.inverseCache.mxy * d3 + this.inverseCache.mxz * d4 + this.inverseCache.tx, this.inverseCache.myx * d2 + this.inverseCache.myy * d3 + this.inverseCache.myz * d4 + this.inverseCache.ty, this.inverseCache.mzx * d2 + this.inverseCache.mzy * d3 + this.inverseCache.mzz * d4 + this.inverseCache.tz);
    }

    @Override
    void inverseTransform2DPointsImpl(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        this.updateInverseCache();
        while (--n4 >= 0) {
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            dArray2[n3++] = this.inverseCache.mxx * d2 + this.inverseCache.mxy * d3 + this.inverseCache.tx;
            dArray2[n3++] = this.inverseCache.myx * d2 + this.inverseCache.myy * d3 + this.inverseCache.ty;
        }
    }

    @Override
    void inverseTransform3DPointsImpl(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        this.updateInverseCache();
        while (--n4 >= 0) {
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            double d4 = dArray[n2++];
            dArray2[n3++] = this.inverseCache.mxx * d2 + this.inverseCache.mxy * d3 + this.inverseCache.mxz * d4 + this.inverseCache.tx;
            dArray2[n3++] = this.inverseCache.myx * d2 + this.inverseCache.myy * d3 + this.inverseCache.myz * d4 + this.inverseCache.ty;
            dArray2[n3++] = this.inverseCache.mzx * d2 + this.inverseCache.mzy * d3 + this.inverseCache.mzz * d4 + this.inverseCache.tz;
        }
    }

    @Override
    public Point2D inverseDeltaTransform(double d2, double d3) {
        this.ensureCanTransform2DPoint();
        this.updateInverseCache();
        return new Point2D(this.inverseCache.mxx * d2 + this.inverseCache.mxy * d3, this.inverseCache.myx * d2 + this.inverseCache.myy * d3);
    }

    @Override
    public Point3D inverseDeltaTransform(double d2, double d3, double d4) {
        this.updateInverseCache();
        return new Point3D(this.inverseCache.mxx * d2 + this.inverseCache.mxy * d3 + this.inverseCache.mxz * d4, this.inverseCache.myx * d2 + this.inverseCache.myy * d3 + this.inverseCache.myz * d4, this.inverseCache.mzx * d2 + this.inverseCache.mzy * d3 + this.inverseCache.mzz * d4);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Rotate [");
        stringBuilder.append("angle=").append(this.getAngle());
        stringBuilder.append(", pivotX=").append(this.getPivotX());
        stringBuilder.append(", pivotY=").append(this.getPivotY());
        stringBuilder.append(", pivotZ=").append(this.getPivotZ());
        stringBuilder.append(", axis=").append(this.getAxis());
        return stringBuilder.append("]").toString();
    }

    @Override
    void apply(Affine3D affine3D) {
        double d2 = this.getPivotX();
        double d3 = this.getPivotY();
        double d4 = this.getPivotZ();
        double d5 = this.getAngle();
        if (d2 != 0.0 || d3 != 0.0 || d4 != 0.0) {
            affine3D.translate(d2, d3, d4);
            affine3D.rotate(Math.toRadians(d5), this.getAxis().getX(), this.getAxis().getY(), this.getAxis().getZ());
            affine3D.translate(-d2, -d3, -d4);
            return;
        }
        affine3D.rotate(Math.toRadians(d5), this.getAxis().getX(), this.getAxis().getY(), this.getAxis().getZ());
    }

    @Override
    BaseTransform derive(BaseTransform baseTransform) {
        if (this.isIdentity()) {
            return baseTransform;
        }
        double d2 = this.getPivotX();
        double d3 = this.getPivotY();
        double d4 = this.getPivotZ();
        double d5 = this.getAngle();
        if (d2 != 0.0 || d3 != 0.0 || d4 != 0.0) {
            baseTransform = baseTransform.deriveWithTranslation(d2, d3, d4);
            baseTransform = baseTransform.deriveWithRotation(Math.toRadians(d5), this.getAxis().getX(), this.getAxis().getY(), this.getAxis().getZ());
            return baseTransform.deriveWithTranslation(-d2, -d3, -d4);
        }
        return baseTransform.deriveWithRotation(Math.toRadians(d5), this.getAxis().getX(), this.getAxis().getY(), this.getAxis().getZ());
    }

    @Override
    void validate() {
        this.getAxis();
        this.getAngle();
        this.getPivotX();
        this.getPivotY();
        this.getPivotZ();
    }

    @Override
    protected void transformChanged() {
        if (this.cache != null) {
            this.cache.invalidate();
        }
        super.transformChanged();
    }

    @Override
    void appendTo(Affine affine) {
        affine.appendRotation(this.getAngle(), this.getPivotX(), this.getPivotY(), this.getPivotZ(), this.getAxis());
    }

    @Override
    void prependTo(Affine affine) {
        affine.prependRotation(this.getAngle(), this.getPivotX(), this.getPivotY(), this.getPivotZ(), this.getAxis());
    }

    private void updateCache() {
        if (this.cache == null) {
            this.cache = new Rotate$MatrixCache();
        }
        if (!this.cache.valid) {
            this.cache.update(this.getAngle(), this.getAxis(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
        }
    }

    private void updateInverseCache() {
        if (this.inverseCache == null) {
            this.inverseCache = new Rotate$MatrixCache();
        }
        if (!this.inverseCache.valid) {
            this.inverseCache.update(-this.getAngle(), this.getAxis(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
        }
    }
}

