/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.transform;

import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import javafx.beans.property.DoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Scale$1;
import javafx.scene.transform.Scale$2;
import javafx.scene.transform.Scale$3;
import javafx.scene.transform.Scale$4;
import javafx.scene.transform.Scale$5;
import javafx.scene.transform.Scale$6;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

public class Scale
extends Transform {
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty z;
    private DoubleProperty pivotX;
    private DoubleProperty pivotY;
    private DoubleProperty pivotZ;

    public Scale() {
    }

    public Scale(double d2, double d3) {
        this.setX(d2);
        this.setY(d3);
    }

    public Scale(double d2, double d3, double d4, double d5) {
        this(d2, d3);
        this.setPivotX(d4);
        this.setPivotY(d5);
    }

    public Scale(double d2, double d3, double d4) {
        this(d2, d3);
        this.setZ(d4);
    }

    public Scale(double d2, double d3, double d4, double d5, double d6, double d7) {
        this(d2, d3, d5, d6);
        this.setZ(d4);
        this.setPivotZ(d7);
    }

    public final void setX(double d2) {
        this.xProperty().set(d2);
    }

    public final double getX() {
        if (this.x == null) {
            return 1.0;
        }
        return this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new Scale$1(this, 1.0);
        }
        return this.x;
    }

    public final void setY(double d2) {
        this.yProperty().set(d2);
    }

    public final double getY() {
        if (this.y == null) {
            return 1.0;
        }
        return this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new Scale$2(this, 1.0);
        }
        return this.y;
    }

    public final void setZ(double d2) {
        this.zProperty().set(d2);
    }

    public final double getZ() {
        if (this.z == null) {
            return 1.0;
        }
        return this.z.get();
    }

    public final DoubleProperty zProperty() {
        if (this.z == null) {
            this.z = new Scale$3(this, 1.0);
        }
        return this.z;
    }

    public final void setPivotX(double d2) {
        this.pivotXProperty().set(d2);
    }

    public final double getPivotX() {
        if (this.pivotX == null) {
            return 0.0;
        }
        return this.pivotX.get();
    }

    public final DoubleProperty pivotXProperty() {
        if (this.pivotX == null) {
            this.pivotX = new Scale$4(this);
        }
        return this.pivotX;
    }

    public final void setPivotY(double d2) {
        this.pivotYProperty().set(d2);
    }

    public final double getPivotY() {
        if (this.pivotY == null) {
            return 0.0;
        }
        return this.pivotY.get();
    }

    public final DoubleProperty pivotYProperty() {
        if (this.pivotY == null) {
            this.pivotY = new Scale$5(this);
        }
        return this.pivotY;
    }

    public final void setPivotZ(double d2) {
        this.pivotZProperty().set(d2);
    }

    public final double getPivotZ() {
        if (this.pivotZ == null) {
            return 0.0;
        }
        return this.pivotZ.get();
    }

    public final DoubleProperty pivotZProperty() {
        if (this.pivotZ == null) {
            this.pivotZ = new Scale$6(this);
        }
        return this.pivotZ;
    }

    @Override
    public double getMxx() {
        return this.getX();
    }

    @Override
    public double getMyy() {
        return this.getY();
    }

    @Override
    public double getMzz() {
        return this.getZ();
    }

    @Override
    public double getTx() {
        return (1.0 - this.getX()) * this.getPivotX();
    }

    @Override
    public double getTy() {
        return (1.0 - this.getY()) * this.getPivotY();
    }

    @Override
    public double getTz() {
        return (1.0 - this.getZ()) * this.getPivotZ();
    }

    @Override
    boolean computeIs2D() {
        return this.getZ() == 1.0;
    }

    @Override
    boolean computeIsIdentity() {
        return this.getX() == 1.0 && this.getY() == 1.0 && this.getZ() == 1.0;
    }

    @Override
    void fill2DArray(double[] dArray) {
        double d2 = this.getX();
        double d3 = this.getY();
        dArray[0] = d2;
        dArray[1] = 0.0;
        dArray[2] = (1.0 - d2) * this.getPivotX();
        dArray[3] = 0.0;
        dArray[4] = d3;
        dArray[5] = (1.0 - d3) * this.getPivotY();
    }

    @Override
    void fill3DArray(double[] dArray) {
        double d2 = this.getX();
        double d3 = this.getY();
        double d4 = this.getZ();
        dArray[0] = d2;
        dArray[1] = 0.0;
        dArray[2] = 0.0;
        dArray[3] = (1.0 - d2) * this.getPivotX();
        dArray[4] = 0.0;
        dArray[5] = d3;
        dArray[6] = 0.0;
        dArray[7] = (1.0 - d3) * this.getPivotY();
        dArray[8] = 0.0;
        dArray[9] = 0.0;
        dArray[10] = d4;
        dArray[11] = (1.0 - d4) * this.getPivotZ();
    }

    @Override
    public Transform createConcatenation(Transform transform) {
        Transform transform2;
        double d2 = this.getX();
        double d3 = this.getY();
        double d4 = this.getZ();
        if (transform instanceof Scale && ((Scale)(transform2 = (Scale)transform)).getPivotX() == this.getPivotX() && ((Scale)transform2).getPivotY() == this.getPivotY() && ((Scale)transform2).getPivotZ() == this.getPivotZ()) {
            return new Scale(d2 * ((Scale)transform2).getX(), d3 * ((Scale)transform2).getY(), d4 * ((Scale)transform2).getZ(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
        }
        if (transform instanceof Translate) {
            transform2 = (Translate)transform;
            double d5 = ((Translate)transform2).getX();
            double d6 = ((Translate)transform2).getY();
            double d7 = ((Translate)transform2).getZ();
            if ((d5 == 0.0 || d2 != 1.0 && d2 != 0.0) && (d6 == 0.0 || d3 != 1.0 && d3 != 0.0) && (d7 == 0.0 || d4 != 1.0 && d4 != 0.0)) {
                return new Scale(d2, d3, d4, (d2 != 1.0 ? d2 * d5 / (1.0 - d2) : 0.0) + this.getPivotX(), (d3 != 1.0 ? d3 * d6 / (1.0 - d3) : 0.0) + this.getPivotY(), (d4 != 1.0 ? d4 * d7 / (1.0 - d4) : 0.0) + this.getPivotZ());
            }
        }
        if (transform instanceof Affine) {
            transform2 = (Affine)transform.clone();
            ((Affine)transform2).prepend(this);
            return transform2;
        }
        double d8 = transform.getMxx();
        double d9 = transform.getMxy();
        double d10 = transform.getMxz();
        double d11 = transform.getTx();
        double d12 = transform.getMyx();
        double d13 = transform.getMyy();
        double d14 = transform.getMyz();
        double d15 = transform.getTy();
        double d16 = transform.getMzx();
        double d17 = transform.getMzy();
        double d18 = transform.getMzz();
        double d19 = transform.getTz();
        return new Affine(d2 * d8, d2 * d9, d2 * d10, d2 * d11 + (1.0 - d2) * this.getPivotX(), d3 * d12, d3 * d13, d3 * d14, d3 * d15 + (1.0 - d3) * this.getPivotY(), d4 * d16, d4 * d17, d4 * d18, d4 * d19 + (1.0 - d4) * this.getPivotZ());
    }

    @Override
    public Scale createInverse() throws NonInvertibleTransformException {
        double d2 = this.getX();
        double d3 = this.getY();
        double d4 = this.getZ();
        if (d2 == 0.0 || d3 == 0.0 || d4 == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        return new Scale(1.0 / d2, 1.0 / d3, 1.0 / d4, this.getPivotX(), this.getPivotY(), this.getPivotZ());
    }

    @Override
    public Scale clone() {
        return new Scale(this.getX(), this.getY(), this.getZ(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
    }

    @Override
    public Point2D transform(double d2, double d3) {
        this.ensureCanTransform2DPoint();
        double d4 = this.getX();
        double d5 = this.getY();
        return new Point2D(d4 * d2 + (1.0 - d4) * this.getPivotX(), d5 * d3 + (1.0 - d5) * this.getPivotY());
    }

    @Override
    public Point3D transform(double d2, double d3, double d4) {
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = this.getZ();
        return new Point3D(d5 * d2 + (1.0 - d5) * this.getPivotX(), d6 * d3 + (1.0 - d6) * this.getPivotY(), d7 * d4 + (1.0 - d7) * this.getPivotZ());
    }

    @Override
    void transform2DPointsImpl(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        double d2 = this.getX();
        double d3 = this.getY();
        double d4 = this.getPivotX();
        double d5 = this.getPivotY();
        while (--n4 >= 0) {
            double d6 = dArray[n2++];
            double d7 = dArray[n2++];
            dArray2[n3++] = d2 * d6 + (1.0 - d2) * d4;
            dArray2[n3++] = d3 * d7 + (1.0 - d3) * d5;
        }
    }

    @Override
    void transform3DPointsImpl(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        double d2 = this.getX();
        double d3 = this.getY();
        double d4 = this.getZ();
        double d5 = this.getPivotX();
        double d6 = this.getPivotY();
        double d7 = this.getPivotZ();
        while (--n4 >= 0) {
            dArray2[n3++] = d2 * dArray[n2++] + (1.0 - d2) * d5;
            dArray2[n3++] = d3 * dArray[n2++] + (1.0 - d3) * d6;
            dArray2[n3++] = d4 * dArray[n2++] + (1.0 - d4) * d7;
        }
    }

    @Override
    public Point2D deltaTransform(double d2, double d3) {
        this.ensureCanTransform2DPoint();
        return new Point2D(this.getX() * d2, this.getY() * d3);
    }

    @Override
    public Point3D deltaTransform(double d2, double d3, double d4) {
        return new Point3D(this.getX() * d2, this.getY() * d3, this.getZ() * d4);
    }

    @Override
    public Point2D inverseTransform(double d2, double d3) throws NonInvertibleTransformException {
        this.ensureCanTransform2DPoint();
        double d4 = this.getX();
        double d5 = this.getY();
        if (d4 == 0.0 || d5 == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        double d6 = 1.0 / d4;
        double d7 = 1.0 / d5;
        return new Point2D(d6 * d2 + (1.0 - d6) * this.getPivotX(), d7 * d3 + (1.0 - d7) * this.getPivotY());
    }

    @Override
    public Point3D inverseTransform(double d2, double d3, double d4) throws NonInvertibleTransformException {
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = this.getZ();
        if (d5 == 0.0 || d6 == 0.0 || d7 == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        double d8 = 1.0 / d5;
        double d9 = 1.0 / d6;
        double d10 = 1.0 / d7;
        return new Point3D(d8 * d2 + (1.0 - d8) * this.getPivotX(), d9 * d3 + (1.0 - d9) * this.getPivotY(), d10 * d4 + (1.0 - d10) * this.getPivotZ());
    }

    @Override
    void inverseTransform2DPointsImpl(double[] dArray, int n2, double[] dArray2, int n3, int n4) throws NonInvertibleTransformException {
        double d2 = this.getX();
        double d3 = this.getY();
        if (d2 == 0.0 || d3 == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        double d4 = 1.0 / d2;
        double d5 = 1.0 / d3;
        double d6 = this.getPivotX();
        double d7 = this.getPivotY();
        while (--n4 >= 0) {
            dArray2[n3++] = d4 * dArray[n2++] + (1.0 - d4) * d6;
            dArray2[n3++] = d5 * dArray[n2++] + (1.0 - d5) * d7;
        }
    }

    @Override
    void inverseTransform3DPointsImpl(double[] dArray, int n2, double[] dArray2, int n3, int n4) throws NonInvertibleTransformException {
        double d2 = this.getX();
        double d3 = this.getY();
        double d4 = this.getZ();
        if (d2 == 0.0 || d3 == 0.0 || d4 == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        double d5 = 1.0 / d2;
        double d6 = 1.0 / d3;
        double d7 = 1.0 / d4;
        double d8 = this.getPivotX();
        double d9 = this.getPivotY();
        double d10 = this.getPivotZ();
        while (--n4 >= 0) {
            dArray2[n3++] = d5 * dArray[n2++] + (1.0 - d5) * d8;
            dArray2[n3++] = d6 * dArray[n2++] + (1.0 - d6) * d9;
            dArray2[n3++] = d7 * dArray[n2++] + (1.0 - d7) * d10;
        }
    }

    @Override
    public Point2D inverseDeltaTransform(double d2, double d3) throws NonInvertibleTransformException {
        this.ensureCanTransform2DPoint();
        double d4 = this.getX();
        double d5 = this.getY();
        if (d4 == 0.0 || d5 == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        return new Point2D(1.0 / d4 * d2, 1.0 / d5 * d3);
    }

    @Override
    public Point3D inverseDeltaTransform(double d2, double d3, double d4) throws NonInvertibleTransformException {
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = this.getZ();
        if (d5 == 0.0 || d6 == 0.0 || d7 == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        return new Point3D(1.0 / d5 * d2, 1.0 / d6 * d3, 1.0 / d7 * d4);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Scale [");
        stringBuilder.append("x=").append(this.getX());
        stringBuilder.append(", y=").append(this.getY());
        stringBuilder.append(", z=").append(this.getZ());
        stringBuilder.append(", pivotX=").append(this.getPivotX());
        stringBuilder.append(", pivotY=").append(this.getPivotY());
        stringBuilder.append(", pivotZ=").append(this.getPivotZ());
        return stringBuilder.append("]").toString();
    }

    @Override
    void apply(Affine3D affine3D) {
        if (this.getPivotX() != 0.0 || this.getPivotY() != 0.0 || this.getPivotZ() != 0.0) {
            affine3D.translate(this.getPivotX(), this.getPivotY(), this.getPivotZ());
            affine3D.scale(this.getX(), this.getY(), this.getZ());
            affine3D.translate(-this.getPivotX(), -this.getPivotY(), -this.getPivotZ());
            return;
        }
        affine3D.scale(this.getX(), this.getY(), this.getZ());
    }

    @Override
    BaseTransform derive(BaseTransform baseTransform) {
        if (this.isIdentity()) {
            return baseTransform;
        }
        if (this.getPivotX() != 0.0 || this.getPivotY() != 0.0 || this.getPivotZ() != 0.0) {
            baseTransform = baseTransform.deriveWithTranslation(this.getPivotX(), this.getPivotY(), this.getPivotZ());
            baseTransform = baseTransform.deriveWithScale(this.getX(), this.getY(), this.getZ());
            return baseTransform.deriveWithTranslation(-this.getPivotX(), -this.getPivotY(), -this.getPivotZ());
        }
        return baseTransform.deriveWithScale(this.getX(), this.getY(), this.getZ());
    }

    @Override
    void validate() {
        this.getX();
        this.getPivotX();
        this.getY();
        this.getPivotY();
        this.getZ();
        this.getPivotZ();
    }

    @Override
    void appendTo(Affine affine) {
        affine.appendScale(this.getX(), this.getY(), this.getZ(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
    }

    @Override
    void prependTo(Affine affine) {
        affine.prependScale(this.getX(), this.getY(), this.getZ(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
    }
}

