/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.transform;

import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;

class Transform$ImmutableTransform
extends Transform {
    private static final int APPLY_IDENTITY = 0;
    private static final int APPLY_TRANSLATE = 1;
    private static final int APPLY_SCALE = 2;
    private static final int APPLY_SHEAR = 4;
    private static final int APPLY_NON_3D = 0;
    private static final int APPLY_3D_COMPLEX = 4;
    private transient int state2d;
    private transient int state3d;
    private double xx;
    private double xy;
    private double xz;
    private double yx;
    private double yy;
    private double yz;
    private double zx;
    private double zy;
    private double zz;
    private double xt;
    private double yt;
    private double zt;

    Transform$ImmutableTransform() {
        Transform$ImmutableTransform transform$ImmutableTransform = this;
        this.zz = 1.0;
        transform$ImmutableTransform.yy = 1.0;
        transform$ImmutableTransform.xx = 1.0;
    }

    Transform$ImmutableTransform(Transform transform) {
        this(transform.getMxx(), transform.getMxy(), transform.getMxz(), transform.getTx(), transform.getMyx(), transform.getMyy(), transform.getMyz(), transform.getTy(), transform.getMzx(), transform.getMzy(), transform.getMzz(), transform.getTz());
    }

    Transform$ImmutableTransform(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        this.xx = d2;
        this.xy = d3;
        this.xz = d4;
        this.xt = d5;
        this.yx = d6;
        this.yy = d7;
        this.yz = d8;
        this.yt = d9;
        this.zx = d10;
        this.zy = d11;
        this.zz = d12;
        this.zt = d13;
        this.updateState();
    }

    private void setToTransform(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        this.xx = d2;
        this.xy = d3;
        this.xz = d4;
        this.xt = d5;
        this.yx = d6;
        this.yy = d7;
        this.yz = d8;
        this.yt = d9;
        this.zx = d10;
        this.zy = d11;
        this.zz = d12;
        this.zt = d13;
        this.updateState();
    }

    private void setToConcatenation(Transform$ImmutableTransform transform$ImmutableTransform, Transform$ImmutableTransform transform$ImmutableTransform2) {
        if (transform$ImmutableTransform.state3d == 0 && transform$ImmutableTransform2.state3d == 0) {
            this.xx = transform$ImmutableTransform.xx * transform$ImmutableTransform2.xx + transform$ImmutableTransform.xy * transform$ImmutableTransform2.yx;
            this.xy = transform$ImmutableTransform.xx * transform$ImmutableTransform2.xy + transform$ImmutableTransform.xy * transform$ImmutableTransform2.yy;
            this.xt = transform$ImmutableTransform.xx * transform$ImmutableTransform2.xt + transform$ImmutableTransform.xy * transform$ImmutableTransform2.yt + transform$ImmutableTransform.xt;
            this.yx = transform$ImmutableTransform.yx * transform$ImmutableTransform2.xx + transform$ImmutableTransform.yy * transform$ImmutableTransform2.yx;
            this.yy = transform$ImmutableTransform.yx * transform$ImmutableTransform2.xy + transform$ImmutableTransform.yy * transform$ImmutableTransform2.yy;
            this.yt = transform$ImmutableTransform.yx * transform$ImmutableTransform2.xt + transform$ImmutableTransform.yy * transform$ImmutableTransform2.yt + transform$ImmutableTransform.yt;
            if (this.state3d != 0) {
                Transform$ImmutableTransform transform$ImmutableTransform3 = this;
                Transform$ImmutableTransform transform$ImmutableTransform4 = this;
                this.zt = 0.0;
                transform$ImmutableTransform4.zy = 0.0;
                transform$ImmutableTransform4.zx = 0.0;
                transform$ImmutableTransform3.yz = 0.0;
                transform$ImmutableTransform3.xz = 0.0;
                this.zz = 1.0;
                this.state3d = 0;
            }
            this.updateState2D();
            return;
        }
        this.xx = transform$ImmutableTransform.xx * transform$ImmutableTransform2.xx + transform$ImmutableTransform.xy * transform$ImmutableTransform2.yx + transform$ImmutableTransform.xz * transform$ImmutableTransform2.zx;
        this.xy = transform$ImmutableTransform.xx * transform$ImmutableTransform2.xy + transform$ImmutableTransform.xy * transform$ImmutableTransform2.yy + transform$ImmutableTransform.xz * transform$ImmutableTransform2.zy;
        this.xz = transform$ImmutableTransform.xx * transform$ImmutableTransform2.xz + transform$ImmutableTransform.xy * transform$ImmutableTransform2.yz + transform$ImmutableTransform.xz * transform$ImmutableTransform2.zz;
        this.xt = transform$ImmutableTransform.xx * transform$ImmutableTransform2.xt + transform$ImmutableTransform.xy * transform$ImmutableTransform2.yt + transform$ImmutableTransform.xz * transform$ImmutableTransform2.zt + transform$ImmutableTransform.xt;
        this.yx = transform$ImmutableTransform.yx * transform$ImmutableTransform2.xx + transform$ImmutableTransform.yy * transform$ImmutableTransform2.yx + transform$ImmutableTransform.yz * transform$ImmutableTransform2.zx;
        this.yy = transform$ImmutableTransform.yx * transform$ImmutableTransform2.xy + transform$ImmutableTransform.yy * transform$ImmutableTransform2.yy + transform$ImmutableTransform.yz * transform$ImmutableTransform2.zy;
        this.yz = transform$ImmutableTransform.yx * transform$ImmutableTransform2.xz + transform$ImmutableTransform.yy * transform$ImmutableTransform2.yz + transform$ImmutableTransform.yz * transform$ImmutableTransform2.zz;
        this.yt = transform$ImmutableTransform.yx * transform$ImmutableTransform2.xt + transform$ImmutableTransform.yy * transform$ImmutableTransform2.yt + transform$ImmutableTransform.yz * transform$ImmutableTransform2.zt + transform$ImmutableTransform.yt;
        this.zx = transform$ImmutableTransform.zx * transform$ImmutableTransform2.xx + transform$ImmutableTransform.zy * transform$ImmutableTransform2.yx + transform$ImmutableTransform.zz * transform$ImmutableTransform2.zx;
        this.zy = transform$ImmutableTransform.zx * transform$ImmutableTransform2.xy + transform$ImmutableTransform.zy * transform$ImmutableTransform2.yy + transform$ImmutableTransform.zz * transform$ImmutableTransform2.zy;
        this.zz = transform$ImmutableTransform.zx * transform$ImmutableTransform2.xz + transform$ImmutableTransform.zy * transform$ImmutableTransform2.yz + transform$ImmutableTransform.zz * transform$ImmutableTransform2.zz;
        this.zt = transform$ImmutableTransform.zx * transform$ImmutableTransform2.xt + transform$ImmutableTransform.zy * transform$ImmutableTransform2.yt + transform$ImmutableTransform.zz * transform$ImmutableTransform2.zt + transform$ImmutableTransform.zt;
        this.updateState();
    }

    @Override
    public double getMxx() {
        return this.xx;
    }

    @Override
    public double getMxy() {
        return this.xy;
    }

    @Override
    public double getMxz() {
        return this.xz;
    }

    @Override
    public double getTx() {
        return this.xt;
    }

    @Override
    public double getMyx() {
        return this.yx;
    }

    @Override
    public double getMyy() {
        return this.yy;
    }

    @Override
    public double getMyz() {
        return this.yz;
    }

    @Override
    public double getTy() {
        return this.yt;
    }

    @Override
    public double getMzx() {
        return this.zx;
    }

    @Override
    public double getMzy() {
        return this.zy;
    }

    @Override
    public double getMzz() {
        return this.zz;
    }

    @Override
    public double getTz() {
        return this.zt;
    }

    @Override
    public double determinant() {
        switch (this.state3d) {
            default: {
                Transform$ImmutableTransform.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Transform$ImmutableTransform.stateError();
                    }
                    case 6: 
                    case 7: {
                        return this.xx * this.yy - this.xy * this.yx;
                    }
                    case 4: 
                    case 5: {
                        return -(this.xy * this.yx);
                    }
                    case 2: 
                    case 3: {
                        return this.xx * this.yy;
                    }
                    case 0: 
                    case 1: 
                }
                return 1.0;
            }
            case 1: {
                return 1.0;
            }
            case 2: 
            case 3: {
                return this.xx * this.yy * this.zz;
            }
            case 4: 
        }
        return this.xx * (this.yy * this.zz - this.zy * this.yz) + this.xy * (this.yz * this.zx - this.zz * this.yx) + this.xz * (this.yx * this.zy - this.zx * this.yy);
    }

    @Override
    public Transform createConcatenation(Transform transform) {
        Affine affine = new Affine(this);
        affine.append(transform);
        return affine;
    }

    @Override
    public Affine createInverse() throws NonInvertibleTransformException {
        Affine affine = new Affine(this);
        affine.invert();
        return affine;
    }

    @Override
    public Transform clone() {
        return new Transform$ImmutableTransform(this);
    }

    @Override
    public Point2D transform(double d2, double d3) {
        this.ensureCanTransform2DPoint();
        switch (this.state2d) {
            default: {
                Transform$ImmutableTransform.stateError();
            }
            case 7: {
                return new Point2D(this.xx * d2 + this.xy * d3 + this.xt, this.yx * d2 + this.yy * d3 + this.yt);
            }
            case 6: {
                return new Point2D(this.xx * d2 + this.xy * d3, this.yx * d2 + this.yy * d3);
            }
            case 5: {
                return new Point2D(this.xy * d3 + this.xt, this.yx * d2 + this.yt);
            }
            case 4: {
                return new Point2D(this.xy * d3, this.yx * d2);
            }
            case 3: {
                return new Point2D(this.xx * d2 + this.xt, this.yy * d3 + this.yt);
            }
            case 2: {
                return new Point2D(this.xx * d2, this.yy * d3);
            }
            case 1: {
                return new Point2D(d2 + this.xt, d3 + this.yt);
            }
            case 0: 
        }
        return new Point2D(d2, d3);
    }

    @Override
    public Point3D transform(double d2, double d3, double d4) {
        switch (this.state3d) {
            default: {
                Transform$ImmutableTransform.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Transform$ImmutableTransform.stateError();
                    }
                    case 7: {
                        return new Point3D(this.xx * d2 + this.xy * d3 + this.xt, this.yx * d2 + this.yy * d3 + this.yt, d4);
                    }
                    case 6: {
                        return new Point3D(this.xx * d2 + this.xy * d3, this.yx * d2 + this.yy * d3, d4);
                    }
                    case 5: {
                        return new Point3D(this.xy * d3 + this.xt, this.yx * d2 + this.yt, d4);
                    }
                    case 4: {
                        return new Point3D(this.xy * d3, this.yx * d2, d4);
                    }
                    case 3: {
                        return new Point3D(this.xx * d2 + this.xt, this.yy * d3 + this.yt, d4);
                    }
                    case 2: {
                        return new Point3D(this.xx * d2, this.yy * d3, d4);
                    }
                    case 1: {
                        return new Point3D(d2 + this.xt, d3 + this.yt, d4);
                    }
                    case 0: 
                }
                return new Point3D(d2, d3, d4);
            }
            case 1: {
                return new Point3D(d2 + this.xt, d3 + this.yt, d4 + this.zt);
            }
            case 2: {
                return new Point3D(this.xx * d2, this.yy * d3, this.zz * d4);
            }
            case 3: {
                return new Point3D(this.xx * d2 + this.xt, this.yy * d3 + this.yt, this.zz * d4 + this.zt);
            }
            case 4: 
        }
        return new Point3D(this.xx * d2 + this.xy * d3 + this.xz * d4 + this.xt, this.yx * d2 + this.yy * d3 + this.yz * d4 + this.yt, this.zx * d2 + this.zy * d3 + this.zz * d4 + this.zt);
    }

    @Override
    public Point2D deltaTransform(double d2, double d3) {
        this.ensureCanTransform2DPoint();
        switch (this.state2d) {
            default: {
                Transform$ImmutableTransform.stateError();
            }
            case 6: 
            case 7: {
                return new Point2D(this.xx * d2 + this.xy * d3, this.yx * d2 + this.yy * d3);
            }
            case 4: 
            case 5: {
                return new Point2D(this.xy * d3, this.yx * d2);
            }
            case 2: 
            case 3: {
                return new Point2D(this.xx * d2, this.yy * d3);
            }
            case 0: 
            case 1: 
        }
        return new Point2D(d2, d3);
    }

    @Override
    public Point3D deltaTransform(double d2, double d3, double d4) {
        switch (this.state3d) {
            default: {
                Transform$ImmutableTransform.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Transform$ImmutableTransform.stateError();
                    }
                    case 6: 
                    case 7: {
                        return new Point3D(this.xx * d2 + this.xy * d3, this.yx * d2 + this.yy * d3, d4);
                    }
                    case 4: 
                    case 5: {
                        return new Point3D(this.xy * d3, this.yx * d2, d4);
                    }
                    case 2: 
                    case 3: {
                        return new Point3D(this.xx * d2, this.yy * d3, d4);
                    }
                    case 0: 
                    case 1: 
                }
                return new Point3D(d2, d3, d4);
            }
            case 1: {
                return new Point3D(d2, d3, d4);
            }
            case 2: 
            case 3: {
                return new Point3D(this.xx * d2, this.yy * d3, this.zz * d4);
            }
            case 4: 
        }
        return new Point3D(this.xx * d2 + this.xy * d3 + this.xz * d4, this.yx * d2 + this.yy * d3 + this.yz * d4, this.zx * d2 + this.zy * d3 + this.zz * d4);
    }

    @Override
    public Point2D inverseTransform(double d2, double d3) throws NonInvertibleTransformException {
        this.ensureCanTransform2DPoint();
        switch (this.state2d) {
            default: {
                return super.inverseTransform(d2, d3);
            }
            case 5: {
                if (this.xy == 0.0 || this.yx == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / this.yx * d3 - this.yt / this.yx, 1.0 / this.xy * d2 - this.xt / this.xy);
            }
            case 4: {
                if (this.xy == 0.0 || this.yx == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / this.yx * d3, 1.0 / this.xy * d2);
            }
            case 3: {
                if (this.xx == 0.0 || this.yy == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / this.xx * d2 - this.xt / this.xx, 1.0 / this.yy * d3 - this.yt / this.yy);
            }
            case 2: {
                if (this.xx == 0.0 || this.yy == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / this.xx * d2, 1.0 / this.yy * d3);
            }
            case 1: {
                return new Point2D(d2 - this.xt, d3 - this.yt);
            }
            case 0: 
        }
        return new Point2D(d2, d3);
    }

    @Override
    public Point3D inverseTransform(double d2, double d3, double d4) throws NonInvertibleTransformException {
        switch (this.state3d) {
            default: {
                Transform$ImmutableTransform.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        return super.inverseTransform(d2, d3, d4);
                    }
                    case 5: {
                        if (this.xy == 0.0 || this.yx == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / this.yx * d3 - this.yt / this.yx, 1.0 / this.xy * d2 - this.xt / this.xy, d4);
                    }
                    case 4: {
                        if (this.xy == 0.0 || this.yx == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / this.yx * d3, 1.0 / this.xy * d2, d4);
                    }
                    case 3: {
                        if (this.xx == 0.0 || this.yy == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / this.xx * d2 - this.xt / this.xx, 1.0 / this.yy * d3 - this.yt / this.yy, d4);
                    }
                    case 2: {
                        if (this.xx == 0.0 || this.yy == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / this.xx * d2, 1.0 / this.yy * d3, d4);
                    }
                    case 1: {
                        return new Point3D(d2 - this.xt, d3 - this.yt, d4);
                    }
                    case 0: 
                }
                return new Point3D(d2, d3, d4);
            }
            case 1: {
                return new Point3D(d2 - this.xt, d3 - this.yt, d4 - this.zt);
            }
            case 2: {
                if (this.xx == 0.0 || this.yy == 0.0 || this.zz == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point3D(1.0 / this.xx * d2, 1.0 / this.yy * d3, 1.0 / this.zz * d4);
            }
            case 3: {
                if (this.xx == 0.0 || this.yy == 0.0 || this.zz == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point3D(1.0 / this.xx * d2 - this.xt / this.xx, 1.0 / this.yy * d3 - this.yt / this.yy, 1.0 / this.zz * d4 - this.zt / this.zz);
            }
            case 4: 
        }
        return super.inverseTransform(d2, d3, d4);
    }

    @Override
    public Point2D inverseDeltaTransform(double d2, double d3) throws NonInvertibleTransformException {
        this.ensureCanTransform2DPoint();
        switch (this.state2d) {
            default: {
                return super.inverseDeltaTransform(d2, d3);
            }
            case 4: 
            case 5: {
                if (this.xy == 0.0 || this.yx == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / this.yx * d3, 1.0 / this.xy * d2);
            }
            case 2: 
            case 3: {
                if (this.xx == 0.0 || this.yy == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / this.xx * d2, 1.0 / this.yy * d3);
            }
            case 0: 
            case 1: 
        }
        return new Point2D(d2, d3);
    }

    @Override
    public Point3D inverseDeltaTransform(double d2, double d3, double d4) throws NonInvertibleTransformException {
        switch (this.state3d) {
            default: {
                Transform$ImmutableTransform.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        return super.inverseDeltaTransform(d2, d3, d4);
                    }
                    case 4: 
                    case 5: {
                        if (this.xy == 0.0 || this.yx == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / this.yx * d3, 1.0 / this.xy * d2, d4);
                    }
                    case 2: 
                    case 3: {
                        if (this.xx == 0.0 || this.yy == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / this.xx * d2, 1.0 / this.yy * d3, d4);
                    }
                    case 0: 
                    case 1: 
                }
                return new Point3D(d2, d3, d4);
            }
            case 1: {
                return new Point3D(d2, d3, d4);
            }
            case 2: 
            case 3: {
                if (this.xx == 0.0 || this.yy == 0.0 || this.zz == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point3D(1.0 / this.xx * d2, 1.0 / this.yy * d3, 1.0 / this.zz * d4);
            }
            case 4: 
        }
        return super.inverseDeltaTransform(d2, d3, d4);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Transform [\n");
        stringBuilder.append("\t").append(this.xx);
        stringBuilder.append(", ").append(this.xy);
        stringBuilder.append(", ").append(this.xz);
        stringBuilder.append(", ").append(this.xt);
        stringBuilder.append('\n');
        stringBuilder.append("\t").append(this.yx);
        stringBuilder.append(", ").append(this.yy);
        stringBuilder.append(", ").append(this.yz);
        stringBuilder.append(", ").append(this.yt);
        stringBuilder.append('\n');
        stringBuilder.append("\t").append(this.zx);
        stringBuilder.append(", ").append(this.zy);
        stringBuilder.append(", ").append(this.zz);
        stringBuilder.append(", ").append(this.zt);
        return stringBuilder.append("\n]").toString();
    }

    private void updateState() {
        this.updateState2D();
        this.state3d = 0;
        if (this.xz != 0.0 || this.yz != 0.0 || this.zx != 0.0 || this.zy != 0.0) {
            this.state3d = 4;
            return;
        }
        if ((this.state2d & 4) == 0) {
            if (this.zt != 0.0) {
                this.state3d |= 1;
            }
            if (this.zz != 1.0) {
                this.state3d |= 2;
            }
            if (this.state3d != 0) {
                this.state3d |= this.state2d & 3;
                return;
            }
        } else if (this.zz != 1.0 || this.zt != 0.0) {
            this.state3d = 4;
        }
    }

    private void updateState2D() {
        if (this.xy == 0.0 && this.yx == 0.0) {
            if (this.xx == 1.0 && this.yy == 1.0) {
                if (this.xt == 0.0 && this.yt == 0.0) {
                    this.state2d = 0;
                    return;
                }
                this.state2d = 1;
                return;
            }
            if (this.xt == 0.0 && this.yt == 0.0) {
                this.state2d = 2;
                return;
            }
            this.state2d = 3;
            return;
        }
        if (this.xx == 0.0 && this.yy == 0.0) {
            if (this.xt == 0.0 && this.yt == 0.0) {
                this.state2d = 4;
                return;
            }
            this.state2d = 5;
            return;
        }
        if (this.xt == 0.0 && this.yt == 0.0) {
            this.state2d = 6;
            return;
        }
        this.state2d = 7;
    }

    @Override
    void ensureCanTransform2DPoint() throws IllegalStateException {
        if (this.state3d != 0) {
            throw new IllegalStateException("Cannot transform 2D point with a 3D transform");
        }
    }

    private static void stateError() {
        throw new InternalError("missing case in a switch");
    }

    @Override
    void apply(Affine3D affine3D) {
        affine3D.concatenate(this.xx, this.xy, this.xz, this.xt, this.yx, this.yy, this.yz, this.yt, this.zx, this.zy, this.zz, this.zt);
    }

    @Override
    BaseTransform derive(BaseTransform baseTransform) {
        return baseTransform.deriveWithConcatenation(this.xx, this.xy, this.xz, this.xt, this.yx, this.yy, this.yz, this.yt, this.zx, this.zy, this.zz, this.zt);
    }

    int getState2d() {
        return this.state2d;
    }

    int getState3d() {
        return this.state3d;
    }
}

